# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFleetComplianceReportResult',
    'AwaitableGetFleetComplianceReportResult',
    'get_fleet_compliance_report',
    'get_fleet_compliance_report_output',
]

@pulumi.output_type
class GetFleetComplianceReportResult:
    """
    A collection of values returned by getFleetComplianceReport.
    """
    def __init__(__self__, compliance_report_id=None, compliance_state=None, fleet_id=None, id=None, resources=None):
        if compliance_report_id and not isinstance(compliance_report_id, str):
            raise TypeError("Expected argument 'compliance_report_id' to be a str")
        pulumi.set(__self__, "compliance_report_id", compliance_report_id)
        if compliance_state and not isinstance(compliance_state, str):
            raise TypeError("Expected argument 'compliance_state' to be a str")
        pulumi.set(__self__, "compliance_state", compliance_state)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="complianceReportId")
    def compliance_report_id(self) -> str:
        return pulumi.get(self, "compliance_report_id")

    @property
    @pulumi.getter(name="complianceState")
    def compliance_state(self) -> str:
        """
        Last known compliance state of target.
        """
        return pulumi.get(self, "compliance_state")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        """
        The fleet OCID.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetFleetComplianceReportResourceResult']:
        """
        Resources assocaited with the Fleet.
        """
        return pulumi.get(self, "resources")


class AwaitableGetFleetComplianceReportResult(GetFleetComplianceReportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetComplianceReportResult(
            compliance_report_id=self.compliance_report_id,
            compliance_state=self.compliance_state,
            fleet_id=self.fleet_id,
            id=self.id,
            resources=self.resources)


def get_fleet_compliance_report(compliance_report_id: Optional[str] = None,
                                fleet_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetComplianceReportResult:
    """
    This data source provides details about a specific Fleet Compliance Report resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Retrieve compiane report for a Fleet

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_compliance_report = oci.FleetAppsManagement.get_fleet_compliance_report(compliance_report_id=test_report["id"],
        fleet_id=test_fleet["id"])
    ```


    :param str compliance_report_id: compliance report identifier
    :param str fleet_id: unique Fleet identifier
    """
    __args__ = dict()
    __args__['complianceReportId'] = compliance_report_id
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getFleetComplianceReport:getFleetComplianceReport', __args__, opts=opts, typ=GetFleetComplianceReportResult).value

    return AwaitableGetFleetComplianceReportResult(
        compliance_report_id=pulumi.get(__ret__, 'compliance_report_id'),
        compliance_state=pulumi.get(__ret__, 'compliance_state'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        resources=pulumi.get(__ret__, 'resources'))
def get_fleet_compliance_report_output(compliance_report_id: Optional[pulumi.Input[str]] = None,
                                       fleet_id: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFleetComplianceReportResult]:
    """
    This data source provides details about a specific Fleet Compliance Report resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Retrieve compiane report for a Fleet

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_compliance_report = oci.FleetAppsManagement.get_fleet_compliance_report(compliance_report_id=test_report["id"],
        fleet_id=test_fleet["id"])
    ```


    :param str compliance_report_id: compliance report identifier
    :param str fleet_id: unique Fleet identifier
    """
    __args__ = dict()
    __args__['complianceReportId'] = compliance_report_id
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getFleetComplianceReport:getFleetComplianceReport', __args__, opts=opts, typ=GetFleetComplianceReportResult)
    return __ret__.apply(lambda __response__: GetFleetComplianceReportResult(
        compliance_report_id=pulumi.get(__response__, 'compliance_report_id'),
        compliance_state=pulumi.get(__response__, 'compliance_state'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        resources=pulumi.get(__response__, 'resources')))
