# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPbfListingResult',
    'AwaitableGetPbfListingResult',
    'get_pbf_listing',
    'get_pbf_listing_output',
]

@pulumi.output_type
class GetPbfListingResult:
    """
    A collection of values returned by getPbfListing.
    """
    def __init__(__self__, defined_tags=None, description=None, freeform_tags=None, id=None, name=None, pbf_listing_id=None, publisher_details=None, state=None, system_tags=None, time_created=None, time_updated=None, triggers=None):
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pbf_listing_id and not isinstance(pbf_listing_id, str):
            raise TypeError("Expected argument 'pbf_listing_id' to be a str")
        pulumi.set(__self__, "pbf_listing_id", pbf_listing_id)
        if publisher_details and not isinstance(publisher_details, list):
            raise TypeError("Expected argument 'publisher_details' to be a list")
        pulumi.set(__self__, "publisher_details", publisher_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if triggers and not isinstance(triggers, list):
            raise TypeError("Expected argument 'triggers' to be a list")
        pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A short overview of the PBF Listing: the purpose of the PBF and and associated information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A brief descriptive name for the PBF trigger.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pbfListingId")
    def pbf_listing_id(self) -> str:
        return pulumi.get(self, "pbf_listing_id")

    @property
    @pulumi.getter(name="publisherDetails")
    def publisher_details(self) -> Sequence['outputs.GetPbfListingPublisherDetailResult']:
        """
        Contains details about the publisher of this PBF Listing.
        """
        return pulumi.get(self, "publisher_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the PBF resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the PbfListing was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The last time the PbfListing was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def triggers(self) -> Sequence['outputs.GetPbfListingTriggerResult']:
        """
        An array of Trigger. A list of triggers that may activate the PBF.
        """
        return pulumi.get(self, "triggers")


class AwaitableGetPbfListingResult(GetPbfListingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPbfListingResult(
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            name=self.name,
            pbf_listing_id=self.pbf_listing_id,
            publisher_details=self.publisher_details,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            triggers=self.triggers)


def get_pbf_listing(pbf_listing_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPbfListingResult:
    """
    This data source provides details about a specific Pbf Listing resource in Oracle Cloud Infrastructure Functions service.

    Fetches a Pre-built Function(PBF) Listing. Returns a PbfListing response model.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pbf_listing = oci.Functions.get_pbf_listing(pbf_listing_id=test_pbf_listing_oci_functions_pbf_listing["id"])
    ```


    :param str pbf_listing_id: unique PbfListing identifier
    """
    __args__ = dict()
    __args__['pbfListingId'] = pbf_listing_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getPbfListing:getPbfListing', __args__, opts=opts, typ=GetPbfListingResult).value

    return AwaitableGetPbfListingResult(
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        pbf_listing_id=pulumi.get(__ret__, 'pbf_listing_id'),
        publisher_details=pulumi.get(__ret__, 'publisher_details'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        triggers=pulumi.get(__ret__, 'triggers'))
def get_pbf_listing_output(pbf_listing_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPbfListingResult]:
    """
    This data source provides details about a specific Pbf Listing resource in Oracle Cloud Infrastructure Functions service.

    Fetches a Pre-built Function(PBF) Listing. Returns a PbfListing response model.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pbf_listing = oci.Functions.get_pbf_listing(pbf_listing_id=test_pbf_listing_oci_functions_pbf_listing["id"])
    ```


    :param str pbf_listing_id: unique PbfListing identifier
    """
    __args__ = dict()
    __args__['pbfListingId'] = pbf_listing_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Functions/getPbfListing:getPbfListing', __args__, opts=opts, typ=GetPbfListingResult)
    return __ret__.apply(lambda __response__: GetPbfListingResult(
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        pbf_listing_id=pulumi.get(__response__, 'pbf_listing_id'),
        publisher_details=pulumi.get(__response__, 'publisher_details'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        triggers=pulumi.get(__response__, 'triggers')))
