# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUserGroupMembershipsResult',
    'AwaitableGetUserGroupMembershipsResult',
    'get_user_group_memberships',
    'get_user_group_memberships_output',
]

@pulumi.output_type
class GetUserGroupMembershipsResult:
    """
    A collection of values returned by getUserGroupMemberships.
    """
    def __init__(__self__, compartment_id=None, filters=None, group_id=None, id=None, memberships=None, user_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if memberships and not isinstance(memberships, list):
            raise TypeError("Expected argument 'memberships' to be a list")
        pulumi.set(__self__, "memberships", memberships)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the tenancy containing the user, group, and membership object.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUserGroupMembershipsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        """
        The OCID of the group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def memberships(self) -> Sequence['outputs.GetUserGroupMembershipsMembershipResult']:
        """
        The list of memberships.
        """
        return pulumi.get(self, "memberships")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[str]:
        """
        The OCID of the user.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetUserGroupMembershipsResult(GetUserGroupMembershipsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserGroupMembershipsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            group_id=self.group_id,
            id=self.id,
            memberships=self.memberships,
            user_id=self.user_id)


def get_user_group_memberships(compartment_id: Optional[str] = None,
                               filters: Optional[Sequence[Union['GetUserGroupMembershipsFilterArgs', 'GetUserGroupMembershipsFilterArgsDict']]] = None,
                               group_id: Optional[str] = None,
                               user_id: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserGroupMembershipsResult:
    """
    This data source provides the list of User Group Memberships in Oracle Cloud Infrastructure Identity service.

    Lists the `UserGroupMembership` objects in your tenancy. You must specify your tenancy's OCID
    as the value for the compartment ID
    (see [Where to Get the Tenancy's OCID and User's OCID](https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm#five)).
    You must also then filter the list in one of these ways:

    - You can limit the results to just the memberships for a given user by specifying a `userId`.
    - Similarly, you can limit the results to just the memberships for a given group by specifying a `groupId`.
    - You can set both the `userId` and `groupId` to determine if the specified user is in the specified group.
      If the answer is no, the response is an empty list.
    - Although`userId` and `groupId` are not individually required, you must set one of them.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_user_group_memberships = oci.Identity.get_user_group_memberships(compartment_id=tenancy_ocid,
        group_id=test_group["id"],
        user_id=test_user["id"])
    ```


    :param str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param str group_id: The OCID of the group.
    :param str user_id: The OCID of the user.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['groupId'] = group_id
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getUserGroupMemberships:getUserGroupMemberships', __args__, opts=opts, typ=GetUserGroupMembershipsResult).value

    return AwaitableGetUserGroupMembershipsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        memberships=pulumi.get(__ret__, 'memberships'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_user_group_memberships_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetUserGroupMembershipsFilterArgs', 'GetUserGroupMembershipsFilterArgsDict']]]]] = None,
                                      group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      user_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserGroupMembershipsResult]:
    """
    This data source provides the list of User Group Memberships in Oracle Cloud Infrastructure Identity service.

    Lists the `UserGroupMembership` objects in your tenancy. You must specify your tenancy's OCID
    as the value for the compartment ID
    (see [Where to Get the Tenancy's OCID and User's OCID](https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm#five)).
    You must also then filter the list in one of these ways:

    - You can limit the results to just the memberships for a given user by specifying a `userId`.
    - Similarly, you can limit the results to just the memberships for a given group by specifying a `groupId`.
    - You can set both the `userId` and `groupId` to determine if the specified user is in the specified group.
      If the answer is no, the response is an empty list.
    - Although`userId` and `groupId` are not individually required, you must set one of them.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_user_group_memberships = oci.Identity.get_user_group_memberships(compartment_id=tenancy_ocid,
        group_id=test_group["id"],
        user_id=test_user["id"])
    ```


    :param str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param str group_id: The OCID of the group.
    :param str user_id: The OCID of the user.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['groupId'] = group_id
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getUserGroupMemberships:getUserGroupMemberships', __args__, opts=opts, typ=GetUserGroupMembershipsResult)
    return __ret__.apply(lambda __response__: GetUserGroupMembershipsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        memberships=pulumi.get(__response__, 'memberships'),
        user_id=pulumi.get(__response__, 'user_id')))
