# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagementAgentPluginsResult',
    'AwaitableGetManagementAgentPluginsResult',
    'get_management_agent_plugins',
    'get_management_agent_plugins_output',
]

@pulumi.output_type
class GetManagementAgentPluginsResult:
    """
    A collection of values returned by getManagementAgentPlugins.
    """
    def __init__(__self__, agent_id=None, compartment_id=None, display_name=None, filters=None, id=None, management_agent_plugins=None, platform_types=None, state=None):
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if management_agent_plugins and not isinstance(management_agent_plugins, list):
            raise TypeError("Expected argument 'management_agent_plugins' to be a list")
        pulumi.set(__self__, "management_agent_plugins", management_agent_plugins)
        if platform_types and not isinstance(platform_types, list):
            raise TypeError("Expected argument 'platform_types' to be a list")
        pulumi.set(__self__, "platform_types", platform_types)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[str]:
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Management Agent Plugin Display Name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagementAgentPluginsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managementAgentPlugins")
    def management_agent_plugins(self) -> Sequence['outputs.GetManagementAgentPluginsManagementAgentPluginResult']:
        """
        The list of management_agent_plugins.
        """
        return pulumi.get(self, "management_agent_plugins")

    @property
    @pulumi.getter(name="platformTypes")
    def platform_types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "platform_types")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of Management Agent Plugin
        """
        return pulumi.get(self, "state")


class AwaitableGetManagementAgentPluginsResult(GetManagementAgentPluginsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementAgentPluginsResult(
            agent_id=self.agent_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            management_agent_plugins=self.management_agent_plugins,
            platform_types=self.platform_types,
            state=self.state)


def get_management_agent_plugins(agent_id: Optional[str] = None,
                                 compartment_id: Optional[str] = None,
                                 display_name: Optional[str] = None,
                                 filters: Optional[Sequence[Union['GetManagementAgentPluginsFilterArgs', 'GetManagementAgentPluginsFilterArgsDict']]] = None,
                                 platform_types: Optional[Sequence[str]] = None,
                                 state: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementAgentPluginsResult:
    """
    This data source provides the list of Management Agent Plugins in Oracle Cloud Infrastructure Management Agent service.

    Returns a list of managementAgentPlugins.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_plugins = oci.ManagementAgent.get_management_agent_plugins(compartment_id=compartment_id,
        agent_id=management_agent_id,
        display_name=management_agent_plugin_display_name,
        platform_types=management_agent_plugin_platform_type,
        state=management_agent_plugin_state)
    ```


    :param str agent_id: The ManagementAgentID of the agent from which the Management Agents to be filtered.
    :param str compartment_id: The OCID of the compartment to which a request will be scoped.
    :param str display_name: Filter to return only Management Agent Plugins having the particular display name.
    :param Sequence[str] platform_types: Array of PlatformTypes to return only results having the particular platform types. Example: ["LINUX"]
    :param str state: Filter to return only Management Agents in the particular lifecycle state.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['platformTypes'] = platform_types
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ManagementAgent/getManagementAgentPlugins:getManagementAgentPlugins', __args__, opts=opts, typ=GetManagementAgentPluginsResult).value

    return AwaitableGetManagementAgentPluginsResult(
        agent_id=pulumi.get(__ret__, 'agent_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        management_agent_plugins=pulumi.get(__ret__, 'management_agent_plugins'),
        platform_types=pulumi.get(__ret__, 'platform_types'),
        state=pulumi.get(__ret__, 'state'))
def get_management_agent_plugins_output(agent_id: Optional[pulumi.Input[Optional[str]]] = None,
                                        compartment_id: Optional[pulumi.Input[str]] = None,
                                        display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagementAgentPluginsFilterArgs', 'GetManagementAgentPluginsFilterArgsDict']]]]] = None,
                                        platform_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                        state: Optional[pulumi.Input[Optional[str]]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagementAgentPluginsResult]:
    """
    This data source provides the list of Management Agent Plugins in Oracle Cloud Infrastructure Management Agent service.

    Returns a list of managementAgentPlugins.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_plugins = oci.ManagementAgent.get_management_agent_plugins(compartment_id=compartment_id,
        agent_id=management_agent_id,
        display_name=management_agent_plugin_display_name,
        platform_types=management_agent_plugin_platform_type,
        state=management_agent_plugin_state)
    ```


    :param str agent_id: The ManagementAgentID of the agent from which the Management Agents to be filtered.
    :param str compartment_id: The OCID of the compartment to which a request will be scoped.
    :param str display_name: Filter to return only Management Agent Plugins having the particular display name.
    :param Sequence[str] platform_types: Array of PlatformTypes to return only results having the particular platform types. Example: ["LINUX"]
    :param str state: Filter to return only Management Agents in the particular lifecycle state.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['platformTypes'] = platform_types
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ManagementAgent/getManagementAgentPlugins:getManagementAgentPlugins', __args__, opts=opts, typ=GetManagementAgentPluginsResult)
    return __ret__.apply(lambda __response__: GetManagementAgentPluginsResult(
        agent_id=pulumi.get(__response__, 'agent_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        management_agent_plugins=pulumi.get(__response__, 'management_agent_plugins'),
        platform_types=pulumi.get(__response__, 'platform_types'),
        state=pulumi.get(__response__, 'state')))
