# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagementAgentArgs', 'ManagementAgent']

@pulumi.input_type
class ManagementAgentArgs:
    def __init__(__self__, *,
                 managed_agent_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 deploy_plugins_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ManagementAgent resource.
        :param pulumi.Input[str] managed_agent_id: Unique Management Agent identifier
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) New displayName of Agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "managed_agent_id", managed_agent_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deploy_plugins_ids is not None:
            pulumi.set(__self__, "deploy_plugins_ids", deploy_plugins_ids)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="managedAgentId")
    def managed_agent_id(self) -> pulumi.Input[str]:
        """
        Unique Management Agent identifier
        """
        return pulumi.get(self, "managed_agent_id")

    @managed_agent_id.setter
    def managed_agent_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_agent_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deployPluginsIds")
    def deploy_plugins_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "deploy_plugins_ids")

    @deploy_plugins_ids.setter
    def deploy_plugins_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "deploy_plugins_ids", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) New displayName of Agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ManagementAgentState:
    def __init__(__self__, *,
                 availability_status: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_source_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceListArgs']]]] = None,
                 data_source_summary_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceSummaryListArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 deploy_plugins_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 host_id: Optional[pulumi.Input[str]] = None,
                 install_key_id: Optional[pulumi.Input[str]] = None,
                 install_path: Optional[pulumi.Input[str]] = None,
                 install_type: Optional[pulumi.Input[str]] = None,
                 is_agent_auto_upgradable: Optional[pulumi.Input[bool]] = None,
                 is_customer_deployed: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 managed_agent_id: Optional[pulumi.Input[str]] = None,
                 management_agent_properties: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentManagementAgentPropertyArgs']]]] = None,
                 platform_name: Optional[pulumi.Input[str]] = None,
                 platform_type: Optional[pulumi.Input[str]] = None,
                 platform_version: Optional[pulumi.Input[str]] = None,
                 plugin_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentPluginListArgs']]]] = None,
                 resource_artifact_version: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_last_heartbeat: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ManagementAgent resources.
        :param pulumi.Input[str] availability_status: The current availability status of managementAgent
        :param pulumi.Input[str] compartment_id: Compartment owning this DataSource.
        :param pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceListArgs']]] data_source_lists: list of dataSources associated with the agent
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) New displayName of Agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] host: Management Agent host machine name
        :param pulumi.Input[str] host_id: Host resource ocid
        :param pulumi.Input[str] install_key_id: agent install key identifier
        :param pulumi.Input[str] install_path: Path where Management Agent is installed
        :param pulumi.Input[str] install_type: The install type, either AGENT or GATEWAY
        :param pulumi.Input[bool] is_agent_auto_upgradable: true if the agent can be upgraded automatically; false if it must be upgraded manually. This flag is derived from the tenancy level auto upgrade preference.
        :param pulumi.Input[bool] is_customer_deployed: true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] managed_agent_id: Unique Management Agent identifier
        :param pulumi.Input[Sequence[pulumi.Input['ManagementAgentManagementAgentPropertyArgs']]] management_agent_properties: Additional properties for this Management Agent
        :param pulumi.Input[str] platform_name: Platform Name
        :param pulumi.Input[str] platform_type: Platform Type
        :param pulumi.Input[str] platform_version: Platform Version
        :param pulumi.Input[Sequence[pulumi.Input['ManagementAgentPluginListArgs']]] plugin_lists: list of managementAgentPlugins associated with the agent
        :param pulumi.Input[str] resource_artifact_version: Version of the deployment artifact instantiated by this Management Agent. The format for Standalone resourceMode is YYMMDD.HHMM, and the format for other modes (whose artifacts are based upon Standalone but can advance independently) is YYMMDD.HHMM.VVVVVVVVVVVV. VVVVVVVVVVVV is always a numeric value between 000000000000 and 999999999999
        :param pulumi.Input[str] state: The current state of managementAgent
        :param pulumi.Input[str] time_created: The time the Management Agent was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_last_heartbeat: The time the Management Agent has last recorded its health status in telemetry. This value will be null if the agent has not recorded its health status in last 7 days. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the Management Agent was last updated. An RFC3339 formatted datetime string
        :param pulumi.Input[str] version: Management Agent Version
        """
        if availability_status is not None:
            pulumi.set(__self__, "availability_status", availability_status)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if data_source_lists is not None:
            pulumi.set(__self__, "data_source_lists", data_source_lists)
        if data_source_summary_lists is not None:
            pulumi.set(__self__, "data_source_summary_lists", data_source_summary_lists)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deploy_plugins_ids is not None:
            pulumi.set(__self__, "deploy_plugins_ids", deploy_plugins_ids)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if install_key_id is not None:
            pulumi.set(__self__, "install_key_id", install_key_id)
        if install_path is not None:
            pulumi.set(__self__, "install_path", install_path)
        if install_type is not None:
            pulumi.set(__self__, "install_type", install_type)
        if is_agent_auto_upgradable is not None:
            pulumi.set(__self__, "is_agent_auto_upgradable", is_agent_auto_upgradable)
        if is_customer_deployed is not None:
            pulumi.set(__self__, "is_customer_deployed", is_customer_deployed)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if managed_agent_id is not None:
            pulumi.set(__self__, "managed_agent_id", managed_agent_id)
        if management_agent_properties is not None:
            pulumi.set(__self__, "management_agent_properties", management_agent_properties)
        if platform_name is not None:
            pulumi.set(__self__, "platform_name", platform_name)
        if platform_type is not None:
            pulumi.set(__self__, "platform_type", platform_type)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if plugin_lists is not None:
            pulumi.set(__self__, "plugin_lists", plugin_lists)
        if resource_artifact_version is not None:
            pulumi.set(__self__, "resource_artifact_version", resource_artifact_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_heartbeat is not None:
            pulumi.set(__self__, "time_last_heartbeat", time_last_heartbeat)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> Optional[pulumi.Input[str]]:
        """
        The current availability status of managementAgent
        """
        return pulumi.get(self, "availability_status")

    @availability_status.setter
    def availability_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_status", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Compartment owning this DataSource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataSourceLists")
    def data_source_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceListArgs']]]]:
        """
        list of dataSources associated with the agent
        """
        return pulumi.get(self, "data_source_lists")

    @data_source_lists.setter
    def data_source_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceListArgs']]]]):
        pulumi.set(self, "data_source_lists", value)

    @property
    @pulumi.getter(name="dataSourceSummaryLists")
    def data_source_summary_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceSummaryListArgs']]]]:
        return pulumi.get(self, "data_source_summary_lists")

    @data_source_summary_lists.setter
    def data_source_summary_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentDataSourceSummaryListArgs']]]]):
        pulumi.set(self, "data_source_summary_lists", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deployPluginsIds")
    def deploy_plugins_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "deploy_plugins_ids")

    @deploy_plugins_ids.setter
    def deploy_plugins_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "deploy_plugins_ids", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) New displayName of Agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Management Agent host machine name
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[str]]:
        """
        Host resource ocid
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_id", value)

    @property
    @pulumi.getter(name="installKeyId")
    def install_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        agent install key identifier
        """
        return pulumi.get(self, "install_key_id")

    @install_key_id.setter
    def install_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "install_key_id", value)

    @property
    @pulumi.getter(name="installPath")
    def install_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path where Management Agent is installed
        """
        return pulumi.get(self, "install_path")

    @install_path.setter
    def install_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "install_path", value)

    @property
    @pulumi.getter(name="installType")
    def install_type(self) -> Optional[pulumi.Input[str]]:
        """
        The install type, either AGENT or GATEWAY
        """
        return pulumi.get(self, "install_type")

    @install_type.setter
    def install_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "install_type", value)

    @property
    @pulumi.getter(name="isAgentAutoUpgradable")
    def is_agent_auto_upgradable(self) -> Optional[pulumi.Input[bool]]:
        """
        true if the agent can be upgraded automatically; false if it must be upgraded manually. This flag is derived from the tenancy level auto upgrade preference.
        """
        return pulumi.get(self, "is_agent_auto_upgradable")

    @is_agent_auto_upgradable.setter
    def is_agent_auto_upgradable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_agent_auto_upgradable", value)

    @property
    @pulumi.getter(name="isCustomerDeployed")
    def is_customer_deployed(self) -> Optional[pulumi.Input[bool]]:
        """
        true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
        """
        return pulumi.get(self, "is_customer_deployed")

    @is_customer_deployed.setter
    def is_customer_deployed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_customer_deployed", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="managedAgentId")
    def managed_agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique Management Agent identifier
        """
        return pulumi.get(self, "managed_agent_id")

    @managed_agent_id.setter
    def managed_agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_agent_id", value)

    @property
    @pulumi.getter(name="managementAgentProperties")
    def management_agent_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentManagementAgentPropertyArgs']]]]:
        """
        Additional properties for this Management Agent
        """
        return pulumi.get(self, "management_agent_properties")

    @management_agent_properties.setter
    def management_agent_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentManagementAgentPropertyArgs']]]]):
        pulumi.set(self, "management_agent_properties", value)

    @property
    @pulumi.getter(name="platformName")
    def platform_name(self) -> Optional[pulumi.Input[str]]:
        """
        Platform Name
        """
        return pulumi.get(self, "platform_name")

    @platform_name.setter
    def platform_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_name", value)

    @property
    @pulumi.getter(name="platformType")
    def platform_type(self) -> Optional[pulumi.Input[str]]:
        """
        Platform Type
        """
        return pulumi.get(self, "platform_type")

    @platform_type.setter
    def platform_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_type", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[str]]:
        """
        Platform Version
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter(name="pluginLists")
    def plugin_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentPluginListArgs']]]]:
        """
        list of managementAgentPlugins associated with the agent
        """
        return pulumi.get(self, "plugin_lists")

    @plugin_lists.setter
    def plugin_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementAgentPluginListArgs']]]]):
        pulumi.set(self, "plugin_lists", value)

    @property
    @pulumi.getter(name="resourceArtifactVersion")
    def resource_artifact_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the deployment artifact instantiated by this Management Agent. The format for Standalone resourceMode is YYMMDD.HHMM, and the format for other modes (whose artifacts are based upon Standalone but can advance independently) is YYMMDD.HHMM.VVVVVVVVVVVV. VVVVVVVVVVVV is always a numeric value between 000000000000 and 999999999999
        """
        return pulumi.get(self, "resource_artifact_version")

    @resource_artifact_version.setter
    def resource_artifact_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_artifact_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of managementAgent
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Management Agent was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastHeartbeat")
    def time_last_heartbeat(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Management Agent has last recorded its health status in telemetry. This value will be null if the agent has not recorded its health status in last 7 days. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_last_heartbeat")

    @time_last_heartbeat.setter
    def time_last_heartbeat(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_heartbeat", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Management Agent was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Management Agent Version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class ManagementAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 deploy_plugins_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 managed_agent_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Management Agent resource in Oracle Cloud Infrastructure Management Agent service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_management_agent = oci.management_agent.ManagementAgent("test_management_agent", managed_agent_id=test_managed_agent["id"])
        ```
        ***
        Add plugin to Management Agent created via OCI Compute instance.

        Compute instance must have OCA Plugin "Management Agent" enabled
        ## Import

        ManagementAgents can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ManagementAgent/managementAgent:ManagementAgent test_management_agent "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) New displayName of Agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] managed_agent_id: Unique Management Agent identifier
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagementAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Management Agent resource in Oracle Cloud Infrastructure Management Agent service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_management_agent = oci.management_agent.ManagementAgent("test_management_agent", managed_agent_id=test_managed_agent["id"])
        ```
        ***
        Add plugin to Management Agent created via OCI Compute instance.

        Compute instance must have OCA Plugin "Management Agent" enabled
        ## Import

        ManagementAgents can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ManagementAgent/managementAgent:ManagementAgent test_management_agent "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagementAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagementAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 deploy_plugins_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 managed_agent_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagementAgentArgs.__new__(ManagementAgentArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["deploy_plugins_ids"] = deploy_plugins_ids
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if managed_agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_agent_id'")
            __props__.__dict__["managed_agent_id"] = managed_agent_id
            __props__.__dict__["availability_status"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["data_source_lists"] = None
            __props__.__dict__["data_source_summary_lists"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["host_id"] = None
            __props__.__dict__["install_key_id"] = None
            __props__.__dict__["install_path"] = None
            __props__.__dict__["install_type"] = None
            __props__.__dict__["is_agent_auto_upgradable"] = None
            __props__.__dict__["is_customer_deployed"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["management_agent_properties"] = None
            __props__.__dict__["platform_name"] = None
            __props__.__dict__["platform_type"] = None
            __props__.__dict__["platform_version"] = None
            __props__.__dict__["plugin_lists"] = None
            __props__.__dict__["resource_artifact_version"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_heartbeat"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["version"] = None
        super(ManagementAgent, __self__).__init__(
            'oci:ManagementAgent/managementAgent:ManagementAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_status: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            data_source_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementAgentDataSourceListArgs', 'ManagementAgentDataSourceListArgsDict']]]]] = None,
            data_source_summary_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementAgentDataSourceSummaryListArgs', 'ManagementAgentDataSourceSummaryListArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            deploy_plugins_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            host: Optional[pulumi.Input[str]] = None,
            host_id: Optional[pulumi.Input[str]] = None,
            install_key_id: Optional[pulumi.Input[str]] = None,
            install_path: Optional[pulumi.Input[str]] = None,
            install_type: Optional[pulumi.Input[str]] = None,
            is_agent_auto_upgradable: Optional[pulumi.Input[bool]] = None,
            is_customer_deployed: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            managed_agent_id: Optional[pulumi.Input[str]] = None,
            management_agent_properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementAgentManagementAgentPropertyArgs', 'ManagementAgentManagementAgentPropertyArgsDict']]]]] = None,
            platform_name: Optional[pulumi.Input[str]] = None,
            platform_type: Optional[pulumi.Input[str]] = None,
            platform_version: Optional[pulumi.Input[str]] = None,
            plugin_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementAgentPluginListArgs', 'ManagementAgentPluginListArgsDict']]]]] = None,
            resource_artifact_version: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_last_heartbeat: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'ManagementAgent':
        """
        Get an existing ManagementAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_status: The current availability status of managementAgent
        :param pulumi.Input[str] compartment_id: Compartment owning this DataSource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementAgentDataSourceListArgs', 'ManagementAgentDataSourceListArgsDict']]]] data_source_lists: list of dataSources associated with the agent
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) New displayName of Agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] host: Management Agent host machine name
        :param pulumi.Input[str] host_id: Host resource ocid
        :param pulumi.Input[str] install_key_id: agent install key identifier
        :param pulumi.Input[str] install_path: Path where Management Agent is installed
        :param pulumi.Input[str] install_type: The install type, either AGENT or GATEWAY
        :param pulumi.Input[bool] is_agent_auto_upgradable: true if the agent can be upgraded automatically; false if it must be upgraded manually. This flag is derived from the tenancy level auto upgrade preference.
        :param pulumi.Input[bool] is_customer_deployed: true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] managed_agent_id: Unique Management Agent identifier
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementAgentManagementAgentPropertyArgs', 'ManagementAgentManagementAgentPropertyArgsDict']]]] management_agent_properties: Additional properties for this Management Agent
        :param pulumi.Input[str] platform_name: Platform Name
        :param pulumi.Input[str] platform_type: Platform Type
        :param pulumi.Input[str] platform_version: Platform Version
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementAgentPluginListArgs', 'ManagementAgentPluginListArgsDict']]]] plugin_lists: list of managementAgentPlugins associated with the agent
        :param pulumi.Input[str] resource_artifact_version: Version of the deployment artifact instantiated by this Management Agent. The format for Standalone resourceMode is YYMMDD.HHMM, and the format for other modes (whose artifacts are based upon Standalone but can advance independently) is YYMMDD.HHMM.VVVVVVVVVVVV. VVVVVVVVVVVV is always a numeric value between 000000000000 and 999999999999
        :param pulumi.Input[str] state: The current state of managementAgent
        :param pulumi.Input[str] time_created: The time the Management Agent was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_last_heartbeat: The time the Management Agent has last recorded its health status in telemetry. This value will be null if the agent has not recorded its health status in last 7 days. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the Management Agent was last updated. An RFC3339 formatted datetime string
        :param pulumi.Input[str] version: Management Agent Version
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagementAgentState.__new__(_ManagementAgentState)

        __props__.__dict__["availability_status"] = availability_status
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["data_source_lists"] = data_source_lists
        __props__.__dict__["data_source_summary_lists"] = data_source_summary_lists
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["deploy_plugins_ids"] = deploy_plugins_ids
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["host"] = host
        __props__.__dict__["host_id"] = host_id
        __props__.__dict__["install_key_id"] = install_key_id
        __props__.__dict__["install_path"] = install_path
        __props__.__dict__["install_type"] = install_type
        __props__.__dict__["is_agent_auto_upgradable"] = is_agent_auto_upgradable
        __props__.__dict__["is_customer_deployed"] = is_customer_deployed
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["managed_agent_id"] = managed_agent_id
        __props__.__dict__["management_agent_properties"] = management_agent_properties
        __props__.__dict__["platform_name"] = platform_name
        __props__.__dict__["platform_type"] = platform_type
        __props__.__dict__["platform_version"] = platform_version
        __props__.__dict__["plugin_lists"] = plugin_lists
        __props__.__dict__["resource_artifact_version"] = resource_artifact_version
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_heartbeat"] = time_last_heartbeat
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["version"] = version
        return ManagementAgent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> pulumi.Output[str]:
        """
        The current availability status of managementAgent
        """
        return pulumi.get(self, "availability_status")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        Compartment owning this DataSource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataSourceLists")
    def data_source_lists(self) -> pulumi.Output[Sequence['outputs.ManagementAgentDataSourceList']]:
        """
        list of dataSources associated with the agent
        """
        return pulumi.get(self, "data_source_lists")

    @property
    @pulumi.getter(name="dataSourceSummaryLists")
    def data_source_summary_lists(self) -> pulumi.Output[Sequence['outputs.ManagementAgentDataSourceSummaryList']]:
        return pulumi.get(self, "data_source_summary_lists")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deployPluginsIds")
    def deploy_plugins_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "deploy_plugins_ids")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) New displayName of Agent.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        Management Agent host machine name
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Output[str]:
        """
        Host resource ocid
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter(name="installKeyId")
    def install_key_id(self) -> pulumi.Output[str]:
        """
        agent install key identifier
        """
        return pulumi.get(self, "install_key_id")

    @property
    @pulumi.getter(name="installPath")
    def install_path(self) -> pulumi.Output[str]:
        """
        Path where Management Agent is installed
        """
        return pulumi.get(self, "install_path")

    @property
    @pulumi.getter(name="installType")
    def install_type(self) -> pulumi.Output[str]:
        """
        The install type, either AGENT or GATEWAY
        """
        return pulumi.get(self, "install_type")

    @property
    @pulumi.getter(name="isAgentAutoUpgradable")
    def is_agent_auto_upgradable(self) -> pulumi.Output[bool]:
        """
        true if the agent can be upgraded automatically; false if it must be upgraded manually. This flag is derived from the tenancy level auto upgrade preference.
        """
        return pulumi.get(self, "is_agent_auto_upgradable")

    @property
    @pulumi.getter(name="isCustomerDeployed")
    def is_customer_deployed(self) -> pulumi.Output[bool]:
        """
        true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
        """
        return pulumi.get(self, "is_customer_deployed")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="managedAgentId")
    def managed_agent_id(self) -> pulumi.Output[str]:
        """
        Unique Management Agent identifier
        """
        return pulumi.get(self, "managed_agent_id")

    @property
    @pulumi.getter(name="managementAgentProperties")
    def management_agent_properties(self) -> pulumi.Output[Sequence['outputs.ManagementAgentManagementAgentProperty']]:
        """
        Additional properties for this Management Agent
        """
        return pulumi.get(self, "management_agent_properties")

    @property
    @pulumi.getter(name="platformName")
    def platform_name(self) -> pulumi.Output[str]:
        """
        Platform Name
        """
        return pulumi.get(self, "platform_name")

    @property
    @pulumi.getter(name="platformType")
    def platform_type(self) -> pulumi.Output[str]:
        """
        Platform Type
        """
        return pulumi.get(self, "platform_type")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> pulumi.Output[str]:
        """
        Platform Version
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="pluginLists")
    def plugin_lists(self) -> pulumi.Output[Sequence['outputs.ManagementAgentPluginList']]:
        """
        list of managementAgentPlugins associated with the agent
        """
        return pulumi.get(self, "plugin_lists")

    @property
    @pulumi.getter(name="resourceArtifactVersion")
    def resource_artifact_version(self) -> pulumi.Output[str]:
        """
        Version of the deployment artifact instantiated by this Management Agent. The format for Standalone resourceMode is YYMMDD.HHMM, and the format for other modes (whose artifacts are based upon Standalone but can advance independently) is YYMMDD.HHMM.VVVVVVVVVVVV. VVVVVVVVVVVV is always a numeric value between 000000000000 and 999999999999
        """
        return pulumi.get(self, "resource_artifact_version")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of managementAgent
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the Management Agent was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastHeartbeat")
    def time_last_heartbeat(self) -> pulumi.Output[str]:
        """
        The time the Management Agent has last recorded its health status in telemetry. This value will be null if the agent has not recorded its health status in last 7 days. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_last_heartbeat")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the Management Agent was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Management Agent Version
        """
        return pulumi.get(self, "version")

