# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMediaWorkflowTaskDeclarationResult',
    'AwaitableGetMediaWorkflowTaskDeclarationResult',
    'get_media_workflow_task_declaration',
    'get_media_workflow_task_declaration_output',
]

@pulumi.output_type
class GetMediaWorkflowTaskDeclarationResult:
    """
    A collection of values returned by getMediaWorkflowTaskDeclaration.
    """
    def __init__(__self__, compartment_id=None, id=None, is_current=None, items=None, name=None, version=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_current and not isinstance(is_current, bool):
            raise TypeError("Expected argument 'is_current' to be a bool")
        pulumi.set(__self__, "is_current", is_current)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCurrent")
    def is_current(self) -> Optional[bool]:
        return pulumi.get(self, "is_current")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetMediaWorkflowTaskDeclarationItemResult']:
        """
        List of MediaWorkflowTaskDeclaration objects.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        MediaWorkflowTaskDeclaration identifier. The name and version should be unique among MediaWorkflowTaskDeclarations.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[int]:
        """
        The version of MediaWorkflowTaskDeclaration, incremented whenever the team implementing the task processor modifies the JSON schema of this declaration's definitions, parameters or list of required parameters.
        """
        return pulumi.get(self, "version")


class AwaitableGetMediaWorkflowTaskDeclarationResult(GetMediaWorkflowTaskDeclarationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMediaWorkflowTaskDeclarationResult(
            compartment_id=self.compartment_id,
            id=self.id,
            is_current=self.is_current,
            items=self.items,
            name=self.name,
            version=self.version)


def get_media_workflow_task_declaration(compartment_id: Optional[str] = None,
                                        is_current: Optional[bool] = None,
                                        name: Optional[str] = None,
                                        version: Optional[int] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMediaWorkflowTaskDeclarationResult:
    """
    This data source provides details about a specific Media Workflow Task Declaration resource in Oracle Cloud Infrastructure Media Services service.

    Returns a list of MediaWorkflowTaskDeclarations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_media_workflow_task_declaration = oci.MediaServices.get_media_workflow_task_declaration(compartment_id=compartment_id,
        is_current=media_workflow_task_declaration_is_current,
        name=media_workflow_task_declaration_name,
        version=media_workflow_task_declaration_version)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param bool is_current: A filter to only select the newest version for each MediaWorkflowTaskDeclaration name.
    :param str name: A filter to return only the resources with their system defined, unique name matching the given name.
    :param int version: A filter to select MediaWorkflowTaskDeclaration by version.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['isCurrent'] = is_current
    __args__['name'] = name
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MediaServices/getMediaWorkflowTaskDeclaration:getMediaWorkflowTaskDeclaration', __args__, opts=opts, typ=GetMediaWorkflowTaskDeclarationResult).value

    return AwaitableGetMediaWorkflowTaskDeclarationResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        is_current=pulumi.get(__ret__, 'is_current'),
        items=pulumi.get(__ret__, 'items'),
        name=pulumi.get(__ret__, 'name'),
        version=pulumi.get(__ret__, 'version'))
def get_media_workflow_task_declaration_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                               is_current: Optional[pulumi.Input[Optional[bool]]] = None,
                                               name: Optional[pulumi.Input[Optional[str]]] = None,
                                               version: Optional[pulumi.Input[Optional[int]]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMediaWorkflowTaskDeclarationResult]:
    """
    This data source provides details about a specific Media Workflow Task Declaration resource in Oracle Cloud Infrastructure Media Services service.

    Returns a list of MediaWorkflowTaskDeclarations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_media_workflow_task_declaration = oci.MediaServices.get_media_workflow_task_declaration(compartment_id=compartment_id,
        is_current=media_workflow_task_declaration_is_current,
        name=media_workflow_task_declaration_name,
        version=media_workflow_task_declaration_version)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param bool is_current: A filter to only select the newest version for each MediaWorkflowTaskDeclaration name.
    :param str name: A filter to return only the resources with their system defined, unique name matching the given name.
    :param int version: A filter to select MediaWorkflowTaskDeclaration by version.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['isCurrent'] = is_current
    __args__['name'] = name
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:MediaServices/getMediaWorkflowTaskDeclaration:getMediaWorkflowTaskDeclaration', __args__, opts=opts, typ=GetMediaWorkflowTaskDeclarationResult)
    return __ret__.apply(lambda __response__: GetMediaWorkflowTaskDeclarationResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        is_current=pulumi.get(__response__, 'is_current'),
        items=pulumi.get(__response__, 'items'),
        name=pulumi.get(__response__, 'name'),
        version=pulumi.get(__response__, 'version')))
