# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MediaAssetArgs', 'MediaAsset']

@pulumi.input_type
class MediaAssetArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 bucket: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_lock_override: Optional[pulumi.Input[bool]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetLockArgs']]]] = None,
                 master_media_asset_id: Optional[pulumi.Input[str]] = None,
                 media_asset_tags: Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetMediaAssetTagArgs']]]] = None,
                 media_workflow_job_id: Optional[pulumi.Input[str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetMetadataArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 object_etag: Optional[pulumi.Input[str]] = None,
                 parent_media_asset_id: Optional[pulumi.Input[str]] = None,
                 segment_range_end_index: Optional[pulumi.Input[str]] = None,
                 segment_range_start_index: Optional[pulumi.Input[str]] = None,
                 source_media_workflow_id: Optional[pulumi.Input[str]] = None,
                 source_media_workflow_version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MediaAsset resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier.
        :param pulumi.Input[str] type: (Updatable) The type of the media asset.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] bucket: The name of the object storage bucket where this asset is located.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Display name for the Media Asset. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['MediaAssetLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[str] master_media_asset_id: (Updatable) The ID of the senior most asset from which this asset is derived.
        :param pulumi.Input[Sequence[pulumi.Input['MediaAssetMediaAssetTagArgs']]] media_asset_tags: (Updatable) list of tags for the MediaAsset.
        :param pulumi.Input[str] media_workflow_job_id: The ID of the MediaWorkflowJob used to produce this asset.
        :param pulumi.Input[Sequence[pulumi.Input['MediaAssetMetadataArgs']]] metadatas: (Updatable) List of Metadata.
        :param pulumi.Input[str] namespace: The object storage namespace where this asset is located.
        :param pulumi.Input[str] object: The object storage object name that identifies this asset.
        :param pulumi.Input[str] object_etag: eTag of the underlying object storage object.
        :param pulumi.Input[str] parent_media_asset_id: (Updatable) The ID of the parent asset from which this asset is derived.
        :param pulumi.Input[str] segment_range_end_index: The end index for video segment files.
        :param pulumi.Input[str] segment_range_start_index: The start index for video segment files.
        :param pulumi.Input[str] source_media_workflow_id: The ID of the MediaWorkflow used to produce this asset.
        :param pulumi.Input[str] source_media_workflow_version: The version of the MediaWorkflow used to produce this asset.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "type", type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_lock_override is not None:
            pulumi.set(__self__, "is_lock_override", is_lock_override)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if master_media_asset_id is not None:
            pulumi.set(__self__, "master_media_asset_id", master_media_asset_id)
        if media_asset_tags is not None:
            pulumi.set(__self__, "media_asset_tags", media_asset_tags)
        if media_workflow_job_id is not None:
            pulumi.set(__self__, "media_workflow_job_id", media_workflow_job_id)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if object_etag is not None:
            pulumi.set(__self__, "object_etag", object_etag)
        if parent_media_asset_id is not None:
            pulumi.set(__self__, "parent_media_asset_id", parent_media_asset_id)
        if segment_range_end_index is not None:
            pulumi.set(__self__, "segment_range_end_index", segment_range_end_index)
        if segment_range_start_index is not None:
            pulumi.set(__self__, "segment_range_start_index", segment_range_start_index)
        if source_media_workflow_id is not None:
            pulumi.set(__self__, "source_media_workflow_id", source_media_workflow_id)
        if source_media_workflow_version is not None:
            pulumi.set(__self__, "source_media_workflow_version", source_media_workflow_version)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of the media asset.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the object storage bucket where this asset is located.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Display name for the Media Asset. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_lock_override")

    @is_lock_override.setter
    def is_lock_override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_lock_override", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter(name="masterMediaAssetId")
    def master_media_asset_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The ID of the senior most asset from which this asset is derived.
        """
        return pulumi.get(self, "master_media_asset_id")

    @master_media_asset_id.setter
    def master_media_asset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_media_asset_id", value)

    @property
    @pulumi.getter(name="mediaAssetTags")
    def media_asset_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetMediaAssetTagArgs']]]]:
        """
        (Updatable) list of tags for the MediaAsset.
        """
        return pulumi.get(self, "media_asset_tags")

    @media_asset_tags.setter
    def media_asset_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetMediaAssetTagArgs']]]]):
        pulumi.set(self, "media_asset_tags", value)

    @property
    @pulumi.getter(name="mediaWorkflowJobId")
    def media_workflow_job_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the MediaWorkflowJob used to produce this asset.
        """
        return pulumi.get(self, "media_workflow_job_id")

    @media_workflow_job_id.setter
    def media_workflow_job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_workflow_job_id", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetMetadataArgs']]]]:
        """
        (Updatable) List of Metadata.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The object storage namespace where this asset is located.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The object storage object name that identifies this asset.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="objectEtag")
    def object_etag(self) -> Optional[pulumi.Input[str]]:
        """
        eTag of the underlying object storage object.
        """
        return pulumi.get(self, "object_etag")

    @object_etag.setter
    def object_etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_etag", value)

    @property
    @pulumi.getter(name="parentMediaAssetId")
    def parent_media_asset_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The ID of the parent asset from which this asset is derived.
        """
        return pulumi.get(self, "parent_media_asset_id")

    @parent_media_asset_id.setter
    def parent_media_asset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_media_asset_id", value)

    @property
    @pulumi.getter(name="segmentRangeEndIndex")
    def segment_range_end_index(self) -> Optional[pulumi.Input[str]]:
        """
        The end index for video segment files.
        """
        return pulumi.get(self, "segment_range_end_index")

    @segment_range_end_index.setter
    def segment_range_end_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_range_end_index", value)

    @property
    @pulumi.getter(name="segmentRangeStartIndex")
    def segment_range_start_index(self) -> Optional[pulumi.Input[str]]:
        """
        The start index for video segment files.
        """
        return pulumi.get(self, "segment_range_start_index")

    @segment_range_start_index.setter
    def segment_range_start_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_range_start_index", value)

    @property
    @pulumi.getter(name="sourceMediaWorkflowId")
    def source_media_workflow_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the MediaWorkflow used to produce this asset.
        """
        return pulumi.get(self, "source_media_workflow_id")

    @source_media_workflow_id.setter
    def source_media_workflow_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_media_workflow_id", value)

    @property
    @pulumi.getter(name="sourceMediaWorkflowVersion")
    def source_media_workflow_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the MediaWorkflow used to produce this asset.
        """
        return pulumi.get(self, "source_media_workflow_version")

    @source_media_workflow_version.setter
    def source_media_workflow_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_media_workflow_version", value)


@pulumi.input_type
class _MediaAssetState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_lock_override: Optional[pulumi.Input[bool]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetLockArgs']]]] = None,
                 master_media_asset_id: Optional[pulumi.Input[str]] = None,
                 media_asset_tags: Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetMediaAssetTagArgs']]]] = None,
                 media_workflow_job_id: Optional[pulumi.Input[str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetMetadataArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 object_etag: Optional[pulumi.Input[str]] = None,
                 parent_media_asset_id: Optional[pulumi.Input[str]] = None,
                 segment_range_end_index: Optional[pulumi.Input[str]] = None,
                 segment_range_start_index: Optional[pulumi.Input[str]] = None,
                 source_media_workflow_id: Optional[pulumi.Input[str]] = None,
                 source_media_workflow_version: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MediaAsset resources.
        :param pulumi.Input[str] bucket: The name of the object storage bucket where this asset is located.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Display name for the Media Asset. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['MediaAssetLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[str] master_media_asset_id: (Updatable) The ID of the senior most asset from which this asset is derived.
        :param pulumi.Input[Sequence[pulumi.Input['MediaAssetMediaAssetTagArgs']]] media_asset_tags: (Updatable) list of tags for the MediaAsset.
        :param pulumi.Input[str] media_workflow_job_id: The ID of the MediaWorkflowJob used to produce this asset.
        :param pulumi.Input[Sequence[pulumi.Input['MediaAssetMetadataArgs']]] metadatas: (Updatable) List of Metadata.
        :param pulumi.Input[str] namespace: The object storage namespace where this asset is located.
        :param pulumi.Input[str] object: The object storage object name that identifies this asset.
        :param pulumi.Input[str] object_etag: eTag of the underlying object storage object.
        :param pulumi.Input[str] parent_media_asset_id: (Updatable) The ID of the parent asset from which this asset is derived.
        :param pulumi.Input[str] segment_range_end_index: The end index for video segment files.
        :param pulumi.Input[str] segment_range_start_index: The start index for video segment files.
        :param pulumi.Input[str] source_media_workflow_id: The ID of the MediaWorkflow used to produce this asset.
        :param pulumi.Input[str] source_media_workflow_version: The version of the MediaWorkflow used to produce this asset.
        :param pulumi.Input[str] state: The current state of the MediaAsset.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time when the MediaAsset was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the MediaAsset was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] type: (Updatable) The type of the media asset.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_lock_override is not None:
            pulumi.set(__self__, "is_lock_override", is_lock_override)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if master_media_asset_id is not None:
            pulumi.set(__self__, "master_media_asset_id", master_media_asset_id)
        if media_asset_tags is not None:
            pulumi.set(__self__, "media_asset_tags", media_asset_tags)
        if media_workflow_job_id is not None:
            pulumi.set(__self__, "media_workflow_job_id", media_workflow_job_id)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if object_etag is not None:
            pulumi.set(__self__, "object_etag", object_etag)
        if parent_media_asset_id is not None:
            pulumi.set(__self__, "parent_media_asset_id", parent_media_asset_id)
        if segment_range_end_index is not None:
            pulumi.set(__self__, "segment_range_end_index", segment_range_end_index)
        if segment_range_start_index is not None:
            pulumi.set(__self__, "segment_range_start_index", segment_range_start_index)
        if source_media_workflow_id is not None:
            pulumi.set(__self__, "source_media_workflow_id", source_media_workflow_id)
        if source_media_workflow_version is not None:
            pulumi.set(__self__, "source_media_workflow_version", source_media_workflow_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the object storage bucket where this asset is located.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Display name for the Media Asset. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_lock_override")

    @is_lock_override.setter
    def is_lock_override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_lock_override", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter(name="masterMediaAssetId")
    def master_media_asset_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The ID of the senior most asset from which this asset is derived.
        """
        return pulumi.get(self, "master_media_asset_id")

    @master_media_asset_id.setter
    def master_media_asset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_media_asset_id", value)

    @property
    @pulumi.getter(name="mediaAssetTags")
    def media_asset_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetMediaAssetTagArgs']]]]:
        """
        (Updatable) list of tags for the MediaAsset.
        """
        return pulumi.get(self, "media_asset_tags")

    @media_asset_tags.setter
    def media_asset_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetMediaAssetTagArgs']]]]):
        pulumi.set(self, "media_asset_tags", value)

    @property
    @pulumi.getter(name="mediaWorkflowJobId")
    def media_workflow_job_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the MediaWorkflowJob used to produce this asset.
        """
        return pulumi.get(self, "media_workflow_job_id")

    @media_workflow_job_id.setter
    def media_workflow_job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_workflow_job_id", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetMetadataArgs']]]]:
        """
        (Updatable) List of Metadata.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MediaAssetMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The object storage namespace where this asset is located.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The object storage object name that identifies this asset.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="objectEtag")
    def object_etag(self) -> Optional[pulumi.Input[str]]:
        """
        eTag of the underlying object storage object.
        """
        return pulumi.get(self, "object_etag")

    @object_etag.setter
    def object_etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_etag", value)

    @property
    @pulumi.getter(name="parentMediaAssetId")
    def parent_media_asset_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The ID of the parent asset from which this asset is derived.
        """
        return pulumi.get(self, "parent_media_asset_id")

    @parent_media_asset_id.setter
    def parent_media_asset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_media_asset_id", value)

    @property
    @pulumi.getter(name="segmentRangeEndIndex")
    def segment_range_end_index(self) -> Optional[pulumi.Input[str]]:
        """
        The end index for video segment files.
        """
        return pulumi.get(self, "segment_range_end_index")

    @segment_range_end_index.setter
    def segment_range_end_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_range_end_index", value)

    @property
    @pulumi.getter(name="segmentRangeStartIndex")
    def segment_range_start_index(self) -> Optional[pulumi.Input[str]]:
        """
        The start index for video segment files.
        """
        return pulumi.get(self, "segment_range_start_index")

    @segment_range_start_index.setter
    def segment_range_start_index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment_range_start_index", value)

    @property
    @pulumi.getter(name="sourceMediaWorkflowId")
    def source_media_workflow_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the MediaWorkflow used to produce this asset.
        """
        return pulumi.get(self, "source_media_workflow_id")

    @source_media_workflow_id.setter
    def source_media_workflow_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_media_workflow_id", value)

    @property
    @pulumi.getter(name="sourceMediaWorkflowVersion")
    def source_media_workflow_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the MediaWorkflow used to produce this asset.
        """
        return pulumi.get(self, "source_media_workflow_version")

    @source_media_workflow_version.setter
    def source_media_workflow_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_media_workflow_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the MediaAsset.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the MediaAsset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the MediaAsset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of the media asset.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class MediaAsset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_lock_override: Optional[pulumi.Input[bool]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetLockArgs', 'MediaAssetLockArgsDict']]]]] = None,
                 master_media_asset_id: Optional[pulumi.Input[str]] = None,
                 media_asset_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetMediaAssetTagArgs', 'MediaAssetMediaAssetTagArgsDict']]]]] = None,
                 media_workflow_job_id: Optional[pulumi.Input[str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetMetadataArgs', 'MediaAssetMetadataArgsDict']]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 object_etag: Optional[pulumi.Input[str]] = None,
                 parent_media_asset_id: Optional[pulumi.Input[str]] = None,
                 segment_range_end_index: Optional[pulumi.Input[str]] = None,
                 segment_range_start_index: Optional[pulumi.Input[str]] = None,
                 source_media_workflow_id: Optional[pulumi.Input[str]] = None,
                 source_media_workflow_version: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Media Asset resource in Oracle Cloud Infrastructure Media Services service.

        Creates a new MediaAsset.

        ## Import

        MediaAssets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:MediaServices/mediaAsset:MediaAsset test_media_asset "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: The name of the object storage bucket where this asset is located.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Display name for the Media Asset. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetLockArgs', 'MediaAssetLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[str] master_media_asset_id: (Updatable) The ID of the senior most asset from which this asset is derived.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetMediaAssetTagArgs', 'MediaAssetMediaAssetTagArgsDict']]]] media_asset_tags: (Updatable) list of tags for the MediaAsset.
        :param pulumi.Input[str] media_workflow_job_id: The ID of the MediaWorkflowJob used to produce this asset.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetMetadataArgs', 'MediaAssetMetadataArgsDict']]]] metadatas: (Updatable) List of Metadata.
        :param pulumi.Input[str] namespace: The object storage namespace where this asset is located.
        :param pulumi.Input[str] object: The object storage object name that identifies this asset.
        :param pulumi.Input[str] object_etag: eTag of the underlying object storage object.
        :param pulumi.Input[str] parent_media_asset_id: (Updatable) The ID of the parent asset from which this asset is derived.
        :param pulumi.Input[str] segment_range_end_index: The end index for video segment files.
        :param pulumi.Input[str] segment_range_start_index: The start index for video segment files.
        :param pulumi.Input[str] source_media_workflow_id: The ID of the MediaWorkflow used to produce this asset.
        :param pulumi.Input[str] source_media_workflow_version: The version of the MediaWorkflow used to produce this asset.
        :param pulumi.Input[str] type: (Updatable) The type of the media asset.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MediaAssetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Media Asset resource in Oracle Cloud Infrastructure Media Services service.

        Creates a new MediaAsset.

        ## Import

        MediaAssets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:MediaServices/mediaAsset:MediaAsset test_media_asset "id"
        ```

        :param str resource_name: The name of the resource.
        :param MediaAssetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MediaAssetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_lock_override: Optional[pulumi.Input[bool]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetLockArgs', 'MediaAssetLockArgsDict']]]]] = None,
                 master_media_asset_id: Optional[pulumi.Input[str]] = None,
                 media_asset_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetMediaAssetTagArgs', 'MediaAssetMediaAssetTagArgsDict']]]]] = None,
                 media_workflow_job_id: Optional[pulumi.Input[str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetMetadataArgs', 'MediaAssetMetadataArgsDict']]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 object_etag: Optional[pulumi.Input[str]] = None,
                 parent_media_asset_id: Optional[pulumi.Input[str]] = None,
                 segment_range_end_index: Optional[pulumi.Input[str]] = None,
                 segment_range_start_index: Optional[pulumi.Input[str]] = None,
                 source_media_workflow_id: Optional[pulumi.Input[str]] = None,
                 source_media_workflow_version: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MediaAssetArgs.__new__(MediaAssetArgs)

            __props__.__dict__["bucket"] = bucket
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_lock_override"] = is_lock_override
            __props__.__dict__["locks"] = locks
            __props__.__dict__["master_media_asset_id"] = master_media_asset_id
            __props__.__dict__["media_asset_tags"] = media_asset_tags
            __props__.__dict__["media_workflow_job_id"] = media_workflow_job_id
            __props__.__dict__["metadatas"] = metadatas
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["object"] = object
            __props__.__dict__["object_etag"] = object_etag
            __props__.__dict__["parent_media_asset_id"] = parent_media_asset_id
            __props__.__dict__["segment_range_end_index"] = segment_range_end_index
            __props__.__dict__["segment_range_start_index"] = segment_range_start_index
            __props__.__dict__["source_media_workflow_id"] = source_media_workflow_id
            __props__.__dict__["source_media_workflow_version"] = source_media_workflow_version
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MediaAsset, __self__).__init__(
            'oci:MediaServices/mediaAsset:MediaAsset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            is_lock_override: Optional[pulumi.Input[bool]] = None,
            locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetLockArgs', 'MediaAssetLockArgsDict']]]]] = None,
            master_media_asset_id: Optional[pulumi.Input[str]] = None,
            media_asset_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetMediaAssetTagArgs', 'MediaAssetMediaAssetTagArgsDict']]]]] = None,
            media_workflow_job_id: Optional[pulumi.Input[str]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetMetadataArgs', 'MediaAssetMetadataArgsDict']]]]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            object: Optional[pulumi.Input[str]] = None,
            object_etag: Optional[pulumi.Input[str]] = None,
            parent_media_asset_id: Optional[pulumi.Input[str]] = None,
            segment_range_end_index: Optional[pulumi.Input[str]] = None,
            segment_range_start_index: Optional[pulumi.Input[str]] = None,
            source_media_workflow_id: Optional[pulumi.Input[str]] = None,
            source_media_workflow_version: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'MediaAsset':
        """
        Get an existing MediaAsset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: The name of the object storage bucket where this asset is located.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Display name for the Media Asset. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetLockArgs', 'MediaAssetLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[str] master_media_asset_id: (Updatable) The ID of the senior most asset from which this asset is derived.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetMediaAssetTagArgs', 'MediaAssetMediaAssetTagArgsDict']]]] media_asset_tags: (Updatable) list of tags for the MediaAsset.
        :param pulumi.Input[str] media_workflow_job_id: The ID of the MediaWorkflowJob used to produce this asset.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MediaAssetMetadataArgs', 'MediaAssetMetadataArgsDict']]]] metadatas: (Updatable) List of Metadata.
        :param pulumi.Input[str] namespace: The object storage namespace where this asset is located.
        :param pulumi.Input[str] object: The object storage object name that identifies this asset.
        :param pulumi.Input[str] object_etag: eTag of the underlying object storage object.
        :param pulumi.Input[str] parent_media_asset_id: (Updatable) The ID of the parent asset from which this asset is derived.
        :param pulumi.Input[str] segment_range_end_index: The end index for video segment files.
        :param pulumi.Input[str] segment_range_start_index: The start index for video segment files.
        :param pulumi.Input[str] source_media_workflow_id: The ID of the MediaWorkflow used to produce this asset.
        :param pulumi.Input[str] source_media_workflow_version: The version of the MediaWorkflow used to produce this asset.
        :param pulumi.Input[str] state: The current state of the MediaAsset.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time when the MediaAsset was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the MediaAsset was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] type: (Updatable) The type of the media asset.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MediaAssetState.__new__(_MediaAssetState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_lock_override"] = is_lock_override
        __props__.__dict__["locks"] = locks
        __props__.__dict__["master_media_asset_id"] = master_media_asset_id
        __props__.__dict__["media_asset_tags"] = media_asset_tags
        __props__.__dict__["media_workflow_job_id"] = media_workflow_job_id
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["object"] = object
        __props__.__dict__["object_etag"] = object_etag
        __props__.__dict__["parent_media_asset_id"] = parent_media_asset_id
        __props__.__dict__["segment_range_end_index"] = segment_range_end_index
        __props__.__dict__["segment_range_start_index"] = segment_range_start_index
        __props__.__dict__["source_media_workflow_id"] = source_media_workflow_id
        __props__.__dict__["source_media_workflow_version"] = source_media_workflow_version
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return MediaAsset(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        The name of the object storage bucket where this asset is located.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Display name for the Media Asset. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter
    def locks(self) -> pulumi.Output[Sequence['outputs.MediaAssetLock']]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="masterMediaAssetId")
    def master_media_asset_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The ID of the senior most asset from which this asset is derived.
        """
        return pulumi.get(self, "master_media_asset_id")

    @property
    @pulumi.getter(name="mediaAssetTags")
    def media_asset_tags(self) -> pulumi.Output[Sequence['outputs.MediaAssetMediaAssetTag']]:
        """
        (Updatable) list of tags for the MediaAsset.
        """
        return pulumi.get(self, "media_asset_tags")

    @property
    @pulumi.getter(name="mediaWorkflowJobId")
    def media_workflow_job_id(self) -> pulumi.Output[str]:
        """
        The ID of the MediaWorkflowJob used to produce this asset.
        """
        return pulumi.get(self, "media_workflow_job_id")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.MediaAssetMetadata']]:
        """
        (Updatable) List of Metadata.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The object storage namespace where this asset is located.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> pulumi.Output[str]:
        """
        The object storage object name that identifies this asset.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="objectEtag")
    def object_etag(self) -> pulumi.Output[str]:
        """
        eTag of the underlying object storage object.
        """
        return pulumi.get(self, "object_etag")

    @property
    @pulumi.getter(name="parentMediaAssetId")
    def parent_media_asset_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The ID of the parent asset from which this asset is derived.
        """
        return pulumi.get(self, "parent_media_asset_id")

    @property
    @pulumi.getter(name="segmentRangeEndIndex")
    def segment_range_end_index(self) -> pulumi.Output[str]:
        """
        The end index for video segment files.
        """
        return pulumi.get(self, "segment_range_end_index")

    @property
    @pulumi.getter(name="segmentRangeStartIndex")
    def segment_range_start_index(self) -> pulumi.Output[str]:
        """
        The start index for video segment files.
        """
        return pulumi.get(self, "segment_range_start_index")

    @property
    @pulumi.getter(name="sourceMediaWorkflowId")
    def source_media_workflow_id(self) -> pulumi.Output[str]:
        """
        The ID of the MediaWorkflow used to produce this asset.
        """
        return pulumi.get(self, "source_media_workflow_id")

    @property
    @pulumi.getter(name="sourceMediaWorkflowVersion")
    def source_media_workflow_version(self) -> pulumi.Output[str]:
        """
        The version of the MediaWorkflow used to produce this asset.
        """
        return pulumi.get(self, "source_media_workflow_version")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the MediaAsset.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time when the MediaAsset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time when the MediaAsset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        (Updatable) The type of the media asset.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

