# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAlarmSuppressionResult',
    'AwaitableGetAlarmSuppressionResult',
    'get_alarm_suppression',
    'get_alarm_suppression_output',
]

@pulumi.output_type
class GetAlarmSuppressionResult:
    """
    A collection of values returned by getAlarmSuppression.
    """
    def __init__(__self__, alarm_suppression_id=None, alarm_suppression_targets=None, compartment_id=None, defined_tags=None, description=None, dimensions=None, display_name=None, freeform_tags=None, id=None, level=None, state=None, suppression_conditions=None, time_created=None, time_suppress_from=None, time_suppress_until=None, time_updated=None):
        if alarm_suppression_id and not isinstance(alarm_suppression_id, str):
            raise TypeError("Expected argument 'alarm_suppression_id' to be a str")
        pulumi.set(__self__, "alarm_suppression_id", alarm_suppression_id)
        if alarm_suppression_targets and not isinstance(alarm_suppression_targets, list):
            raise TypeError("Expected argument 'alarm_suppression_targets' to be a list")
        pulumi.set(__self__, "alarm_suppression_targets", alarm_suppression_targets)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dimensions and not isinstance(dimensions, dict):
            raise TypeError("Expected argument 'dimensions' to be a dict")
        pulumi.set(__self__, "dimensions", dimensions)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if level and not isinstance(level, str):
            raise TypeError("Expected argument 'level' to be a str")
        pulumi.set(__self__, "level", level)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if suppression_conditions and not isinstance(suppression_conditions, list):
            raise TypeError("Expected argument 'suppression_conditions' to be a list")
        pulumi.set(__self__, "suppression_conditions", suppression_conditions)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_suppress_from and not isinstance(time_suppress_from, str):
            raise TypeError("Expected argument 'time_suppress_from' to be a str")
        pulumi.set(__self__, "time_suppress_from", time_suppress_from)
        if time_suppress_until and not isinstance(time_suppress_until, str):
            raise TypeError("Expected argument 'time_suppress_until' to be a str")
        pulumi.set(__self__, "time_suppress_until", time_suppress_until)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alarmSuppressionId")
    def alarm_suppression_id(self) -> str:
        return pulumi.get(self, "alarm_suppression_id")

    @property
    @pulumi.getter(name="alarmSuppressionTargets")
    def alarm_suppression_targets(self) -> Sequence['outputs.GetAlarmSuppressionAlarmSuppressionTargetResult']:
        """
        The target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_suppression_targets")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm suppression.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dimensions(self) -> Mapping[str, str]:
        """
        Configured dimension filter for suppressing alarm state entries that include the set of specified dimension key-value pairs.  Example: `{"resourceId": "instance.region1.phx.exampleuniqueID"}`
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm suppression.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        The level of this alarm suppression. `ALARM` indicates a suppression of the entire alarm, regardless of dimension. `DIMENSION` indicates a suppression configured for specified dimensions.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the alarm suppression.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="suppressionConditions")
    def suppression_conditions(self) -> Sequence['outputs.GetAlarmSuppressionSuppressionConditionResult']:
        """
        Array of all preconditions for alarm suppression. Example: `[{ conditionType: "RECURRENCE", suppressionRecurrence: "FRQ=DAILY;BYHOUR=10", suppressionDuration: "PT1H" }]`
        """
        return pulumi.get(self, "suppression_conditions")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the alarm suppression was created. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> str:
        """
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> str:
        """
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2018-02-01T02:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_until")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.  Example: `2018-02-03T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAlarmSuppressionResult(GetAlarmSuppressionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlarmSuppressionResult(
            alarm_suppression_id=self.alarm_suppression_id,
            alarm_suppression_targets=self.alarm_suppression_targets,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            dimensions=self.dimensions,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            level=self.level,
            state=self.state,
            suppression_conditions=self.suppression_conditions,
            time_created=self.time_created,
            time_suppress_from=self.time_suppress_from,
            time_suppress_until=self.time_suppress_until,
            time_updated=self.time_updated)


def get_alarm_suppression(alarm_suppression_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlarmSuppressionResult:
    """
    This data source provides details about a specific Alarm Suppression resource in Oracle Cloud Infrastructure Monitoring service.

    Gets the specified alarm suppression. For more information, see
    [Getting an Alarm-wide Suppression](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/get-alarm-suppression.htm).

    For important limits information, see
    [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

    This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
    Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
    or transactions, per second (TPS) for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alarm_suppression = oci.Monitoring.get_alarm_suppression(alarm_suppression_id=test_alarm_suppression_oci_monitoring_alarm_suppression["id"])
    ```


    :param str alarm_suppression_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm suppression.
    """
    __args__ = dict()
    __args__['alarmSuppressionId'] = alarm_suppression_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Monitoring/getAlarmSuppression:getAlarmSuppression', __args__, opts=opts, typ=GetAlarmSuppressionResult).value

    return AwaitableGetAlarmSuppressionResult(
        alarm_suppression_id=pulumi.get(__ret__, 'alarm_suppression_id'),
        alarm_suppression_targets=pulumi.get(__ret__, 'alarm_suppression_targets'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        dimensions=pulumi.get(__ret__, 'dimensions'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        level=pulumi.get(__ret__, 'level'),
        state=pulumi.get(__ret__, 'state'),
        suppression_conditions=pulumi.get(__ret__, 'suppression_conditions'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_suppress_from=pulumi.get(__ret__, 'time_suppress_from'),
        time_suppress_until=pulumi.get(__ret__, 'time_suppress_until'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_alarm_suppression_output(alarm_suppression_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlarmSuppressionResult]:
    """
    This data source provides details about a specific Alarm Suppression resource in Oracle Cloud Infrastructure Monitoring service.

    Gets the specified alarm suppression. For more information, see
    [Getting an Alarm-wide Suppression](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Tasks/get-alarm-suppression.htm).

    For important limits information, see
    [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

    This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
    Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
    or transactions, per second (TPS) for a given tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alarm_suppression = oci.Monitoring.get_alarm_suppression(alarm_suppression_id=test_alarm_suppression_oci_monitoring_alarm_suppression["id"])
    ```


    :param str alarm_suppression_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the alarm suppression.
    """
    __args__ = dict()
    __args__['alarmSuppressionId'] = alarm_suppression_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Monitoring/getAlarmSuppression:getAlarmSuppression', __args__, opts=opts, typ=GetAlarmSuppressionResult)
    return __ret__.apply(lambda __response__: GetAlarmSuppressionResult(
        alarm_suppression_id=pulumi.get(__response__, 'alarm_suppression_id'),
        alarm_suppression_targets=pulumi.get(__response__, 'alarm_suppression_targets'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        dimensions=pulumi.get(__response__, 'dimensions'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        level=pulumi.get(__response__, 'level'),
        state=pulumi.get(__response__, 'state'),
        suppression_conditions=pulumi.get(__response__, 'suppression_conditions'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_suppress_from=pulumi.get(__response__, 'time_suppress_from'),
        time_suppress_until=pulumi.get(__response__, 'time_suppress_until'),
        time_updated=pulumi.get(__response__, 'time_updated')))
