# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetActionsResult',
    'AwaitableGetActionsResult',
    'get_actions',
    'get_actions_output',
]

@pulumi.output_type
class GetActionsResult:
    """
    A collection of values returned by getActions.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, operator_action_collections=None, resource_type=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if operator_action_collections and not isinstance(operator_action_collections, list):
            raise TypeError("Expected argument 'operator_action_collections' to be a list")
        pulumi.set(__self__, "operator_action_collections", operator_action_collections)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetActionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operatorActionCollections")
    def operator_action_collections(self) -> Sequence['outputs.GetActionsOperatorActionCollectionResult']:
        """
        The list of operator_action_collection.
        """
        return pulumi.get(self, "operator_action_collections")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        """
        resourceType for which the OperatorAction is applicable
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")


class AwaitableGetActionsResult(GetActionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetActionsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            operator_action_collections=self.operator_action_collections,
            resource_type=self.resource_type,
            state=self.state)


def get_actions(compartment_id: Optional[str] = None,
                filters: Optional[Sequence[Union['GetActionsFilterArgs', 'GetActionsFilterArgsDict']]] = None,
                name: Optional[str] = None,
                resource_type: Optional[str] = None,
                state: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetActionsResult:
    """
    This data source provides the list of Operator Actions in Oracle Cloud Infrastructure Operator Access Control service.

    Lists all the OperatorActions available in the system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operator_actions = oci.OperatorAccessControl.get_actions(compartment_id=compartment_id,
        name=operator_action_name,
        resource_type=operator_action_resource_type,
        state=operator_action_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str name: A filter to return only resources that match the entire display name given.
    :param str resource_type: A filter to return only lists of resources that match the entire given service type.
    :param str state: A filter to return only resources whose lifecycleState matches the given OperatorAction lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['resourceType'] = resource_type
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OperatorAccessControl/getActions:getActions', __args__, opts=opts, typ=GetActionsResult).value

    return AwaitableGetActionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        operator_action_collections=pulumi.get(__ret__, 'operator_action_collections'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        state=pulumi.get(__ret__, 'state'))
def get_actions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetActionsFilterArgs', 'GetActionsFilterArgsDict']]]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       resource_type: Optional[pulumi.Input[Optional[str]]] = None,
                       state: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetActionsResult]:
    """
    This data source provides the list of Operator Actions in Oracle Cloud Infrastructure Operator Access Control service.

    Lists all the OperatorActions available in the system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_operator_actions = oci.OperatorAccessControl.get_actions(compartment_id=compartment_id,
        name=operator_action_name,
        resource_type=operator_action_resource_type,
        state=operator_action_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str name: A filter to return only resources that match the entire display name given.
    :param str resource_type: A filter to return only lists of resources that match the entire given service type.
    :param str state: A filter to return only resources whose lifecycleState matches the given OperatorAction lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['resourceType'] = resource_type
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OperatorAccessControl/getActions:getActions', __args__, opts=opts, typ=GetActionsResult)
    return __ret__.apply(lambda __response__: GetActionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        operator_action_collections=pulumi.get(__response__, 'operator_action_collections'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        state=pulumi.get(__response__, 'state')))
