# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceGroupInstallWindowsUpdatesManagementArgs', 'ManagedInstanceGroupInstallWindowsUpdatesManagement']

@pulumi.input_type
class ManagedInstanceGroupInstallWindowsUpdatesManagementArgs:
    def __init__(__self__, *,
                 managed_instance_group_id: pulumi.Input[str],
                 windows_update_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 work_request_details: Optional[pulumi.Input['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs']] = None):
        """
        The set of arguments for constructing a ManagedInstanceGroupInstallWindowsUpdatesManagement resource.
        :param pulumi.Input[str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] windows_update_types: The type of Windows updates to be applied.
        :param pulumi.Input['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        pulumi.set(__self__, "windows_update_types", windows_update_types)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter(name="windowsUpdateTypes")
    def windows_update_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The type of Windows updates to be applied.
        """
        return pulumi.get(self, "windows_update_types")

    @windows_update_types.setter
    def windows_update_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "windows_update_types", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.input_type
class _ManagedInstanceGroupInstallWindowsUpdatesManagementState:
    def __init__(__self__, *,
                 managed_instance_group_id: Optional[pulumi.Input[str]] = None,
                 windows_update_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 work_request_details: Optional[pulumi.Input['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceGroupInstallWindowsUpdatesManagement resources.
        :param pulumi.Input[str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] windows_update_types: The type of Windows updates to be applied.
        :param pulumi.Input['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        if managed_instance_group_id is not None:
            pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if windows_update_types is not None:
            pulumi.set(__self__, "windows_update_types", windows_update_types)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter(name="windowsUpdateTypes")
    def windows_update_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The type of Windows updates to be applied.
        """
        return pulumi.get(self, "windows_update_types")

    @windows_update_types.setter
    def windows_update_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "windows_update_types", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


class ManagedInstanceGroupInstallWindowsUpdatesManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_group_id: Optional[pulumi.Input[str]] = None,
                 windows_update_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance Group Install Windows Updates Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Installs Windows updates on each managed instance in the managed instance group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_install_windows_updates_management = oci.os_management_hub.ManagedInstanceGroupInstallWindowsUpdatesManagement("test_managed_instance_group_install_windows_updates_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            windows_update_types=managed_instance_group_install_windows_updates_management_windows_update_types,
            work_request_details={
                "description": managed_instance_group_install_windows_updates_management_work_request_details_description,
                "display_name": managed_instance_group_install_windows_updates_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceGroupInstallWindowsUpdatesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupInstallWindowsUpdatesManagement:ManagedInstanceGroupInstallWindowsUpdatesManagement test_managed_instance_group_install_windows_updates_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] windows_update_types: The type of Windows updates to be applied.
        :param pulumi.Input[Union['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceGroupInstallWindowsUpdatesManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance Group Install Windows Updates Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Installs Windows updates on each managed instance in the managed instance group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_install_windows_updates_management = oci.os_management_hub.ManagedInstanceGroupInstallWindowsUpdatesManagement("test_managed_instance_group_install_windows_updates_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            windows_update_types=managed_instance_group_install_windows_updates_management_windows_update_types,
            work_request_details={
                "description": managed_instance_group_install_windows_updates_management_work_request_details_description,
                "display_name": managed_instance_group_install_windows_updates_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceGroupInstallWindowsUpdatesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupInstallWindowsUpdatesManagement:ManagedInstanceGroupInstallWindowsUpdatesManagement test_managed_instance_group_install_windows_updates_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceGroupInstallWindowsUpdatesManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceGroupInstallWindowsUpdatesManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_group_id: Optional[pulumi.Input[str]] = None,
                 windows_update_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceGroupInstallWindowsUpdatesManagementArgs.__new__(ManagedInstanceGroupInstallWindowsUpdatesManagementArgs)

            if managed_instance_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_group_id'")
            __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
            if windows_update_types is None and not opts.urn:
                raise TypeError("Missing required property 'windows_update_types'")
            __props__.__dict__["windows_update_types"] = windows_update_types
            __props__.__dict__["work_request_details"] = work_request_details
        super(ManagedInstanceGroupInstallWindowsUpdatesManagement, __self__).__init__(
            'oci:OsManagementHub/managedInstanceGroupInstallWindowsUpdatesManagement:ManagedInstanceGroupInstallWindowsUpdatesManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            managed_instance_group_id: Optional[pulumi.Input[str]] = None,
            windows_update_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgsDict']]] = None) -> 'ManagedInstanceGroupInstallWindowsUpdatesManagement':
        """
        Get an existing ManagedInstanceGroupInstallWindowsUpdatesManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] windows_update_types: The type of Windows updates to be applied.
        :param pulumi.Input[Union['ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceGroupInstallWindowsUpdatesManagementState.__new__(_ManagedInstanceGroupInstallWindowsUpdatesManagementState)

        __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
        __props__.__dict__["windows_update_types"] = windows_update_types
        __props__.__dict__["work_request_details"] = work_request_details
        return ManagedInstanceGroupInstallWindowsUpdatesManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @property
    @pulumi.getter(name="windowsUpdateTypes")
    def windows_update_types(self) -> pulumi.Output[Sequence[str]]:
        """
        The type of Windows updates to be applied.
        """
        return pulumi.get(self, "windows_update_types")

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> pulumi.Output['outputs.ManagedInstanceGroupInstallWindowsUpdatesManagementWorkRequestDetails']:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

