# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMonitoredResourceTypesResult',
    'AwaitableGetMonitoredResourceTypesResult',
    'get_monitored_resource_types',
    'get_monitored_resource_types_output',
]

@pulumi.output_type
class GetMonitoredResourceTypesResult:
    """
    A collection of values returned by getMonitoredResourceTypes.
    """
    def __init__(__self__, compartment_id=None, exclude_fields=None, fields=None, filters=None, id=None, is_exclude_system_types=None, metric_namespace=None, monitored_resource_types_collections=None, name=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if exclude_fields and not isinstance(exclude_fields, list):
            raise TypeError("Expected argument 'exclude_fields' to be a list")
        pulumi.set(__self__, "exclude_fields", exclude_fields)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_exclude_system_types and not isinstance(is_exclude_system_types, bool):
            raise TypeError("Expected argument 'is_exclude_system_types' to be a bool")
        pulumi.set(__self__, "is_exclude_system_types", is_exclude_system_types)
        if metric_namespace and not isinstance(metric_namespace, str):
            raise TypeError("Expected argument 'metric_namespace' to be a str")
        pulumi.set(__self__, "metric_namespace", metric_namespace)
        if monitored_resource_types_collections and not isinstance(monitored_resource_types_collections, list):
            raise TypeError("Expected argument 'monitored_resource_types_collections' to be a list")
        pulumi.set(__self__, "monitored_resource_types_collections", monitored_resource_types_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy containing the resource type.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="excludeFields")
    def exclude_fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "exclude_fields")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMonitoredResourceTypesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isExcludeSystemTypes")
    def is_exclude_system_types(self) -> Optional[bool]:
        return pulumi.get(self, "is_exclude_system_types")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[str]:
        """
        Metric namespace for resource type.
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter(name="monitoredResourceTypesCollections")
    def monitored_resource_types_collections(self) -> Sequence['outputs.GetMonitoredResourceTypesMonitoredResourceTypesCollectionResult']:
        """
        The list of monitored_resource_types_collection.
        """
        return pulumi.get(self, "monitored_resource_types_collections")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A unique monitored resource type name. The name must be unique across tenancy.  Name can not be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetMonitoredResourceTypesResult(GetMonitoredResourceTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitoredResourceTypesResult(
            compartment_id=self.compartment_id,
            exclude_fields=self.exclude_fields,
            fields=self.fields,
            filters=self.filters,
            id=self.id,
            is_exclude_system_types=self.is_exclude_system_types,
            metric_namespace=self.metric_namespace,
            monitored_resource_types_collections=self.monitored_resource_types_collections,
            name=self.name,
            status=self.status)


def get_monitored_resource_types(compartment_id: Optional[str] = None,
                                 exclude_fields: Optional[Sequence[str]] = None,
                                 fields: Optional[Sequence[str]] = None,
                                 filters: Optional[Sequence[Union['GetMonitoredResourceTypesFilterArgs', 'GetMonitoredResourceTypesFilterArgsDict']]] = None,
                                 is_exclude_system_types: Optional[bool] = None,
                                 metric_namespace: Optional[str] = None,
                                 name: Optional[str] = None,
                                 status: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitoredResourceTypesResult:
    """
    This data source provides the list of Monitored Resource Types in Oracle Cloud Infrastructure Stack Monitoring service.

    Returns list of resource types accessible to the customer.
    There are two types of resource types - System resource types and User resource types.
    System resource types are available out of the box in the stack monitoring resource service
    and are accessible to all the tenant users. User resource types are created in the context
    of a tenancy and are visible only for the tenancy. By default, both System resource types
    and User resource types are returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_resource_types = oci.StackMonitoring.get_monitored_resource_types(compartment_id=compartment_id,
        exclude_fields=monitored_resource_type_exclude_fields,
        fields=monitored_resource_type_fields,
        is_exclude_system_types=monitored_resource_type_is_exclude_system_types,
        metric_namespace=monitored_resource_type_metric_namespace,
        name=monitored_resource_type_name,
        status=monitored_resource_type_status)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy for which  monitored resource types should be listed.
    :param Sequence[str] exclude_fields: Partial response refers to an optimization technique offered by the RESTful web APIs, to return all the information except the fields requested to be excluded (excludeFields) by the client. In this mechanism, the client sends the exclude field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to exlude and to return and should be a query string parameter called "excludeFields" of an array type, provide the values as enums, and use collectionFormat.
    :param Sequence[str] fields: Partial response refers to an optimization technique offered by the RESTful web APIs, to return only the information (fields) required by the client. In this mechanism, the client sends the required field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to return and should be a query string parameter called "fields" of an array type, provide the values as enums, and use collectionFormat.
           
           MonitoredResourceType Id, name and compartment will be added by default.
    :param bool is_exclude_system_types: A filter to exclude system resource types. If set to true, system resource types will be excluded.
    :param str metric_namespace: A filter to return monitored resource types that has the matching namespace.
    :param str name: A filter to return monitored resource types that match exactly with the resource type name given.
    :param str status: A filter to return only resources that matches with lifecycleState given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['excludeFields'] = exclude_fields
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['isExcludeSystemTypes'] = is_exclude_system_types
    __args__['metricNamespace'] = metric_namespace
    __args__['name'] = name
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getMonitoredResourceTypes:getMonitoredResourceTypes', __args__, opts=opts, typ=GetMonitoredResourceTypesResult).value

    return AwaitableGetMonitoredResourceTypesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        exclude_fields=pulumi.get(__ret__, 'exclude_fields'),
        fields=pulumi.get(__ret__, 'fields'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_exclude_system_types=pulumi.get(__ret__, 'is_exclude_system_types'),
        metric_namespace=pulumi.get(__ret__, 'metric_namespace'),
        monitored_resource_types_collections=pulumi.get(__ret__, 'monitored_resource_types_collections'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'))
def get_monitored_resource_types_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                        exclude_fields: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                        fields: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMonitoredResourceTypesFilterArgs', 'GetMonitoredResourceTypesFilterArgsDict']]]]] = None,
                                        is_exclude_system_types: Optional[pulumi.Input[Optional[bool]]] = None,
                                        metric_namespace: Optional[pulumi.Input[Optional[str]]] = None,
                                        name: Optional[pulumi.Input[Optional[str]]] = None,
                                        status: Optional[pulumi.Input[Optional[str]]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMonitoredResourceTypesResult]:
    """
    This data source provides the list of Monitored Resource Types in Oracle Cloud Infrastructure Stack Monitoring service.

    Returns list of resource types accessible to the customer.
    There are two types of resource types - System resource types and User resource types.
    System resource types are available out of the box in the stack monitoring resource service
    and are accessible to all the tenant users. User resource types are created in the context
    of a tenancy and are visible only for the tenancy. By default, both System resource types
    and User resource types are returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_resource_types = oci.StackMonitoring.get_monitored_resource_types(compartment_id=compartment_id,
        exclude_fields=monitored_resource_type_exclude_fields,
        fields=monitored_resource_type_fields,
        is_exclude_system_types=monitored_resource_type_is_exclude_system_types,
        metric_namespace=monitored_resource_type_metric_namespace,
        name=monitored_resource_type_name,
        status=monitored_resource_type_status)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy for which  monitored resource types should be listed.
    :param Sequence[str] exclude_fields: Partial response refers to an optimization technique offered by the RESTful web APIs, to return all the information except the fields requested to be excluded (excludeFields) by the client. In this mechanism, the client sends the exclude field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to exlude and to return and should be a query string parameter called "excludeFields" of an array type, provide the values as enums, and use collectionFormat.
    :param Sequence[str] fields: Partial response refers to an optimization technique offered by the RESTful web APIs, to return only the information (fields) required by the client. In this mechanism, the client sends the required field names as the query parameters for an API to the server, and the server trims down the default response content by removing the fields that are not required by the client. The parameter controls which fields to return and should be a query string parameter called "fields" of an array type, provide the values as enums, and use collectionFormat.
           
           MonitoredResourceType Id, name and compartment will be added by default.
    :param bool is_exclude_system_types: A filter to exclude system resource types. If set to true, system resource types will be excluded.
    :param str metric_namespace: A filter to return monitored resource types that has the matching namespace.
    :param str name: A filter to return monitored resource types that match exactly with the resource type name given.
    :param str status: A filter to return only resources that matches with lifecycleState given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['excludeFields'] = exclude_fields
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['isExcludeSystemTypes'] = is_exclude_system_types
    __args__['metricNamespace'] = metric_namespace
    __args__['name'] = name
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getMonitoredResourceTypes:getMonitoredResourceTypes', __args__, opts=opts, typ=GetMonitoredResourceTypesResult)
    return __ret__.apply(lambda __response__: GetMonitoredResourceTypesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        exclude_fields=pulumi.get(__response__, 'exclude_fields'),
        fields=pulumi.get(__response__, 'fields'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_exclude_system_types=pulumi.get(__response__, 'is_exclude_system_types'),
        metric_namespace=pulumi.get(__response__, 'metric_namespace'),
        monitored_resource_types_collections=pulumi.get(__response__, 'monitored_resource_types_collections'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status')))
