# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HostScanRecipeArgs', 'HostScanRecipe']

@pulumi.input_type
class HostScanRecipeArgs:
    def __init__(__self__, *,
                 agent_settings: pulumi.Input['HostScanRecipeAgentSettingsArgs'],
                 compartment_id: pulumi.Input[str],
                 port_settings: pulumi.Input['HostScanRecipePortSettingsArgs'],
                 schedule: pulumi.Input['HostScanRecipeScheduleArgs'],
                 application_settings: Optional[pulumi.Input['HostScanRecipeApplicationSettingsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a HostScanRecipe resource.
        :param pulumi.Input['HostScanRecipeAgentSettingsArgs'] agent_settings: (Updatable) Agent scan settings for a host scan
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment ID of the scanning config. If no individual hosts are specified, all hosts in this compartment are scanned
        :param pulumi.Input['HostScanRecipePortSettingsArgs'] port_settings: (Updatable) Port scan settings for a host scan
        :param pulumi.Input['HostScanRecipeScheduleArgs'] schedule: (Updatable) A scanning schedule
        :param pulumi.Input['HostScanRecipeApplicationSettingsArgs'] application_settings: (Updatable) Agent scan settings for an application scan (as a part of a host scan)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Recipe identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        pulumi.set(__self__, "agent_settings", agent_settings)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "port_settings", port_settings)
        pulumi.set(__self__, "schedule", schedule)
        if application_settings is not None:
            pulumi.set(__self__, "application_settings", application_settings)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="agentSettings")
    def agent_settings(self) -> pulumi.Input['HostScanRecipeAgentSettingsArgs']:
        """
        (Updatable) Agent scan settings for a host scan
        """
        return pulumi.get(self, "agent_settings")

    @agent_settings.setter
    def agent_settings(self, value: pulumi.Input['HostScanRecipeAgentSettingsArgs']):
        pulumi.set(self, "agent_settings", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment ID of the scanning config. If no individual hosts are specified, all hosts in this compartment are scanned
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="portSettings")
    def port_settings(self) -> pulumi.Input['HostScanRecipePortSettingsArgs']:
        """
        (Updatable) Port scan settings for a host scan
        """
        return pulumi.get(self, "port_settings")

    @port_settings.setter
    def port_settings(self, value: pulumi.Input['HostScanRecipePortSettingsArgs']):
        pulumi.set(self, "port_settings", value)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input['HostScanRecipeScheduleArgs']:
        """
        (Updatable) A scanning schedule
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input['HostScanRecipeScheduleArgs']):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> Optional[pulumi.Input['HostScanRecipeApplicationSettingsArgs']]:
        """
        (Updatable) Agent scan settings for an application scan (as a part of a host scan)
        """
        return pulumi.get(self, "application_settings")

    @application_settings.setter
    def application_settings(self, value: Optional[pulumi.Input['HostScanRecipeApplicationSettingsArgs']]):
        pulumi.set(self, "application_settings", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Recipe identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _HostScanRecipeState:
    def __init__(__self__, *,
                 agent_settings: Optional[pulumi.Input['HostScanRecipeAgentSettingsArgs']] = None,
                 application_settings: Optional[pulumi.Input['HostScanRecipeApplicationSettingsArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 port_settings: Optional[pulumi.Input['HostScanRecipePortSettingsArgs']] = None,
                 schedule: Optional[pulumi.Input['HostScanRecipeScheduleArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering HostScanRecipe resources.
        :param pulumi.Input['HostScanRecipeAgentSettingsArgs'] agent_settings: (Updatable) Agent scan settings for a host scan
        :param pulumi.Input['HostScanRecipeApplicationSettingsArgs'] application_settings: (Updatable) Agent scan settings for an application scan (as a part of a host scan)
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment ID of the scanning config. If no individual hosts are specified, all hosts in this compartment are scanned
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Recipe identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['HostScanRecipePortSettingsArgs'] port_settings: (Updatable) Port scan settings for a host scan
        :param pulumi.Input['HostScanRecipeScheduleArgs'] schedule: (Updatable) A scanning schedule
        :param pulumi.Input[str] state: The current state of the config.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Date and time the recipe was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        :param pulumi.Input[str] time_updated: Date and time the recipe was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        if agent_settings is not None:
            pulumi.set(__self__, "agent_settings", agent_settings)
        if application_settings is not None:
            pulumi.set(__self__, "application_settings", application_settings)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if port_settings is not None:
            pulumi.set(__self__, "port_settings", port_settings)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="agentSettings")
    def agent_settings(self) -> Optional[pulumi.Input['HostScanRecipeAgentSettingsArgs']]:
        """
        (Updatable) Agent scan settings for a host scan
        """
        return pulumi.get(self, "agent_settings")

    @agent_settings.setter
    def agent_settings(self, value: Optional[pulumi.Input['HostScanRecipeAgentSettingsArgs']]):
        pulumi.set(self, "agent_settings", value)

    @property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> Optional[pulumi.Input['HostScanRecipeApplicationSettingsArgs']]:
        """
        (Updatable) Agent scan settings for an application scan (as a part of a host scan)
        """
        return pulumi.get(self, "application_settings")

    @application_settings.setter
    def application_settings(self, value: Optional[pulumi.Input['HostScanRecipeApplicationSettingsArgs']]):
        pulumi.set(self, "application_settings", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment ID of the scanning config. If no individual hosts are specified, all hosts in this compartment are scanned
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Recipe identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="portSettings")
    def port_settings(self) -> Optional[pulumi.Input['HostScanRecipePortSettingsArgs']]:
        """
        (Updatable) Port scan settings for a host scan
        """
        return pulumi.get(self, "port_settings")

    @port_settings.setter
    def port_settings(self, value: Optional[pulumi.Input['HostScanRecipePortSettingsArgs']]):
        pulumi.set(self, "port_settings", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['HostScanRecipeScheduleArgs']]:
        """
        (Updatable) A scanning schedule
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['HostScanRecipeScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time the recipe was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time the recipe was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class HostScanRecipe(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_settings: Optional[pulumi.Input[Union['HostScanRecipeAgentSettingsArgs', 'HostScanRecipeAgentSettingsArgsDict']]] = None,
                 application_settings: Optional[pulumi.Input[Union['HostScanRecipeApplicationSettingsArgs', 'HostScanRecipeApplicationSettingsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 port_settings: Optional[pulumi.Input[Union['HostScanRecipePortSettingsArgs', 'HostScanRecipePortSettingsArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[Union['HostScanRecipeScheduleArgs', 'HostScanRecipeScheduleArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Host Scan Recipe resource in Oracle Cloud Infrastructure Vulnerability Scanning service.

        Creates a new HostScanRecipe. A recipe determines the types of security issues that you want scanned, and how often to scan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_host_scan_recipe = oci.vulnerability_scanning.HostScanRecipe("test_host_scan_recipe",
            agent_settings={
                "scan_level": host_scan_recipe_agent_settings_scan_level,
                "agent_configuration": {
                    "vendor": host_scan_recipe_agent_settings_agent_configuration_vendor,
                    "cis_benchmark_settings": {
                        "scan_level": host_scan_recipe_agent_settings_agent_configuration_cis_benchmark_settings_scan_level,
                    },
                    "endpoint_protection_settings": {
                        "scan_level": host_scan_recipe_agent_settings_agent_configuration_endpoint_protection_settings_scan_level,
                    },
                    "should_un_install": host_scan_recipe_agent_settings_agent_configuration_should_un_install,
                    "vault_secret_id": test_secret["id"],
                    "vendor_type": host_scan_recipe_agent_settings_agent_configuration_vendor_type,
                },
            },
            compartment_id=compartment_id,
            port_settings={
                "scan_level": host_scan_recipe_port_settings_scan_level,
            },
            schedule={
                "type": host_scan_recipe_schedule_type,
                "day_of_week": host_scan_recipe_schedule_day_of_week,
            },
            application_settings={
                "application_scan_recurrence": host_scan_recipe_application_settings_application_scan_recurrence,
                "folders_to_scans": [{
                    "folder": host_scan_recipe_application_settings_folders_to_scan_folder,
                    "operatingsystem": host_scan_recipe_application_settings_folders_to_scan_operatingsystem,
                }],
                "is_enabled": host_scan_recipe_application_settings_is_enabled,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=host_scan_recipe_display_name,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        HostScanRecipes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:VulnerabilityScanning/hostScanRecipe:HostScanRecipe test_host_scan_recipe "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['HostScanRecipeAgentSettingsArgs', 'HostScanRecipeAgentSettingsArgsDict']] agent_settings: (Updatable) Agent scan settings for a host scan
        :param pulumi.Input[Union['HostScanRecipeApplicationSettingsArgs', 'HostScanRecipeApplicationSettingsArgsDict']] application_settings: (Updatable) Agent scan settings for an application scan (as a part of a host scan)
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment ID of the scanning config. If no individual hosts are specified, all hosts in this compartment are scanned
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Recipe identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Union['HostScanRecipePortSettingsArgs', 'HostScanRecipePortSettingsArgsDict']] port_settings: (Updatable) Port scan settings for a host scan
        :param pulumi.Input[Union['HostScanRecipeScheduleArgs', 'HostScanRecipeScheduleArgsDict']] schedule: (Updatable) A scanning schedule
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostScanRecipeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Host Scan Recipe resource in Oracle Cloud Infrastructure Vulnerability Scanning service.

        Creates a new HostScanRecipe. A recipe determines the types of security issues that you want scanned, and how often to scan.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_host_scan_recipe = oci.vulnerability_scanning.HostScanRecipe("test_host_scan_recipe",
            agent_settings={
                "scan_level": host_scan_recipe_agent_settings_scan_level,
                "agent_configuration": {
                    "vendor": host_scan_recipe_agent_settings_agent_configuration_vendor,
                    "cis_benchmark_settings": {
                        "scan_level": host_scan_recipe_agent_settings_agent_configuration_cis_benchmark_settings_scan_level,
                    },
                    "endpoint_protection_settings": {
                        "scan_level": host_scan_recipe_agent_settings_agent_configuration_endpoint_protection_settings_scan_level,
                    },
                    "should_un_install": host_scan_recipe_agent_settings_agent_configuration_should_un_install,
                    "vault_secret_id": test_secret["id"],
                    "vendor_type": host_scan_recipe_agent_settings_agent_configuration_vendor_type,
                },
            },
            compartment_id=compartment_id,
            port_settings={
                "scan_level": host_scan_recipe_port_settings_scan_level,
            },
            schedule={
                "type": host_scan_recipe_schedule_type,
                "day_of_week": host_scan_recipe_schedule_day_of_week,
            },
            application_settings={
                "application_scan_recurrence": host_scan_recipe_application_settings_application_scan_recurrence,
                "folders_to_scans": [{
                    "folder": host_scan_recipe_application_settings_folders_to_scan_folder,
                    "operatingsystem": host_scan_recipe_application_settings_folders_to_scan_operatingsystem,
                }],
                "is_enabled": host_scan_recipe_application_settings_is_enabled,
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=host_scan_recipe_display_name,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        HostScanRecipes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:VulnerabilityScanning/hostScanRecipe:HostScanRecipe test_host_scan_recipe "id"
        ```

        :param str resource_name: The name of the resource.
        :param HostScanRecipeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostScanRecipeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_settings: Optional[pulumi.Input[Union['HostScanRecipeAgentSettingsArgs', 'HostScanRecipeAgentSettingsArgsDict']]] = None,
                 application_settings: Optional[pulumi.Input[Union['HostScanRecipeApplicationSettingsArgs', 'HostScanRecipeApplicationSettingsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 port_settings: Optional[pulumi.Input[Union['HostScanRecipePortSettingsArgs', 'HostScanRecipePortSettingsArgsDict']]] = None,
                 schedule: Optional[pulumi.Input[Union['HostScanRecipeScheduleArgs', 'HostScanRecipeScheduleArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostScanRecipeArgs.__new__(HostScanRecipeArgs)

            if agent_settings is None and not opts.urn:
                raise TypeError("Missing required property 'agent_settings'")
            __props__.__dict__["agent_settings"] = agent_settings
            __props__.__dict__["application_settings"] = application_settings
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if port_settings is None and not opts.urn:
                raise TypeError("Missing required property 'port_settings'")
            __props__.__dict__["port_settings"] = port_settings
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(HostScanRecipe, __self__).__init__(
            'oci:VulnerabilityScanning/hostScanRecipe:HostScanRecipe',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_settings: Optional[pulumi.Input[Union['HostScanRecipeAgentSettingsArgs', 'HostScanRecipeAgentSettingsArgsDict']]] = None,
            application_settings: Optional[pulumi.Input[Union['HostScanRecipeApplicationSettingsArgs', 'HostScanRecipeApplicationSettingsArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            port_settings: Optional[pulumi.Input[Union['HostScanRecipePortSettingsArgs', 'HostScanRecipePortSettingsArgsDict']]] = None,
            schedule: Optional[pulumi.Input[Union['HostScanRecipeScheduleArgs', 'HostScanRecipeScheduleArgsDict']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'HostScanRecipe':
        """
        Get an existing HostScanRecipe resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['HostScanRecipeAgentSettingsArgs', 'HostScanRecipeAgentSettingsArgsDict']] agent_settings: (Updatable) Agent scan settings for a host scan
        :param pulumi.Input[Union['HostScanRecipeApplicationSettingsArgs', 'HostScanRecipeApplicationSettingsArgsDict']] application_settings: (Updatable) Agent scan settings for an application scan (as a part of a host scan)
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment ID of the scanning config. If no individual hosts are specified, all hosts in this compartment are scanned
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Recipe identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Union['HostScanRecipePortSettingsArgs', 'HostScanRecipePortSettingsArgsDict']] port_settings: (Updatable) Port scan settings for a host scan
        :param pulumi.Input[Union['HostScanRecipeScheduleArgs', 'HostScanRecipeScheduleArgsDict']] schedule: (Updatable) A scanning schedule
        :param pulumi.Input[str] state: The current state of the config.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Date and time the recipe was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        :param pulumi.Input[str] time_updated: Date and time the recipe was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostScanRecipeState.__new__(_HostScanRecipeState)

        __props__.__dict__["agent_settings"] = agent_settings
        __props__.__dict__["application_settings"] = application_settings
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["port_settings"] = port_settings
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return HostScanRecipe(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentSettings")
    def agent_settings(self) -> pulumi.Output['outputs.HostScanRecipeAgentSettings']:
        """
        (Updatable) Agent scan settings for a host scan
        """
        return pulumi.get(self, "agent_settings")

    @property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> pulumi.Output['outputs.HostScanRecipeApplicationSettings']:
        """
        (Updatable) Agent scan settings for an application scan (as a part of a host scan)
        """
        return pulumi.get(self, "application_settings")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment ID of the scanning config. If no individual hosts are specified, all hosts in this compartment are scanned
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Recipe identifier, which can be renamed. If not present, it will be auto-generated. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="portSettings")
    def port_settings(self) -> pulumi.Output['outputs.HostScanRecipePortSettings']:
        """
        (Updatable) Port scan settings for a host scan
        """
        return pulumi.get(self, "port_settings")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output['outputs.HostScanRecipeSchedule']:
        """
        (Updatable) A scanning schedule
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the config.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Date and time the recipe was created, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        Date and time the recipe was last updated, format as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "time_updated")

