# -*- coding: utf-8 -*-
from plone import api
from plone.app.testing import setRoles
from plone.app.testing import TEST_USER_ID
from Products.EasyNewsletter.testing import PRODUCTS_EASYNEWSLETTER_FUNCTIONAL_TESTING
from Products.EasyNewsletter.testing import PRODUCTS_EASYNEWSLETTER_INTEGRATION_TESTING
from zope.component import getMultiAdapter
from zope.interface.interfaces import ComponentLookupError

import unittest


class ViewsIntegrationTest(unittest.TestCase):

    layer = PRODUCTS_EASYNEWSLETTER_INTEGRATION_TESTING

    def setUp(self):
        self.portal = self.layer["portal"]
        setRoles(self.portal, TEST_USER_ID, ["Manager"])
        self.newsletter = api.content.create(
            container=self.portal, type="Newsletter", id="newsletter"
        )
        self.issue = api.content.create(
            container=self.newsletter, type="Newsletter Issue", id="issue"
        )

    def test_copy_as_draft_is_registered(self):
        view = getMultiAdapter((self.issue, self.portal.REQUEST), name="copy-as-draft")
        self.assertTrue(view.__name__ == "copy-as-draft")

    def test_copy_as_draft_not_matching_interface(self):
        with self.assertRaises(ComponentLookupError):
            getMultiAdapter((self.portal, self.portal.REQUEST), name="copy-as-draft")


class ViewsFunctionalTest(unittest.TestCase):

    layer = PRODUCTS_EASYNEWSLETTER_FUNCTIONAL_TESTING

    def setUp(self):
        self.portal = self.layer["portal"]
        setRoles(self.portal, TEST_USER_ID, ["Manager"])
