# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import re
from libcloud.test import MockHttp

FORMAT_URL = re.compile(r"[./?=&-]")


class BaseOvhMockHttp(MockHttp):
    def _get_method_name(self, type, use_param, qs, path):
        if type:
            meth_name = "_json%s_%s_%s" % (FORMAT_URL.sub("_", path), "get", type)
            return meth_name
        return "_json"

    def _json(self, method, url, body, headers):
        meth_name = "_json%s_%s" % (FORMAT_URL.sub("_", url), method.lower())
        return getattr(self, meth_name)(method, url, body, headers)
