"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DedicatedBlockStorageCluster = exports.DedicatedBlockStorageClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ebs_generated_1 = require("./ebs.generated");
Object.defineProperty(exports, "DedicatedBlockStorageClusterProperty", { enumerable: true, get: function () { return ebs_generated_1.RosDedicatedBlockStorageCluster; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::EBS::DedicatedBlockStorageCluster`, which is used to query the information about a dedicated block storage cluster.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDedicatedBlockStorageCluster`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-ebs-dedicatedblockstoragecluster
 */
class DedicatedBlockStorageCluster extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDedicatedBlockStorageCluster = new ebs_generated_1.RosDedicatedBlockStorageCluster(this, id, {
            dedicatedBlockStorageClusterId: props.dedicatedBlockStorageClusterId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDedicatedBlockStorageCluster;
        this.attrAvailableCapacity = rosDedicatedBlockStorageCluster.attrAvailableCapacity;
        this.attrCategory = rosDedicatedBlockStorageCluster.attrCategory;
        this.attrCreateTime = rosDedicatedBlockStorageCluster.attrCreateTime;
        this.attrDedicatedBlockStorageClusterId = rosDedicatedBlockStorageCluster.attrDedicatedBlockStorageClusterId;
        this.attrDedicatedBlockStorageClusterName = rosDedicatedBlockStorageCluster.attrDedicatedBlockStorageClusterName;
        this.attrDeliveryCapacity = rosDedicatedBlockStorageCluster.attrDeliveryCapacity;
        this.attrDescription = rosDedicatedBlockStorageCluster.attrDescription;
        this.attrExpiredTime = rosDedicatedBlockStorageCluster.attrExpiredTime;
        this.attrPerformanceLevel = rosDedicatedBlockStorageCluster.attrPerformanceLevel;
        this.attrResourceGroupId = rosDedicatedBlockStorageCluster.attrResourceGroupId;
        this.attrSupportedCategory = rosDedicatedBlockStorageCluster.attrSupportedCategory;
        this.attrTags = rosDedicatedBlockStorageCluster.attrTags;
        this.attrTotalCapacity = rosDedicatedBlockStorageCluster.attrTotalCapacity;
        this.attrType = rosDedicatedBlockStorageCluster.attrType;
        this.attrUsedCapacity = rosDedicatedBlockStorageCluster.attrUsedCapacity;
        this.attrZoneId = rosDedicatedBlockStorageCluster.attrZoneId;
    }
}
exports.DedicatedBlockStorageCluster = DedicatedBlockStorageCluster;
//# sourceMappingURL=data:application/json;base64,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