"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DedicatedBlockStorageClusters = exports.DedicatedBlockStorageClustersProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ebs_generated_1 = require("./ebs.generated");
Object.defineProperty(exports, "DedicatedBlockStorageClustersProperty", { enumerable: true, get: function () { return ebs_generated_1.RosDedicatedBlockStorageClusters; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::EBS::DedicatedBlockStorageClusters`, which is used to query dedicated block storage clusters.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDedicatedBlockStorageClusters`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-ebs-dedicatedblockstorageclusters
 */
class DedicatedBlockStorageClusters extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDedicatedBlockStorageClusters = new ebs_generated_1.RosDedicatedBlockStorageClusters(this, id, {
            resourceGroupId: props.resourceGroupId,
            dedicatedBlockStorageClusterId: props.dedicatedBlockStorageClusterId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDedicatedBlockStorageClusters;
        this.attrDedicatedBlockStorageClusterIds = rosDedicatedBlockStorageClusters.attrDedicatedBlockStorageClusterIds;
        this.attrDedicatedBlockStorageClusters = rosDedicatedBlockStorageClusters.attrDedicatedBlockStorageClusters;
    }
}
exports.DedicatedBlockStorageClusters = DedicatedBlockStorageClusters;
//# sourceMappingURL=data:application/json;base64,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