"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiskReplicaGroup = exports.DiskReplicaGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ebs_generated_1 = require("./ebs.generated");
Object.defineProperty(exports, "DiskReplicaGroupProperty", { enumerable: true, get: function () { return ebs_generated_1.RosDiskReplicaGroup; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::EBS::DiskReplicaGroup`, which is used to query the information about a replication pair-consistent group.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDiskReplicaGroup`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-ebs-diskreplicagroup
 */
class DiskReplicaGroup extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDiskReplicaGroup = new ebs_generated_1.RosDiskReplicaGroup(this, id, {
            replicaGroupId: props.replicaGroupId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDiskReplicaGroup;
        this.attrDescription = rosDiskReplicaGroup.attrDescription;
        this.attrDestinationRegionId = rosDiskReplicaGroup.attrDestinationRegionId;
        this.attrDestinationZoneId = rosDiskReplicaGroup.attrDestinationZoneId;
        this.attrDiskReplicaGroupName = rosDiskReplicaGroup.attrDiskReplicaGroupName;
        this.attrLastRecoverPoint = rosDiskReplicaGroup.attrLastRecoverPoint;
        this.attrPairIds = rosDiskReplicaGroup.attrPairIds;
        this.attrPairNumber = rosDiskReplicaGroup.attrPairNumber;
        this.attrPrimaryRegion = rosDiskReplicaGroup.attrPrimaryRegion;
        this.attrPrimaryZone = rosDiskReplicaGroup.attrPrimaryZone;
        this.attrRpo = rosDiskReplicaGroup.attrRpo;
        this.attrReplicaGroupId = rosDiskReplicaGroup.attrReplicaGroupId;
        this.attrResourceGroupId = rosDiskReplicaGroup.attrResourceGroupId;
        this.attrSite = rosDiskReplicaGroup.attrSite;
        this.attrSourceRegionId = rosDiskReplicaGroup.attrSourceRegionId;
        this.attrSourceZoneId = rosDiskReplicaGroup.attrSourceZoneId;
        this.attrStandbyRegion = rosDiskReplicaGroup.attrStandbyRegion;
        this.attrStandbyZone = rosDiskReplicaGroup.attrStandbyZone;
        this.attrTags = rosDiskReplicaGroup.attrTags;
    }
}
exports.DiskReplicaGroup = DiskReplicaGroup;
//# sourceMappingURL=data:application/json;base64,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