"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiskReplicaGroups = exports.DiskReplicaGroupsProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ebs_generated_1 = require("./ebs.generated");
Object.defineProperty(exports, "DiskReplicaGroupsProperty", { enumerable: true, get: function () { return ebs_generated_1.RosDiskReplicaGroups; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::EBS::DiskReplicaGroups`, which is used to query the information about replication pair-consistent groups.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDiskReplicaGroups`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-ebs-diskreplicagroups
 */
class DiskReplicaGroups extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDiskReplicaGroups = new ebs_generated_1.RosDiskReplicaGroups(this, id, {
            site: props.site,
            resourceGroupId: props.resourceGroupId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDiskReplicaGroups;
        this.attrDiskReplicaGroups = rosDiskReplicaGroups.attrDiskReplicaGroups;
        this.attrReplicaGroupIds = rosDiskReplicaGroups.attrReplicaGroupIds;
    }
}
exports.DiskReplicaGroups = DiskReplicaGroups;
//# sourceMappingURL=data:application/json;base64,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