"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiskReplicaPair = exports.DiskReplicaPairProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ebs_generated_1 = require("./ebs.generated");
Object.defineProperty(exports, "DiskReplicaPairProperty", { enumerable: true, get: function () { return ebs_generated_1.RosDiskReplicaPair; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::EBS::DiskReplicaPair`, which is used to query a replication pair.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDiskReplicaPair`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-ebs-diskreplicapair
 */
class DiskReplicaPair extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDiskReplicaPair = new ebs_generated_1.RosDiskReplicaPair(this, id, {
            replicaPairId: props.replicaPairId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDiskReplicaPair;
        this.attrBandwidth = rosDiskReplicaPair.attrBandwidth;
        this.attrCreateTime = rosDiskReplicaPair.attrCreateTime;
        this.attrDescription = rosDiskReplicaPair.attrDescription;
        this.attrDestinationDiskId = rosDiskReplicaPair.attrDestinationDiskId;
        this.attrDestinationRegionId = rosDiskReplicaPair.attrDestinationRegionId;
        this.attrDestinationZoneId = rosDiskReplicaPair.attrDestinationZoneId;
        this.attrDiskId = rosDiskReplicaPair.attrDiskId;
        this.attrDiskReplicaPairName = rosDiskReplicaPair.attrDiskReplicaPairName;
        this.attrPaymentType = rosDiskReplicaPair.attrPaymentType;
        this.attrRpo = rosDiskReplicaPair.attrRpo;
        this.attrReplicaPairId = rosDiskReplicaPair.attrReplicaPairId;
        this.attrResourceGroupId = rosDiskReplicaPair.attrResourceGroupId;
        this.attrSourceZoneId = rosDiskReplicaPair.attrSourceZoneId;
        this.attrTags = rosDiskReplicaPair.attrTags;
    }
}
exports.DiskReplicaPair = DiskReplicaPair;
//# sourceMappingURL=data:application/json;base64,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