"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DedicatedBlockStorageCluster = exports.DedicatedBlockStorageClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ebs_generated_1 = require("./ebs.generated");
Object.defineProperty(exports, "DedicatedBlockStorageClusterProperty", { enumerable: true, get: function () { return ebs_generated_1.RosDedicatedBlockStorageCluster; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::EBS::DedicatedBlockStorageCluster`, which is used to create a dedicated block storage cluster.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDedicatedBlockStorageCluster`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ebs-dedicatedblockstoragecluster
 */
class DedicatedBlockStorageCluster extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDedicatedBlockStorageCluster = new ebs_generated_1.RosDedicatedBlockStorageCluster(this, id, {
            azone: props.azone,
            type: props.type,
            resourceGroupId: props.resourceGroupId,
            capacity: props.capacity,
            period: props.period,
            tag: props.tag,
            dbscName: props.dbscName,
            periodUnit: props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDedicatedBlockStorageCluster;
        this.attrDedicatedBlockStorageClusterId = rosDedicatedBlockStorageCluster.attrDedicatedBlockStorageClusterId;
    }
}
exports.DedicatedBlockStorageCluster = DedicatedBlockStorageCluster;
//# sourceMappingURL=data:application/json;base64,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