"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiskReplicaGroup = exports.DiskReplicaGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ebs_generated_1 = require("./ebs.generated");
Object.defineProperty(exports, "DiskReplicaGroupProperty", { enumerable: true, get: function () { return ebs_generated_1.RosDiskReplicaGroup; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::EBS::DiskReplicaGroup`, which is used to create a replication pair-consistent group.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDiskReplicaGroup`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ebs-diskreplicagroup
 */
class DiskReplicaGroup extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDiskReplicaGroup = new ebs_generated_1.RosDiskReplicaGroup(this, id, {
            rpo: props.rpo,
            sourceRegionId: props.sourceRegionId,
            description: props.description,
            diskReplicaGroupName: props.diskReplicaGroupName,
            resourceGroupId: props.resourceGroupId,
            destinationRegionId: props.destinationRegionId,
            destinationZoneId: props.destinationZoneId,
            sourceZoneId: props.sourceZoneId,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDiskReplicaGroup;
        this.attrDescription = rosDiskReplicaGroup.attrDescription;
        this.attrDestinationRegionId = rosDiskReplicaGroup.attrDestinationRegionId;
        this.attrDestinationZoneId = rosDiskReplicaGroup.attrDestinationZoneId;
        this.attrDiskReplicaGroupName = rosDiskReplicaGroup.attrDiskReplicaGroupName;
        this.attrLastRecoverPoint = rosDiskReplicaGroup.attrLastRecoverPoint;
        this.attrPairIds = rosDiskReplicaGroup.attrPairIds;
        this.attrPairNumber = rosDiskReplicaGroup.attrPairNumber;
        this.attrPrimaryRegion = rosDiskReplicaGroup.attrPrimaryRegion;
        this.attrPrimaryZone = rosDiskReplicaGroup.attrPrimaryZone;
        this.attrRpo = rosDiskReplicaGroup.attrRpo;
        this.attrReplicaGroupId = rosDiskReplicaGroup.attrReplicaGroupId;
        this.attrResourceGroupId = rosDiskReplicaGroup.attrResourceGroupId;
        this.attrSite = rosDiskReplicaGroup.attrSite;
        this.attrSourceRegionId = rosDiskReplicaGroup.attrSourceRegionId;
        this.attrSourceZoneId = rosDiskReplicaGroup.attrSourceZoneId;
        this.attrStandbyRegion = rosDiskReplicaGroup.attrStandbyRegion;
        this.attrStandbyZone = rosDiskReplicaGroup.attrStandbyZone;
        this.attrTags = rosDiskReplicaGroup.attrTags;
    }
}
exports.DiskReplicaGroup = DiskReplicaGroup;
//# sourceMappingURL=data:application/json;base64,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