"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiskReplicaPairAddition = exports.DiskReplicaPairAdditionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ebs_generated_1 = require("./ebs.generated");
Object.defineProperty(exports, "DiskReplicaPairAdditionProperty", { enumerable: true, get: function () { return ebs_generated_1.RosDiskReplicaPairAddition; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::EBS::DiskReplicaPairAddition`, which is used to add a replication pair to a replication pair-consistent group.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDiskReplicaPairAddition`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ebs-diskreplicapairaddition
 */
class DiskReplicaPairAddition extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDiskReplicaPairAddition = new ebs_generated_1.RosDiskReplicaPairAddition(this, id, {
            replicaPairId: props.replicaPairId,
            replicaGroupId: props.replicaGroupId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDiskReplicaPairAddition;
        this.attrReplicaGroupId = rosDiskReplicaPairAddition.attrReplicaGroupId;
        this.attrReplicaPairId = rosDiskReplicaPairAddition.attrReplicaPairId;
    }
}
exports.DiskReplicaPairAddition = DiskReplicaPairAddition;
//# sourceMappingURL=data:application/json;base64,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