"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const iam = require("@aws-cdk/aws-iam");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const app = new cdk_1.App();
const stack = new cdk_1.Stack(app, `aws-cdk-kms-1`);
const key = new lib_1.Key(stack, 'MyKey', { removalPolicy: cdk_1.RemovalPolicy.Destroy });
key.addToResourcePolicy(new aws_iam_1.PolicyStatement({
    resources: ['*'],
    actions: ['kms:encrypt'],
    principals: [new iam.ArnPrincipal(stack.account)]
}));
key.addAlias('alias/bar');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcua2V5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcua2V5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQW1EO0FBQ25ELHdDQUF5QztBQUN6QyxzQ0FBeUQ7QUFDekQsZ0NBQTZCO0FBRTdCLE1BQU0sR0FBRyxHQUFHLElBQUksU0FBRyxFQUFFLENBQUM7QUFFdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxXQUFLLENBQUMsR0FBRyxFQUFFLGVBQWUsQ0FBQyxDQUFDO0FBRTlDLE1BQU0sR0FBRyxHQUFHLElBQUksU0FBRyxDQUFDLEtBQUssRUFBRSxPQUFPLEVBQUUsRUFBRSxhQUFhLEVBQUUsbUJBQWEsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDO0FBRTlFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLHlCQUFlLENBQUM7SUFDMUMsU0FBUyxFQUFFLENBQUMsR0FBRyxDQUFDO0lBQ2hCLE9BQU8sRUFBRSxDQUFDLGFBQWEsQ0FBQztJQUN4QixVQUFVLEVBQUUsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0NBQ2xELENBQUMsQ0FBQyxDQUFDO0FBRUosR0FBRyxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsQ0FBQztBQUUxQixHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCBpYW0gPSByZXF1aXJlKCdAYXdzLWNkay9hd3MtaWFtJyk7XG5pbXBvcnQgeyBBcHAsIFJlbW92YWxQb2xpY3ksIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY2RrJztcbmltcG9ydCB7IEtleSB9IGZyb20gJy4uL2xpYic7XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcblxuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCBgYXdzLWNkay1rbXMtMWApO1xuXG5jb25zdCBrZXkgPSBuZXcgS2V5KHN0YWNrLCAnTXlLZXknLCB7IHJlbW92YWxQb2xpY3k6IFJlbW92YWxQb2xpY3kuRGVzdHJveSB9KTtcblxua2V5LmFkZFRvUmVzb3VyY2VQb2xpY3kobmV3IFBvbGljeVN0YXRlbWVudCh7XG4gIHJlc291cmNlczogWycqJ10sXG4gIGFjdGlvbnM6IFsna21zOmVuY3J5cHQnXSxcbiAgcHJpbmNpcGFsczogW25ldyBpYW0uQXJuUHJpbmNpcGFsKHN0YWNrLmFjY291bnQpXVxufSkpO1xuXG5rZXkuYWRkQWxpYXMoJ2FsaWFzL2JhcicpO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==