# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CameraCustomAnalyticsArgs', 'CameraCustomAnalytics']

@pulumi.input_type
class CameraCustomAnalyticsArgs:
    def __init__(__self__, *,
                 serial: pulumi.Input[str],
                 artifact_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['CameraCustomAnalyticsParameterArgs']]]] = None):
        """
        The set of arguments for constructing a CameraCustomAnalytics resource.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[str] artifact_id: Custom analytics artifact ID
        :param pulumi.Input[bool] enabled: Whether custom analytics is enabled
        :param pulumi.Input[Sequence[pulumi.Input['CameraCustomAnalyticsParameterArgs']]] parameters: Parameters for the custom analytics workload
        """
        pulumi.set(__self__, "serial", serial)
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Input[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[str]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        Custom analytics artifact ID
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether custom analytics is enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CameraCustomAnalyticsParameterArgs']]]]:
        """
        Parameters for the custom analytics workload
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CameraCustomAnalyticsParameterArgs']]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class _CameraCustomAnalyticsState:
    def __init__(__self__, *,
                 artifact_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['CameraCustomAnalyticsParameterArgs']]]] = None,
                 serial: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CameraCustomAnalytics resources.
        :param pulumi.Input[str] artifact_id: Custom analytics artifact ID
        :param pulumi.Input[bool] enabled: Whether custom analytics is enabled
        :param pulumi.Input[Sequence[pulumi.Input['CameraCustomAnalyticsParameterArgs']]] parameters: Parameters for the custom analytics workload
        :param pulumi.Input[str] serial: serial path parameter.
        """
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[pulumi.Input[str]]:
        """
        Custom analytics artifact ID
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether custom analytics is enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CameraCustomAnalyticsParameterArgs']]]]:
        """
        Parameters for the custom analytics workload
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CameraCustomAnalyticsParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial", value)


class CameraCustomAnalytics(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CameraCustomAnalyticsParameterArgs', 'CameraCustomAnalyticsParameterArgsDict']]]]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.CameraCustomAnalytics("example",
            artifact_id="1",
            enabled=True,
            parameters=[{
                "name": "detection_threshold",
                "value": 0.5,
            }],
            serial="string")
        pulumi.export("merakiDevicesCameraCustomAnalyticsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/cameraCustomAnalytics:CameraCustomAnalytics example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artifact_id: Custom analytics artifact ID
        :param pulumi.Input[bool] enabled: Whether custom analytics is enabled
        :param pulumi.Input[Sequence[pulumi.Input[Union['CameraCustomAnalyticsParameterArgs', 'CameraCustomAnalyticsParameterArgsDict']]]] parameters: Parameters for the custom analytics workload
        :param pulumi.Input[str] serial: serial path parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CameraCustomAnalyticsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.CameraCustomAnalytics("example",
            artifact_id="1",
            enabled=True,
            parameters=[{
                "name": "detection_threshold",
                "value": 0.5,
            }],
            serial="string")
        pulumi.export("merakiDevicesCameraCustomAnalyticsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/cameraCustomAnalytics:CameraCustomAnalytics example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param CameraCustomAnalyticsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CameraCustomAnalyticsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifact_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CameraCustomAnalyticsParameterArgs', 'CameraCustomAnalyticsParameterArgsDict']]]]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CameraCustomAnalyticsArgs.__new__(CameraCustomAnalyticsArgs)

            __props__.__dict__["artifact_id"] = artifact_id
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["parameters"] = parameters
            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
        super(CameraCustomAnalytics, __self__).__init__(
            'meraki:devices/cameraCustomAnalytics:CameraCustomAnalytics',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artifact_id: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CameraCustomAnalyticsParameterArgs', 'CameraCustomAnalyticsParameterArgsDict']]]]] = None,
            serial: Optional[pulumi.Input[str]] = None) -> 'CameraCustomAnalytics':
        """
        Get an existing CameraCustomAnalytics resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artifact_id: Custom analytics artifact ID
        :param pulumi.Input[bool] enabled: Whether custom analytics is enabled
        :param pulumi.Input[Sequence[pulumi.Input[Union['CameraCustomAnalyticsParameterArgs', 'CameraCustomAnalyticsParameterArgsDict']]]] parameters: Parameters for the custom analytics workload
        :param pulumi.Input[str] serial: serial path parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CameraCustomAnalyticsState.__new__(_CameraCustomAnalyticsState)

        __props__.__dict__["artifact_id"] = artifact_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["serial"] = serial
        return CameraCustomAnalytics(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> pulumi.Output[str]:
        """
        Custom analytics artifact ID
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Whether custom analytics is enabled
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.CameraCustomAnalyticsParameter']]:
        """
        Parameters for the custom analytics workload
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

