# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LiveToolsWakeOnLanArgs', 'LiveToolsWakeOnLan']

@pulumi.input_type
class LiveToolsWakeOnLanArgs:
    def __init__(__self__, *,
                 serial: pulumi.Input[str],
                 callback: Optional[pulumi.Input['LiveToolsWakeOnLanCallbackArgs']] = None,
                 mac: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 wake_on_lan_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LiveToolsWakeOnLan resource.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input['LiveToolsWakeOnLanCallbackArgs'] callback: Details for the callback. Please include either an httpServerId OR url and sharedSecret
        :param pulumi.Input[str] mac: The target's MAC address
        :param pulumi.Input[int] vlan_id: The target's VLAN (1 to 4094)
        :param pulumi.Input[str] wake_on_lan_id: ID of the Wake-on-LAN job
        """
        pulumi.set(__self__, "serial", serial)
        if callback is not None:
            pulumi.set(__self__, "callback", callback)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if wake_on_lan_id is not None:
            pulumi.set(__self__, "wake_on_lan_id", wake_on_lan_id)

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Input[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[str]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter
    def callback(self) -> Optional[pulumi.Input['LiveToolsWakeOnLanCallbackArgs']]:
        """
        Details for the callback. Please include either an httpServerId OR url and sharedSecret
        """
        return pulumi.get(self, "callback")

    @callback.setter
    def callback(self, value: Optional[pulumi.Input['LiveToolsWakeOnLanCallbackArgs']]):
        pulumi.set(self, "callback", value)

    @property
    @pulumi.getter
    def mac(self) -> Optional[pulumi.Input[str]]:
        """
        The target's MAC address
        """
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        The target's VLAN (1 to 4094)
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="wakeOnLanId")
    def wake_on_lan_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Wake-on-LAN job
        """
        return pulumi.get(self, "wake_on_lan_id")

    @wake_on_lan_id.setter
    def wake_on_lan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wake_on_lan_id", value)


@pulumi.input_type
class _LiveToolsWakeOnLanState:
    def __init__(__self__, *,
                 callback: Optional[pulumi.Input['LiveToolsWakeOnLanCallbackArgs']] = None,
                 error: Optional[pulumi.Input[str]] = None,
                 mac: Optional[pulumi.Input[str]] = None,
                 request: Optional[pulumi.Input['LiveToolsWakeOnLanRequestArgs']] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 wake_on_lan_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LiveToolsWakeOnLan resources.
        :param pulumi.Input['LiveToolsWakeOnLanCallbackArgs'] callback: Details for the callback. Please include either an httpServerId OR url and sharedSecret
        :param pulumi.Input[str] error: An error message for a failed execution
        :param pulumi.Input[str] mac: The target's MAC address
        :param pulumi.Input['LiveToolsWakeOnLanRequestArgs'] request: The parameters of the Wake-on-LAN request
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[str] status: Status of the Wake-on-LAN request
        :param pulumi.Input[str] url: GET this url to check the status of your ping request
        :param pulumi.Input[int] vlan_id: The target's VLAN (1 to 4094)
        :param pulumi.Input[str] wake_on_lan_id: ID of the Wake-on-LAN job
        """
        if callback is not None:
            pulumi.set(__self__, "callback", callback)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if wake_on_lan_id is not None:
            pulumi.set(__self__, "wake_on_lan_id", wake_on_lan_id)

    @property
    @pulumi.getter
    def callback(self) -> Optional[pulumi.Input['LiveToolsWakeOnLanCallbackArgs']]:
        """
        Details for the callback. Please include either an httpServerId OR url and sharedSecret
        """
        return pulumi.get(self, "callback")

    @callback.setter
    def callback(self, value: Optional[pulumi.Input['LiveToolsWakeOnLanCallbackArgs']]):
        pulumi.set(self, "callback", value)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input[str]]:
        """
        An error message for a failed execution
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error", value)

    @property
    @pulumi.getter
    def mac(self) -> Optional[pulumi.Input[str]]:
        """
        The target's MAC address
        """
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac", value)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['LiveToolsWakeOnLanRequestArgs']]:
        """
        The parameters of the Wake-on-LAN request
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['LiveToolsWakeOnLanRequestArgs']]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the Wake-on-LAN request
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        GET this url to check the status of your ping request
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        The target's VLAN (1 to 4094)
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="wakeOnLanId")
    def wake_on_lan_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Wake-on-LAN job
        """
        return pulumi.get(self, "wake_on_lan_id")

    @wake_on_lan_id.setter
    def wake_on_lan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wake_on_lan_id", value)


class LiveToolsWakeOnLan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 callback: Optional[pulumi.Input[Union['LiveToolsWakeOnLanCallbackArgs', 'LiveToolsWakeOnLanCallbackArgsDict']]] = None,
                 mac: Optional[pulumi.Input[str]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 wake_on_lan_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:devices/liveToolsWakeOnLan:LiveToolsWakeOnLan example "serial,wake_on_lan_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LiveToolsWakeOnLanCallbackArgs', 'LiveToolsWakeOnLanCallbackArgsDict']] callback: Details for the callback. Please include either an httpServerId OR url and sharedSecret
        :param pulumi.Input[str] mac: The target's MAC address
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[int] vlan_id: The target's VLAN (1 to 4094)
        :param pulumi.Input[str] wake_on_lan_id: ID of the Wake-on-LAN job
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LiveToolsWakeOnLanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:devices/liveToolsWakeOnLan:LiveToolsWakeOnLan example "serial,wake_on_lan_id"
        ```

        :param str resource_name: The name of the resource.
        :param LiveToolsWakeOnLanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LiveToolsWakeOnLanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 callback: Optional[pulumi.Input[Union['LiveToolsWakeOnLanCallbackArgs', 'LiveToolsWakeOnLanCallbackArgsDict']]] = None,
                 mac: Optional[pulumi.Input[str]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 wake_on_lan_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LiveToolsWakeOnLanArgs.__new__(LiveToolsWakeOnLanArgs)

            __props__.__dict__["callback"] = callback
            __props__.__dict__["mac"] = mac
            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["wake_on_lan_id"] = wake_on_lan_id
            __props__.__dict__["error"] = None
            __props__.__dict__["request"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["url"] = None
        super(LiveToolsWakeOnLan, __self__).__init__(
            'meraki:devices/liveToolsWakeOnLan:LiveToolsWakeOnLan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            callback: Optional[pulumi.Input[Union['LiveToolsWakeOnLanCallbackArgs', 'LiveToolsWakeOnLanCallbackArgsDict']]] = None,
            error: Optional[pulumi.Input[str]] = None,
            mac: Optional[pulumi.Input[str]] = None,
            request: Optional[pulumi.Input[Union['LiveToolsWakeOnLanRequestArgs', 'LiveToolsWakeOnLanRequestArgsDict']]] = None,
            serial: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            vlan_id: Optional[pulumi.Input[int]] = None,
            wake_on_lan_id: Optional[pulumi.Input[str]] = None) -> 'LiveToolsWakeOnLan':
        """
        Get an existing LiveToolsWakeOnLan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LiveToolsWakeOnLanCallbackArgs', 'LiveToolsWakeOnLanCallbackArgsDict']] callback: Details for the callback. Please include either an httpServerId OR url and sharedSecret
        :param pulumi.Input[str] error: An error message for a failed execution
        :param pulumi.Input[str] mac: The target's MAC address
        :param pulumi.Input[Union['LiveToolsWakeOnLanRequestArgs', 'LiveToolsWakeOnLanRequestArgsDict']] request: The parameters of the Wake-on-LAN request
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[str] status: Status of the Wake-on-LAN request
        :param pulumi.Input[str] url: GET this url to check the status of your ping request
        :param pulumi.Input[int] vlan_id: The target's VLAN (1 to 4094)
        :param pulumi.Input[str] wake_on_lan_id: ID of the Wake-on-LAN job
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LiveToolsWakeOnLanState.__new__(_LiveToolsWakeOnLanState)

        __props__.__dict__["callback"] = callback
        __props__.__dict__["error"] = error
        __props__.__dict__["mac"] = mac
        __props__.__dict__["request"] = request
        __props__.__dict__["serial"] = serial
        __props__.__dict__["status"] = status
        __props__.__dict__["url"] = url
        __props__.__dict__["vlan_id"] = vlan_id
        __props__.__dict__["wake_on_lan_id"] = wake_on_lan_id
        return LiveToolsWakeOnLan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def callback(self) -> pulumi.Output['outputs.LiveToolsWakeOnLanCallback']:
        """
        Details for the callback. Please include either an httpServerId OR url and sharedSecret
        """
        return pulumi.get(self, "callback")

    @property
    @pulumi.getter
    def error(self) -> pulumi.Output[str]:
        """
        An error message for a failed execution
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def mac(self) -> pulumi.Output[str]:
        """
        The target's MAC address
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def request(self) -> pulumi.Output['outputs.LiveToolsWakeOnLanRequest']:
        """
        The parameters of the Wake-on-LAN request
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the Wake-on-LAN request
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        GET this url to check the status of your ping request
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[int]:
        """
        The target's VLAN (1 to 4094)
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="wakeOnLanId")
    def wake_on_lan_id(self) -> pulumi.Output[str]:
        """
        ID of the Wake-on-LAN job
        """
        return pulumi.get(self, "wake_on_lan_id")

