# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-06-15 16:35
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import jsonfield.fields
import mptt.fields
import rest_survey.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Answer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date Created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date Updated')),
                ('value', models.CharField(max_length=256, verbose_name='Value')),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'Answer',
                'verbose_name_plural': 'Answers',
            },
        ),
        migrations.CreateModel(
            name='OtherAnswer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date Created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date Updated')),
                ('value', models.CharField(max_length=256, verbose_name='Value')),
            ],
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date Created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date Updated')),
                ('parent_value', models.CharField(help_text='Value that enables the user to answer the children questions.', max_length=256, null=True, verbose_name='Parent Value')),
                ('type', models.CharField(choices=[('Radio', 'Radio'), ('Checkboxes', 'Checkboxes'), ('Select', 'Select'), ('Text', 'Text'), ('TextArea', 'TextArea'), ('Number', 'Number'), ('Date', 'Date'), ('DateTime', 'DateTime'), ('List', 'List'), ('Grid', 'Grid')], default='Text', max_length=32, verbose_name='Question Type')),
                ('text', models.CharField(max_length=512, verbose_name='Text')),
                ('help', models.CharField(max_length=512, null=True, verbose_name='Help')),
                ('validators', jsonfield.fields.JSONField(default=rest_survey.models.default_validators, help_text='Validators to be applied at front-end level.', verbose_name='Validators')),
                ('other_token', models.CharField(max_length=16, null=True, verbose_name='Other Token')),
                ('options', jsonfield.fields.JSONField(help_text='Options to be used, if the field is SELECT, RADIO, CHECKBOX or GRID.', null=True, verbose_name='Options')),
                ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
                ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(db_index=True, editable=False)),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='rest_survey.Question')),
            ],
            options={
                'verbose_name': 'Question',
                'verbose_name_plural': 'Questions',
            },
        ),
        migrations.CreateModel(
            name='Section',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date Created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date Updated')),
                ('title', models.CharField(max_length=128, verbose_name='Title')),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'ordering': ('survey', 'order'),
                'verbose_name': 'Section',
                'verbose_name_plural': 'Sections',
            },
        ),
        migrations.CreateModel(
            name='Survey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date Created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date Updated')),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('active', models.BooleanField(default=True, verbose_name='Active?')),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'Survey',
                'verbose_name_plural': 'Surveys',
            },
        ),
        migrations.CreateModel(
            name='SurveyedObject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date Created')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date Updated')),
                ('object_id', models.PositiveIntegerField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='surveyeds', to='rest_survey.Survey')),
            ],
            options={
                'verbose_name': 'Surveyed Object',
                'verbose_name_plural': 'Surveyed Objects',
            },
        ),
        migrations.AddField(
            model_name='section',
            name='survey',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='sections', to='rest_survey.Survey'),
        ),
        migrations.AddField(
            model_name='question',
            name='section',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='questions', to='rest_survey.Section'),
        ),
        migrations.AddField(
            model_name='question',
            name='survey',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='questions', to='rest_survey.Survey'),
        ),
        migrations.AddField(
            model_name='otheranswer',
            name='question',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='others', to='rest_survey.Question'),
        ),
        migrations.AddField(
            model_name='answer',
            name='question',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='answers', to='rest_survey.Question'),
        ),
        migrations.AddField(
            model_name='answer',
            name='surveyed',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='answers', to='rest_survey.SurveyedObject'),
        ),
        migrations.AlterUniqueTogether(
            name='otheranswer',
            unique_together=set([('question', 'value')]),
        ),
    ]
