"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreinstalledAmazonLinuxInstance = exports.PreinstalledSoftwarePackage = void 0;
const ec2 = require("aws-cdk-lib/aws-ec2");
;
/**
 * The type of preinstalled software.
 */
var PreinstalledSoftwarePackage;
(function (PreinstalledSoftwarePackage) {
    /**
     * Node.js
     */
    PreinstalledSoftwarePackage[PreinstalledSoftwarePackage["NODEJS"] = 0] = "NODEJS";
    /**
     * Docker
     */
    PreinstalledSoftwarePackage[PreinstalledSoftwarePackage["DOCKER"] = 1] = "DOCKER";
    /**
     * Visual Studio Code
     */
    PreinstalledSoftwarePackage[PreinstalledSoftwarePackage["VSCODE"] = 2] = "VSCODE";
    /**
     * Git
     */
    PreinstalledSoftwarePackage[PreinstalledSoftwarePackage["GIT"] = 3] = "GIT";
})(PreinstalledSoftwarePackage || (exports.PreinstalledSoftwarePackage = PreinstalledSoftwarePackage = {}));
/**
 * Create an EC2 instance with preinstalled software.
 */
class PreinstalledAmazonLinuxInstance extends ec2.Instance {
    constructor(scope, id, props) {
        if (!(props.machineImage instanceof ec2.AmazonLinuxImage)) {
            throw new Error('Only AMAZON_LINUX, AMAZON_LINUX_2, AMAZON_LINUX_2022, and AMAZON_LINUX_2023 are supported.');
        }
        const userData = props.userData ?? ec2.UserData.forLinux();
        if (props.preinstalledSoftware != null) {
            userData.addCommands('sudo dnf update -y');
            const preinstalledSoftware = props.preinstalledSoftware;
            if (preinstalledSoftware.packages?.includes(PreinstalledSoftwarePackage.NODEJS)) {
                userData.addCommands('touch ~/.bashrc', 'curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.39.7/install.sh | bash', 'source ~/.bashrc', 'export NVM_DIR="$HOME/.nvm"', '[ -s "$NVM_DIR/nvm.sh" ] && \. "$NVM_DIR/nvm.sh"', 'nvm install --lts', `cat <<EOF >> /home/ec2-user/.bashrc
export NVM_DIR="/.nvm"
[ -s "$NVM_DIR/nvm.sh" ] && \. "$NVM_DIR/nvm.sh"
EOF`);
            }
            if (preinstalledSoftware.packages?.includes(PreinstalledSoftwarePackage.DOCKER)) {
                userData.addCommands('sudo amazon-linux-extras install docker', 'sudo systemctl start docker', 'sudo systemctl enable docker', 'sudo usermod -a -G docker ec2-user');
            }
            if (preinstalledSoftware.packages?.includes(PreinstalledSoftwarePackage.VSCODE)) {
                userData.addCommands('sudo rpm --import https://packages.microsoft.com/keys/microsoft.asc', 'echo -e "[code]\nname=Visual Studio Code\nbaseurl=https://packages.microsoft.com/yumrepos/vscode\nenabled=1\ngpgcheck=1\ngpgkey=https://packages.microsoft.com/keys/microsoft.asc" | sudo tee /etc/yum.repos.d/vscode.repo > /dev/null', 'sudo dnf check-update', 'sudo dnf install -y code');
            }
            if (preinstalledSoftware.packages?.includes(PreinstalledSoftwarePackage.GIT)) {
                userData.addCommands('sudo dnf install -y git');
            }
            if (preinstalledSoftware.others) {
                userData.addCommands(`sudo dnf install -y ${preinstalledSoftware.others.join(' ')}`);
            }
        }
        const { preinstalledSoftware, ...rest } = props;
        super(scope, id, { ...rest, userData: userData });
    }
}
exports.PreinstalledAmazonLinuxInstance = PreinstalledAmazonLinuxInstance;
//# sourceMappingURL=data:application/json;base64,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