"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceConnectEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Represents an EC2 Instance Connect Endpoint construct in AWS CDK.
 *
 * @example
 * declare const securityGroups: aws_ec2.ISecurityGroup[];
 * declare const vpc: aws_ec2.IVpc;
 *
 * const instanceConnectEndpoint = new InstanceConnectEndpoint(
 *   stack,
 *   'InstanceConnectEndpoint',
 *   {
 *     clientToken: 'my-client-token',
 *     preserveClientIp: true,
 *     securityGroups,
 *     vpc,
 *   },
 * );
 */
class InstanceConnectEndpoint extends aws_cdk_lib_1.Resource {
    /**
     * Import an existing endpoint to the stack from its attributes.
     */
    static fromInstanceConnectEndpointAttributes(scope, id, attrs) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.instanceConnectEndpointId = attrs.instanceConnectEndpointId;
                this.connections = new aws_cdk_lib_1.aws_ec2.Connections({
                    securityGroups: attrs.securityGroups,
                });
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.securityGroups = props.securityGroups ?? [this.createSecurityGroup()];
        this.connections = new aws_cdk_lib_1.aws_ec2.Connections({
            securityGroups: this.securityGroups,
        });
        const instanceConnectEndpoint = this.createInstanceConnectEndpoint();
        this.instanceConnectEndpointId = instanceConnectEndpoint.attrId;
    }
    createInstanceConnectEndpoint() {
        return new aws_cdk_lib_1.aws_ec2.CfnInstanceConnectEndpoint(this, 'Resource', {
            clientToken: this.props.clientToken,
            preserveClientIp: this.props.preserveClientIp,
            securityGroupIds: this.securityGroups.map(sg => sg.securityGroupId),
            subnetId: this.props.vpc.selectSubnets().subnetIds[0],
        });
    }
    createSecurityGroup() {
        return new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'SecurityGroup', {
            vpc: this.props.vpc,
        });
    }
}
exports.InstanceConnectEndpoint = InstanceConnectEndpoint;
_a = JSII_RTTI_SYMBOL_1;
InstanceConnectEndpoint[_a] = { fqn: "@open-constructs/aws-cdk.aws_ec2.InstanceConnectEndpoint", version: "0.1.1" };
//# sourceMappingURL=data:application/json;base64,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