import { aws_fsx } from 'aws-cdk-lib';
/**
 * Properties required for setting up a weekly maintenance time
 */
export interface MaintenanceTimeProps {
    /**
     * The day of the week for maintenance to be performed.
     */
    readonly day: aws_fsx.Weekday;
    /**
     * The hour of the day (from 0-23) for maintenance to be performed.
     */
    readonly hour: number;
    /**
     * The minute of the hour (from 0-59) for maintenance to be performed.
     */
    readonly minute: number;
}
/**
 * Class for scheduling a weekly maintenance time.
 */
export declare class MaintenanceTime {
    /**
     * The day of the week for maintenance to be performed.
     */
    private readonly day;
    /**
     * The hour of the day (from 00-23) for maintenance to be performed.
     */
    private readonly hour;
    /**
     * The minute of the hour (from 00-59) for maintenance to be performed.
     */
    private readonly minute;
    constructor(props: MaintenanceTimeProps);
    /**
     * Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     */
    toTimestamp(): string;
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    private getTwoDigitString;
    /**
     * Validation needed for the values of the maintenance time.
     */
    private validate;
}
