"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import common.healthcheck.v1alpha.healthcheck_pb2
import common.task.v1alpha.task_pb2
import google.longrunning.operations_pb2
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import model.model.v1alpha.model_definition_pb2
import model.model.v1alpha.task_classification_pb2
import model.model.v1alpha.task_detection_pb2
import model.model.v1alpha.task_instance_segmentation_pb2
import model.model.v1alpha.task_keypoint_pb2
import model.model.v1alpha.task_ocr_pb2
import model.model.v1alpha.task_semantic_segmentation_pb2
import model.model.v1alpha.task_text_generation_pb2
import model.model.v1alpha.task_text_to_image_pb2
import model.model.v1alpha.task_unspecified_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class LivenessRequest(google.protobuf.message.Message):
    """LivenessRequest represents a request to check a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___LivenessRequest = LivenessRequest

@typing_extensions.final
class LivenessResponse(google.protobuf.message.Message):
    """LivenessResponse represents a response for a service liveness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___LivenessResponse = LivenessResponse

@typing_extensions.final
class ReadinessRequest(google.protobuf.message.Message):
    """ReadinessRequest represents a request to check a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def health_check_request(self) -> common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckRequest:
        """HealthCheckRequest message"""
    def __init__(
        self,
        *,
        health_check_request: common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_health_check_request", b"_health_check_request", "health_check_request", b"health_check_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_health_check_request", b"_health_check_request"]) -> typing_extensions.Literal["health_check_request"] | None: ...

global___ReadinessRequest = ReadinessRequest

@typing_extensions.final
class ReadinessResponse(google.protobuf.message.Message):
    """ReadinessResponse represents a response for a service readiness status"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def health_check_response(self) -> common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckResponse:
        """HealthCheckResponse message"""
    def __init__(
        self,
        *,
        health_check_response: common.healthcheck.v1alpha.healthcheck_pb2.HealthCheckResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["health_check_response", b"health_check_response"]) -> None: ...

global___ReadinessResponse = ReadinessResponse

@typing_extensions.final
class Model(google.protobuf.message.Message):
    """Model represents a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Visibility:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _VisibilityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Model._Visibility.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VISIBILITY_UNSPECIFIED: Model._Visibility.ValueType  # 0
        """Visibility: UNSPECIFIED, equivalent to PRIVATE."""
        VISIBILITY_PRIVATE: Model._Visibility.ValueType  # 1
        """Visibility: PRIVATE"""
        VISIBILITY_PUBLIC: Model._Visibility.ValueType  # 2
        """Visibility: PUBLIC"""

    class Visibility(_Visibility, metaclass=_VisibilityEnumTypeWrapper):
        """Model visibility including public or private"""

    VISIBILITY_UNSPECIFIED: Model.Visibility.ValueType  # 0
    """Visibility: UNSPECIFIED, equivalent to PRIVATE."""
    VISIBILITY_PRIVATE: Model.Visibility.ValueType  # 1
    """Visibility: PRIVATE"""
    VISIBILITY_PUBLIC: Model.Visibility.ValueType  # 2
    """Visibility: PUBLIC"""

    class _State:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Model._State.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATE_UNSPECIFIED: Model._State.ValueType  # 0
        """State: UNSPECIFIED"""
        STATE_OFFLINE: Model._State.ValueType  # 1
        """State: OFFLINE"""
        STATE_ONLINE: Model._State.ValueType  # 2
        """State: ONLINE"""
        STATE_ERROR: Model._State.ValueType  # 3
        """State: ERROR"""

    class State(_State, metaclass=_StateEnumTypeWrapper):
        """State enumerates a model state"""

    STATE_UNSPECIFIED: Model.State.ValueType  # 0
    """State: UNSPECIFIED"""
    STATE_OFFLINE: Model.State.ValueType  # 1
    """State: OFFLINE"""
    STATE_ONLINE: Model.State.ValueType  # 2
    """State: ONLINE"""
    STATE_ERROR: Model.State.ValueType  # 3
    """State: ERROR"""

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    MODEL_DEFINITION_FIELD_NUMBER: builtins.int
    CONFIGURATION_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    ORG_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name. It must have the format of "users/{user}/models/{model}".
    For example: "users/instill-ai/models/yolov4"
    """
    uid: builtins.str
    """Model ID in UUIDv4"""
    id: builtins.str
    """Resource ID (the last segment of the resource name) used to construct the
    resource name. This conforms to RFC-1034, which restricts to letters,
    numbers, and hyphen, with the first character a letter, the last a letter
    or a number, and a 63 character maximum.
    """
    description: builtins.str
    """Model description"""
    model_definition: builtins.str
    """Model definition resource name"""
    @property
    def configuration(self) -> google.protobuf.struct_pb2.Struct:
        """Model configuration represents the configuration JSON that has been
        validated using the `model_spec` JSON schema of a ModelDefinition
        """
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """Model task"""
    state: global___Model.State.ValueType
    """Model state"""
    visibility: global___Model.Visibility.ValueType
    """Model visibility including public or private"""
    user: builtins.str
    """The resource name with UUID of a user, e.g.,
    "users/bfb978f8-78d3-4338-aa2b-a6c699cb07c5".
    """
    org: builtins.str
    """The resource name with UUID of an organization"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Model create time"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Model update time"""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Model delete time"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        description: builtins.str | None = ...,
        model_definition: builtins.str = ...,
        configuration: google.protobuf.struct_pb2.Struct | None = ...,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        state: global___Model.State.ValueType = ...,
        visibility: global___Model.Visibility.ValueType = ...,
        user: builtins.str = ...,
        org: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_description", b"_description", "configuration", b"configuration", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "org", b"org", "owner", b"owner", "update_time", b"update_time", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_description", b"_description", "configuration", b"configuration", "create_time", b"create_time", "delete_time", b"delete_time", "description", b"description", "id", b"id", "model_definition", b"model_definition", "name", b"name", "org", b"org", "owner", b"owner", "state", b"state", "task", b"task", "uid", b"uid", "update_time", b"update_time", "user", b"user", "visibility", b"visibility"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_description", b"_description"]) -> typing_extensions.Literal["description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["owner", b"owner"]) -> typing_extensions.Literal["user", "org"] | None: ...

global___Model = Model

@typing_extensions.final
class ModelCard(google.protobuf.message.Message):
    """ModelCard represents the README card for a model. There
    exists one and exactly one README card per model.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    ENCODING_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name. It must have the format of
    "users/{user}/models/{model}/readme"
    """
    size: builtins.int
    """Size of the file"""
    type: builtins.str
    """Type of the resource. Fixed to "file"."""
    content: builtins.bytes
    """Content of the README file in bytes and base64 format"""
    encoding: builtins.str
    """Encoding type of the content. Fixed to "base64"."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        size: builtins.int = ...,
        type: builtins.str = ...,
        content: builtins.bytes = ...,
        encoding: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["content", b"content", "encoding", b"encoding", "name", b"name", "size", b"size", "type", b"type"]) -> None: ...

global___ModelCard = ModelCard

@typing_extensions.final
class ListModelsRequest(google.protobuf.message.Message):
    """ListModelsRequest represents a request to list all models"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """Page size: the maximum number of resources to return. The service may
    return fewer than this value. If unspecified, at most 10 models will be
    returned. The maximum value is 100; values above 100 will be coereced to
    100.
    """
    page_token: builtins.str
    """Page token"""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """Model view (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `Model.configuration`
    VIEW_FULL: show full information
    """
    show_deleted: builtins.bool
    """Return soft_deleted models"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListModelsRequest = ListModelsRequest

@typing_extensions.final
class ListModelsResponse(google.protobuf.message.Message):
    """ListModelsResponse represents a response for a list of models"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """a list of Models"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of models"""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListModelsResponse = ListModelsResponse

@typing_extensions.final
class LookUpModelRequest(google.protobuf.message.Message):
    """LookUpModelRequest represents a request to query a model via permalink"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """Permalink of a model. For example:
    Format: models/{uid}
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """Model view (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `Model.configuration`
    VIEW_FULL: show full information
    """
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpModelRequest = LookUpModelRequest

@typing_extensions.final
class LookUpModelResponse(google.protobuf.message.Message):
    """LookUpModelResponse represents a response for a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """A model resource"""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___LookUpModelResponse = LookUpModelResponse

@typing_extensions.final
class CreateUserModelRequest(google.protobuf.message.Message):
    """CreateUserModelRequest represents a request to create a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The model to be created

        The model `name` field is used to identify the model to create.
        Format: users/{user}/models/{model}
        """
    parent: builtins.str
    """The parent resource where this connector resource will be created.
    Format: users/{users}
    """
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "parent", b"parent"]) -> None: ...

global___CreateUserModelRequest = CreateUserModelRequest

@typing_extensions.final
class CreateUserModelResponse(google.protobuf.message.Message):
    """CreateUserModelResponse represents a response for a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Create model operation message"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___CreateUserModelResponse = CreateUserModelResponse

@typing_extensions.final
class CreateUserModelBinaryFileUploadRequest(google.protobuf.message.Message):
    """CreateUserModelBinaryFileUploadRequest represents a request to create a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The model to be created

        The model `name` field is used to identify the model to create.
        Format: users/{user}/models/{model}
        """
    content: builtins.bytes
    """Model content in bytes"""
    parent: builtins.str
    """The parent resource where this connector resource will be created.
    Format: users/{users}
    """
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        content: builtins.bytes = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["content", b"content", "model", b"model", "parent", b"parent"]) -> None: ...

global___CreateUserModelBinaryFileUploadRequest = CreateUserModelBinaryFileUploadRequest

@typing_extensions.final
class CreateUserModelBinaryFileUploadResponse(google.protobuf.message.Message):
    """CreateUserModelBinaryFileUploadResponse represents a response for a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Create model operation message"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___CreateUserModelBinaryFileUploadResponse = CreateUserModelBinaryFileUploadResponse

@typing_extensions.final
class ListUserModelsRequest(google.protobuf.message.Message):
    """ListUserModelsRequest represents a request to list all models"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """Page size: the maximum number of resources to return. The service may
    return fewer than this value. If unspecified, at most 10 models will be
    returned. The maximum value is 100; values above 100 will be coereced to
    100.
    """
    page_token: builtins.str
    """Page token"""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """Model view (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `Model.configuration`
    VIEW_FULL: show full information
    """
    parent: builtins.str
    """The parent resource where this connector resource will be created.
    Format: users/{users}
    """
    show_deleted: builtins.bool
    """Return soft_deleted models"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
        parent: builtins.str = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListUserModelsRequest = ListUserModelsRequest

@typing_extensions.final
class ListUserModelsResponse(google.protobuf.message.Message):
    """ListUserModelsResponse represents a response for a list of models"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """a list of Models"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of models"""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListUserModelsResponse = ListUserModelsResponse

@typing_extensions.final
class GetUserModelRequest(google.protobuf.message.Message):
    """GetUserModelRequest represents a request to query a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name of the model.
    Format: users/{user}/models/{model}
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """Model view (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `Model.configuration`
    VIEW_FULL: show full information
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetUserModelRequest = GetUserModelRequest

@typing_extensions.final
class GetUserModelResponse(google.protobuf.message.Message):
    """GetUserModelResponse represents a response for a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The retrieved model"""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___GetUserModelResponse = GetUserModelResponse

@typing_extensions.final
class UpdateUserModelRequest(google.protobuf.message.Message):
    """UpdateUserModelRequest represents a request to update a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The model to update"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Mask of fields to update."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "update_mask", b"update_mask"]) -> None: ...

global___UpdateUserModelRequest = UpdateUserModelRequest

@typing_extensions.final
class UpdateUserModelResponse(google.protobuf.message.Message):
    """UpdateUserModelResponse represents a response for a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """The updated model"""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___UpdateUserModelResponse = UpdateUserModelResponse

@typing_extensions.final
class DeleteUserModelRequest(google.protobuf.message.Message):
    """DeleteUserModelRequest represents a request to delete a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name of the model.
    Format: users/{user}/models/{model}
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteUserModelRequest = DeleteUserModelRequest

@typing_extensions.final
class DeleteUserModelResponse(google.protobuf.message.Message):
    """DeleteUserModelResponse represents an empty response"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserModelResponse = DeleteUserModelResponse

@typing_extensions.final
class RenameUserModelRequest(google.protobuf.message.Message):
    """RenameUserModelRequest represents a request to rename a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    NEW_MODEL_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name for the model to be renamed.
    Format: users/{user}/models/{model}
    """
    new_model_id: builtins.str
    """New ID of this model
    Format: users/{user}/models/{new_model_id}
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        new_model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "new_model_id", b"new_model_id"]) -> None: ...

global___RenameUserModelRequest = RenameUserModelRequest

@typing_extensions.final
class RenameUserModelResponse(google.protobuf.message.Message):
    """RenameUserModelResponse represents a response for a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """Renamed model"""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___RenameUserModelResponse = RenameUserModelResponse

@typing_extensions.final
class PublishUserModelRequest(google.protobuf.message.Message):
    """PublisUserhModelRequest represents a request to publish a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name of the model.
    Format: users/{user}/models/{model}
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___PublishUserModelRequest = PublishUserModelRequest

@typing_extensions.final
class PublishUserModelResponse(google.protobuf.message.Message):
    """PublishUserModelResponse represents a response for the published model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """Published model"""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___PublishUserModelResponse = PublishUserModelResponse

@typing_extensions.final
class UnpublishUserModelRequest(google.protobuf.message.Message):
    """UnpublishUserModelRequest represents a request to unpublish a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name of the model.
    Format: users/{user}/models/{model}
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___UnpublishUserModelRequest = UnpublishUserModelRequest

@typing_extensions.final
class UnpublishUserModelResponse(google.protobuf.message.Message):
    """UnpublishUserModelResponse represents a response for the unpublished model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """Unpublished model"""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___UnpublishUserModelResponse = UnpublishUserModelResponse

@typing_extensions.final
class DeployUserModelRequest(google.protobuf.message.Message):
    """DeployUserModelRequest represents a request to deploy a model to online state"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name for the model to be deployed.
    Format: users/{user}/models/{model}
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeployUserModelRequest = DeployUserModelRequest

@typing_extensions.final
class DeployUserModelResponse(google.protobuf.message.Message):
    """DeployUserModelResponse represents a response for a deployed model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Deployed model's id
    Format: users/{user}/models/{model}
    """
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id"]) -> None: ...

global___DeployUserModelResponse = DeployUserModelResponse

@typing_extensions.final
class UndeployUserModelRequest(google.protobuf.message.Message):
    """UndeployUserModelRequest represents a request to undeploy a model to offline
    state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name for the model to be undeployed.
    Format: users/{user}/models/{model}
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___UndeployUserModelRequest = UndeployUserModelRequest

@typing_extensions.final
class UndeployUserModelResponse(google.protobuf.message.Message):
    """UndeployUserModelResponse represents a response for a undeployed model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ID_FIELD_NUMBER: builtins.int
    model_id: builtins.str
    """Undeployed model's id
    Format: users/{user}/models/{model}
    """
    def __init__(
        self,
        *,
        model_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_id", b"model_id"]) -> None: ...

global___UndeployUserModelResponse = UndeployUserModelResponse

@typing_extensions.final
class GetUserModelCardRequest(google.protobuf.message.Message):
    """GetUserModelCardRequest represents a request to query a model's README card"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name of the model card.
    For example "// Format: users/{user}/models/{model}/readme"
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___GetUserModelCardRequest = GetUserModelCardRequest

@typing_extensions.final
class GetUserModelCardResponse(google.protobuf.message.Message):
    """GetUserModelCardResponse represents a response to fetch a model's README card"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    README_FIELD_NUMBER: builtins.int
    @property
    def readme(self) -> global___ModelCard:
        """Retrieved model card"""
    def __init__(
        self,
        *,
        readme: global___ModelCard | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["readme", b"readme"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["readme", b"readme"]) -> None: ...

global___GetUserModelCardResponse = GetUserModelCardResponse

@typing_extensions.final
class WatchUserModelRequest(google.protobuf.message.Message):
    """WatchUserModelRequest represents a public request to query
    a model's current state and longrunning progress
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource name of the model.
    Format: users/{user}/models/{model}
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___WatchUserModelRequest = WatchUserModelRequest

@typing_extensions.final
class WatchUserModelResponse(google.protobuf.message.Message):
    """WatchUserModelResponse represents a public response to
    fetch a model current state and longrunning progress
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    PROGRESS_FIELD_NUMBER: builtins.int
    state: global___Model.State.ValueType
    """Retrieved model state"""
    progress: builtins.int
    """Retrieved model logrunning progress"""
    def __init__(
        self,
        *,
        state: global___Model.State.ValueType = ...,
        progress: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["progress", b"progress", "state", b"state"]) -> None: ...

global___WatchUserModelResponse = WatchUserModelResponse

@typing_extensions.final
class TaskInput(google.protobuf.message.Message):
    """//////////////////////////////////
     Trigger methods
    //////////////////////////////////

    Input represents the input to trigger a model
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLASSIFICATION_FIELD_NUMBER: builtins.int
    DETECTION_FIELD_NUMBER: builtins.int
    KEYPOINT_FIELD_NUMBER: builtins.int
    OCR_FIELD_NUMBER: builtins.int
    INSTANCE_SEGMENTATION_FIELD_NUMBER: builtins.int
    SEMANTIC_SEGMENTATION_FIELD_NUMBER: builtins.int
    TEXT_TO_IMAGE_FIELD_NUMBER: builtins.int
    TEXT_GENERATION_FIELD_NUMBER: builtins.int
    UNSPECIFIED_FIELD_NUMBER: builtins.int
    @property
    def classification(self) -> model.model.v1alpha.task_classification_pb2.ClassificationInput:
        """The classification input"""
    @property
    def detection(self) -> model.model.v1alpha.task_detection_pb2.DetectionInput:
        """The detection input"""
    @property
    def keypoint(self) -> model.model.v1alpha.task_keypoint_pb2.KeypointInput:
        """The keypoint input"""
    @property
    def ocr(self) -> model.model.v1alpha.task_ocr_pb2.OcrInput:
        """The ocr input"""
    @property
    def instance_segmentation(self) -> model.model.v1alpha.task_instance_segmentation_pb2.InstanceSegmentationInput:
        """The instance segmentation input"""
    @property
    def semantic_segmentation(self) -> model.model.v1alpha.task_semantic_segmentation_pb2.SemanticSegmentationInput:
        """The semantic segmentation input"""
    @property
    def text_to_image(self) -> model.model.v1alpha.task_text_to_image_pb2.TextToImageInput:
        """The text to image input"""
    @property
    def text_generation(self) -> model.model.v1alpha.task_text_generation_pb2.TextGenerationInput:
        """The text generation input"""
    @property
    def unspecified(self) -> model.model.v1alpha.task_unspecified_pb2.UnspecifiedInput:
        """The unspecified task input"""
    def __init__(
        self,
        *,
        classification: model.model.v1alpha.task_classification_pb2.ClassificationInput | None = ...,
        detection: model.model.v1alpha.task_detection_pb2.DetectionInput | None = ...,
        keypoint: model.model.v1alpha.task_keypoint_pb2.KeypointInput | None = ...,
        ocr: model.model.v1alpha.task_ocr_pb2.OcrInput | None = ...,
        instance_segmentation: model.model.v1alpha.task_instance_segmentation_pb2.InstanceSegmentationInput | None = ...,
        semantic_segmentation: model.model.v1alpha.task_semantic_segmentation_pb2.SemanticSegmentationInput | None = ...,
        text_to_image: model.model.v1alpha.task_text_to_image_pb2.TextToImageInput | None = ...,
        text_generation: model.model.v1alpha.task_text_generation_pb2.TextGenerationInput | None = ...,
        unspecified: model.model.v1alpha.task_unspecified_pb2.UnspecifiedInput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["classification", b"classification", "detection", b"detection", "input", b"input", "instance_segmentation", b"instance_segmentation", "keypoint", b"keypoint", "ocr", b"ocr", "semantic_segmentation", b"semantic_segmentation", "text_generation", b"text_generation", "text_to_image", b"text_to_image", "unspecified", b"unspecified"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["classification", b"classification", "detection", b"detection", "input", b"input", "instance_segmentation", b"instance_segmentation", "keypoint", b"keypoint", "ocr", b"ocr", "semantic_segmentation", b"semantic_segmentation", "text_generation", b"text_generation", "text_to_image", b"text_to_image", "unspecified", b"unspecified"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["input", b"input"]) -> typing_extensions.Literal["classification", "detection", "keypoint", "ocr", "instance_segmentation", "semantic_segmentation", "text_to_image", "text_generation", "unspecified"] | None: ...

global___TaskInput = TaskInput

@typing_extensions.final
class TaskInputStream(google.protobuf.message.Message):
    """TaskInputStream represents the input to trigger a model with stream method"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLASSIFICATION_FIELD_NUMBER: builtins.int
    DETECTION_FIELD_NUMBER: builtins.int
    KEYPOINT_FIELD_NUMBER: builtins.int
    OCR_FIELD_NUMBER: builtins.int
    INSTANCE_SEGMENTATION_FIELD_NUMBER: builtins.int
    SEMANTIC_SEGMENTATION_FIELD_NUMBER: builtins.int
    TEXT_TO_IMAGE_FIELD_NUMBER: builtins.int
    TEXT_GENERATION_FIELD_NUMBER: builtins.int
    UNSPECIFIED_FIELD_NUMBER: builtins.int
    @property
    def classification(self) -> model.model.v1alpha.task_classification_pb2.ClassificationInputStream:
        """The classification input"""
    @property
    def detection(self) -> model.model.v1alpha.task_detection_pb2.DetectionInputStream:
        """The detection input"""
    @property
    def keypoint(self) -> model.model.v1alpha.task_keypoint_pb2.KeypointInputStream:
        """The keypoint input"""
    @property
    def ocr(self) -> model.model.v1alpha.task_ocr_pb2.OcrInputStream:
        """The ocr input"""
    @property
    def instance_segmentation(self) -> model.model.v1alpha.task_instance_segmentation_pb2.InstanceSegmentationInputStream:
        """The instance segmentation input"""
    @property
    def semantic_segmentation(self) -> model.model.v1alpha.task_semantic_segmentation_pb2.SemanticSegmentationInputStream:
        """The semantic segmentation input"""
    @property
    def text_to_image(self) -> model.model.v1alpha.task_text_to_image_pb2.TextToImageInput:
        """The text to image input"""
    @property
    def text_generation(self) -> model.model.v1alpha.task_text_generation_pb2.TextGenerationInput:
        """The text generation input"""
    @property
    def unspecified(self) -> model.model.v1alpha.task_unspecified_pb2.UnspecifiedInput:
        """The unspecified task input"""
    def __init__(
        self,
        *,
        classification: model.model.v1alpha.task_classification_pb2.ClassificationInputStream | None = ...,
        detection: model.model.v1alpha.task_detection_pb2.DetectionInputStream | None = ...,
        keypoint: model.model.v1alpha.task_keypoint_pb2.KeypointInputStream | None = ...,
        ocr: model.model.v1alpha.task_ocr_pb2.OcrInputStream | None = ...,
        instance_segmentation: model.model.v1alpha.task_instance_segmentation_pb2.InstanceSegmentationInputStream | None = ...,
        semantic_segmentation: model.model.v1alpha.task_semantic_segmentation_pb2.SemanticSegmentationInputStream | None = ...,
        text_to_image: model.model.v1alpha.task_text_to_image_pb2.TextToImageInput | None = ...,
        text_generation: model.model.v1alpha.task_text_generation_pb2.TextGenerationInput | None = ...,
        unspecified: model.model.v1alpha.task_unspecified_pb2.UnspecifiedInput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["classification", b"classification", "detection", b"detection", "input", b"input", "instance_segmentation", b"instance_segmentation", "keypoint", b"keypoint", "ocr", b"ocr", "semantic_segmentation", b"semantic_segmentation", "text_generation", b"text_generation", "text_to_image", b"text_to_image", "unspecified", b"unspecified"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["classification", b"classification", "detection", b"detection", "input", b"input", "instance_segmentation", b"instance_segmentation", "keypoint", b"keypoint", "ocr", b"ocr", "semantic_segmentation", b"semantic_segmentation", "text_generation", b"text_generation", "text_to_image", b"text_to_image", "unspecified", b"unspecified"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["input", b"input"]) -> typing_extensions.Literal["classification", "detection", "keypoint", "ocr", "instance_segmentation", "semantic_segmentation", "text_to_image", "text_generation", "unspecified"] | None: ...

global___TaskInputStream = TaskInputStream

@typing_extensions.final
class TaskOutput(google.protobuf.message.Message):
    """TaskOutput represents the output of a CV Task result from a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLASSIFICATION_FIELD_NUMBER: builtins.int
    DETECTION_FIELD_NUMBER: builtins.int
    KEYPOINT_FIELD_NUMBER: builtins.int
    OCR_FIELD_NUMBER: builtins.int
    INSTANCE_SEGMENTATION_FIELD_NUMBER: builtins.int
    SEMANTIC_SEGMENTATION_FIELD_NUMBER: builtins.int
    TEXT_TO_IMAGE_FIELD_NUMBER: builtins.int
    TEXT_GENERATION_FIELD_NUMBER: builtins.int
    UNSPECIFIED_FIELD_NUMBER: builtins.int
    @property
    def classification(self) -> model.model.v1alpha.task_classification_pb2.ClassificationOutput:
        """The classification output"""
    @property
    def detection(self) -> model.model.v1alpha.task_detection_pb2.DetectionOutput:
        """The detection output"""
    @property
    def keypoint(self) -> model.model.v1alpha.task_keypoint_pb2.KeypointOutput:
        """The keypoint output"""
    @property
    def ocr(self) -> model.model.v1alpha.task_ocr_pb2.OcrOutput:
        """The ocr output"""
    @property
    def instance_segmentation(self) -> model.model.v1alpha.task_instance_segmentation_pb2.InstanceSegmentationOutput:
        """The instance segmentation output"""
    @property
    def semantic_segmentation(self) -> model.model.v1alpha.task_semantic_segmentation_pb2.SemanticSegmentationOutput:
        """The semantic segmentation output"""
    @property
    def text_to_image(self) -> model.model.v1alpha.task_text_to_image_pb2.TextToImageOutput:
        """The text to image output"""
    @property
    def text_generation(self) -> model.model.v1alpha.task_text_generation_pb2.TextGenerationOutput:
        """The text generation output"""
    @property
    def unspecified(self) -> model.model.v1alpha.task_unspecified_pb2.UnspecifiedOutput:
        """The unspecified task output"""
    def __init__(
        self,
        *,
        classification: model.model.v1alpha.task_classification_pb2.ClassificationOutput | None = ...,
        detection: model.model.v1alpha.task_detection_pb2.DetectionOutput | None = ...,
        keypoint: model.model.v1alpha.task_keypoint_pb2.KeypointOutput | None = ...,
        ocr: model.model.v1alpha.task_ocr_pb2.OcrOutput | None = ...,
        instance_segmentation: model.model.v1alpha.task_instance_segmentation_pb2.InstanceSegmentationOutput | None = ...,
        semantic_segmentation: model.model.v1alpha.task_semantic_segmentation_pb2.SemanticSegmentationOutput | None = ...,
        text_to_image: model.model.v1alpha.task_text_to_image_pb2.TextToImageOutput | None = ...,
        text_generation: model.model.v1alpha.task_text_generation_pb2.TextGenerationOutput | None = ...,
        unspecified: model.model.v1alpha.task_unspecified_pb2.UnspecifiedOutput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["classification", b"classification", "detection", b"detection", "instance_segmentation", b"instance_segmentation", "keypoint", b"keypoint", "ocr", b"ocr", "output", b"output", "semantic_segmentation", b"semantic_segmentation", "text_generation", b"text_generation", "text_to_image", b"text_to_image", "unspecified", b"unspecified"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["classification", b"classification", "detection", b"detection", "instance_segmentation", b"instance_segmentation", "keypoint", b"keypoint", "ocr", b"ocr", "output", b"output", "semantic_segmentation", b"semantic_segmentation", "text_generation", b"text_generation", "text_to_image", b"text_to_image", "unspecified", b"unspecified"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["output", b"output"]) -> typing_extensions.Literal["classification", "detection", "keypoint", "ocr", "instance_segmentation", "semantic_segmentation", "text_to_image", "text_generation", "unspecified"] | None: ...

global___TaskOutput = TaskOutput

@typing_extensions.final
class TriggerUserModelRequest(google.protobuf.message.Message):
    """TriggerUserModelRequest represents a request to trigger a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model to trigger.
    Format: users/{user}/models/{model}
    """
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskInput]:
        """Input to trigger the model"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        task_inputs: collections.abc.Iterable[global___TaskInput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs"]) -> None: ...

global___TriggerUserModelRequest = TriggerUserModelRequest

@typing_extensions.final
class TriggerUserModelResponse(google.protobuf.message.Message):
    """TriggerUserModelResponse represents a response for the output for
    triggering a model
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """The task type"""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskOutput]:
        """The task output from a model"""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[global___TaskOutput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerUserModelResponse = TriggerUserModelResponse

@typing_extensions.final
class TriggerUserModelBinaryFileUploadRequest(google.protobuf.message.Message):
    """TriggerUserModelBinaryFileUploadRequest represents a request to test a
    model by uploading binary file
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TASK_INPUT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model to trigger.
    Format: users/{user}/models/{model}
    """
    @property
    def task_input(self) -> global___TaskInputStream:
        """Input to trigger the model"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        task_input: global___TaskInputStream | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["task_input", b"task_input"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_input", b"task_input"]) -> None: ...

global___TriggerUserModelBinaryFileUploadRequest = TriggerUserModelBinaryFileUploadRequest

@typing_extensions.final
class TriggerUserModelBinaryFileUploadResponse(google.protobuf.message.Message):
    """TriggerUserModelBinaryFileUploadResponse represents a response for the
    output for testing a model
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """The task type"""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskOutput]:
        """The task output from a model"""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[global___TaskOutput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TriggerUserModelBinaryFileUploadResponse = TriggerUserModelBinaryFileUploadResponse

@typing_extensions.final
class TestUserModelRequest(google.protobuf.message.Message):
    """TestUserModelRequest represents a request to test a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TASK_INPUTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model to trigger.
    Format: users/{user}/models/{model}
    """
    @property
    def task_inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskInput]:
        """Input to trigger the model"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        task_inputs: collections.abc.Iterable[global___TaskInput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_inputs", b"task_inputs"]) -> None: ...

global___TestUserModelRequest = TestUserModelRequest

@typing_extensions.final
class TestUserModelResponse(google.protobuf.message.Message):
    """TestUserModelResponse represents a response for the output for
    testing a model
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """The task type"""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskOutput]:
        """The task output from a model"""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[global___TaskOutput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TestUserModelResponse = TestUserModelResponse

@typing_extensions.final
class TestUserModelBinaryFileUploadRequest(google.protobuf.message.Message):
    """TestUserModelBinaryFileUploadRequest represents a request to test a
    model by uploading binary file
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TASK_INPUT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the model to trigger.
    Format: users/{user}/models/{model}
    """
    @property
    def task_input(self) -> global___TaskInputStream:
        """Input to trigger the model"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        task_input: global___TaskInputStream | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["task_input", b"task_input"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "task_input", b"task_input"]) -> None: ...

global___TestUserModelBinaryFileUploadRequest = TestUserModelBinaryFileUploadRequest

@typing_extensions.final
class TestUserModelBinaryFileUploadResponse(google.protobuf.message.Message):
    """TestUserModelBinaryFileUploadResponse represents a response for the
    output for testing a model
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TASK_FIELD_NUMBER: builtins.int
    TASK_OUTPUTS_FIELD_NUMBER: builtins.int
    task: common.task.v1alpha.task_pb2.Task.ValueType
    """The task type"""
    @property
    def task_outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskOutput]:
        """The task output from a model"""
    def __init__(
        self,
        *,
        task: common.task.v1alpha.task_pb2.Task.ValueType = ...,
        task_outputs: collections.abc.Iterable[global___TaskOutput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["task", b"task", "task_outputs", b"task_outputs"]) -> None: ...

global___TestUserModelBinaryFileUploadResponse = TestUserModelBinaryFileUploadResponse

@typing_extensions.final
class GetModelOperationRequest(google.protobuf.message.Message):
    """GerModelOperationRequest represents a request to query a model operation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the operation resource."""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """View (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `Model.configuration`,
    `Model.configuration` VIEW_FULL: show full information
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetModelOperationRequest = GetModelOperationRequest

@typing_extensions.final
class GetModelOperationResponse(google.protobuf.message.Message):
    """GetModelOperationResponse represents a response for a model operation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """The retrieved model operation"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___GetModelOperationResponse = GetModelOperationResponse

@typing_extensions.final
class ListModelsAdminRequest(google.protobuf.message.Message):
    """========== Private endpoints

    ListModelsAdminRequest represents a request to list all models from all users
    by admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    SHOW_DELETED_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """Page size: the maximum number of resources to return. The service may
    return fewer than this value. If unspecified, at most 10 models will be
    returned. The maximum value is 100; values above 100 will be coereced to
    100.
    """
    page_token: builtins.str
    """Page token"""
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """Model view (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `Model.configuration`
    VIEW_FULL: show full information
    """
    show_deleted: builtins.bool
    """Return soft_deleted models"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
        show_deleted: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "_show_deleted", b"_show_deleted", "_view", b"_view", "page_size", b"page_size", "page_token", b"page_token", "show_deleted", b"show_deleted", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_show_deleted", b"_show_deleted"]) -> typing_extensions.Literal["show_deleted"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListModelsAdminRequest = ListModelsAdminRequest

@typing_extensions.final
class ListModelsAdminResponse(google.protobuf.message.Message):
    """ListModelsAdminResponse represents a response for a list of models"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Model]:
        """a list of Models"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of models"""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___Model] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListModelsAdminResponse = ListModelsAdminResponse

@typing_extensions.final
class LookUpModelAdminRequest(google.protobuf.message.Message):
    """LookUpModelAdminRequest represents a request to query a model via
    permalink by admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """Permalink of a model. For example:
    "models/{uid}"
    """
    view: model.model.v1alpha.model_definition_pb2.View.ValueType
    """Model view (default is VIEW_BASIC)
    VIEW_UNSPECIFIED/VIEW_BASIC: omit `Model.configuration`
    VIEW_FULL: show full information
    """
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: model.model.v1alpha.model_definition_pb2.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpModelAdminRequest = LookUpModelAdminRequest

@typing_extensions.final
class LookUpModelAdminResponse(google.protobuf.message.Message):
    """LookUpModelResponse represents a response for a model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """A model resource"""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___LookUpModelAdminResponse = LookUpModelAdminResponse

@typing_extensions.final
class CheckModelAdminRequest(google.protobuf.message.Message):
    """CheckModelAdminRequest represents a private request to query
    a model current state and longrunning progress
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_PERMALINK_FIELD_NUMBER: builtins.int
    model_permalink: builtins.str
    """Permalink of a model. For example:
    "models/{uid}"
    """
    def __init__(
        self,
        *,
        model_permalink: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_permalink", b"model_permalink"]) -> None: ...

global___CheckModelAdminRequest = CheckModelAdminRequest

@typing_extensions.final
class CheckModelAdminResponse(google.protobuf.message.Message):
    """CheckModelAdminResponse represents a response to fetch a model's
    current state and longrunning progress
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATE_FIELD_NUMBER: builtins.int
    state: global___Model.State.ValueType
    """Retrieved model state"""
    def __init__(
        self,
        *,
        state: global___Model.State.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state"]) -> None: ...

global___CheckModelAdminResponse = CheckModelAdminResponse

@typing_extensions.final
class DeployModelAdminRequest(google.protobuf.message.Message):
    """DeployModelAdminRequest represents a request to deploy a model to online state"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_PERMALINK_FIELD_NUMBER: builtins.int
    model_permalink: builtins.str
    """Permalink for the model to be deployed.
    Format: "models/{uid}"
    """
    def __init__(
        self,
        *,
        model_permalink: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_permalink", b"model_permalink"]) -> None: ...

global___DeployModelAdminRequest = DeployModelAdminRequest

@typing_extensions.final
class DeployModelAdminResponse(google.protobuf.message.Message):
    """DeployModelAdminResponse represents a response for a deployed model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Deploy operation message"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___DeployModelAdminResponse = DeployModelAdminResponse

@typing_extensions.final
class UndeployModelAdminRequest(google.protobuf.message.Message):
    """UndeployModelAdminRequest represents a request to undeploy a model to offline
    state
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_PERMALINK_FIELD_NUMBER: builtins.int
    model_permalink: builtins.str
    """Permalink for the model to be undeployed.
    Format: "models/{uid}"
    """
    def __init__(
        self,
        *,
        model_permalink: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_permalink", b"model_permalink"]) -> None: ...

global___UndeployModelAdminRequest = UndeployModelAdminRequest

@typing_extensions.final
class UndeployModelAdminResponse(google.protobuf.message.Message):
    """UndeployModelAdminResponse represents a response for a undeployed model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_FIELD_NUMBER: builtins.int
    @property
    def operation(self) -> google.longrunning.operations_pb2.Operation:
        """Undeploy operation message"""
    def __init__(
        self,
        *,
        operation: google.longrunning.operations_pb2.Operation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation", b"operation"]) -> None: ...

global___UndeployModelAdminResponse = UndeployModelAdminResponse
