"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import sys
import typing
import vdp.connector.v1alpha.spec_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _View:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_View.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    VIEW_UNSPECIFIED: _View.ValueType  # 0
    """View: UNSPECIFIED"""
    VIEW_BASIC: _View.ValueType  # 1
    """View: BASIC"""
    VIEW_FULL: _View.ValueType  # 2
    """View: FULL"""
    VIEW_CONFIGURATION: _View.ValueType  # 3
    """View: CONFIGURATION"""

class View(_View, metaclass=_ViewEnumTypeWrapper):
    """View enumerates the definition views"""

VIEW_UNSPECIFIED: View.ValueType  # 0
"""View: UNSPECIFIED"""
VIEW_BASIC: View.ValueType  # 1
"""View: BASIC"""
VIEW_FULL: View.ValueType  # 2
"""View: FULL"""
VIEW_CONFIGURATION: View.ValueType  # 3
"""View: CONFIGURATION"""
global___View = View

class _ConnectorType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ConnectorTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ConnectorType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CONNECTOR_TYPE_UNSPECIFIED: _ConnectorType.ValueType  # 0
    """ConnectorType: UNSPECIFIED"""
    CONNECTOR_TYPE_SOURCE: _ConnectorType.ValueType  # 1
    """ConnectorType: SOURCE"""
    CONNECTOR_TYPE_DESTINATION: _ConnectorType.ValueType  # 2
    """ConnectorType: DESTINATION"""
    CONNECTOR_TYPE_AI: _ConnectorType.ValueType  # 3
    """ConnectorType: AI"""
    CONNECTOR_TYPE_BLOCKCHAIN: _ConnectorType.ValueType  # 4
    """ConnectorType: Blockchain"""
    CONNECTOR_TYPE_DATA: _ConnectorType.ValueType  # 5
    """ConnectorType: DATA"""
    CONNECTOR_TYPE_OPERATOR: _ConnectorType.ValueType  # 6
    """ConnectorType: OPERATOR"""

class ConnectorType(_ConnectorType, metaclass=_ConnectorTypeEnumTypeWrapper):
    """////////////////////////////////////////////////////////////////////////

    ConnectorType enumerates connector types
    """

CONNECTOR_TYPE_UNSPECIFIED: ConnectorType.ValueType  # 0
"""ConnectorType: UNSPECIFIED"""
CONNECTOR_TYPE_SOURCE: ConnectorType.ValueType  # 1
"""ConnectorType: SOURCE"""
CONNECTOR_TYPE_DESTINATION: ConnectorType.ValueType  # 2
"""ConnectorType: DESTINATION"""
CONNECTOR_TYPE_AI: ConnectorType.ValueType  # 3
"""ConnectorType: AI"""
CONNECTOR_TYPE_BLOCKCHAIN: ConnectorType.ValueType  # 4
"""ConnectorType: Blockchain"""
CONNECTOR_TYPE_DATA: ConnectorType.ValueType  # 5
"""ConnectorType: DATA"""
CONNECTOR_TYPE_OPERATOR: ConnectorType.ValueType  # 6
"""ConnectorType: OPERATOR"""
global___ConnectorType = ConnectorType

@typing_extensions.final
class ConnectorDefinition(google.protobuf.message.Message):
    """ConnectorDefinition represents the connector definition data model"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DOCUMENTATION_URL_FIELD_NUMBER: builtins.int
    ICON_FIELD_NUMBER: builtins.int
    SPEC_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    TOMBSTONE_FIELD_NUMBER: builtins.int
    PUBLIC_FIELD_NUMBER: builtins.int
    CUSTOM_FIELD_NUMBER: builtins.int
    ICON_URL_FIELD_NUMBER: builtins.int
    VENDOR_FIELD_NUMBER: builtins.int
    VENDOR_ATTRIBUTES_FIELD_NUMBER: builtins.int
    name: builtins.str
    """ConnectorDefinition resource name. It must have the format of
    "connector-definitions/*"
    """
    uid: builtins.str
    """ConnectorDefinition UUID"""
    id: builtins.str
    """ConnectorDefinition resource ID (the last segment of the
    resource name) used to construct the resource name. This conforms to
    RFC-1034, which restricts to letters, numbers, and hyphen, with the first
    character a letter, the last a letter or a number, and a 63 character
    maximum.
    """
    title: builtins.str
    """ConnectorDefinition title"""
    documentation_url: builtins.str
    """ConnectorDefinition documentation URL"""
    icon: builtins.str
    """ConnectorDefinition icon"""
    @property
    def spec(self) -> vdp.connector.v1alpha.spec_pb2.Spec:
        """ConnectorDefinition spec"""
    type: global___ConnectorType.ValueType
    """Connector Type"""
    tombstone: builtins.bool
    """ConnectorDefinition tombstone, i.e., if not set or false, the
    configuration is active, or otherwise, if true, this configuration is
    permanently off
    """
    public: builtins.bool
    """ConnectorDefinition public flag, i.e., true if this connector
    definition is available to all workspaces
    """
    custom: builtins.bool
    """ConnectorDefinition custom flag, i.e., whether this is a custom
    connector definition
    """
    icon_url: builtins.str
    """ConnectorDefinition iconUrl"""
    vendor: builtins.str
    """ConnectorDefinition vendor name"""
    @property
    def vendor_attributes(self) -> google.protobuf.struct_pb2.Struct:
        """ConnectorDefinition vendorAttributes, i.e. the vendor-specific attributes"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        title: builtins.str = ...,
        documentation_url: builtins.str = ...,
        icon: builtins.str = ...,
        spec: vdp.connector.v1alpha.spec_pb2.Spec | None = ...,
        type: global___ConnectorType.ValueType = ...,
        tombstone: builtins.bool = ...,
        public: builtins.bool = ...,
        custom: builtins.bool = ...,
        icon_url: builtins.str = ...,
        vendor: builtins.str = ...,
        vendor_attributes: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["spec", b"spec", "vendor_attributes", b"vendor_attributes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["custom", b"custom", "documentation_url", b"documentation_url", "icon", b"icon", "icon_url", b"icon_url", "id", b"id", "name", b"name", "public", b"public", "spec", b"spec", "title", b"title", "tombstone", b"tombstone", "type", b"type", "uid", b"uid", "vendor", b"vendor", "vendor_attributes", b"vendor_attributes"]) -> None: ...

global___ConnectorDefinition = ConnectorDefinition

@typing_extensions.final
class ListConnectorDefinitionsRequest(google.protobuf.message.Message):
    """/////////////////////////////////////////////////////////////////////
    RPC messages
    /////////////////////////////////////////////////////////////////////

    ListConnectorDefinitionsRequest represents a request to list
    ConnectorDefinitions
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of ConnectorDefinitions to return. The
    service may return fewer than this value. If unspecified, at most 10
    ConnectorDefinitions will be returned. The maximum value is 100;
    values above 100 will be coerced to 100.
    """
    page_token: builtins.str
    """Page token"""
    view: global___View.ValueType
    """Definition view (default is DEFINITION_VIEW_BASIC)"""
    filter: builtins.str
    """Filter expression to list connector definitions"""
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___View.ValueType | None = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListConnectorDefinitionsRequest = ListConnectorDefinitionsRequest

@typing_extensions.final
class ListConnectorDefinitionsResponse(google.protobuf.message.Message):
    """ListConnectorDefinitionsResponse represents a response for a list
    of ConnectorDefinitions
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_DEFINITIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def connector_definitions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConnectorDefinition]:
        """A list of ConnectorDefinition resources"""
    next_page_token: builtins.str
    """Next page token"""
    total_size: builtins.int
    """Total count of ConnectorDefinition resources"""
    def __init__(
        self,
        *,
        connector_definitions: collections.abc.Iterable[global___ConnectorDefinition] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector_definitions", b"connector_definitions", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListConnectorDefinitionsResponse = ListConnectorDefinitionsResponse

@typing_extensions.final
class GetConnectorDefinitionRequest(google.protobuf.message.Message):
    """GetConnectorDefinitionRequest represents a request to query a
    ConnectorDefinition resource
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """ConnectorDefinition resource name. It must have the format of
    "connector-definitions/*"
    """
    view: global___View.ValueType
    """ConnectorDefinition resource view (default is
    DEFINITION_VIEW_BASIC)
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetConnectorDefinitionRequest = GetConnectorDefinitionRequest

@typing_extensions.final
class GetConnectorDefinitionResponse(google.protobuf.message.Message):
    """GetConnectorDefinitionResponse represents a
    ConnectorDefinition response
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_DEFINITION_FIELD_NUMBER: builtins.int
    @property
    def connector_definition(self) -> global___ConnectorDefinition:
        """A ConnectorDefinition resource"""
    def __init__(
        self,
        *,
        connector_definition: global___ConnectorDefinition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector_definition", b"connector_definition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector_definition", b"connector_definition"]) -> None: ...

global___GetConnectorDefinitionResponse = GetConnectorDefinitionResponse

@typing_extensions.final
class LookUpConnectorDefinitionAdminRequest(google.protobuf.message.Message):
    """LookUpConnectorDefinitionAdminRequest represents a request to query a
    connectorDefinition via permalink by admin
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """Permalink of a connector. For example:
    "connector-definitions/{uid}"
    """
    view: global___View.ValueType
    """Connector view (default is VIEW_BASIC)"""
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: global___View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpConnectorDefinitionAdminRequest = LookUpConnectorDefinitionAdminRequest

@typing_extensions.final
class LookUpConnectorDefinitionAdminResponse(google.protobuf.message.Message):
    """LookUpConnectorDefinitionAdminResponse represents a response for a
    connector definition
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_DEFINITION_FIELD_NUMBER: builtins.int
    @property
    def connector_definition(self) -> global___ConnectorDefinition:
        """Connector resource"""
    def __init__(
        self,
        *,
        connector_definition: global___ConnectorDefinition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector_definition", b"connector_definition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector_definition", b"connector_definition"]) -> None: ...

global___LookUpConnectorDefinitionAdminResponse = LookUpConnectorDefinitionAdminResponse
