from windchill_metric_config.description import Description


class GarbageCollector:
    def __init__(self):
        self.gc_threshold = Description(
            metric_id='windchill_server_status_gc_time_spent_in_threshold_percent',
            desc='Garbage collection time spent in threshold percent'
        )
        self.gc_recent = Description(
            metric_id='windchill_server_status_gc_recent_time_spent_percent',
            desc='Garbage collection time spent recent percent'
        )
        self.gc_overall = Description(
            metric_id='windchill_server_status_gc_overall_time_spent_percent',
            desc='Garbage collection time spent overall percent'
        )

    def as_dict(self):
        all_metrics = {}
        for item in self.__dict__.keys():
            all_metrics[item] = self.__getattribute__(item).as_dict()
        return all_metrics

    def as_yaml_dict(self):
        metrics = {}
        for item in self.__dict__.keys():
            child = self.__getattribute__(item)
            if type(child) == Description:
                metrics[child.id] = child.enabled
            else:
                metrics[item] = child.as_yaml_dict()
        return metrics

    def generate_yaml(self, yaml_object, comment_indent):
        for item in self.__dict__.keys():
            child = self.__getattribute__(item)
            if type(child) == Description:
                yaml_object.yaml_add_eol_comment(child.description, child.id,
                                                 comment_indent)
            else:
                child.generate_yaml(yaml_object[item], comment_indent)

    def metrics_as_list(self, metric_list: list):
        for item in self.__dict__.keys():
            child = self.__getattribute__(item)
            if type(child) == Description:
                metric_list.append(child)
            else:
                child.metrics_as_list(metric_list)

    def set_config(self, config: dict):
        for key in config:
            for item in self.__dict__.keys():
                child = self.__getattribute__(item)
                if type(child) == Description:
                    if child.id == key:
                        child.enabled = config[key]

                else:
                    if item == key:
                        child.set_config(config[key])
