# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.analysis_config import AnalysisConfig
from revengai.models.analysis_scope import AnalysisScope
from revengai.models.binary_config import BinaryConfig
from revengai.models.symbols import Symbols
from revengai.models.tag import Tag
from typing import Optional, Set
from typing_extensions import Self

class AnalysisCreateRequest(BaseModel):
    """
    AnalysisCreateRequest
    """ # noqa: E501
    filename: StrictStr = Field(description="The name of the file")
    sha_256_hash: StrictStr = Field(description="The name of the file")
    tags: Optional[List[Tag]] = Field(default=None, description="List of community tags to assign to an analysis")
    analysis_scope: Optional[AnalysisScope] = Field(default=None, description="The scope of the analysis determines who can access it")
    symbols: Optional[Symbols] = None
    debug_hash: Optional[StrictStr] = None
    analysis_config: Optional[AnalysisConfig] = Field(default=None, description="The analysis config enables the configuration of optional analysis stages")
    binary_config: Optional[BinaryConfig] = Field(default=None, description="The binary config can override automatically determined values such as ISA, Platform, File Format, etc")
    __properties: ClassVar[List[str]] = ["filename", "sha_256_hash", "tags", "analysis_scope", "symbols", "debug_hash", "analysis_config", "binary_config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnalysisCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of symbols
        if self.symbols:
            _dict['symbols'] = self.symbols.to_dict()
        # override the default output from pydantic by calling `to_dict()` of analysis_config
        if self.analysis_config:
            _dict['analysis_config'] = self.analysis_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of binary_config
        if self.binary_config:
            _dict['binary_config'] = self.binary_config.to_dict()
        # set to None if symbols (nullable) is None
        # and model_fields_set contains the field
        if self.symbols is None and "symbols" in self.model_fields_set:
            _dict['symbols'] = None

        # set to None if debug_hash (nullable) is None
        # and model_fields_set contains the field
        if self.debug_hash is None and "debug_hash" in self.model_fields_set:
            _dict['debug_hash'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnalysisCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "filename": obj.get("filename"),
            "sha_256_hash": obj.get("sha_256_hash"),
            "tags": [Tag.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "analysis_scope": obj.get("analysis_scope"),
            "symbols": Symbols.from_dict(obj["symbols"]) if obj.get("symbols") is not None else None,
            "debug_hash": obj.get("debug_hash"),
            "analysis_config": AnalysisConfig.from_dict(obj["analysis_config"]) if obj.get("analysis_config") is not None else None,
            "binary_config": BinaryConfig.from_dict(obj["binary_config"]) if obj.get("binary_config") is not None else None
        })
        return _obj


