# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.app_api_rest_v2_analyses_enums_dynamic_execution_status import AppApiRestV2AnalysesEnumsDynamicExecutionStatus
from typing import Optional, Set
from typing_extensions import Self

class AnalysisRecord(BaseModel):
    """
    AnalysisRecord
    """ # noqa: E501
    analysis_id: StrictInt = Field(description="ID to identify analysis")
    analysis_scope: StrictStr = Field(description="Scope of the analysis")
    binary_id: StrictInt = Field(description="ID to identify the binary analyse")
    model_id: StrictInt = Field(description="ID to identify the model used for analysis")
    model_name: StrictStr = Field(description="Name of the model used for analysis")
    status: StrictStr = Field(description="The current status of analysis")
    creation: datetime = Field(description="The current status of analysis")
    is_owner: StrictBool = Field(description="Whether the current user is the owner of a binary")
    binary_name: StrictStr = Field(description="The name of the file uploaded")
    sha_256_hash: StrictStr = Field(description="The hash of the binary")
    function_boundaries_hash: StrictStr = Field(description="The hash of the function boundaries")
    binary_size: StrictInt = Field(description="The size of the binary")
    username: StrictStr = Field(description="The username of the analysis owner")
    dynamic_execution_status: Optional[AppApiRestV2AnalysesEnumsDynamicExecutionStatus] = None
    dynamic_execution_task_id: Optional[StrictInt] = None
    base_address: StrictInt = Field(description="The base address of the binary")
    __properties: ClassVar[List[str]] = ["analysis_id", "analysis_scope", "binary_id", "model_id", "model_name", "status", "creation", "is_owner", "binary_name", "sha_256_hash", "function_boundaries_hash", "binary_size", "username", "dynamic_execution_status", "dynamic_execution_task_id", "base_address"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnalysisRecord from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if dynamic_execution_status (nullable) is None
        # and model_fields_set contains the field
        if self.dynamic_execution_status is None and "dynamic_execution_status" in self.model_fields_set:
            _dict['dynamic_execution_status'] = None

        # set to None if dynamic_execution_task_id (nullable) is None
        # and model_fields_set contains the field
        if self.dynamic_execution_task_id is None and "dynamic_execution_task_id" in self.model_fields_set:
            _dict['dynamic_execution_task_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnalysisRecord from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "analysis_id": obj.get("analysis_id"),
            "analysis_scope": obj.get("analysis_scope"),
            "binary_id": obj.get("binary_id"),
            "model_id": obj.get("model_id"),
            "model_name": obj.get("model_name"),
            "status": obj.get("status"),
            "creation": obj.get("creation"),
            "is_owner": obj.get("is_owner"),
            "binary_name": obj.get("binary_name"),
            "sha_256_hash": obj.get("sha_256_hash"),
            "function_boundaries_hash": obj.get("function_boundaries_hash"),
            "binary_size": obj.get("binary_size"),
            "username": obj.get("username"),
            "dynamic_execution_status": obj.get("dynamic_execution_status"),
            "dynamic_execution_task_id": obj.get("dynamic_execution_task_id"),
            "base_address": obj.get("base_address")
        })
        return _obj


