# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class BoxPlotConfidence(BaseModel):
    """
    Format for confidence - returned in the box plot format
    """ # noqa: E501
    min: Union[StrictFloat, StrictInt]
    max: Union[StrictFloat, StrictInt]
    average: Union[StrictFloat, StrictInt]
    upper_quartile: Union[StrictFloat, StrictInt]
    lower_quartile: Union[StrictFloat, StrictInt]
    positive_count: StrictInt
    negative_count: StrictInt
    __properties: ClassVar[List[str]] = ["min", "max", "average", "upper_quartile", "lower_quartile", "positive_count", "negative_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BoxPlotConfidence from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BoxPlotConfidence from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "min": obj.get("min"),
            "max": obj.get("max"),
            "average": obj.get("average"),
            "upper_quartile": obj.get("upper_quartile"),
            "lower_quartile": obj.get("lower_quartile"),
            "positive_count": obj.get("positive_count"),
            "negative_count": obj.get("negative_count")
        })
        return _obj


