# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CollectionSearchResult(BaseModel):
    """
    CollectionSearchResult
    """ # noqa: E501
    collection_id: StrictInt = Field(description="The ID of the collection")
    collection_name: StrictStr = Field(description="The name of the collection")
    scope: StrictStr = Field(description="The scope of the collection")
    last_updated_at: datetime = Field(description="The last update date of the collection")
    created_at: datetime = Field(description="The creation date of the collection")
    model_id: StrictInt = Field(description="The model ID of the binary")
    model_name: StrictStr = Field(description="The name of the model")
    owned_by: StrictStr = Field(description="The owner of the collection")
    tags: Optional[List[StrictStr]] = None
    size: Optional[StrictInt] = None
    description: StrictStr = Field(description="The description of the collection")
    team_id: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["collection_id", "collection_name", "scope", "last_updated_at", "created_at", "model_id", "model_name", "owned_by", "tags", "size", "description", "team_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CollectionSearchResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if size (nullable) is None
        # and model_fields_set contains the field
        if self.size is None and "size" in self.model_fields_set:
            _dict['size'] = None

        # set to None if team_id (nullable) is None
        # and model_fields_set contains the field
        if self.team_id is None and "team_id" in self.model_fields_set:
            _dict['team_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CollectionSearchResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "collection_id": obj.get("collection_id"),
            "collection_name": obj.get("collection_name"),
            "scope": obj.get("scope"),
            "last_updated_at": obj.get("last_updated_at"),
            "created_at": obj.get("created_at"),
            "model_id": obj.get("model_id"),
            "model_name": obj.get("model_name"),
            "owned_by": obj.get("owned_by"),
            "tags": obj.get("tags"),
            "size": obj.get("size"),
            "description": obj.get("description"),
            "team_id": obj.get("team_id")
        })
        return _obj


