# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.function_mapping_full import FunctionMappingFull
from revengai.models.inverse_function_map_item import InverseFunctionMapItem
from typing import Optional, Set
from typing_extensions import Self

class GetAiDecompilationTask(BaseModel):
    """
    GetAiDecompilationTask
    """ # noqa: E501
    status: StrictStr
    decompilation: Optional[StrictStr]
    raw_decompilation: Optional[StrictStr]
    function_mapping: Optional[Dict[str, InverseFunctionMapItem]]
    function_mapping_full: Optional[FunctionMappingFull]
    summary: Optional[StrictStr] = None
    ai_summary: Optional[StrictStr] = None
    raw_ai_summary: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["status", "decompilation", "raw_decompilation", "function_mapping", "function_mapping_full", "summary", "ai_summary", "raw_ai_summary"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetAiDecompilationTask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in function_mapping (dict)
        _field_dict = {}
        if self.function_mapping:
            for _key_function_mapping in self.function_mapping:
                if self.function_mapping[_key_function_mapping]:
                    _field_dict[_key_function_mapping] = self.function_mapping[_key_function_mapping].to_dict()
            _dict['function_mapping'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of function_mapping_full
        if self.function_mapping_full:
            _dict['function_mapping_full'] = self.function_mapping_full.to_dict()
        # set to None if decompilation (nullable) is None
        # and model_fields_set contains the field
        if self.decompilation is None and "decompilation" in self.model_fields_set:
            _dict['decompilation'] = None

        # set to None if raw_decompilation (nullable) is None
        # and model_fields_set contains the field
        if self.raw_decompilation is None and "raw_decompilation" in self.model_fields_set:
            _dict['raw_decompilation'] = None

        # set to None if function_mapping (nullable) is None
        # and model_fields_set contains the field
        if self.function_mapping is None and "function_mapping" in self.model_fields_set:
            _dict['function_mapping'] = None

        # set to None if function_mapping_full (nullable) is None
        # and model_fields_set contains the field
        if self.function_mapping_full is None and "function_mapping_full" in self.model_fields_set:
            _dict['function_mapping_full'] = None

        # set to None if summary (nullable) is None
        # and model_fields_set contains the field
        if self.summary is None and "summary" in self.model_fields_set:
            _dict['summary'] = None

        # set to None if ai_summary (nullable) is None
        # and model_fields_set contains the field
        if self.ai_summary is None and "ai_summary" in self.model_fields_set:
            _dict['ai_summary'] = None

        # set to None if raw_ai_summary (nullable) is None
        # and model_fields_set contains the field
        if self.raw_ai_summary is None and "raw_ai_summary" in self.model_fields_set:
            _dict['raw_ai_summary'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetAiDecompilationTask from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "decompilation": obj.get("decompilation"),
            "raw_decompilation": obj.get("raw_decompilation"),
            "function_mapping": dict(
                (_k, InverseFunctionMapItem.from_dict(_v))
                for _k, _v in obj["function_mapping"].items()
            )
            if obj.get("function_mapping") is not None
            else None,
            "function_mapping_full": FunctionMappingFull.from_dict(obj["function_mapping_full"]) if obj.get("function_mapping_full") is not None else None,
            "summary": obj.get("summary"),
            "ai_summary": obj.get("ai_summary"),
            "raw_ai_summary": obj.get("raw_ai_summary")
        })
        return _obj


