from datetime import datetime
from typing import (Any, Dict, Iterable, List, Mapping, MutableMapping,
                    Optional, Union)


class Image:
    created_at: datetime
    image_id: Optional[str]
    permalink_url: Optional[str]
    thumb_url = str
    type = str
    url = Optional[str]

    def __init__(self, **kwargs: Any) -> None: ...  # TODO
    @staticmethod
    def from_dict(data: MutableMapping[str, Any]) -> Image: ...
    def __str__(self) -> str: ...
    def __unicode__(self) -> Any: ...  # TODO
    def __or__(self, other: Image) -> Image: ...
    @property
    def filename(self) -> Optional[str]: ...
    @property
    def thumb_filename(self) -> str: ...
    @property
    def local_created_at(self) -> datetime: ...
    def to_json(self, indent: Optional[Union[int, str]] = ..., sort_keys: bool = ...) -> str: ...
    def to_dict(self) -> Dict[str, Any]: ...
    def download(self) -> Optional[bytes]: ...
    def download_thumb(self) -> bytes: ...

class ImageList(Iterable[Image]):
    total_count: Optional[int]
    current_page: Optional[int]
    per_page: Optional[int]
    user_type: Optional[str]
    images: List[Image]

    def __init__(self, **kwargs: Any) -> None: ...  # TODO
    def __len__(self) -> int: ...
    def __getitem__(self, key: int) -> Image: ...
    def __setitem__(self, key: int, value: Image) -> None: ...
    def __delitem__(self, key: int) -> None: ...
    def __add__(self, other: ImageList) -> ImageList: ...
    @property
    def num_pages(self) -> int: ...
    def has_next_page(self) -> bool: ...
    def has_previous_page(self) -> bool: ...
    def set_attributes_from_headers(self, headers: Mapping[str, str]) -> None: ...
    def to_json(self, indent: Optional[Union[int, str]] = ..., sort_keys: bool = ...) -> str: ...
    @staticmethod
    def from_list(data: Iterable[Mapping[str, Any]]) -> ImageList: ...
