"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Activate = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [activate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsactivate.html).
 *
 * @experimental
 */
class Activate extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [activate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsactivate.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'activate';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "CreateForm",
                "PutMemberInfo"
            ],
            "Read": [
                "GetAccountContact",
                "GetContentInfo",
                "GetCosts",
                "GetCredits",
                "GetMemberInfo",
                "GetProgram"
            ]
        };
    }
    /**
     * (experimental) Grants permission to submit an Activate application form.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateForm() {
        this.to('activate:CreateForm');
        return this;
    }
    /**
     * (experimental) Grants permission to get the AWS account contact information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetAccountContact() {
        this.to('activate:GetAccountContact');
        return this;
    }
    /**
     * (experimental) Grants permission to get Activate tech posts and offer information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetContentInfo() {
        this.to('activate:GetContentInfo');
        return this;
    }
    /**
     * (experimental) Grants permission to get the AWS cost information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetCosts() {
        this.to('activate:GetCosts');
        return this;
    }
    /**
     * (experimental) Grants permission to get the AWS credit information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetCredits() {
        this.to('activate:GetCredits');
        return this;
    }
    /**
     * (experimental) Grants permission to get the Activate member information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetMemberInfo() {
        this.to('activate:GetMemberInfo');
        return this;
    }
    /**
     * (experimental) Grants permission to get an Activate program.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetProgram() {
        this.to('activate:GetProgram');
        return this;
    }
    /**
     * (experimental) Grants permission to create or update the Activate member information.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toPutMemberInfo() {
        this.to('activate:PutMemberInfo');
        return this;
    }
}
exports.Activate = Activate;
//# sourceMappingURL=data:application/json;base64,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