"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoscalingPlans = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [autoscaling-plans](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsautoscaling.html).
 *
 * @experimental
 */
class AutoscalingPlans extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [autoscaling-plans](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsautoscaling.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'autoscaling-plans';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "CreateScalingPlan",
                "DeleteScalingPlan",
                "UpdateScalingPlan"
            ],
            "Read": [
                "DescribeScalingPlanResources",
                "DescribeScalingPlans",
                "GetScalingPlanResourceForecastData"
            ]
        };
    }
    /**
     * (experimental) Creates a scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CreateScalingPlan.html
     *
     * @experimental
     */
    toCreateScalingPlan() {
        this.to('autoscaling-plans:CreateScalingPlan');
        return this;
    }
    /**
     * (experimental) Deletes the specified scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DeleteScalingPlan.html
     *
     * @experimental
     */
    toDeleteScalingPlan() {
        this.to('autoscaling-plans:DeleteScalingPlan');
        return this;
    }
    /**
     * (experimental) Describes the scalable resources in the specified scaling plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlanResources.html
     *
     * @experimental
     */
    toDescribeScalingPlanResources() {
        this.to('autoscaling-plans:DescribeScalingPlanResources');
        return this;
    }
    /**
     * (experimental) Describes the specified scaling plans or all of your scaling plans.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_DescribeScalingPlans.html
     *
     * @experimental
     */
    toDescribeScalingPlans() {
        this.to('autoscaling-plans:DescribeScalingPlans');
        return this;
    }
    /**
     * (experimental) Retrieves the forecast data for a scalable resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_GetScalingPlanResourceForecastData.html
     *
     * @experimental
     */
    toGetScalingPlanResourceForecastData() {
        this.to('autoscaling-plans:GetScalingPlanResourceForecastData');
        return this;
    }
    /**
     * (experimental) Updates a scaling plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_UpdateScalingPlan.html
     *
     * @experimental
     */
    toUpdateScalingPlan() {
        this.to('autoscaling-plans:UpdateScalingPlan');
        return this;
    }
}
exports.AutoscalingPlans = AutoscalingPlans;
//# sourceMappingURL=data:application/json;base64,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