#!/usr/bin/env python
"""
Copyright 2012 GroupDocs.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from .models import *
from groupdocs.FileStream import FileStream
from groupdocs.ApiClient import ApiException

class SystemApi(object):

    def __init__(self, apiClient):
        self.apiClient = apiClient
        self.__basePath = "https://api.groupdocs.com/v2.0"

    @property
    def basePath(self):
        return self.__basePath
    
    @basePath.setter
    def basePath(self, value):
        self.__basePath = value

    
    def SimulateAssessForPricingPlan(self, userId, discountCode, planId, **kwargs):
        """Simulate Assess For Pricing Plan

        Args:
            userId, str: User GUID (required)
            discountCode, str: Discount Code (optional)
            planId, str: Subscription Plan Id (optional)
            
        Returns: GetInvoicesResponse
        """
        if( userId == None or discountCode == None or planId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'discountCode', 'planId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SimulateAssessForPricingPlan" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{userId}/plans/{planId}/discounts/{discountCode}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('discountCode' in params):
            replacement = str(self.apiClient.toPathValue(params['discountCode']))
            resourcePath = resourcePath.replace('{' + 'discountCode' + '}',
                                                replacement)
        if ('planId' in params):
            replacement = str(self.apiClient.toPathValue(params['planId']))
            resourcePath = resourcePath.replace('{' + 'planId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetInvoicesResponse')
        return responseObject
        
        
    def SimulateAssessForPaymentPlan(self, userId, discountCode, paymentPlanId, **kwargs):
        """Simulate Assess For Payment Plan

        Args:
            userId, str: User GUID (required)
            discountCode, str: Discount Code (optional)
            paymentPlanId, str: Payment PlanId on the payment service (optional)
            
        Returns: GetInvoicesResponse
        """
        if( userId == None or discountCode == None or paymentPlanId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'discountCode', 'paymentPlanId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SimulateAssessForPaymentPlan" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{userId}/paymentPlans/{paymentPlanId}/discounts/{discountCode}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('discountCode' in params):
            replacement = str(self.apiClient.toPathValue(params['discountCode']))
            resourcePath = resourcePath.replace('{' + 'discountCode' + '}',
                                                replacement)
        if ('paymentPlanId' in params):
            replacement = str(self.apiClient.toPathValue(params['paymentPlanId']))
            resourcePath = resourcePath.replace('{' + 'paymentPlanId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetInvoicesResponse')
        return responseObject
        
        
    def GetUserPlan(self, callerId, **kwargs):
        """Get user plan

        Args:
            callerId, str: User GUID (required)
            
        Returns: GetPlanResponse
        """
        if( callerId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['callerId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetUserPlan" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{callerId}/plan'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetPlanResponse')
        return responseObject
        
        
    def GetUserSubscriptionPlan(self, callerId, **kwargs):
        """Get user plan

        Args:
            callerId, str: User GUID (required)
            
        Returns: GetUserSubscriptionPlanResponse
        """
        if( callerId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['callerId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetUserSubscriptionPlan" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{callerId}/subscription'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetUserSubscriptionPlanResponse')
        return responseObject
        
        
    def GetSubscriptionPlans(self, callerId, family, **kwargs):
        """Get subscription plans

        Args:
            callerId, str: User GUID (required)
            family, str: Product Family Name (required)
            
        Returns: GetSubscriptionPlansResponse
        """
        if( callerId == None or family == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['callerId', 'family']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSubscriptionPlans" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{callerId}/plans/{family}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('family' in params):
            replacement = str(self.apiClient.toPathValue(params['family']))
            resourcePath = resourcePath.replace('{' + 'family' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetSubscriptionPlansResponse')
        return responseObject
        
        
    def SetSubscriptionPlan(self, userId, productId, body, **kwargs):
        """Set subscription plan user plan

        Args:
            userId, str: User GUID (required)
            productId, str: Product ID (required)
            body, SubscriptionPlanInfo: Subscription Plan (required)
            
        Returns: SetUserSubscriptionPlanResponse
        """
        if( userId == None or productId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'productId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SetSubscriptionPlan" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{userId}/subscriptions/{productId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('productId' in params):
            replacement = str(self.apiClient.toPathValue(params['productId']))
            resourcePath = resourcePath.replace('{' + 'productId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SetUserSubscriptionPlanResponse')
        return responseObject
        
        
    def UpdateSubscriptionPlan(self, userId, productId, body, **kwargs):
        """Update subscription plan user plan

        Args:
            userId, str: User GUID (required)
            productId, str: Product ID (required)
            body, UpdateSubscriptionPlanInfo: Subscripition Plan Update parameters (required)
            
        Returns: SetUserSubscriptionPlanResponse
        """
        if( userId == None or productId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'productId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateSubscriptionPlan" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{userId}/subscriptions/{productId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('productId' in params):
            replacement = str(self.apiClient.toPathValue(params['productId']))
            resourcePath = resourcePath.replace('{' + 'productId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SetUserSubscriptionPlanResponse')
        return responseObject
        
        
    def GetCountries(self, callerId, **kwargs):
        """Get countries

        Args:
            callerId, str: User GUID (required)
            
        Returns: GetCountriesResponse
        """
        if( callerId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['callerId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetCountries" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{callerId}/countries'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetCountriesResponse')
        return responseObject
        
        
    def GetStates(self, callerId, countryName, **kwargs):
        """Get states

        Args:
            callerId, str: User GUID (required)
            countryName, str: Country Name (required)
            
        Returns: GetStatesResponse
        """
        if( callerId == None or countryName == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['callerId', 'countryName']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetStates" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{callerId}/countries/{countryName}/states'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        if ('countryName' in params):
            replacement = str(self.apiClient.toPathValue(params['countryName']))
            resourcePath = resourcePath.replace('{' + 'countryName' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetStatesResponse')
        return responseObject
        
        
    def SetBillingAddress(self, userId, body, **kwargs):
        """Set user billing address

        Args:
            userId, str: User GUID (required)
            body, BillingAddressInfo: Billing Address (required)
            
        Returns: GetBillingAddressResponse
        """
        if( userId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SetBillingAddress" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{userId}/billingaddress'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetBillingAddressResponse')
        return responseObject
        
        
    def SetCreditCard(self, userId, body, **kwargs):
        """Set user credit card

        Args:
            userId, str: User GUID (required)
            body, CreditCardInfo: Credit Card (required)
            
        Returns: GetCreditCardResponse
        """
        if( userId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SetCreditCard" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{userId}/creditcard'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetCreditCardResponse')
        return responseObject
        
        
    def GetCreditCard(self, userId, **kwargs):
        """Get user credit card

        Args:
            userId, str: User GUID (required)
            
        Returns: GetCreditCardResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetCreditCard" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{userId}/creditcard'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetCreditCardResponse')
        return responseObject
        
        
    def GetInvoices(self, callerId, **kwargs):
        """Get invoices

        Args:
            callerId, str: User GUID (required)
            pageNumber, str: Show records for page number (optional)
            pageSize, int: Show records count (optional)
            
        Returns: GetInvoicesResponse
        """
        if( callerId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['callerId', 'pageNumber', 'pageSize']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetInvoices" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{callerId}/invoices?pageNumber={pageNumber}&pageSize={pageSize}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('pageNumber' in params):
            queryParams['pageNumber'] = self.apiClient.toPathValue(params['pageNumber'])
        if ('pageSize' in params):
            queryParams['pageSize'] = self.apiClient.toPathValue(params['pageSize'])
        if ('callerId' in params):
            replacement = str(self.apiClient.toPathValue(params['callerId']))
            resourcePath = resourcePath.replace('{' + 'callerId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetInvoicesResponse')
        return responseObject
        
        
    def GetSubscriptionPlanUsage(self, userId, **kwargs):
        """Get subscription plans

        Args:
            userId, str: User GUID (required)
            
        Returns: GetSubscriptionPlanUsageResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSubscriptionPlanUsage" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{userId}/usage'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetSubscriptionPlanUsageResponse')
        return responseObject
        
        
    def GetPurchseWizardInfo(self, userId, **kwargs):
        """Returns purchase wizard info from billing provider

        Args:
            userId, str: User global unique identifier (required)
            
        Returns: GetPurchaseWizardResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetPurchseWizardInfo" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{userId}/purchase/wizard'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetPurchaseWizardResponse')
        return responseObject
        
        
    def GetTermSuggestions(self, userId, term, **kwargs):
        """Returns suggestions for a specified term

        Args:
            userId, str: User global unique identifier (required)
            term, str: A term to return suggestions for (required)
            
        Returns: GetTermSuggestionsResponse
        """
        if( userId == None or term == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'term']

        params = locals()
        for (key, val) in params['kwargs'].items():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetTermSuggestions" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/system/{userId}/terms/{term}/suggestions'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('term' in params):
            replacement = str(self.apiClient.toPathValue(params['term']))
            resourcePath = resourcePath.replace('{' + 'term' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetTermSuggestionsResponse')
        return responseObject
        
        
    


