# coding: utf-8

"""
    metal-api

    API to manage and control plane resources like machines, switches, operating system images, machine sizes, networks, IP addresses and more  # noqa: E501

    OpenAPI spec version: v0.41.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class V1NetworkResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'additional_announcable_cid_rs': 'list[str]',
        'changed': 'datetime',
        'consumption': 'V1NetworkConsumption',
        'created': 'datetime',
        'defaultchildprefixlength': 'dict(str, int)',
        'description': 'str',
        'destinationprefixes': 'list[str]',
        'id': 'str',
        'labels': 'dict(str, str)',
        'name': 'str',
        'nat': 'bool',
        'parentnetworkid': 'str',
        'partitionid': 'str',
        'prefixes': 'list[str]',
        'privatesuper': 'bool',
        'projectid': 'str',
        'shared': 'bool',
        'underlay': 'bool',
        'usage': 'V1NetworkUsage',
        'vrf': 'int',
        'vrfshared': 'bool'
    }

    attribute_map = {
        'additional_announcable_cid_rs': 'additionalAnnouncableCIDRs',
        'changed': 'changed',
        'consumption': 'consumption',
        'created': 'created',
        'defaultchildprefixlength': 'defaultchildprefixlength',
        'description': 'description',
        'destinationprefixes': 'destinationprefixes',
        'id': 'id',
        'labels': 'labels',
        'name': 'name',
        'nat': 'nat',
        'parentnetworkid': 'parentnetworkid',
        'partitionid': 'partitionid',
        'prefixes': 'prefixes',
        'privatesuper': 'privatesuper',
        'projectid': 'projectid',
        'shared': 'shared',
        'underlay': 'underlay',
        'usage': 'usage',
        'vrf': 'vrf',
        'vrfshared': 'vrfshared'
    }

    def __init__(self, additional_announcable_cid_rs=None, changed=None, consumption=None, created=None, defaultchildprefixlength=None, description=None, destinationprefixes=None, id=None, labels=None, name=None, nat=None, parentnetworkid=None, partitionid=None, prefixes=None, privatesuper=None, projectid=None, shared=None, underlay=None, usage=None, vrf=None, vrfshared=None):  # noqa: E501
        """V1NetworkResponse - a model defined in Swagger"""  # noqa: E501

        self._additional_announcable_cid_rs = None
        self._changed = None
        self._consumption = None
        self._created = None
        self._defaultchildprefixlength = None
        self._description = None
        self._destinationprefixes = None
        self._id = None
        self._labels = None
        self._name = None
        self._nat = None
        self._parentnetworkid = None
        self._partitionid = None
        self._prefixes = None
        self._privatesuper = None
        self._projectid = None
        self._shared = None
        self._underlay = None
        self._usage = None
        self._vrf = None
        self._vrfshared = None
        self.discriminator = None

        if additional_announcable_cid_rs is not None:
            self.additional_announcable_cid_rs = additional_announcable_cid_rs
        if changed is not None:
            self.changed = changed
        self.consumption = consumption
        if created is not None:
            self.created = created
        if defaultchildprefixlength is not None:
            self.defaultchildprefixlength = defaultchildprefixlength
        if description is not None:
            self.description = description
        self.destinationprefixes = destinationprefixes
        self.id = id
        if labels is not None:
            self.labels = labels
        if name is not None:
            self.name = name
        self.nat = nat
        if parentnetworkid is not None:
            self.parentnetworkid = parentnetworkid
        if partitionid is not None:
            self.partitionid = partitionid
        self.prefixes = prefixes
        self.privatesuper = privatesuper
        if projectid is not None:
            self.projectid = projectid
        if shared is not None:
            self.shared = shared
        self.underlay = underlay
        self.usage = usage
        if vrf is not None:
            self.vrf = vrf
        if vrfshared is not None:
            self.vrfshared = vrfshared

    @property
    def additional_announcable_cid_rs(self):
        """Gets the additional_announcable_cid_rs of this V1NetworkResponse.  # noqa: E501

        list of cidrs which are added to the route maps per tenant private network, these are typically pod- and service cidrs, can only be set for private super networks  # noqa: E501

        :return: The additional_announcable_cid_rs of this V1NetworkResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._additional_announcable_cid_rs

    @additional_announcable_cid_rs.setter
    def additional_announcable_cid_rs(self, additional_announcable_cid_rs):
        """Sets the additional_announcable_cid_rs of this V1NetworkResponse.

        list of cidrs which are added to the route maps per tenant private network, these are typically pod- and service cidrs, can only be set for private super networks  # noqa: E501

        :param additional_announcable_cid_rs: The additional_announcable_cid_rs of this V1NetworkResponse.  # noqa: E501
        :type: list[str]
        """

        self._additional_announcable_cid_rs = additional_announcable_cid_rs

    @property
    def changed(self):
        """Gets the changed of this V1NetworkResponse.  # noqa: E501

        the last changed timestamp of this entity  # noqa: E501

        :return: The changed of this V1NetworkResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._changed

    @changed.setter
    def changed(self, changed):
        """Sets the changed of this V1NetworkResponse.

        the last changed timestamp of this entity  # noqa: E501

        :param changed: The changed of this V1NetworkResponse.  # noqa: E501
        :type: datetime
        """

        self._changed = changed

    @property
    def consumption(self):
        """Gets the consumption of this V1NetworkResponse.  # noqa: E501

        consumption of ips and prefixes in this network  # noqa: E501

        :return: The consumption of this V1NetworkResponse.  # noqa: E501
        :rtype: V1NetworkConsumption
        """
        return self._consumption

    @consumption.setter
    def consumption(self, consumption):
        """Sets the consumption of this V1NetworkResponse.

        consumption of ips and prefixes in this network  # noqa: E501

        :param consumption: The consumption of this V1NetworkResponse.  # noqa: E501
        :type: V1NetworkConsumption
        """
        if consumption is None:
            raise ValueError("Invalid value for `consumption`, must not be `None`")  # noqa: E501

        self._consumption = consumption

    @property
    def created(self):
        """Gets the created of this V1NetworkResponse.  # noqa: E501

        the creation time of this entity  # noqa: E501

        :return: The created of this V1NetworkResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this V1NetworkResponse.

        the creation time of this entity  # noqa: E501

        :param created: The created of this V1NetworkResponse.  # noqa: E501
        :type: datetime
        """

        self._created = created

    @property
    def defaultchildprefixlength(self):
        """Gets the defaultchildprefixlength of this V1NetworkResponse.  # noqa: E501

        if privatesuper, this defines the bitlen of child prefixes per addressfamily if not nil  # noqa: E501

        :return: The defaultchildprefixlength of this V1NetworkResponse.  # noqa: E501
        :rtype: dict(str, int)
        """
        return self._defaultchildprefixlength

    @defaultchildprefixlength.setter
    def defaultchildprefixlength(self, defaultchildprefixlength):
        """Sets the defaultchildprefixlength of this V1NetworkResponse.

        if privatesuper, this defines the bitlen of child prefixes per addressfamily if not nil  # noqa: E501

        :param defaultchildprefixlength: The defaultchildprefixlength of this V1NetworkResponse.  # noqa: E501
        :type: dict(str, int)
        """

        self._defaultchildprefixlength = defaultchildprefixlength

    @property
    def description(self):
        """Gets the description of this V1NetworkResponse.  # noqa: E501

        a description for this entity  # noqa: E501

        :return: The description of this V1NetworkResponse.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this V1NetworkResponse.

        a description for this entity  # noqa: E501

        :param description: The description of this V1NetworkResponse.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def destinationprefixes(self):
        """Gets the destinationprefixes of this V1NetworkResponse.  # noqa: E501

        the destination prefixes of this network  # noqa: E501

        :return: The destinationprefixes of this V1NetworkResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._destinationprefixes

    @destinationprefixes.setter
    def destinationprefixes(self, destinationprefixes):
        """Sets the destinationprefixes of this V1NetworkResponse.

        the destination prefixes of this network  # noqa: E501

        :param destinationprefixes: The destinationprefixes of this V1NetworkResponse.  # noqa: E501
        :type: list[str]
        """
        if destinationprefixes is None:
            raise ValueError("Invalid value for `destinationprefixes`, must not be `None`")  # noqa: E501

        self._destinationprefixes = destinationprefixes

    @property
    def id(self):
        """Gets the id of this V1NetworkResponse.  # noqa: E501

        the unique ID of this entity  # noqa: E501

        :return: The id of this V1NetworkResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this V1NetworkResponse.

        the unique ID of this entity  # noqa: E501

        :param id: The id of this V1NetworkResponse.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def labels(self):
        """Gets the labels of this V1NetworkResponse.  # noqa: E501

        free labels that you associate with this network.  # noqa: E501

        :return: The labels of this V1NetworkResponse.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this V1NetworkResponse.

        free labels that you associate with this network.  # noqa: E501

        :param labels: The labels of this V1NetworkResponse.  # noqa: E501
        :type: dict(str, str)
        """

        self._labels = labels

    @property
    def name(self):
        """Gets the name of this V1NetworkResponse.  # noqa: E501

        a readable name for this entity  # noqa: E501

        :return: The name of this V1NetworkResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this V1NetworkResponse.

        a readable name for this entity  # noqa: E501

        :param name: The name of this V1NetworkResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def nat(self):
        """Gets the nat of this V1NetworkResponse.  # noqa: E501

        if set to true, packets leaving this ipv4 network get masqueraded behind interface ip  # noqa: E501

        :return: The nat of this V1NetworkResponse.  # noqa: E501
        :rtype: bool
        """
        return self._nat

    @nat.setter
    def nat(self, nat):
        """Sets the nat of this V1NetworkResponse.

        if set to true, packets leaving this ipv4 network get masqueraded behind interface ip  # noqa: E501

        :param nat: The nat of this V1NetworkResponse.  # noqa: E501
        :type: bool
        """
        if nat is None:
            raise ValueError("Invalid value for `nat`, must not be `None`")  # noqa: E501

        self._nat = nat

    @property
    def parentnetworkid(self):
        """Gets the parentnetworkid of this V1NetworkResponse.  # noqa: E501

        the id of the parent network  # noqa: E501

        :return: The parentnetworkid of this V1NetworkResponse.  # noqa: E501
        :rtype: str
        """
        return self._parentnetworkid

    @parentnetworkid.setter
    def parentnetworkid(self, parentnetworkid):
        """Sets the parentnetworkid of this V1NetworkResponse.

        the id of the parent network  # noqa: E501

        :param parentnetworkid: The parentnetworkid of this V1NetworkResponse.  # noqa: E501
        :type: str
        """

        self._parentnetworkid = parentnetworkid

    @property
    def partitionid(self):
        """Gets the partitionid of this V1NetworkResponse.  # noqa: E501

        the partition this network belongs to  # noqa: E501

        :return: The partitionid of this V1NetworkResponse.  # noqa: E501
        :rtype: str
        """
        return self._partitionid

    @partitionid.setter
    def partitionid(self, partitionid):
        """Sets the partitionid of this V1NetworkResponse.

        the partition this network belongs to  # noqa: E501

        :param partitionid: The partitionid of this V1NetworkResponse.  # noqa: E501
        :type: str
        """

        self._partitionid = partitionid

    @property
    def prefixes(self):
        """Gets the prefixes of this V1NetworkResponse.  # noqa: E501

        the prefixes of this network  # noqa: E501

        :return: The prefixes of this V1NetworkResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._prefixes

    @prefixes.setter
    def prefixes(self, prefixes):
        """Sets the prefixes of this V1NetworkResponse.

        the prefixes of this network  # noqa: E501

        :param prefixes: The prefixes of this V1NetworkResponse.  # noqa: E501
        :type: list[str]
        """
        if prefixes is None:
            raise ValueError("Invalid value for `prefixes`, must not be `None`")  # noqa: E501

        self._prefixes = prefixes

    @property
    def privatesuper(self):
        """Gets the privatesuper of this V1NetworkResponse.  # noqa: E501

        if set to true, this network will serve as a partition's super network for the internal machine networks,there can only be one privatesuper network per partition  # noqa: E501

        :return: The privatesuper of this V1NetworkResponse.  # noqa: E501
        :rtype: bool
        """
        return self._privatesuper

    @privatesuper.setter
    def privatesuper(self, privatesuper):
        """Sets the privatesuper of this V1NetworkResponse.

        if set to true, this network will serve as a partition's super network for the internal machine networks,there can only be one privatesuper network per partition  # noqa: E501

        :param privatesuper: The privatesuper of this V1NetworkResponse.  # noqa: E501
        :type: bool
        """
        if privatesuper is None:
            raise ValueError("Invalid value for `privatesuper`, must not be `None`")  # noqa: E501

        self._privatesuper = privatesuper

    @property
    def projectid(self):
        """Gets the projectid of this V1NetworkResponse.  # noqa: E501

        the project id this network belongs to, can be empty if globally available  # noqa: E501

        :return: The projectid of this V1NetworkResponse.  # noqa: E501
        :rtype: str
        """
        return self._projectid

    @projectid.setter
    def projectid(self, projectid):
        """Sets the projectid of this V1NetworkResponse.

        the project id this network belongs to, can be empty if globally available  # noqa: E501

        :param projectid: The projectid of this V1NetworkResponse.  # noqa: E501
        :type: str
        """

        self._projectid = projectid

    @property
    def shared(self):
        """Gets the shared of this V1NetworkResponse.  # noqa: E501

        marks a network as shareable.  # noqa: E501

        :return: The shared of this V1NetworkResponse.  # noqa: E501
        :rtype: bool
        """
        return self._shared

    @shared.setter
    def shared(self, shared):
        """Sets the shared of this V1NetworkResponse.

        marks a network as shareable.  # noqa: E501

        :param shared: The shared of this V1NetworkResponse.  # noqa: E501
        :type: bool
        """

        self._shared = shared

    @property
    def underlay(self):
        """Gets the underlay of this V1NetworkResponse.  # noqa: E501

        if set to true, this network can be used for underlay communication  # noqa: E501

        :return: The underlay of this V1NetworkResponse.  # noqa: E501
        :rtype: bool
        """
        return self._underlay

    @underlay.setter
    def underlay(self, underlay):
        """Sets the underlay of this V1NetworkResponse.

        if set to true, this network can be used for underlay communication  # noqa: E501

        :param underlay: The underlay of this V1NetworkResponse.  # noqa: E501
        :type: bool
        """
        if underlay is None:
            raise ValueError("Invalid value for `underlay`, must not be `None`")  # noqa: E501

        self._underlay = underlay

    @property
    def usage(self):
        """Gets the usage of this V1NetworkResponse.  # noqa: E501

        usage of IPv4 ips and prefixes in this network  # noqa: E501

        :return: The usage of this V1NetworkResponse.  # noqa: E501
        :rtype: V1NetworkUsage
        """
        return self._usage

    @usage.setter
    def usage(self, usage):
        """Sets the usage of this V1NetworkResponse.

        usage of IPv4 ips and prefixes in this network  # noqa: E501

        :param usage: The usage of this V1NetworkResponse.  # noqa: E501
        :type: V1NetworkUsage
        """
        if usage is None:
            raise ValueError("Invalid value for `usage`, must not be `None`")  # noqa: E501

        self._usage = usage

    @property
    def vrf(self):
        """Gets the vrf of this V1NetworkResponse.  # noqa: E501

        the vrf this network is associated with  # noqa: E501

        :return: The vrf of this V1NetworkResponse.  # noqa: E501
        :rtype: int
        """
        return self._vrf

    @vrf.setter
    def vrf(self, vrf):
        """Sets the vrf of this V1NetworkResponse.

        the vrf this network is associated with  # noqa: E501

        :param vrf: The vrf of this V1NetworkResponse.  # noqa: E501
        :type: int
        """

        self._vrf = vrf

    @property
    def vrfshared(self):
        """Gets the vrfshared of this V1NetworkResponse.  # noqa: E501

        if set to true, given vrf can be used by multiple networks, which is sometimes useful for network partitioning (default: false)  # noqa: E501

        :return: The vrfshared of this V1NetworkResponse.  # noqa: E501
        :rtype: bool
        """
        return self._vrfshared

    @vrfshared.setter
    def vrfshared(self, vrfshared):
        """Sets the vrfshared of this V1NetworkResponse.

        if set to true, given vrf can be used by multiple networks, which is sometimes useful for network partitioning (default: false)  # noqa: E501

        :param vrfshared: The vrfshared of this V1NetworkResponse.  # noqa: E501
        :type: bool
        """

        self._vrfshared = vrfshared

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(V1NetworkResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1NetworkResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
