# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'ServiceACLEntriesEntry',
    'ServiceComputeBackend',
    'ServiceComputeDictionary',
    'ServiceComputeDomain',
    'ServiceComputeLoggingBigquery',
    'ServiceComputeLoggingBlobstorage',
    'ServiceComputeLoggingCloudfile',
    'ServiceComputeLoggingDatadog',
    'ServiceComputeLoggingDigitalocean',
    'ServiceComputeLoggingElasticsearch',
    'ServiceComputeLoggingFtp',
    'ServiceComputeLoggingGc',
    'ServiceComputeLoggingGooglepubsub',
    'ServiceComputeLoggingHeroku',
    'ServiceComputeLoggingHoneycomb',
    'ServiceComputeLoggingHttp',
    'ServiceComputeLoggingKafka',
    'ServiceComputeLoggingKinese',
    'ServiceComputeLoggingLogentry',
    'ServiceComputeLoggingLoggly',
    'ServiceComputeLoggingLogshuttle',
    'ServiceComputeLoggingNewrelic',
    'ServiceComputeLoggingOpenstack',
    'ServiceComputeLoggingPapertrail',
    'ServiceComputeLoggingS3',
    'ServiceComputeLoggingScalyr',
    'ServiceComputeLoggingSftp',
    'ServiceComputeLoggingSplunk',
    'ServiceComputeLoggingSumologic',
    'ServiceComputeLoggingSyslog',
    'ServiceComputePackage',
    'ServiceComputeProductEnablement',
    'ServiceComputeResourceLink',
    'ServiceVclAcl',
    'ServiceVclBackend',
    'ServiceVclCacheSetting',
    'ServiceVclCondition',
    'ServiceVclDictionary',
    'ServiceVclDirector',
    'ServiceVclDomain',
    'ServiceVclDynamicsnippet',
    'ServiceVclGzip',
    'ServiceVclHeader',
    'ServiceVclHealthcheck',
    'ServiceVclLoggingBigquery',
    'ServiceVclLoggingBlobstorage',
    'ServiceVclLoggingCloudfile',
    'ServiceVclLoggingDatadog',
    'ServiceVclLoggingDigitalocean',
    'ServiceVclLoggingElasticsearch',
    'ServiceVclLoggingFtp',
    'ServiceVclLoggingGc',
    'ServiceVclLoggingGooglepubsub',
    'ServiceVclLoggingHerokus',
    'ServiceVclLoggingHoneycomb',
    'ServiceVclLoggingHttp',
    'ServiceVclLoggingKafka',
    'ServiceVclLoggingKinese',
    'ServiceVclLoggingLogentry',
    'ServiceVclLoggingLoggly',
    'ServiceVclLoggingLogshuttle',
    'ServiceVclLoggingNewrelic',
    'ServiceVclLoggingOpenstack',
    'ServiceVclLoggingPapertrail',
    'ServiceVclLoggingS3',
    'ServiceVclLoggingScalyr',
    'ServiceVclLoggingSftp',
    'ServiceVclLoggingSplunk',
    'ServiceVclLoggingSumologic',
    'ServiceVclLoggingSyslog',
    'ServiceVclProductEnablement',
    'ServiceVclRateLimiter',
    'ServiceVclRateLimiterResponse',
    'ServiceVclRequestSetting',
    'ServiceVclResponseObject',
    'ServiceVclSnippet',
    'ServiceVclVcl',
    'ServiceVclWaf',
    'ServiceWafConfigurationRule',
    'ServiceWafConfigurationRuleExclusion',
    'TlsSubscriptionManagedDnsChallenge',
    'TlsSubscriptionManagedHttpChallenge',
    'GetConfigstoresStoreResult',
    'GetDatacentersPopResult',
    'GetDictionariesDictionaryResult',
    'GetKvstoresStoreResult',
    'GetSecretstoresStoreResult',
    'GetServicesDetailResult',
    'GetTlsConfigurationDnsRecordResult',
    'GetWafRulesRuleResult',
]

@pulumi.output_type
class ServiceACLEntriesEntry(dict):
    def __init__(__self__, *,
                 ip: str,
                 comment: Optional[str] = None,
                 id: Optional[str] = None,
                 negated: Optional[bool] = None,
                 subnet: Optional[str] = None):
        """
        :param str ip: An IP address that is the focus for the ACL
        :param str comment: A personal freeform descriptive note
        :param str id: The unique ID of the entry
        :param bool negated: A boolean that will negate the match if true
        :param str subnet: An optional subnet mask applied to the IP address
        """
        ServiceACLEntriesEntry._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ip=ip,
            comment=comment,
            id=id,
            negated=negated,
            subnet=subnet,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ip: Optional[str] = None,
             comment: Optional[str] = None,
             id: Optional[str] = None,
             negated: Optional[bool] = None,
             subnet: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if ip is None:
            raise TypeError("Missing 'ip' argument")

        _setter("ip", ip)
        if comment is not None:
            _setter("comment", comment)
        if id is not None:
            _setter("id", id)
        if negated is not None:
            _setter("negated", negated)
        if subnet is not None:
            _setter("subnet", subnet)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        An IP address that is the focus for the ACL
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        A personal freeform descriptive note
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The unique ID of the entry
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def negated(self) -> Optional[bool]:
        """
        A boolean that will negate the match if true
        """
        return pulumi.get(self, "negated")

    @property
    @pulumi.getter
    def subnet(self) -> Optional[str]:
        """
        An optional subnet mask applied to the IP address
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ServiceComputeBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "betweenBytesTimeout":
            suggest = "between_bytes_timeout"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "errorThreshold":
            suggest = "error_threshold"
        elif key == "firstByteTimeout":
            suggest = "first_byte_timeout"
        elif key == "keepaliveTime":
            suggest = "keepalive_time"
        elif key == "maxConn":
            suggest = "max_conn"
        elif key == "maxTlsVersion":
            suggest = "max_tls_version"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "overrideHost":
            suggest = "override_host"
        elif key == "shareKey":
            suggest = "share_key"
        elif key == "sslCaCert":
            suggest = "ssl_ca_cert"
        elif key == "sslCertHostname":
            suggest = "ssl_cert_hostname"
        elif key == "sslCheckCert":
            suggest = "ssl_check_cert"
        elif key == "sslCiphers":
            suggest = "ssl_ciphers"
        elif key == "sslClientCert":
            suggest = "ssl_client_cert"
        elif key == "sslClientKey":
            suggest = "ssl_client_key"
        elif key == "sslSniHostname":
            suggest = "ssl_sni_hostname"
        elif key == "useSsl":
            suggest = "use_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 between_bytes_timeout: Optional[int] = None,
                 connect_timeout: Optional[int] = None,
                 error_threshold: Optional[int] = None,
                 first_byte_timeout: Optional[int] = None,
                 healthcheck: Optional[str] = None,
                 keepalive_time: Optional[int] = None,
                 max_conn: Optional[int] = None,
                 max_tls_version: Optional[str] = None,
                 min_tls_version: Optional[str] = None,
                 override_host: Optional[str] = None,
                 port: Optional[int] = None,
                 share_key: Optional[str] = None,
                 shield: Optional[str] = None,
                 ssl_ca_cert: Optional[str] = None,
                 ssl_cert_hostname: Optional[str] = None,
                 ssl_check_cert: Optional[bool] = None,
                 ssl_ciphers: Optional[str] = None,
                 ssl_client_cert: Optional[str] = None,
                 ssl_client_key: Optional[str] = None,
                 ssl_sni_hostname: Optional[str] = None,
                 use_ssl: Optional[bool] = None,
                 weight: Optional[int] = None):
        """
        :param str address: An IPv4, hostname, or IPv6 address for the Backend
        :param str name: Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        :param int between_bytes_timeout: How long to wait between bytes in milliseconds. Default `10000`
        :param int connect_timeout: How long to wait for a timeout in milliseconds. Default `1000`
        :param int error_threshold: Number of errors to allow before the Backend is marked as down. Default `0`
        :param int first_byte_timeout: How long to wait for the first bytes in milliseconds. Default `15000`
        :param str healthcheck: Name of a defined `healthcheck` to assign to this backend
        :param int keepalive_time: How long in seconds to keep a persistent connection to the backend between requests.
        :param int max_conn: Maximum number of connections for this Backend. Default `200`
        :param str max_tls_version: Maximum allowed TLS version on SSL connections to this backend.
        :param str min_tls_version: Minimum allowed TLS version on SSL connections to this backend.
        :param str override_host: The hostname to override the Host header
        :param int port: The port number on which the Backend responds. Default `80`
        :param str share_key: Value that when shared across backends will enable those backends to share the same health check.
        :param str shield: The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        :param str ssl_ca_cert: CA certificate attached to origin.
        :param str ssl_cert_hostname: Configure certificate validation. Does not affect SNI at all
        :param bool ssl_check_cert: Be strict about checking SSL certs. Default `true`
        :param str ssl_ciphers: Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        :param str ssl_client_cert: Client certificate attached to origin. Used when connecting to the backend
        :param str ssl_client_key: Client key attached to origin. Used when connecting to the backend
        :param str ssl_sni_hostname: Configure SNI in the TLS handshake. Does not affect cert validation at all
        :param bool use_ssl: Whether or not to use SSL to reach the Backend. Default `false`
        :param int weight: The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        ServiceComputeBackend._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            name=name,
            between_bytes_timeout=between_bytes_timeout,
            connect_timeout=connect_timeout,
            error_threshold=error_threshold,
            first_byte_timeout=first_byte_timeout,
            healthcheck=healthcheck,
            keepalive_time=keepalive_time,
            max_conn=max_conn,
            max_tls_version=max_tls_version,
            min_tls_version=min_tls_version,
            override_host=override_host,
            port=port,
            share_key=share_key,
            shield=shield,
            ssl_ca_cert=ssl_ca_cert,
            ssl_cert_hostname=ssl_cert_hostname,
            ssl_check_cert=ssl_check_cert,
            ssl_ciphers=ssl_ciphers,
            ssl_client_cert=ssl_client_cert,
            ssl_client_key=ssl_client_key,
            ssl_sni_hostname=ssl_sni_hostname,
            use_ssl=use_ssl,
            weight=weight,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             name: Optional[str] = None,
             between_bytes_timeout: Optional[int] = None,
             connect_timeout: Optional[int] = None,
             error_threshold: Optional[int] = None,
             first_byte_timeout: Optional[int] = None,
             healthcheck: Optional[str] = None,
             keepalive_time: Optional[int] = None,
             max_conn: Optional[int] = None,
             max_tls_version: Optional[str] = None,
             min_tls_version: Optional[str] = None,
             override_host: Optional[str] = None,
             port: Optional[int] = None,
             share_key: Optional[str] = None,
             shield: Optional[str] = None,
             ssl_ca_cert: Optional[str] = None,
             ssl_cert_hostname: Optional[str] = None,
             ssl_check_cert: Optional[bool] = None,
             ssl_ciphers: Optional[str] = None,
             ssl_client_cert: Optional[str] = None,
             ssl_client_key: Optional[str] = None,
             ssl_sni_hostname: Optional[str] = None,
             use_ssl: Optional[bool] = None,
             weight: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if address is None:
            raise TypeError("Missing 'address' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if between_bytes_timeout is None and 'betweenBytesTimeout' in kwargs:
            between_bytes_timeout = kwargs['betweenBytesTimeout']
        if connect_timeout is None and 'connectTimeout' in kwargs:
            connect_timeout = kwargs['connectTimeout']
        if error_threshold is None and 'errorThreshold' in kwargs:
            error_threshold = kwargs['errorThreshold']
        if first_byte_timeout is None and 'firstByteTimeout' in kwargs:
            first_byte_timeout = kwargs['firstByteTimeout']
        if keepalive_time is None and 'keepaliveTime' in kwargs:
            keepalive_time = kwargs['keepaliveTime']
        if max_conn is None and 'maxConn' in kwargs:
            max_conn = kwargs['maxConn']
        if max_tls_version is None and 'maxTlsVersion' in kwargs:
            max_tls_version = kwargs['maxTlsVersion']
        if min_tls_version is None and 'minTlsVersion' in kwargs:
            min_tls_version = kwargs['minTlsVersion']
        if override_host is None and 'overrideHost' in kwargs:
            override_host = kwargs['overrideHost']
        if share_key is None and 'shareKey' in kwargs:
            share_key = kwargs['shareKey']
        if ssl_ca_cert is None and 'sslCaCert' in kwargs:
            ssl_ca_cert = kwargs['sslCaCert']
        if ssl_cert_hostname is None and 'sslCertHostname' in kwargs:
            ssl_cert_hostname = kwargs['sslCertHostname']
        if ssl_check_cert is None and 'sslCheckCert' in kwargs:
            ssl_check_cert = kwargs['sslCheckCert']
        if ssl_ciphers is None and 'sslCiphers' in kwargs:
            ssl_ciphers = kwargs['sslCiphers']
        if ssl_client_cert is None and 'sslClientCert' in kwargs:
            ssl_client_cert = kwargs['sslClientCert']
        if ssl_client_key is None and 'sslClientKey' in kwargs:
            ssl_client_key = kwargs['sslClientKey']
        if ssl_sni_hostname is None and 'sslSniHostname' in kwargs:
            ssl_sni_hostname = kwargs['sslSniHostname']
        if use_ssl is None and 'useSsl' in kwargs:
            use_ssl = kwargs['useSsl']

        _setter("address", address)
        _setter("name", name)
        if between_bytes_timeout is not None:
            _setter("between_bytes_timeout", between_bytes_timeout)
        if connect_timeout is not None:
            _setter("connect_timeout", connect_timeout)
        if error_threshold is not None:
            _setter("error_threshold", error_threshold)
        if first_byte_timeout is not None:
            _setter("first_byte_timeout", first_byte_timeout)
        if healthcheck is not None:
            _setter("healthcheck", healthcheck)
        if keepalive_time is not None:
            _setter("keepalive_time", keepalive_time)
        if max_conn is not None:
            _setter("max_conn", max_conn)
        if max_tls_version is not None:
            _setter("max_tls_version", max_tls_version)
        if min_tls_version is not None:
            _setter("min_tls_version", min_tls_version)
        if override_host is not None:
            _setter("override_host", override_host)
        if port is not None:
            _setter("port", port)
        if share_key is not None:
            _setter("share_key", share_key)
        if shield is not None:
            _setter("shield", shield)
        if ssl_ca_cert is not None:
            _setter("ssl_ca_cert", ssl_ca_cert)
        if ssl_cert_hostname is not None:
            _setter("ssl_cert_hostname", ssl_cert_hostname)
        if ssl_check_cert is not None:
            _setter("ssl_check_cert", ssl_check_cert)
        if ssl_ciphers is not None:
            _setter("ssl_ciphers", ssl_ciphers)
        if ssl_client_cert is not None:
            _setter("ssl_client_cert", ssl_client_cert)
        if ssl_client_key is not None:
            _setter("ssl_client_key", ssl_client_key)
        if ssl_sni_hostname is not None:
            _setter("ssl_sni_hostname", ssl_sni_hostname)
        if use_ssl is not None:
            _setter("use_ssl", use_ssl)
        if weight is not None:
            _setter("weight", weight)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        An IPv4, hostname, or IPv6 address for the Backend
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="betweenBytesTimeout")
    def between_bytes_timeout(self) -> Optional[int]:
        """
        How long to wait between bytes in milliseconds. Default `10000`
        """
        return pulumi.get(self, "between_bytes_timeout")

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[int]:
        """
        How long to wait for a timeout in milliseconds. Default `1000`
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[int]:
        """
        Number of errors to allow before the Backend is marked as down. Default `0`
        """
        return pulumi.get(self, "error_threshold")

    @property
    @pulumi.getter(name="firstByteTimeout")
    def first_byte_timeout(self) -> Optional[int]:
        """
        How long to wait for the first bytes in milliseconds. Default `15000`
        """
        return pulumi.get(self, "first_byte_timeout")

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[str]:
        """
        Name of a defined `healthcheck` to assign to this backend
        """
        return pulumi.get(self, "healthcheck")

    @property
    @pulumi.getter(name="keepaliveTime")
    def keepalive_time(self) -> Optional[int]:
        """
        How long in seconds to keep a persistent connection to the backend between requests.
        """
        return pulumi.get(self, "keepalive_time")

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> Optional[int]:
        """
        Maximum number of connections for this Backend. Default `200`
        """
        return pulumi.get(self, "max_conn")

    @property
    @pulumi.getter(name="maxTlsVersion")
    def max_tls_version(self) -> Optional[str]:
        """
        Maximum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "max_tls_version")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[str]:
        """
        Minimum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter(name="overrideHost")
    def override_host(self) -> Optional[str]:
        """
        The hostname to override the Host header
        """
        return pulumi.get(self, "override_host")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number on which the Backend responds. Default `80`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="shareKey")
    def share_key(self) -> Optional[str]:
        """
        Value that when shared across backends will enable those backends to share the same health check.
        """
        return pulumi.get(self, "share_key")

    @property
    @pulumi.getter
    def shield(self) -> Optional[str]:
        """
        The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter(name="sslCaCert")
    def ssl_ca_cert(self) -> Optional[str]:
        """
        CA certificate attached to origin.
        """
        return pulumi.get(self, "ssl_ca_cert")

    @property
    @pulumi.getter(name="sslCertHostname")
    def ssl_cert_hostname(self) -> Optional[str]:
        """
        Configure certificate validation. Does not affect SNI at all
        """
        return pulumi.get(self, "ssl_cert_hostname")

    @property
    @pulumi.getter(name="sslCheckCert")
    def ssl_check_cert(self) -> Optional[bool]:
        """
        Be strict about checking SSL certs. Default `true`
        """
        return pulumi.get(self, "ssl_check_cert")

    @property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> Optional[str]:
        """
        Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        """
        return pulumi.get(self, "ssl_ciphers")

    @property
    @pulumi.getter(name="sslClientCert")
    def ssl_client_cert(self) -> Optional[str]:
        """
        Client certificate attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_cert")

    @property
    @pulumi.getter(name="sslClientKey")
    def ssl_client_key(self) -> Optional[str]:
        """
        Client key attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_key")

    @property
    @pulumi.getter(name="sslSniHostname")
    def ssl_sni_hostname(self) -> Optional[str]:
        """
        Configure SNI in the TLS handshake. Does not affect cert validation at all
        """
        return pulumi.get(self, "ssl_sni_hostname")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[bool]:
        """
        Whether or not to use SSL to reach the Backend. Default `false`
        """
        return pulumi.get(self, "use_ssl")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServiceComputeDictionary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dictionaryId":
            suggest = "dictionary_id"
        elif key == "forceDestroy":
            suggest = "force_destroy"
        elif key == "writeOnly":
            suggest = "write_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeDictionary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeDictionary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeDictionary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 dictionary_id: Optional[str] = None,
                 force_destroy: Optional[bool] = None,
                 write_only: Optional[bool] = None):
        """
        :param str name: A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        :param str dictionary_id: The ID of the dictionary
        :param bool force_destroy: Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        ServiceComputeDictionary._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            dictionary_id=dictionary_id,
            force_destroy=force_destroy,
            write_only=write_only,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             dictionary_id: Optional[str] = None,
             force_destroy: Optional[bool] = None,
             write_only: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if dictionary_id is None and 'dictionaryId' in kwargs:
            dictionary_id = kwargs['dictionaryId']
        if force_destroy is None and 'forceDestroy' in kwargs:
            force_destroy = kwargs['forceDestroy']
        if write_only is None and 'writeOnly' in kwargs:
            write_only = kwargs['writeOnly']

        _setter("name", name)
        if dictionary_id is not None:
            _setter("dictionary_id", dictionary_id)
        if force_destroy is not None:
            _setter("force_destroy", force_destroy)
        if write_only is not None:
            _setter("write_only", write_only)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[str]:
        """
        The ID of the dictionary
        """
        return pulumi.get(self, "dictionary_id")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[bool]:
        """
        Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> Optional[bool]:
        return pulumi.get(self, "write_only")


@pulumi.output_type
class ServiceComputeDomain(dict):
    def __init__(__self__, *,
                 name: str,
                 comment: Optional[str] = None):
        """
        :param str name: The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        :param str comment: An optional comment about the Domain.
        """
        ServiceComputeDomain._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            comment=comment,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             comment: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")

        _setter("name", name)
        if comment is not None:
            _setter("comment", comment)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        An optional comment about the Domain.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class ServiceComputeLoggingBigquery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "accountName":
            suggest = "account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingBigquery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingBigquery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingBigquery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: str,
                 email: str,
                 name: str,
                 project_id: str,
                 secret_key: str,
                 table: str,
                 account_name: Optional[str] = None,
                 template: Optional[str] = None):
        """
        :param str dataset: The ID of your BigQuery dataset
        :param str email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        :param str name: A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str project_id: The ID of your GCP project
        :param str secret_key: The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        :param str table: The ID of your BigQuery table
        :param str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param str template: BigQuery table name suffix template
        """
        ServiceComputeLoggingBigquery._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset=dataset,
            email=email,
            name=name,
            project_id=project_id,
            secret_key=secret_key,
            table=table,
            account_name=account_name,
            template=template,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset: Optional[str] = None,
             email: Optional[str] = None,
             name: Optional[str] = None,
             project_id: Optional[str] = None,
             secret_key: Optional[str] = None,
             table: Optional[str] = None,
             account_name: Optional[str] = None,
             template: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if dataset is None:
            raise TypeError("Missing 'dataset' argument")
        if email is None:
            raise TypeError("Missing 'email' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if project_id is None and 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if project_id is None:
            raise TypeError("Missing 'project_id' argument")
        if secret_key is None and 'secretKey' in kwargs:
            secret_key = kwargs['secretKey']
        if secret_key is None:
            raise TypeError("Missing 'secret_key' argument")
        if table is None:
            raise TypeError("Missing 'table' argument")
        if account_name is None and 'accountName' in kwargs:
            account_name = kwargs['accountName']

        _setter("dataset", dataset)
        _setter("email", email)
        _setter("name", name)
        _setter("project_id", project_id)
        _setter("secret_key", secret_key)
        _setter("table", table)
        if account_name is not None:
            _setter("account_name", account_name)
        if template is not None:
            _setter("template", template)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The ID of your BigQuery dataset
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of your GCP project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        The ID of your BigQuery table
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def template(self) -> Optional[str]:
        """
        BigQuery table name suffix template
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class ServiceComputeLoggingBlobstorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "sasToken":
            suggest = "sas_token"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingBlobstorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingBlobstorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingBlobstorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: str,
                 container: str,
                 name: str,
                 sas_token: str,
                 compression_codec: Optional[str] = None,
                 file_max_bytes: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 public_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str account_name: The unique Azure Blob Storage namespace in which your data objects are stored
        :param str container: The name of the Azure Blob Storage container in which to store logs
        :param str name: A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str sas_token: The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str path: The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        :param int period: How frequently the logs should be transferred in seconds. Default `3600`
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceComputeLoggingBlobstorage._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            account_name=account_name,
            container=container,
            name=name,
            sas_token=sas_token,
            compression_codec=compression_codec,
            file_max_bytes=file_max_bytes,
            gzip_level=gzip_level,
            message_type=message_type,
            path=path,
            period=period,
            public_key=public_key,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             account_name: Optional[str] = None,
             container: Optional[str] = None,
             name: Optional[str] = None,
             sas_token: Optional[str] = None,
             compression_codec: Optional[str] = None,
             file_max_bytes: Optional[int] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             path: Optional[str] = None,
             period: Optional[int] = None,
             public_key: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if account_name is None and 'accountName' in kwargs:
            account_name = kwargs['accountName']
        if account_name is None:
            raise TypeError("Missing 'account_name' argument")
        if container is None:
            raise TypeError("Missing 'container' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if sas_token is None and 'sasToken' in kwargs:
            sas_token = kwargs['sasToken']
        if sas_token is None:
            raise TypeError("Missing 'sas_token' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if file_max_bytes is None and 'fileMaxBytes' in kwargs:
            file_max_bytes = kwargs['fileMaxBytes']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("account_name", account_name)
        _setter("container", container)
        _setter("name", name)
        _setter("sas_token", sas_token)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if file_max_bytes is not None:
            _setter("file_max_bytes", file_max_bytes)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if path is not None:
            _setter("path", path)
        if period is not None:
            _setter("period", period)
        if public_key is not None:
            _setter("public_key", public_key)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        The unique Azure Blob Storage namespace in which your data objects are stored
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The name of the Azure Blob Storage container in which to store logs
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> str:
        """
        The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        """
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingCloudfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingCloudfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingCloudfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingCloudfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 public_key: Optional[str] = None,
                 region: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your Cloud File account access key
        :param str bucket_name: The name of your Cloud Files container
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str user: The username for your Cloud Files account
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str path: The path to upload logs to
        :param int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceComputeLoggingCloudfile._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_key=access_key,
            bucket_name=bucket_name,
            name=name,
            user=user,
            compression_codec=compression_codec,
            gzip_level=gzip_level,
            message_type=message_type,
            path=path,
            period=period,
            public_key=public_key,
            region=region,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_key: Optional[str] = None,
             bucket_name: Optional[str] = None,
             name: Optional[str] = None,
             user: Optional[str] = None,
             compression_codec: Optional[str] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             path: Optional[str] = None,
             period: Optional[int] = None,
             public_key: Optional[str] = None,
             region: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if access_key is None and 'accessKey' in kwargs:
            access_key = kwargs['accessKey']
        if access_key is None:
            raise TypeError("Missing 'access_key' argument")
        if bucket_name is None and 'bucketName' in kwargs:
            bucket_name = kwargs['bucketName']
        if bucket_name is None:
            raise TypeError("Missing 'bucket_name' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if user is None:
            raise TypeError("Missing 'user' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("access_key", access_key)
        _setter("bucket_name", bucket_name)
        _setter("name", name)
        _setter("user", user)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if path is not None:
            _setter("path", path)
        if period is not None:
            _setter("period", period)
        if public_key is not None:
            _setter("public_key", public_key)
        if region is not None:
            _setter("region", region)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your Cloud File account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingDatadog(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 region: Optional[str] = None):
        """
        :param str name: The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The API key from your Datadog account
        :param str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        ServiceComputeLoggingDatadog._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            region=region,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             region: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")

        _setter("name", name)
        _setter("token", token)
        if region is not None:
            _setter("region", region)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The API key from your Datadog account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ServiceComputeLoggingDigitalocean(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingDigitalocean. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingDigitalocean.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingDigitalocean.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 secret_key: str,
                 compression_codec: Optional[str] = None,
                 domain: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 public_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your DigitalOcean Spaces account access key
        :param str bucket_name: The name of the DigitalOcean Space
        :param str name: The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str secret_key: Your DigitalOcean Spaces account secret key
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str domain: The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str path: The path to upload logs to
        :param int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceComputeLoggingDigitalocean._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_key=access_key,
            bucket_name=bucket_name,
            name=name,
            secret_key=secret_key,
            compression_codec=compression_codec,
            domain=domain,
            gzip_level=gzip_level,
            message_type=message_type,
            path=path,
            period=period,
            public_key=public_key,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_key: Optional[str] = None,
             bucket_name: Optional[str] = None,
             name: Optional[str] = None,
             secret_key: Optional[str] = None,
             compression_codec: Optional[str] = None,
             domain: Optional[str] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             path: Optional[str] = None,
             period: Optional[int] = None,
             public_key: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if access_key is None and 'accessKey' in kwargs:
            access_key = kwargs['accessKey']
        if access_key is None:
            raise TypeError("Missing 'access_key' argument")
        if bucket_name is None and 'bucketName' in kwargs:
            bucket_name = kwargs['bucketName']
        if bucket_name is None:
            raise TypeError("Missing 'bucket_name' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if secret_key is None and 'secretKey' in kwargs:
            secret_key = kwargs['secretKey']
        if secret_key is None:
            raise TypeError("Missing 'secret_key' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("access_key", access_key)
        _setter("bucket_name", bucket_name)
        _setter("name", name)
        _setter("secret_key", secret_key)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if domain is not None:
            _setter("domain", domain)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if path is not None:
            _setter("path", path)
        if period is not None:
            _setter("period", period)
        if public_key is not None:
            _setter("public_key", public_key)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your DigitalOcean Spaces account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the DigitalOcean Space
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your DigitalOcean Spaces account secret key
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingElasticsearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingElasticsearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingElasticsearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingElasticsearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index: str,
                 name: str,
                 url: str,
                 password: Optional[str] = None,
                 pipeline: Optional[str] = None,
                 request_max_bytes: Optional[int] = None,
                 request_max_entries: Optional[int] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str index: The name of the Elasticsearch index to send documents (logs) to
        :param str name: The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: The Elasticsearch URL to stream logs to
        :param str password: BasicAuth password for Elasticsearch
        :param str pipeline: The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        :param int request_max_bytes: The maximum number of logs sent in one request. Defaults to `0` for unbounded
        :param int request_max_entries: The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        :param str user: BasicAuth username for Elasticsearch
        """
        ServiceComputeLoggingElasticsearch._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            index=index,
            name=name,
            url=url,
            password=password,
            pipeline=pipeline,
            request_max_bytes=request_max_bytes,
            request_max_entries=request_max_entries,
            tls_ca_cert=tls_ca_cert,
            tls_client_cert=tls_client_cert,
            tls_client_key=tls_client_key,
            tls_hostname=tls_hostname,
            user=user,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             index: Optional[str] = None,
             name: Optional[str] = None,
             url: Optional[str] = None,
             password: Optional[str] = None,
             pipeline: Optional[str] = None,
             request_max_bytes: Optional[int] = None,
             request_max_entries: Optional[int] = None,
             tls_ca_cert: Optional[str] = None,
             tls_client_cert: Optional[str] = None,
             tls_client_key: Optional[str] = None,
             tls_hostname: Optional[str] = None,
             user: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if index is None:
            raise TypeError("Missing 'index' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")
        if request_max_bytes is None and 'requestMaxBytes' in kwargs:
            request_max_bytes = kwargs['requestMaxBytes']
        if request_max_entries is None and 'requestMaxEntries' in kwargs:
            request_max_entries = kwargs['requestMaxEntries']
        if tls_ca_cert is None and 'tlsCaCert' in kwargs:
            tls_ca_cert = kwargs['tlsCaCert']
        if tls_client_cert is None and 'tlsClientCert' in kwargs:
            tls_client_cert = kwargs['tlsClientCert']
        if tls_client_key is None and 'tlsClientKey' in kwargs:
            tls_client_key = kwargs['tlsClientKey']
        if tls_hostname is None and 'tlsHostname' in kwargs:
            tls_hostname = kwargs['tlsHostname']

        _setter("index", index)
        _setter("name", name)
        _setter("url", url)
        if password is not None:
            _setter("password", password)
        if pipeline is not None:
            _setter("pipeline", pipeline)
        if request_max_bytes is not None:
            _setter("request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            _setter("request_max_entries", request_max_entries)
        if tls_ca_cert is not None:
            _setter("tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            _setter("tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            _setter("tls_client_key", tls_client_key)
        if tls_hostname is not None:
            _setter("tls_hostname", tls_hostname)
        if user is not None:
            _setter("user", user)

    @property
    @pulumi.getter
    def index(self) -> str:
        """
        The name of the Elasticsearch index to send documents (logs) to
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The Elasticsearch URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        BasicAuth password for Elasticsearch
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[str]:
        """
        The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[int]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[int]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        BasicAuth username for Elasticsearch
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingFtp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingFtp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingFtp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingFtp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 password: str,
                 path: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 period: Optional[int] = None,
                 port: Optional[int] = None,
                 public_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str address: The FTP address to stream logs to
        :param str name: The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str password: The password for the server (for anonymous use an email address)
        :param str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param str user: The username for the server (can be `anonymous`)
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param int period: How frequently the logs should be transferred, in seconds (Default `3600`)
        :param int port: The port number. Default: `21`
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceComputeLoggingFtp._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            name=name,
            password=password,
            path=path,
            user=user,
            compression_codec=compression_codec,
            gzip_level=gzip_level,
            message_type=message_type,
            period=period,
            port=port,
            public_key=public_key,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             name: Optional[str] = None,
             password: Optional[str] = None,
             path: Optional[str] = None,
             user: Optional[str] = None,
             compression_codec: Optional[str] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             period: Optional[int] = None,
             port: Optional[int] = None,
             public_key: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if address is None:
            raise TypeError("Missing 'address' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if password is None:
            raise TypeError("Missing 'password' argument")
        if path is None:
            raise TypeError("Missing 'path' argument")
        if user is None:
            raise TypeError("Missing 'user' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("address", address)
        _setter("name", name)
        _setter("password", password)
        _setter("path", path)
        _setter("user", user)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if period is not None:
            _setter("period", period)
        if port is not None:
            _setter("port", port)
        if public_key is not None:
            _setter("public_key", public_key)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The FTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for the server (for anonymous use an email address)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for the server (can be `anonymous`)
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds (Default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number. Default: `21`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingGc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingGc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingGc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingGc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 name: str,
                 account_name: Optional[str] = None,
                 compression_codec: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 project_id: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str bucket_name: The name of the bucket in which to store the logs
        :param str name: A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param int period: How frequently the logs should be transferred, in seconds (Default 3600)
        :param str project_id: The ID of your Google Cloud Platform project
        :param str secret_key: The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        :param str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        ServiceComputeLoggingGc._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket_name=bucket_name,
            name=name,
            account_name=account_name,
            compression_codec=compression_codec,
            gzip_level=gzip_level,
            message_type=message_type,
            path=path,
            period=period,
            project_id=project_id,
            secret_key=secret_key,
            timestamp_format=timestamp_format,
            user=user,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket_name: Optional[str] = None,
             name: Optional[str] = None,
             account_name: Optional[str] = None,
             compression_codec: Optional[str] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             path: Optional[str] = None,
             period: Optional[int] = None,
             project_id: Optional[str] = None,
             secret_key: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             user: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if bucket_name is None and 'bucketName' in kwargs:
            bucket_name = kwargs['bucketName']
        if bucket_name is None:
            raise TypeError("Missing 'bucket_name' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if account_name is None and 'accountName' in kwargs:
            account_name = kwargs['accountName']
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if project_id is None and 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if secret_key is None and 'secretKey' in kwargs:
            secret_key = kwargs['secretKey']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("bucket_name", bucket_name)
        _setter("name", name)
        if account_name is not None:
            _setter("account_name", account_name)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if path is not None:
            _setter("path", path)
        if period is not None:
            _setter("period", period)
        if project_id is not None:
            _setter("project_id", project_id)
        if secret_key is not None:
            _setter("secret_key", secret_key)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)
        if user is not None:
            _setter("user", user)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds (Default 3600)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingGooglepubsub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "accountName":
            suggest = "account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingGooglepubsub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingGooglepubsub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingGooglepubsub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 project_id: str,
                 secret_key: str,
                 topic: str,
                 user: str,
                 account_name: Optional[str] = None):
        """
        :param str name: The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str project_id: The ID of your Google Cloud Platform project
        :param str secret_key: Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        :param str topic: The Google Cloud Pub/Sub topic to which logs will be published
        :param str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        :param str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        ServiceComputeLoggingGooglepubsub._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            project_id=project_id,
            secret_key=secret_key,
            topic=topic,
            user=user,
            account_name=account_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             project_id: Optional[str] = None,
             secret_key: Optional[str] = None,
             topic: Optional[str] = None,
             user: Optional[str] = None,
             account_name: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if project_id is None and 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if project_id is None:
            raise TypeError("Missing 'project_id' argument")
        if secret_key is None and 'secretKey' in kwargs:
            secret_key = kwargs['secretKey']
        if secret_key is None:
            raise TypeError("Missing 'secret_key' argument")
        if topic is None:
            raise TypeError("Missing 'topic' argument")
        if user is None:
            raise TypeError("Missing 'user' argument")
        if account_name is None and 'accountName' in kwargs:
            account_name = kwargs['accountName']

        _setter("name", name)
        _setter("project_id", project_id)
        _setter("secret_key", secret_key)
        _setter("topic", topic)
        _setter("user", user)
        if account_name is not None:
            _setter("account_name", account_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Google Cloud Pub/Sub topic to which logs will be published
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")


@pulumi.output_type
class ServiceComputeLoggingHeroku(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str):
        """
        :param str name: The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        :param str url: The URL to stream logs to
        """
        ServiceComputeLoggingHeroku._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            url=url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             url: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")

        _setter("name", name)
        _setter("token", token)
        _setter("url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ServiceComputeLoggingHoneycomb(dict):
    def __init__(__self__, *,
                 dataset: str,
                 name: str,
                 token: str):
        """
        :param str dataset: The Honeycomb Dataset you want to log to
        :param str name: The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The Write Key from the Account page of your Honeycomb account
        """
        ServiceComputeLoggingHoneycomb._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset=dataset,
            name=name,
            token=token,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset: Optional[str] = None,
             name: Optional[str] = None,
             token: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if dataset is None:
            raise TypeError("Missing 'dataset' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")

        _setter("dataset", dataset)
        _setter("name", name)
        _setter("token", token)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The Honeycomb Dataset you want to log to
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Write Key from the Account page of your Honeycomb account
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceComputeLoggingHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"
        elif key == "jsonFormat":
            suggest = "json_format"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 url: str,
                 content_type: Optional[str] = None,
                 header_name: Optional[str] = None,
                 header_value: Optional[str] = None,
                 json_format: Optional[str] = None,
                 message_type: Optional[str] = None,
                 method: Optional[str] = None,
                 request_max_bytes: Optional[int] = None,
                 request_max_entries: Optional[int] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None):
        """
        :param str name: The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: URL that log data will be sent to. Must use the https protocol
        :param str content_type: Value of the `Content-Type` header sent with the request
        :param str header_name: Custom header sent with the request
        :param str header_value: Value of the custom header sent with the request
        :param str json_format: Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        :param int request_max_bytes: The maximum number of bytes sent in one request
        :param int request_max_entries: The maximum number of logs sent in one request
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param str tls_hostname: Used during the TLS handshake to validate the certificate
        """
        ServiceComputeLoggingHttp._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            url=url,
            content_type=content_type,
            header_name=header_name,
            header_value=header_value,
            json_format=json_format,
            message_type=message_type,
            method=method,
            request_max_bytes=request_max_bytes,
            request_max_entries=request_max_entries,
            tls_ca_cert=tls_ca_cert,
            tls_client_cert=tls_client_cert,
            tls_client_key=tls_client_key,
            tls_hostname=tls_hostname,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             url: Optional[str] = None,
             content_type: Optional[str] = None,
             header_name: Optional[str] = None,
             header_value: Optional[str] = None,
             json_format: Optional[str] = None,
             message_type: Optional[str] = None,
             method: Optional[str] = None,
             request_max_bytes: Optional[int] = None,
             request_max_entries: Optional[int] = None,
             tls_ca_cert: Optional[str] = None,
             tls_client_cert: Optional[str] = None,
             tls_client_key: Optional[str] = None,
             tls_hostname: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")
        if content_type is None and 'contentType' in kwargs:
            content_type = kwargs['contentType']
        if header_name is None and 'headerName' in kwargs:
            header_name = kwargs['headerName']
        if header_value is None and 'headerValue' in kwargs:
            header_value = kwargs['headerValue']
        if json_format is None and 'jsonFormat' in kwargs:
            json_format = kwargs['jsonFormat']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if request_max_bytes is None and 'requestMaxBytes' in kwargs:
            request_max_bytes = kwargs['requestMaxBytes']
        if request_max_entries is None and 'requestMaxEntries' in kwargs:
            request_max_entries = kwargs['requestMaxEntries']
        if tls_ca_cert is None and 'tlsCaCert' in kwargs:
            tls_ca_cert = kwargs['tlsCaCert']
        if tls_client_cert is None and 'tlsClientCert' in kwargs:
            tls_client_cert = kwargs['tlsClientCert']
        if tls_client_key is None and 'tlsClientKey' in kwargs:
            tls_client_key = kwargs['tlsClientKey']
        if tls_hostname is None and 'tlsHostname' in kwargs:
            tls_hostname = kwargs['tlsHostname']

        _setter("name", name)
        _setter("url", url)
        if content_type is not None:
            _setter("content_type", content_type)
        if header_name is not None:
            _setter("header_name", header_name)
        if header_value is not None:
            _setter("header_value", header_value)
        if json_format is not None:
            _setter("json_format", json_format)
        if message_type is not None:
            _setter("message_type", message_type)
        if method is not None:
            _setter("method", method)
        if request_max_bytes is not None:
            _setter("request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            _setter("request_max_entries", request_max_entries)
        if tls_ca_cert is not None:
            _setter("tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            _setter("tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            _setter("tls_client_key", tls_client_key)
        if tls_hostname is not None:
            _setter("tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL that log data will be sent to. Must use the https protocol
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        Value of the `Content-Type` header sent with the request
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[str]:
        """
        Custom header sent with the request
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[str]:
        """
        Value of the custom header sent with the request
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter(name="jsonFormat")
    def json_format(self) -> Optional[str]:
        """
        Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        """
        return pulumi.get(self, "json_format")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[int]:
        """
        The maximum number of bytes sent in one request
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[int]:
        """
        The maximum number of logs sent in one request
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")


@pulumi.output_type
class ServiceComputeLoggingKafka(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMethod":
            suggest = "auth_method"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "parseLogKeyvals":
            suggest = "parse_log_keyvals"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requiredAcks":
            suggest = "required_acks"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingKafka. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingKafka.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingKafka.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 brokers: str,
                 name: str,
                 topic: str,
                 auth_method: Optional[str] = None,
                 compression_codec: Optional[str] = None,
                 parse_log_keyvals: Optional[bool] = None,
                 password: Optional[str] = None,
                 request_max_bytes: Optional[int] = None,
                 required_acks: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 use_tls: Optional[bool] = None,
                 user: Optional[str] = None):
        """
        :param str brokers: A comma-separated list of IP addresses or hostnames of Kafka brokers
        :param str name: The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str topic: The Kafka topic to send logs to
        :param str auth_method: SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        :param str compression_codec: The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        :param bool parse_log_keyvals: Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        :param str password: SASL Pass
        :param int request_max_bytes: Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        :param str required_acks: The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1` Wait for all in-sync replicas to respond
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param bool use_tls: Whether to use TLS for secure logging. Can be either `true` or `false`
        :param str user: SASL User
        """
        ServiceComputeLoggingKafka._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            brokers=brokers,
            name=name,
            topic=topic,
            auth_method=auth_method,
            compression_codec=compression_codec,
            parse_log_keyvals=parse_log_keyvals,
            password=password,
            request_max_bytes=request_max_bytes,
            required_acks=required_acks,
            tls_ca_cert=tls_ca_cert,
            tls_client_cert=tls_client_cert,
            tls_client_key=tls_client_key,
            tls_hostname=tls_hostname,
            use_tls=use_tls,
            user=user,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             brokers: Optional[str] = None,
             name: Optional[str] = None,
             topic: Optional[str] = None,
             auth_method: Optional[str] = None,
             compression_codec: Optional[str] = None,
             parse_log_keyvals: Optional[bool] = None,
             password: Optional[str] = None,
             request_max_bytes: Optional[int] = None,
             required_acks: Optional[str] = None,
             tls_ca_cert: Optional[str] = None,
             tls_client_cert: Optional[str] = None,
             tls_client_key: Optional[str] = None,
             tls_hostname: Optional[str] = None,
             use_tls: Optional[bool] = None,
             user: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if brokers is None:
            raise TypeError("Missing 'brokers' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if topic is None:
            raise TypeError("Missing 'topic' argument")
        if auth_method is None and 'authMethod' in kwargs:
            auth_method = kwargs['authMethod']
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if parse_log_keyvals is None and 'parseLogKeyvals' in kwargs:
            parse_log_keyvals = kwargs['parseLogKeyvals']
        if request_max_bytes is None and 'requestMaxBytes' in kwargs:
            request_max_bytes = kwargs['requestMaxBytes']
        if required_acks is None and 'requiredAcks' in kwargs:
            required_acks = kwargs['requiredAcks']
        if tls_ca_cert is None and 'tlsCaCert' in kwargs:
            tls_ca_cert = kwargs['tlsCaCert']
        if tls_client_cert is None and 'tlsClientCert' in kwargs:
            tls_client_cert = kwargs['tlsClientCert']
        if tls_client_key is None and 'tlsClientKey' in kwargs:
            tls_client_key = kwargs['tlsClientKey']
        if tls_hostname is None and 'tlsHostname' in kwargs:
            tls_hostname = kwargs['tlsHostname']
        if use_tls is None and 'useTls' in kwargs:
            use_tls = kwargs['useTls']

        _setter("brokers", brokers)
        _setter("name", name)
        _setter("topic", topic)
        if auth_method is not None:
            _setter("auth_method", auth_method)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if parse_log_keyvals is not None:
            _setter("parse_log_keyvals", parse_log_keyvals)
        if password is not None:
            _setter("password", password)
        if request_max_bytes is not None:
            _setter("request_max_bytes", request_max_bytes)
        if required_acks is not None:
            _setter("required_acks", required_acks)
        if tls_ca_cert is not None:
            _setter("tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            _setter("tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            _setter("tls_client_key", tls_client_key)
        if tls_hostname is not None:
            _setter("tls_hostname", tls_hostname)
        if use_tls is not None:
            _setter("use_tls", use_tls)
        if user is not None:
            _setter("user", user)

    @property
    @pulumi.getter
    def brokers(self) -> str:
        """
        A comma-separated list of IP addresses or hostnames of Kafka brokers
        """
        return pulumi.get(self, "brokers")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Kafka topic to send logs to
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[str]:
        """
        SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        """
        return pulumi.get(self, "auth_method")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="parseLogKeyvals")
    def parse_log_keyvals(self) -> Optional[bool]:
        """
        Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        """
        return pulumi.get(self, "parse_log_keyvals")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        SASL Pass
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[int]:
        """
        Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requiredAcks")
    def required_acks(self) -> Optional[str]:
        """
        The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1` Wait for all in-sync replicas to respond
        """
        return pulumi.get(self, "required_acks")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Can be either `true` or `false`
        """
        return pulumi.get(self, "use_tls")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        SASL User
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingKinese(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "iamRole":
            suggest = "iam_role"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingKinese. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingKinese.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingKinese.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 topic: str,
                 access_key: Optional[str] = None,
                 iam_role: Optional[str] = None,
                 region: Optional[str] = None,
                 secret_key: Optional[str] = None):
        """
        :param str name: The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str topic: The Kinesis stream name
        :param str access_key: The AWS access key to be used to write to the stream
        :param str iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        :param str region: The AWS region the stream resides in. (Default: `us-east-1`)
        :param str secret_key: The AWS secret access key to authenticate with
        """
        ServiceComputeLoggingKinese._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            topic=topic,
            access_key=access_key,
            iam_role=iam_role,
            region=region,
            secret_key=secret_key,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             topic: Optional[str] = None,
             access_key: Optional[str] = None,
             iam_role: Optional[str] = None,
             region: Optional[str] = None,
             secret_key: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if topic is None:
            raise TypeError("Missing 'topic' argument")
        if access_key is None and 'accessKey' in kwargs:
            access_key = kwargs['accessKey']
        if iam_role is None and 'iamRole' in kwargs:
            iam_role = kwargs['iamRole']
        if secret_key is None and 'secretKey' in kwargs:
            secret_key = kwargs['secretKey']

        _setter("name", name)
        _setter("topic", topic)
        if access_key is not None:
            _setter("access_key", access_key)
        if iam_role is not None:
            _setter("iam_role", iam_role)
        if region is not None:
            _setter("region", region)
        if secret_key is not None:
            _setter("secret_key", secret_key)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Kinesis stream name
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[str]:
        """
        The AWS access key to be used to write to the stream
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        """
        return pulumi.get(self, "iam_role")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The AWS region the stream resides in. (Default: `us-east-1`)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The AWS secret access key to authenticate with
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class ServiceComputeLoggingLogentry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingLogentry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingLogentry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingLogentry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 port: Optional[int] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str name: The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: Use token based authentication (https://logentries.com/doc/input-token/)
        :param int port: The port number configured in Logentries
        :param bool use_tls: Whether to use TLS for secure logging
        """
        ServiceComputeLoggingLogentry._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            port=port,
            use_tls=use_tls,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             port: Optional[int] = None,
             use_tls: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if use_tls is None and 'useTls' in kwargs:
            use_tls = kwargs['useTls']

        _setter("name", name)
        _setter("token", token)
        if port is not None:
            _setter("port", port)
        if use_tls is not None:
            _setter("use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Use token based authentication (https://logentries.com/doc/input-token/)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number configured in Logentries
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceComputeLoggingLoggly(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str):
        """
        :param str name: The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        ServiceComputeLoggingLoggly._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")

        _setter("name", name)
        _setter("token", token)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceComputeLoggingLogshuttle(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str):
        """
        :param str name: The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The data authentication token associated with this endpoint
        :param str url: Your Log Shuttle endpoint URL
        """
        ServiceComputeLoggingLogshuttle._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            url=url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             url: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")

        _setter("name", name)
        _setter("token", token)
        _setter("url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your Log Shuttle endpoint URL
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ServiceComputeLoggingNewrelic(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 region: Optional[str] = None):
        """
        :param str name: The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The Insert API key from the Account page of your New Relic account
        :param str region: The region that log data will be sent to. Default: `US`
        """
        ServiceComputeLoggingNewrelic._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            region=region,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             region: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")

        _setter("name", name)
        _setter("token", token)
        if region is not None:
            _setter("region", region)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Insert API key from the Account page of your New Relic account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region that log data will be sent to. Default: `US`
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ServiceComputeLoggingOpenstack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingOpenstack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingOpenstack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingOpenstack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 url: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 public_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your OpenStack account access key
        :param str bucket_name: The name of your OpenStack container
        :param str name: The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: Your OpenStack auth url
        :param str user: The username for your OpenStack account
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceComputeLoggingOpenstack._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_key=access_key,
            bucket_name=bucket_name,
            name=name,
            url=url,
            user=user,
            compression_codec=compression_codec,
            gzip_level=gzip_level,
            message_type=message_type,
            path=path,
            period=period,
            public_key=public_key,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_key: Optional[str] = None,
             bucket_name: Optional[str] = None,
             name: Optional[str] = None,
             url: Optional[str] = None,
             user: Optional[str] = None,
             compression_codec: Optional[str] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             path: Optional[str] = None,
             period: Optional[int] = None,
             public_key: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if access_key is None and 'accessKey' in kwargs:
            access_key = kwargs['accessKey']
        if access_key is None:
            raise TypeError("Missing 'access_key' argument")
        if bucket_name is None and 'bucketName' in kwargs:
            bucket_name = kwargs['bucketName']
        if bucket_name is None:
            raise TypeError("Missing 'bucket_name' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")
        if user is None:
            raise TypeError("Missing 'user' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("access_key", access_key)
        _setter("bucket_name", bucket_name)
        _setter("name", name)
        _setter("url", url)
        _setter("user", user)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if path is not None:
            _setter("path", path)
        if period is not None:
            _setter("period", period)
        if public_key is not None:
            _setter("public_key", public_key)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your OpenStack account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your OpenStack container
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your OpenStack account
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingPapertrail(dict):
    def __init__(__self__, *,
                 address: str,
                 name: str,
                 port: int):
        """
        :param str address: The address of the Papertrail endpoint
        :param str name: A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param int port: The port associated with the address where the Papertrail endpoint can be accessed
        """
        ServiceComputeLoggingPapertrail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            name=name,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             name: Optional[str] = None,
             port: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if address is None:
            raise TypeError("Missing 'address' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if port is None:
            raise TypeError("Missing 'port' argument")

        _setter("address", address)
        _setter("name", name)
        _setter("port", port)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The address of the Papertrail endpoint
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port associated with the address where the Papertrail endpoint can be accessed
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceComputeLoggingS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "s3AccessKey":
            suggest = "s3_access_key"
        elif key == "s3IamRole":
            suggest = "s3_iam_role"
        elif key == "s3SecretKey":
            suggest = "s3_secret_key"
        elif key == "serverSideEncryption":
            suggest = "server_side_encryption"
        elif key == "serverSideEncryptionKmsKeyId":
            suggest = "server_side_encryption_kms_key_id"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 name: str,
                 acl: Optional[str] = None,
                 compression_codec: Optional[str] = None,
                 domain: Optional[str] = None,
                 file_max_bytes: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 public_key: Optional[str] = None,
                 redundancy: Optional[str] = None,
                 s3_access_key: Optional[str] = None,
                 s3_iam_role: Optional[str] = None,
                 s3_secret_key: Optional[str] = None,
                 server_side_encryption: Optional[str] = None,
                 server_side_encryption_kms_key_id: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str bucket_name: The name of the bucket in which to store the logs
        :param str name: The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str acl: The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str domain: If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        :param int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str redundancy: The S3 storage class (redundancy level). Should be one of: `standard`, `intelligent_tiering`, `standard_ia`, `onezone_ia`, `glacier`, `glacier_ir`, `deep_archive`, or `reduced_redundancy`
        :param str s3_access_key: AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        :param str s3_iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        :param str s3_secret_key: AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        :param str server_side_encryption: Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        :param str server_side_encryption_kms_key_id: Optional server-side KMS Key Id. Must be set if server*side*encryption is set to `aws:kms`
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceComputeLoggingS3._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket_name=bucket_name,
            name=name,
            acl=acl,
            compression_codec=compression_codec,
            domain=domain,
            file_max_bytes=file_max_bytes,
            gzip_level=gzip_level,
            message_type=message_type,
            path=path,
            period=period,
            public_key=public_key,
            redundancy=redundancy,
            s3_access_key=s3_access_key,
            s3_iam_role=s3_iam_role,
            s3_secret_key=s3_secret_key,
            server_side_encryption=server_side_encryption,
            server_side_encryption_kms_key_id=server_side_encryption_kms_key_id,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket_name: Optional[str] = None,
             name: Optional[str] = None,
             acl: Optional[str] = None,
             compression_codec: Optional[str] = None,
             domain: Optional[str] = None,
             file_max_bytes: Optional[int] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             path: Optional[str] = None,
             period: Optional[int] = None,
             public_key: Optional[str] = None,
             redundancy: Optional[str] = None,
             s3_access_key: Optional[str] = None,
             s3_iam_role: Optional[str] = None,
             s3_secret_key: Optional[str] = None,
             server_side_encryption: Optional[str] = None,
             server_side_encryption_kms_key_id: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if bucket_name is None and 'bucketName' in kwargs:
            bucket_name = kwargs['bucketName']
        if bucket_name is None:
            raise TypeError("Missing 'bucket_name' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if file_max_bytes is None and 'fileMaxBytes' in kwargs:
            file_max_bytes = kwargs['fileMaxBytes']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if s3_access_key is None and 's3AccessKey' in kwargs:
            s3_access_key = kwargs['s3AccessKey']
        if s3_iam_role is None and 's3IamRole' in kwargs:
            s3_iam_role = kwargs['s3IamRole']
        if s3_secret_key is None and 's3SecretKey' in kwargs:
            s3_secret_key = kwargs['s3SecretKey']
        if server_side_encryption is None and 'serverSideEncryption' in kwargs:
            server_side_encryption = kwargs['serverSideEncryption']
        if server_side_encryption_kms_key_id is None and 'serverSideEncryptionKmsKeyId' in kwargs:
            server_side_encryption_kms_key_id = kwargs['serverSideEncryptionKmsKeyId']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("bucket_name", bucket_name)
        _setter("name", name)
        if acl is not None:
            _setter("acl", acl)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if domain is not None:
            _setter("domain", domain)
        if file_max_bytes is not None:
            _setter("file_max_bytes", file_max_bytes)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if path is not None:
            _setter("path", path)
        if period is not None:
            _setter("period", period)
        if public_key is not None:
            _setter("public_key", public_key)
        if redundancy is not None:
            _setter("redundancy", redundancy)
        if s3_access_key is not None:
            _setter("s3_access_key", s3_access_key)
        if s3_iam_role is not None:
            _setter("s3_iam_role", s3_iam_role)
        if s3_secret_key is not None:
            _setter("s3_secret_key", s3_secret_key)
        if server_side_encryption is not None:
            _setter("server_side_encryption", server_side_encryption)
        if server_side_encryption_kms_key_id is not None:
            _setter("server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def acl(self) -> Optional[str]:
        """
        The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def redundancy(self) -> Optional[str]:
        """
        The S3 storage class (redundancy level). Should be one of: `standard`, `intelligent_tiering`, `standard_ia`, `onezone_ia`, `glacier`, `glacier_ir`, `deep_archive`, or `reduced_redundancy`
        """
        return pulumi.get(self, "redundancy")

    @property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> Optional[str]:
        """
        AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        """
        return pulumi.get(self, "s3_access_key")

    @property
    @pulumi.getter(name="s3IamRole")
    def s3_iam_role(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        """
        return pulumi.get(self, "s3_iam_role")

    @property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> Optional[str]:
        """
        AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        """
        return pulumi.get(self, "s3_secret_key")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[str]:
        """
        Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[str]:
        """
        Optional server-side KMS Key Id. Must be set if server*side*encryption is set to `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingScalyr(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 region: Optional[str] = None):
        """
        :param str name: The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The token to use for authentication (https://www.scalyr.com/keys)
        :param str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        ServiceComputeLoggingScalyr._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            region=region,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             region: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")

        _setter("name", name)
        _setter("token", token)
        if region is not None:
            _setter("region", region)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to use for authentication (https://www.scalyr.com/keys)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ServiceComputeLoggingSftp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKnownHosts":
            suggest = "ssh_known_hosts"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSftp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSftp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSftp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 path: str,
                 ssh_known_hosts: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 password: Optional[str] = None,
                 period: Optional[int] = None,
                 port: Optional[int] = None,
                 public_key: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str address: The SFTP address to stream logs to
        :param str name: The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param str ssh_known_hosts: A list of host keys for all hosts we can connect to over SFTP
        :param str user: The username for the server
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param int port: The port the SFTP service listens on. (Default: `22`)
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str secret_key: The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceComputeLoggingSftp._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            name=name,
            path=path,
            ssh_known_hosts=ssh_known_hosts,
            user=user,
            compression_codec=compression_codec,
            gzip_level=gzip_level,
            message_type=message_type,
            password=password,
            period=period,
            port=port,
            public_key=public_key,
            secret_key=secret_key,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             name: Optional[str] = None,
             path: Optional[str] = None,
             ssh_known_hosts: Optional[str] = None,
             user: Optional[str] = None,
             compression_codec: Optional[str] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             password: Optional[str] = None,
             period: Optional[int] = None,
             port: Optional[int] = None,
             public_key: Optional[str] = None,
             secret_key: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if address is None:
            raise TypeError("Missing 'address' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if path is None:
            raise TypeError("Missing 'path' argument")
        if ssh_known_hosts is None and 'sshKnownHosts' in kwargs:
            ssh_known_hosts = kwargs['sshKnownHosts']
        if ssh_known_hosts is None:
            raise TypeError("Missing 'ssh_known_hosts' argument")
        if user is None:
            raise TypeError("Missing 'user' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if secret_key is None and 'secretKey' in kwargs:
            secret_key = kwargs['secretKey']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("address", address)
        _setter("name", name)
        _setter("path", path)
        _setter("ssh_known_hosts", ssh_known_hosts)
        _setter("user", user)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if password is not None:
            _setter("password", password)
        if period is not None:
            _setter("period", period)
        if port is not None:
            _setter("port", port)
        if public_key is not None:
            _setter("public_key", public_key)
        if secret_key is not None:
            _setter("secret_key", secret_key)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> str:
        """
        A list of host keys for all hosts we can connect to over SFTP
        """
        return pulumi.get(self, "ssh_known_hosts")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for the server
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port the SFTP service listens on. (Default: `22`)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingSplunk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSplunk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSplunk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSplunk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str name: A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The Splunk token to be used for authentication
        :param str url: The Splunk URL to stream logs to
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param bool use_tls: Whether to use TLS for secure logging. Default: `false`
        """
        ServiceComputeLoggingSplunk._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            url=url,
            tls_ca_cert=tls_ca_cert,
            tls_client_cert=tls_client_cert,
            tls_client_key=tls_client_key,
            tls_hostname=tls_hostname,
            use_tls=use_tls,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             url: Optional[str] = None,
             tls_ca_cert: Optional[str] = None,
             tls_client_cert: Optional[str] = None,
             tls_client_key: Optional[str] = None,
             tls_hostname: Optional[str] = None,
             use_tls: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")
        if tls_ca_cert is None and 'tlsCaCert' in kwargs:
            tls_ca_cert = kwargs['tlsCaCert']
        if tls_client_cert is None and 'tlsClientCert' in kwargs:
            tls_client_cert = kwargs['tlsClientCert']
        if tls_client_key is None and 'tlsClientKey' in kwargs:
            tls_client_key = kwargs['tlsClientKey']
        if tls_hostname is None and 'tlsHostname' in kwargs:
            tls_hostname = kwargs['tlsHostname']
        if use_tls is None and 'useTls' in kwargs:
            use_tls = kwargs['useTls']

        _setter("name", name)
        _setter("token", token)
        _setter("url", url)
        if tls_ca_cert is not None:
            _setter("tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            _setter("tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            _setter("tls_client_key", tls_client_key)
        if tls_hostname is not None:
            _setter("tls_hostname", tls_hostname)
        if use_tls is not None:
            _setter("use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Splunk token to be used for authentication
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The Splunk URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Default: `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceComputeLoggingSumologic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageType":
            suggest = "message_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSumologic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSumologic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSumologic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 url: str,
                 message_type: Optional[str] = None):
        """
        :param str name: A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: The URL to Sumologic collector endpoint
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        ServiceComputeLoggingSumologic._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            url=url,
            message_type=message_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             url: Optional[str] = None,
             message_type: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']

        _setter("name", name)
        _setter("url", url)
        if message_type is not None:
            _setter("message_type", message_type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL to Sumologic collector endpoint
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")


@pulumi.output_type
class ServiceComputeLoggingSyslog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageType":
            suggest = "message_type"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSyslog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSyslog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSyslog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 message_type: Optional[str] = None,
                 port: Optional[int] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 token: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str address: A hostname or IPv4 address of the Syslog endpoint
        :param str name: A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param int port: The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        :param str tls_hostname: Used during the TLS handshake to validate the certificate
        :param str token: Whether to prepend each message with a specific token
        :param bool use_tls: Whether to use TLS for secure logging. Default `false`
        """
        ServiceComputeLoggingSyslog._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            name=name,
            message_type=message_type,
            port=port,
            tls_ca_cert=tls_ca_cert,
            tls_client_cert=tls_client_cert,
            tls_client_key=tls_client_key,
            tls_hostname=tls_hostname,
            token=token,
            use_tls=use_tls,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             name: Optional[str] = None,
             message_type: Optional[str] = None,
             port: Optional[int] = None,
             tls_ca_cert: Optional[str] = None,
             tls_client_cert: Optional[str] = None,
             tls_client_key: Optional[str] = None,
             tls_hostname: Optional[str] = None,
             token: Optional[str] = None,
             use_tls: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if address is None:
            raise TypeError("Missing 'address' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if tls_ca_cert is None and 'tlsCaCert' in kwargs:
            tls_ca_cert = kwargs['tlsCaCert']
        if tls_client_cert is None and 'tlsClientCert' in kwargs:
            tls_client_cert = kwargs['tlsClientCert']
        if tls_client_key is None and 'tlsClientKey' in kwargs:
            tls_client_key = kwargs['tlsClientKey']
        if tls_hostname is None and 'tlsHostname' in kwargs:
            tls_hostname = kwargs['tlsHostname']
        if use_tls is None and 'useTls' in kwargs:
            use_tls = kwargs['useTls']

        _setter("address", address)
        _setter("name", name)
        if message_type is not None:
            _setter("message_type", message_type)
        if port is not None:
            _setter("port", port)
        if tls_ca_cert is not None:
            _setter("tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            _setter("tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            _setter("tls_client_key", tls_client_key)
        if tls_hostname is not None:
            _setter("tls_hostname", tls_hostname)
        if token is not None:
            _setter("token", token)
        if use_tls is not None:
            _setter("use_tls", use_tls)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        A hostname or IPv4 address of the Syslog endpoint
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        Whether to prepend each message with a specific token
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Default `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceComputePackage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceCodeHash":
            suggest = "source_code_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputePackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputePackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputePackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: Optional[str] = None,
                 filename: Optional[str] = None,
                 source_code_hash: Optional[str] = None):
        """
        :param str content: The contents of the Wasm deployment package as a base64 encoded string (e.g. could be provided using an input variable or via external data source output variable). Conflicts with `filename`. Exactly one of these two arguments must be specified
        :param str filename: The path to the Wasm deployment package within your local filesystem. Conflicts with `content`. Exactly one of these two arguments must be specified
        :param str source_code_hash: Used to trigger updates. Must be set to a SHA512 hash of all files (in sorted order) within the package. The usual way to set this is using the fastly*package*hash data source.
        """
        ServiceComputePackage._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            filename=filename,
            source_code_hash=source_code_hash,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: Optional[str] = None,
             filename: Optional[str] = None,
             source_code_hash: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if source_code_hash is None and 'sourceCodeHash' in kwargs:
            source_code_hash = kwargs['sourceCodeHash']

        if content is not None:
            _setter("content", content)
        if filename is not None:
            _setter("filename", filename)
        if source_code_hash is not None:
            _setter("source_code_hash", source_code_hash)

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        The contents of the Wasm deployment package as a base64 encoded string (e.g. could be provided using an input variable or via external data source output variable). Conflicts with `filename`. Exactly one of these two arguments must be specified
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def filename(self) -> Optional[str]:
        """
        The path to the Wasm deployment package within your local filesystem. Conflicts with `content`. Exactly one of these two arguments must be specified
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[str]:
        """
        Used to trigger updates. Must be set to a SHA512 hash of all files (in sorted order) within the package. The usual way to set this is using the fastly*package*hash data source.
        """
        return pulumi.get(self, "source_code_hash")


@pulumi.output_type
class ServiceComputeProductEnablement(dict):
    def __init__(__self__, *,
                 fanout: Optional[bool] = None,
                 name: Optional[str] = None,
                 websockets: Optional[bool] = None):
        """
        :param bool fanout: Enable Fanout support
        :param str name: Used by the provider to identify modified settings (changing this value will force the entire block to be deleted, then recreated)
        :param bool websockets: Enable WebSockets support
        """
        ServiceComputeProductEnablement._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            fanout=fanout,
            name=name,
            websockets=websockets,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             fanout: Optional[bool] = None,
             name: Optional[str] = None,
             websockets: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):

        if fanout is not None:
            _setter("fanout", fanout)
        if name is not None:
            _setter("name", name)
        if websockets is not None:
            _setter("websockets", websockets)

    @property
    @pulumi.getter
    def fanout(self) -> Optional[bool]:
        """
        Enable Fanout support
        """
        return pulumi.get(self, "fanout")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Used by the provider to identify modified settings (changing this value will force the entire block to be deleted, then recreated)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def websockets(self) -> Optional[bool]:
        """
        Enable WebSockets support
        """
        return pulumi.get(self, "websockets")


@pulumi.output_type
class ServiceComputeResourceLink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "linkId":
            suggest = "link_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeResourceLink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeResourceLink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeResourceLink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 resource_id: str,
                 link_id: Optional[str] = None):
        """
        :param str name: The name of the resource link.
        :param str resource_id: The ID of the underlying linked resource.
        :param str link_id: An alphanumeric string identifying the resource link.
        """
        ServiceComputeResourceLink._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            resource_id=resource_id,
            link_id=link_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             resource_id: Optional[str] = None,
             link_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if resource_id is None and 'resourceId' in kwargs:
            resource_id = kwargs['resourceId']
        if resource_id is None:
            raise TypeError("Missing 'resource_id' argument")
        if link_id is None and 'linkId' in kwargs:
            link_id = kwargs['linkId']

        _setter("name", name)
        _setter("resource_id", resource_id)
        if link_id is not None:
            _setter("link_id", link_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource link.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The ID of the underlying linked resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="linkId")
    def link_id(self) -> Optional[str]:
        """
        An alphanumeric string identifying the resource link.
        """
        return pulumi.get(self, "link_id")


@pulumi.output_type
class ServiceVclAcl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aclId":
            suggest = "acl_id"
        elif key == "forceDestroy":
            suggest = "force_destroy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclAcl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclAcl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclAcl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 acl_id: Optional[str] = None,
                 force_destroy: Optional[bool] = None):
        """
        :param str name: A unique name to identify this ACL. It is important to note that changing this attribute will delete and recreate the ACL, and discard the current items in the ACL
        :param str acl_id: The ID of the ACL
        :param bool force_destroy: Allow the ACL to be deleted, even if it contains entries. Defaults to false.
        """
        ServiceVclAcl._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            acl_id=acl_id,
            force_destroy=force_destroy,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             acl_id: Optional[str] = None,
             force_destroy: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if acl_id is None and 'aclId' in kwargs:
            acl_id = kwargs['aclId']
        if force_destroy is None and 'forceDestroy' in kwargs:
            force_destroy = kwargs['forceDestroy']

        _setter("name", name)
        if acl_id is not None:
            _setter("acl_id", acl_id)
        if force_destroy is not None:
            _setter("force_destroy", force_destroy)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this ACL. It is important to note that changing this attribute will delete and recreate the ACL, and discard the current items in the ACL
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[str]:
        """
        The ID of the ACL
        """
        return pulumi.get(self, "acl_id")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[bool]:
        """
        Allow the ACL to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")


@pulumi.output_type
class ServiceVclBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoLoadbalance":
            suggest = "auto_loadbalance"
        elif key == "betweenBytesTimeout":
            suggest = "between_bytes_timeout"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "errorThreshold":
            suggest = "error_threshold"
        elif key == "firstByteTimeout":
            suggest = "first_byte_timeout"
        elif key == "keepaliveTime":
            suggest = "keepalive_time"
        elif key == "maxConn":
            suggest = "max_conn"
        elif key == "maxTlsVersion":
            suggest = "max_tls_version"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "overrideHost":
            suggest = "override_host"
        elif key == "requestCondition":
            suggest = "request_condition"
        elif key == "shareKey":
            suggest = "share_key"
        elif key == "sslCaCert":
            suggest = "ssl_ca_cert"
        elif key == "sslCertHostname":
            suggest = "ssl_cert_hostname"
        elif key == "sslCheckCert":
            suggest = "ssl_check_cert"
        elif key == "sslCiphers":
            suggest = "ssl_ciphers"
        elif key == "sslClientCert":
            suggest = "ssl_client_cert"
        elif key == "sslClientKey":
            suggest = "ssl_client_key"
        elif key == "sslSniHostname":
            suggest = "ssl_sni_hostname"
        elif key == "useSsl":
            suggest = "use_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 auto_loadbalance: Optional[bool] = None,
                 between_bytes_timeout: Optional[int] = None,
                 connect_timeout: Optional[int] = None,
                 error_threshold: Optional[int] = None,
                 first_byte_timeout: Optional[int] = None,
                 healthcheck: Optional[str] = None,
                 keepalive_time: Optional[int] = None,
                 max_conn: Optional[int] = None,
                 max_tls_version: Optional[str] = None,
                 min_tls_version: Optional[str] = None,
                 override_host: Optional[str] = None,
                 port: Optional[int] = None,
                 request_condition: Optional[str] = None,
                 share_key: Optional[str] = None,
                 shield: Optional[str] = None,
                 ssl_ca_cert: Optional[str] = None,
                 ssl_cert_hostname: Optional[str] = None,
                 ssl_check_cert: Optional[bool] = None,
                 ssl_ciphers: Optional[str] = None,
                 ssl_client_cert: Optional[str] = None,
                 ssl_client_key: Optional[str] = None,
                 ssl_sni_hostname: Optional[str] = None,
                 use_ssl: Optional[bool] = None,
                 weight: Optional[int] = None):
        """
        :param str address: An IPv4, hostname, or IPv6 address for the Backend
        :param str name: Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        :param bool auto_loadbalance: Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `false`
        :param int between_bytes_timeout: How long to wait between bytes in milliseconds. Default `10000`
        :param int connect_timeout: How long to wait for a timeout in milliseconds. Default `1000`
        :param int error_threshold: Number of errors to allow before the Backend is marked as down. Default `0`
        :param int first_byte_timeout: How long to wait for the first bytes in milliseconds. Default `15000`
        :param str healthcheck: Name of a defined `healthcheck` to assign to this backend
        :param int keepalive_time: How long in seconds to keep a persistent connection to the backend between requests.
        :param int max_conn: Maximum number of connections for this Backend. Default `200`
        :param str max_tls_version: Maximum allowed TLS version on SSL connections to this backend.
        :param str min_tls_version: Minimum allowed TLS version on SSL connections to this backend.
        :param str override_host: The hostname to override the Host header
        :param int port: The port number on which the Backend responds. Default `80`
        :param str request_condition: Name of a condition, which if met, will select this backend during a request.
        :param str share_key: Value that when shared across backends will enable those backends to share the same health check.
        :param str shield: The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        :param str ssl_ca_cert: CA certificate attached to origin.
        :param str ssl_cert_hostname: Configure certificate validation. Does not affect SNI at all
        :param bool ssl_check_cert: Be strict about checking SSL certs. Default `true`
        :param str ssl_ciphers: Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        :param str ssl_client_cert: Client certificate attached to origin. Used when connecting to the backend
        :param str ssl_client_key: Client key attached to origin. Used when connecting to the backend
        :param str ssl_sni_hostname: Configure SNI in the TLS handshake. Does not affect cert validation at all
        :param bool use_ssl: Whether or not to use SSL to reach the Backend. Default `false`
        :param int weight: The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        ServiceVclBackend._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            name=name,
            auto_loadbalance=auto_loadbalance,
            between_bytes_timeout=between_bytes_timeout,
            connect_timeout=connect_timeout,
            error_threshold=error_threshold,
            first_byte_timeout=first_byte_timeout,
            healthcheck=healthcheck,
            keepalive_time=keepalive_time,
            max_conn=max_conn,
            max_tls_version=max_tls_version,
            min_tls_version=min_tls_version,
            override_host=override_host,
            port=port,
            request_condition=request_condition,
            share_key=share_key,
            shield=shield,
            ssl_ca_cert=ssl_ca_cert,
            ssl_cert_hostname=ssl_cert_hostname,
            ssl_check_cert=ssl_check_cert,
            ssl_ciphers=ssl_ciphers,
            ssl_client_cert=ssl_client_cert,
            ssl_client_key=ssl_client_key,
            ssl_sni_hostname=ssl_sni_hostname,
            use_ssl=use_ssl,
            weight=weight,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             name: Optional[str] = None,
             auto_loadbalance: Optional[bool] = None,
             between_bytes_timeout: Optional[int] = None,
             connect_timeout: Optional[int] = None,
             error_threshold: Optional[int] = None,
             first_byte_timeout: Optional[int] = None,
             healthcheck: Optional[str] = None,
             keepalive_time: Optional[int] = None,
             max_conn: Optional[int] = None,
             max_tls_version: Optional[str] = None,
             min_tls_version: Optional[str] = None,
             override_host: Optional[str] = None,
             port: Optional[int] = None,
             request_condition: Optional[str] = None,
             share_key: Optional[str] = None,
             shield: Optional[str] = None,
             ssl_ca_cert: Optional[str] = None,
             ssl_cert_hostname: Optional[str] = None,
             ssl_check_cert: Optional[bool] = None,
             ssl_ciphers: Optional[str] = None,
             ssl_client_cert: Optional[str] = None,
             ssl_client_key: Optional[str] = None,
             ssl_sni_hostname: Optional[str] = None,
             use_ssl: Optional[bool] = None,
             weight: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if address is None:
            raise TypeError("Missing 'address' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if auto_loadbalance is None and 'autoLoadbalance' in kwargs:
            auto_loadbalance = kwargs['autoLoadbalance']
        if between_bytes_timeout is None and 'betweenBytesTimeout' in kwargs:
            between_bytes_timeout = kwargs['betweenBytesTimeout']
        if connect_timeout is None and 'connectTimeout' in kwargs:
            connect_timeout = kwargs['connectTimeout']
        if error_threshold is None and 'errorThreshold' in kwargs:
            error_threshold = kwargs['errorThreshold']
        if first_byte_timeout is None and 'firstByteTimeout' in kwargs:
            first_byte_timeout = kwargs['firstByteTimeout']
        if keepalive_time is None and 'keepaliveTime' in kwargs:
            keepalive_time = kwargs['keepaliveTime']
        if max_conn is None and 'maxConn' in kwargs:
            max_conn = kwargs['maxConn']
        if max_tls_version is None and 'maxTlsVersion' in kwargs:
            max_tls_version = kwargs['maxTlsVersion']
        if min_tls_version is None and 'minTlsVersion' in kwargs:
            min_tls_version = kwargs['minTlsVersion']
        if override_host is None and 'overrideHost' in kwargs:
            override_host = kwargs['overrideHost']
        if request_condition is None and 'requestCondition' in kwargs:
            request_condition = kwargs['requestCondition']
        if share_key is None and 'shareKey' in kwargs:
            share_key = kwargs['shareKey']
        if ssl_ca_cert is None and 'sslCaCert' in kwargs:
            ssl_ca_cert = kwargs['sslCaCert']
        if ssl_cert_hostname is None and 'sslCertHostname' in kwargs:
            ssl_cert_hostname = kwargs['sslCertHostname']
        if ssl_check_cert is None and 'sslCheckCert' in kwargs:
            ssl_check_cert = kwargs['sslCheckCert']
        if ssl_ciphers is None and 'sslCiphers' in kwargs:
            ssl_ciphers = kwargs['sslCiphers']
        if ssl_client_cert is None and 'sslClientCert' in kwargs:
            ssl_client_cert = kwargs['sslClientCert']
        if ssl_client_key is None and 'sslClientKey' in kwargs:
            ssl_client_key = kwargs['sslClientKey']
        if ssl_sni_hostname is None and 'sslSniHostname' in kwargs:
            ssl_sni_hostname = kwargs['sslSniHostname']
        if use_ssl is None and 'useSsl' in kwargs:
            use_ssl = kwargs['useSsl']

        _setter("address", address)
        _setter("name", name)
        if auto_loadbalance is not None:
            _setter("auto_loadbalance", auto_loadbalance)
        if between_bytes_timeout is not None:
            _setter("between_bytes_timeout", between_bytes_timeout)
        if connect_timeout is not None:
            _setter("connect_timeout", connect_timeout)
        if error_threshold is not None:
            _setter("error_threshold", error_threshold)
        if first_byte_timeout is not None:
            _setter("first_byte_timeout", first_byte_timeout)
        if healthcheck is not None:
            _setter("healthcheck", healthcheck)
        if keepalive_time is not None:
            _setter("keepalive_time", keepalive_time)
        if max_conn is not None:
            _setter("max_conn", max_conn)
        if max_tls_version is not None:
            _setter("max_tls_version", max_tls_version)
        if min_tls_version is not None:
            _setter("min_tls_version", min_tls_version)
        if override_host is not None:
            _setter("override_host", override_host)
        if port is not None:
            _setter("port", port)
        if request_condition is not None:
            _setter("request_condition", request_condition)
        if share_key is not None:
            _setter("share_key", share_key)
        if shield is not None:
            _setter("shield", shield)
        if ssl_ca_cert is not None:
            _setter("ssl_ca_cert", ssl_ca_cert)
        if ssl_cert_hostname is not None:
            _setter("ssl_cert_hostname", ssl_cert_hostname)
        if ssl_check_cert is not None:
            _setter("ssl_check_cert", ssl_check_cert)
        if ssl_ciphers is not None:
            _setter("ssl_ciphers", ssl_ciphers)
        if ssl_client_cert is not None:
            _setter("ssl_client_cert", ssl_client_cert)
        if ssl_client_key is not None:
            _setter("ssl_client_key", ssl_client_key)
        if ssl_sni_hostname is not None:
            _setter("ssl_sni_hostname", ssl_sni_hostname)
        if use_ssl is not None:
            _setter("use_ssl", use_ssl)
        if weight is not None:
            _setter("weight", weight)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        An IPv4, hostname, or IPv6 address for the Backend
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="autoLoadbalance")
    def auto_loadbalance(self) -> Optional[bool]:
        """
        Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `false`
        """
        return pulumi.get(self, "auto_loadbalance")

    @property
    @pulumi.getter(name="betweenBytesTimeout")
    def between_bytes_timeout(self) -> Optional[int]:
        """
        How long to wait between bytes in milliseconds. Default `10000`
        """
        return pulumi.get(self, "between_bytes_timeout")

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[int]:
        """
        How long to wait for a timeout in milliseconds. Default `1000`
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[int]:
        """
        Number of errors to allow before the Backend is marked as down. Default `0`
        """
        return pulumi.get(self, "error_threshold")

    @property
    @pulumi.getter(name="firstByteTimeout")
    def first_byte_timeout(self) -> Optional[int]:
        """
        How long to wait for the first bytes in milliseconds. Default `15000`
        """
        return pulumi.get(self, "first_byte_timeout")

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[str]:
        """
        Name of a defined `healthcheck` to assign to this backend
        """
        return pulumi.get(self, "healthcheck")

    @property
    @pulumi.getter(name="keepaliveTime")
    def keepalive_time(self) -> Optional[int]:
        """
        How long in seconds to keep a persistent connection to the backend between requests.
        """
        return pulumi.get(self, "keepalive_time")

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> Optional[int]:
        """
        Maximum number of connections for this Backend. Default `200`
        """
        return pulumi.get(self, "max_conn")

    @property
    @pulumi.getter(name="maxTlsVersion")
    def max_tls_version(self) -> Optional[str]:
        """
        Maximum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "max_tls_version")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[str]:
        """
        Minimum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter(name="overrideHost")
    def override_host(self) -> Optional[str]:
        """
        The hostname to override the Host header
        """
        return pulumi.get(self, "override_host")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number on which the Backend responds. Default `80`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[str]:
        """
        Name of a condition, which if met, will select this backend during a request.
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter(name="shareKey")
    def share_key(self) -> Optional[str]:
        """
        Value that when shared across backends will enable those backends to share the same health check.
        """
        return pulumi.get(self, "share_key")

    @property
    @pulumi.getter
    def shield(self) -> Optional[str]:
        """
        The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter(name="sslCaCert")
    def ssl_ca_cert(self) -> Optional[str]:
        """
        CA certificate attached to origin.
        """
        return pulumi.get(self, "ssl_ca_cert")

    @property
    @pulumi.getter(name="sslCertHostname")
    def ssl_cert_hostname(self) -> Optional[str]:
        """
        Configure certificate validation. Does not affect SNI at all
        """
        return pulumi.get(self, "ssl_cert_hostname")

    @property
    @pulumi.getter(name="sslCheckCert")
    def ssl_check_cert(self) -> Optional[bool]:
        """
        Be strict about checking SSL certs. Default `true`
        """
        return pulumi.get(self, "ssl_check_cert")

    @property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> Optional[str]:
        """
        Cipher list consisting of one or more cipher strings separated by colons. Commas or spaces are also acceptable separators but colons are normally used.
        """
        return pulumi.get(self, "ssl_ciphers")

    @property
    @pulumi.getter(name="sslClientCert")
    def ssl_client_cert(self) -> Optional[str]:
        """
        Client certificate attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_cert")

    @property
    @pulumi.getter(name="sslClientKey")
    def ssl_client_key(self) -> Optional[str]:
        """
        Client key attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_key")

    @property
    @pulumi.getter(name="sslSniHostname")
    def ssl_sni_hostname(self) -> Optional[str]:
        """
        Configure SNI in the TLS handshake. Does not affect cert validation at all
        """
        return pulumi.get(self, "ssl_sni_hostname")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[bool]:
        """
        Whether or not to use SSL to reach the Backend. Default `false`
        """
        return pulumi.get(self, "use_ssl")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServiceVclCacheSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "staleTtl":
            suggest = "stale_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclCacheSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclCacheSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclCacheSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 action: Optional[str] = None,
                 cache_condition: Optional[str] = None,
                 stale_ttl: Optional[int] = None,
                 ttl: Optional[int] = None):
        """
        :param str name: Unique name for this Cache Setting. It is important to note that changing this attribute will delete and recreate the resource
        :param str action: One of cache, pass, or restart, as defined on Fastly's documentation under "[Caching action descriptions](https://docs.fastly.com/en/guides/controlling-caching#caching-action-descriptions)"
        :param str cache_condition: Name of already defined `condition` used to test whether this settings object should be used. This `condition` must be of type `CACHE`
        :param int stale_ttl: Max "Time To Live" for stale (unreachable) objects
        :param int ttl: The Time-To-Live (TTL) for the object
        """
        ServiceVclCacheSetting._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            action=action,
            cache_condition=cache_condition,
            stale_ttl=stale_ttl,
            ttl=ttl,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             action: Optional[str] = None,
             cache_condition: Optional[str] = None,
             stale_ttl: Optional[int] = None,
             ttl: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if cache_condition is None and 'cacheCondition' in kwargs:
            cache_condition = kwargs['cacheCondition']
        if stale_ttl is None and 'staleTtl' in kwargs:
            stale_ttl = kwargs['staleTtl']

        _setter("name", name)
        if action is not None:
            _setter("action", action)
        if cache_condition is not None:
            _setter("cache_condition", cache_condition)
        if stale_ttl is not None:
            _setter("stale_ttl", stale_ttl)
        if ttl is not None:
            _setter("ttl", ttl)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name for this Cache Setting. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        One of cache, pass, or restart, as defined on Fastly's documentation under "[Caching action descriptions](https://docs.fastly.com/en/guides/controlling-caching#caching-action-descriptions)"
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` used to test whether this settings object should be used. This `condition` must be of type `CACHE`
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter(name="staleTtl")
    def stale_ttl(self) -> Optional[int]:
        """
        Max "Time To Live" for stale (unreachable) objects
        """
        return pulumi.get(self, "stale_ttl")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[int]:
        """
        The Time-To-Live (TTL) for the object
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class ServiceVclCondition(dict):
    def __init__(__self__, *,
                 name: str,
                 statement: str,
                 type: str,
                 priority: Optional[int] = None):
        """
        :param str name: The unique name for the condition. It is important to note that changing this attribute will delete and recreate the resource
        :param str statement: The statement used to determine if the condition is met
        :param str type: Type of condition, either `REQUEST` (req), `RESPONSE` (req, resp), or `CACHE` (req, beresp)
        :param int priority: A number used to determine the order in which multiple conditions execute. Lower numbers execute first. Default `10`
        """
        ServiceVclCondition._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            statement=statement,
            type=type,
            priority=priority,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             statement: Optional[str] = None,
             type: Optional[str] = None,
             priority: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if statement is None:
            raise TypeError("Missing 'statement' argument")
        if type is None:
            raise TypeError("Missing 'type' argument")

        _setter("name", name)
        _setter("statement", statement)
        _setter("type", type)
        if priority is not None:
            _setter("priority", priority)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name for the condition. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statement(self) -> str:
        """
        The statement used to determine if the condition is met
        """
        return pulumi.get(self, "statement")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of condition, either `REQUEST` (req), `RESPONSE` (req, resp), or `CACHE` (req, beresp)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        A number used to determine the order in which multiple conditions execute. Lower numbers execute first. Default `10`
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class ServiceVclDictionary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dictionaryId":
            suggest = "dictionary_id"
        elif key == "forceDestroy":
            suggest = "force_destroy"
        elif key == "writeOnly":
            suggest = "write_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclDictionary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclDictionary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclDictionary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 dictionary_id: Optional[str] = None,
                 force_destroy: Optional[bool] = None,
                 write_only: Optional[bool] = None):
        """
        :param str name: A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        :param str dictionary_id: The ID of the dictionary
        :param bool force_destroy: Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        ServiceVclDictionary._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            dictionary_id=dictionary_id,
            force_destroy=force_destroy,
            write_only=write_only,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             dictionary_id: Optional[str] = None,
             force_destroy: Optional[bool] = None,
             write_only: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if dictionary_id is None and 'dictionaryId' in kwargs:
            dictionary_id = kwargs['dictionaryId']
        if force_destroy is None and 'forceDestroy' in kwargs:
            force_destroy = kwargs['forceDestroy']
        if write_only is None and 'writeOnly' in kwargs:
            write_only = kwargs['writeOnly']

        _setter("name", name)
        if dictionary_id is not None:
            _setter("dictionary_id", dictionary_id)
        if force_destroy is not None:
            _setter("force_destroy", force_destroy)
        if write_only is not None:
            _setter("write_only", write_only)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[str]:
        """
        The ID of the dictionary
        """
        return pulumi.get(self, "dictionary_id")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[bool]:
        """
        Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> Optional[bool]:
        return pulumi.get(self, "write_only")


@pulumi.output_type
class ServiceVclDirector(dict):
    def __init__(__self__, *,
                 backends: Sequence[str],
                 name: str,
                 comment: Optional[str] = None,
                 quorum: Optional[int] = None,
                 retries: Optional[int] = None,
                 shield: Optional[str] = None,
                 type: Optional[int] = None):
        """
        :param Sequence[str] backends: Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        :param str name: Unique name for this Director. It is important to note that changing this attribute will delete and recreate the resource
        :param str comment: An optional comment about the Director
        :param int quorum: Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`
        :param int retries: How many backends to search if it fails. Default `5`
        :param str shield: Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response
        :param int type: Type of load balance group to use. Integer, 1 to 4. Values: `1` (random), `3` (hash), `4` (client). Default `1`
        """
        ServiceVclDirector._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            backends=backends,
            name=name,
            comment=comment,
            quorum=quorum,
            retries=retries,
            shield=shield,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             backends: Optional[Sequence[str]] = None,
             name: Optional[str] = None,
             comment: Optional[str] = None,
             quorum: Optional[int] = None,
             retries: Optional[int] = None,
             shield: Optional[str] = None,
             type: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if backends is None:
            raise TypeError("Missing 'backends' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")

        _setter("backends", backends)
        _setter("name", name)
        if comment is not None:
            _setter("comment", comment)
        if quorum is not None:
            _setter("quorum", quorum)
        if retries is not None:
            _setter("retries", retries)
        if shield is not None:
            _setter("shield", shield)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter
    def backends(self) -> Sequence[str]:
        """
        Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name for this Director. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        An optional comment about the Director
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def quorum(self) -> Optional[int]:
        """
        Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`
        """
        return pulumi.get(self, "quorum")

    @property
    @pulumi.getter
    def retries(self) -> Optional[int]:
        """
        How many backends to search if it fails. Default `5`
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter
    def shield(self) -> Optional[str]:
        """
        Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter
    def type(self) -> Optional[int]:
        """
        Type of load balance group to use. Integer, 1 to 4. Values: `1` (random), `3` (hash), `4` (client). Default `1`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceVclDomain(dict):
    def __init__(__self__, *,
                 name: str,
                 comment: Optional[str] = None):
        """
        :param str name: The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        :param str comment: An optional comment about the Domain.
        """
        ServiceVclDomain._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            comment=comment,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             comment: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")

        _setter("name", name)
        if comment is not None:
            _setter("comment", comment)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        An optional comment about the Domain.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class ServiceVclDynamicsnippet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snippetId":
            suggest = "snippet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclDynamicsnippet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclDynamicsnippet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclDynamicsnippet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 content: Optional[str] = None,
                 priority: Optional[int] = None,
                 snippet_id: Optional[str] = None):
        """
        :param str name: A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        :param str type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        :param str content: The VCL code that specifies exactly what the snippet does
        :param int priority: Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        :param str snippet_id: The ID of the dynamic snippet
        """
        ServiceVclDynamicsnippet._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            type=type,
            content=content,
            priority=priority,
            snippet_id=snippet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             type: Optional[str] = None,
             content: Optional[str] = None,
             priority: Optional[int] = None,
             snippet_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if type is None:
            raise TypeError("Missing 'type' argument")
        if snippet_id is None and 'snippetId' in kwargs:
            snippet_id = kwargs['snippetId']

        _setter("name", name)
        _setter("type", type)
        if content is not None:
            _setter("content", content)
        if priority is not None:
            _setter("priority", priority)
        if snippet_id is not None:
            _setter("snippet_id", snippet_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="snippetId")
    def snippet_id(self) -> Optional[str]:
        """
        The ID of the dynamic snippet
        """
        return pulumi.get(self, "snippet_id")


@pulumi.output_type
class ServiceVclGzip(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "contentTypes":
            suggest = "content_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclGzip. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclGzip.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclGzip.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 cache_condition: Optional[str] = None,
                 content_types: Optional[Sequence[str]] = None,
                 extensions: Optional[Sequence[str]] = None):
        """
        :param str name: A name to refer to this gzip condition. It is important to note that changing this attribute will delete and recreate the resource
        :param str cache_condition: Name of already defined `condition` controlling when this gzip configuration applies. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param Sequence[str] content_types: The content-type for each type of content you wish to have dynamically gzip'ed. Example: `["text/html", "text/css"]`
        :param Sequence[str] extensions: File extensions for each file type to dynamically gzip. Example: `["css", "js"]`
        """
        ServiceVclGzip._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            cache_condition=cache_condition,
            content_types=content_types,
            extensions=extensions,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             cache_condition: Optional[str] = None,
             content_types: Optional[Sequence[str]] = None,
             extensions: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if cache_condition is None and 'cacheCondition' in kwargs:
            cache_condition = kwargs['cacheCondition']
        if content_types is None and 'contentTypes' in kwargs:
            content_types = kwargs['contentTypes']

        _setter("name", name)
        if cache_condition is not None:
            _setter("cache_condition", cache_condition)
        if content_types is not None:
            _setter("content_types", content_types)
        if extensions is not None:
            _setter("extensions", extensions)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name to refer to this gzip condition. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` controlling when this gzip configuration applies. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Optional[Sequence[str]]:
        """
        The content-type for each type of content you wish to have dynamically gzip'ed. Example: `["text/html", "text/css"]`
        """
        return pulumi.get(self, "content_types")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence[str]]:
        """
        File extensions for each file type to dynamically gzip. Example: `["css", "js"]`
        """
        return pulumi.get(self, "extensions")


@pulumi.output_type
class ServiceVclHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "ignoreIfSet":
            suggest = "ignore_if_set"
        elif key == "requestCondition":
            suggest = "request_condition"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 destination: str,
                 name: str,
                 type: str,
                 cache_condition: Optional[str] = None,
                 ignore_if_set: Optional[bool] = None,
                 priority: Optional[int] = None,
                 regex: Optional[str] = None,
                 request_condition: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 source: Optional[str] = None,
                 substitution: Optional[str] = None):
        """
        :param str action: The Header manipulation action to take; must be one of `set`, `append`, `delete`, `regex`, or `regex_repeat`
        :param str destination: The name of the header that is going to be affected by the Action
        :param str name: Unique name for this header attribute. It is important to note that changing this attribute will delete and recreate the resource
        :param str type: The Request type on which to apply the selected Action; must be one of `request`, `fetch`, `cache` or `response`
        :param str cache_condition: Name of already defined `condition` to apply. This `condition` must be of type `CACHE`
        :param bool ignore_if_set: Don't add the header if it is already. (Only applies to `set` action.). Default `false`
        :param int priority: Lower priorities execute first. Default: `100`
        :param str regex: Regular expression to use (Only applies to `regex` and `regex_repeat` actions.)
        :param str request_condition: Name of already defined `condition` to apply. This `condition` must be of type `REQUEST`
        :param str response_condition: Name of already defined `condition` to apply. This `condition` must be of type `RESPONSE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param str source: Variable to be used as a source for the header content (Does not apply to `delete` action.)
        :param str substitution: Value to substitute in place of regular expression. (Only applies to `regex` and `regex_repeat`.)
        """
        ServiceVclHeader._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            destination=destination,
            name=name,
            type=type,
            cache_condition=cache_condition,
            ignore_if_set=ignore_if_set,
            priority=priority,
            regex=regex,
            request_condition=request_condition,
            response_condition=response_condition,
            source=source,
            substitution=substitution,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: Optional[str] = None,
             destination: Optional[str] = None,
             name: Optional[str] = None,
             type: Optional[str] = None,
             cache_condition: Optional[str] = None,
             ignore_if_set: Optional[bool] = None,
             priority: Optional[int] = None,
             regex: Optional[str] = None,
             request_condition: Optional[str] = None,
             response_condition: Optional[str] = None,
             source: Optional[str] = None,
             substitution: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if action is None:
            raise TypeError("Missing 'action' argument")
        if destination is None:
            raise TypeError("Missing 'destination' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if type is None:
            raise TypeError("Missing 'type' argument")
        if cache_condition is None and 'cacheCondition' in kwargs:
            cache_condition = kwargs['cacheCondition']
        if ignore_if_set is None and 'ignoreIfSet' in kwargs:
            ignore_if_set = kwargs['ignoreIfSet']
        if request_condition is None and 'requestCondition' in kwargs:
            request_condition = kwargs['requestCondition']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']

        _setter("action", action)
        _setter("destination", destination)
        _setter("name", name)
        _setter("type", type)
        if cache_condition is not None:
            _setter("cache_condition", cache_condition)
        if ignore_if_set is not None:
            _setter("ignore_if_set", ignore_if_set)
        if priority is not None:
            _setter("priority", priority)
        if regex is not None:
            _setter("regex", regex)
        if request_condition is not None:
            _setter("request_condition", request_condition)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if source is not None:
            _setter("source", source)
        if substitution is not None:
            _setter("substitution", substitution)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The Header manipulation action to take; must be one of `set`, `append`, `delete`, `regex`, or `regex_repeat`
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        The name of the header that is going to be affected by the Action
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name for this header attribute. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The Request type on which to apply the selected Action; must be one of `request`, `fetch`, `cache` or `response`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `CACHE`
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter(name="ignoreIfSet")
    def ignore_if_set(self) -> Optional[bool]:
        """
        Don't add the header if it is already. (Only applies to `set` action.). Default `false`
        """
        return pulumi.get(self, "ignore_if_set")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Lower priorities execute first. Default: `100`
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        Regular expression to use (Only applies to `regex` and `regex_repeat` actions.)
        """
        return pulumi.get(self, "regex")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `REQUEST`
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `RESPONSE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Variable to be used as a source for the header content (Does not apply to `delete` action.)
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def substitution(self) -> Optional[str]:
        """
        Value to substitute in place of regular expression. (Only applies to `regex` and `regex_repeat`.)
        """
        return pulumi.get(self, "substitution")


@pulumi.output_type
class ServiceVclHealthcheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkInterval":
            suggest = "check_interval"
        elif key == "expectedResponse":
            suggest = "expected_response"
        elif key == "httpVersion":
            suggest = "http_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclHealthcheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclHealthcheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclHealthcheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: str,
                 name: str,
                 path: str,
                 check_interval: Optional[int] = None,
                 expected_response: Optional[int] = None,
                 headers: Optional[Sequence[str]] = None,
                 http_version: Optional[str] = None,
                 initial: Optional[int] = None,
                 method: Optional[str] = None,
                 threshold: Optional[int] = None,
                 timeout: Optional[int] = None,
                 window: Optional[int] = None):
        """
        :param str host: The Host header to send for this Healthcheck
        :param str name: A unique name to identify this Healthcheck. It is important to note that changing this attribute will delete and recreate the resource
        :param str path: The path to check
        :param int check_interval: How often to run the Healthcheck in milliseconds. Default `5000`
        :param int expected_response: The status code expected from the host. Default `200`
        :param Sequence[str] headers: Custom health check HTTP headers (e.g. if your health check requires an API key to be provided).
        :param str http_version: Whether to use version 1.0 or 1.1 HTTP. Default `1.1`
        :param int initial: When loading a config, the initial number of probes to be seen as OK. Default `3`
        :param str method: Which HTTP method to use. Default `HEAD`
        :param int threshold: How many Healthchecks must succeed to be considered healthy. Default `3`
        :param int timeout: Timeout in milliseconds. Default `500`
        :param int window: The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`
        """
        ServiceVclHealthcheck._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host=host,
            name=name,
            path=path,
            check_interval=check_interval,
            expected_response=expected_response,
            headers=headers,
            http_version=http_version,
            initial=initial,
            method=method,
            threshold=threshold,
            timeout=timeout,
            window=window,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host: Optional[str] = None,
             name: Optional[str] = None,
             path: Optional[str] = None,
             check_interval: Optional[int] = None,
             expected_response: Optional[int] = None,
             headers: Optional[Sequence[str]] = None,
             http_version: Optional[str] = None,
             initial: Optional[int] = None,
             method: Optional[str] = None,
             threshold: Optional[int] = None,
             timeout: Optional[int] = None,
             window: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if host is None:
            raise TypeError("Missing 'host' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if path is None:
            raise TypeError("Missing 'path' argument")
        if check_interval is None and 'checkInterval' in kwargs:
            check_interval = kwargs['checkInterval']
        if expected_response is None and 'expectedResponse' in kwargs:
            expected_response = kwargs['expectedResponse']
        if http_version is None and 'httpVersion' in kwargs:
            http_version = kwargs['httpVersion']

        _setter("host", host)
        _setter("name", name)
        _setter("path", path)
        if check_interval is not None:
            _setter("check_interval", check_interval)
        if expected_response is not None:
            _setter("expected_response", expected_response)
        if headers is not None:
            _setter("headers", headers)
        if http_version is not None:
            _setter("http_version", http_version)
        if initial is not None:
            _setter("initial", initial)
        if method is not None:
            _setter("method", method)
        if threshold is not None:
            _setter("threshold", threshold)
        if timeout is not None:
            _setter("timeout", timeout)
        if window is not None:
            _setter("window", window)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The Host header to send for this Healthcheck
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Healthcheck. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to check
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[int]:
        """
        How often to run the Healthcheck in milliseconds. Default `5000`
        """
        return pulumi.get(self, "check_interval")

    @property
    @pulumi.getter(name="expectedResponse")
    def expected_response(self) -> Optional[int]:
        """
        The status code expected from the host. Default `200`
        """
        return pulumi.get(self, "expected_response")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[str]]:
        """
        Custom health check HTTP headers (e.g. if your health check requires an API key to be provided).
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[str]:
        """
        Whether to use version 1.0 or 1.1 HTTP. Default `1.1`
        """
        return pulumi.get(self, "http_version")

    @property
    @pulumi.getter
    def initial(self) -> Optional[int]:
        """
        When loading a config, the initial number of probes to be seen as OK. Default `3`
        """
        return pulumi.get(self, "initial")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        Which HTTP method to use. Default `HEAD`
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[int]:
        """
        How many Healthchecks must succeed to be considered healthy. Default `3`
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Timeout in milliseconds. Default `500`
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def window(self) -> Optional[int]:
        """
        The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`
        """
        return pulumi.get(self, "window")


@pulumi.output_type
class ServiceVclLoggingBigquery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingBigquery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingBigquery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingBigquery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: str,
                 email: str,
                 name: str,
                 project_id: str,
                 secret_key: str,
                 table: str,
                 account_name: Optional[str] = None,
                 format: Optional[str] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 template: Optional[str] = None):
        """
        :param str dataset: The ID of your BigQuery dataset
        :param str email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        :param str name: A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str project_id: The ID of your GCP project
        :param str secret_key: The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        :param str table: The ID of your BigQuery table
        :param str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param str format: The logging format desired.
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str response_condition: Name of a condition to apply this logging.
        :param str template: BigQuery table name suffix template
        """
        ServiceVclLoggingBigquery._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset=dataset,
            email=email,
            name=name,
            project_id=project_id,
            secret_key=secret_key,
            table=table,
            account_name=account_name,
            format=format,
            placement=placement,
            response_condition=response_condition,
            template=template,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset: Optional[str] = None,
             email: Optional[str] = None,
             name: Optional[str] = None,
             project_id: Optional[str] = None,
             secret_key: Optional[str] = None,
             table: Optional[str] = None,
             account_name: Optional[str] = None,
             format: Optional[str] = None,
             placement: Optional[str] = None,
             response_condition: Optional[str] = None,
             template: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if dataset is None:
            raise TypeError("Missing 'dataset' argument")
        if email is None:
            raise TypeError("Missing 'email' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if project_id is None and 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if project_id is None:
            raise TypeError("Missing 'project_id' argument")
        if secret_key is None and 'secretKey' in kwargs:
            secret_key = kwargs['secretKey']
        if secret_key is None:
            raise TypeError("Missing 'secret_key' argument")
        if table is None:
            raise TypeError("Missing 'table' argument")
        if account_name is None and 'accountName' in kwargs:
            account_name = kwargs['accountName']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']

        _setter("dataset", dataset)
        _setter("email", email)
        _setter("name", name)
        _setter("project_id", project_id)
        _setter("secret_key", secret_key)
        _setter("table", table)
        if account_name is not None:
            _setter("account_name", account_name)
        if format is not None:
            _setter("format", format)
        if placement is not None:
            _setter("placement", placement)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if template is not None:
            _setter("template", template)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The ID of your BigQuery dataset
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of your GCP project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        The ID of your BigQuery table
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        The logging format desired.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of a condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter
    def template(self) -> Optional[str]:
        """
        BigQuery table name suffix template
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class ServiceVclLoggingBlobstorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "sasToken":
            suggest = "sas_token"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingBlobstorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingBlobstorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingBlobstorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: str,
                 container: str,
                 name: str,
                 sas_token: str,
                 compression_codec: Optional[str] = None,
                 file_max_bytes: Optional[int] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str account_name: The unique Azure Blob Storage namespace in which your data objects are stored
        :param str container: The name of the Azure Blob Storage container in which to store logs
        :param str name: A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str sas_token: The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param str format: Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str path: The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        :param int period: How frequently the logs should be transferred in seconds. Default `3600`
        :param str placement: Where in the generated VCL the logging call should be placed
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str response_condition: The name of the condition to apply
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceVclLoggingBlobstorage._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            account_name=account_name,
            container=container,
            name=name,
            sas_token=sas_token,
            compression_codec=compression_codec,
            file_max_bytes=file_max_bytes,
            format=format,
            format_version=format_version,
            gzip_level=gzip_level,
            message_type=message_type,
            path=path,
            period=period,
            placement=placement,
            public_key=public_key,
            response_condition=response_condition,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             account_name: Optional[str] = None,
             container: Optional[str] = None,
             name: Optional[str] = None,
             sas_token: Optional[str] = None,
             compression_codec: Optional[str] = None,
             file_max_bytes: Optional[int] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             path: Optional[str] = None,
             period: Optional[int] = None,
             placement: Optional[str] = None,
             public_key: Optional[str] = None,
             response_condition: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if account_name is None and 'accountName' in kwargs:
            account_name = kwargs['accountName']
        if account_name is None:
            raise TypeError("Missing 'account_name' argument")
        if container is None:
            raise TypeError("Missing 'container' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if sas_token is None and 'sasToken' in kwargs:
            sas_token = kwargs['sasToken']
        if sas_token is None:
            raise TypeError("Missing 'sas_token' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if file_max_bytes is None and 'fileMaxBytes' in kwargs:
            file_max_bytes = kwargs['fileMaxBytes']
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("account_name", account_name)
        _setter("container", container)
        _setter("name", name)
        _setter("sas_token", sas_token)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if file_max_bytes is not None:
            _setter("file_max_bytes", file_max_bytes)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if path is not None:
            _setter("path", path)
        if period is not None:
            _setter("period", period)
        if placement is not None:
            _setter("placement", placement)
        if public_key is not None:
            _setter("public_key", public_key)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        The unique Azure Blob Storage namespace in which your data objects are stored
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The name of the Azure Blob Storage container in which to store logs
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> str:
        """
        The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        """
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingCloudfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingCloudfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingCloudfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingCloudfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 region: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your Cloud File account access key
        :param str bucket_name: The name of your Cloud Files container
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str user: The username for your Cloud Files account
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str path: The path to upload logs to
        :param int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceVclLoggingCloudfile._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_key=access_key,
            bucket_name=bucket_name,
            name=name,
            user=user,
            compression_codec=compression_codec,
            format=format,
            format_version=format_version,
            gzip_level=gzip_level,
            message_type=message_type,
            path=path,
            period=period,
            placement=placement,
            public_key=public_key,
            region=region,
            response_condition=response_condition,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_key: Optional[str] = None,
             bucket_name: Optional[str] = None,
             name: Optional[str] = None,
             user: Optional[str] = None,
             compression_codec: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             path: Optional[str] = None,
             period: Optional[int] = None,
             placement: Optional[str] = None,
             public_key: Optional[str] = None,
             region: Optional[str] = None,
             response_condition: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if access_key is None and 'accessKey' in kwargs:
            access_key = kwargs['accessKey']
        if access_key is None:
            raise TypeError("Missing 'access_key' argument")
        if bucket_name is None and 'bucketName' in kwargs:
            bucket_name = kwargs['bucketName']
        if bucket_name is None:
            raise TypeError("Missing 'bucket_name' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if user is None:
            raise TypeError("Missing 'user' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("access_key", access_key)
        _setter("bucket_name", bucket_name)
        _setter("name", name)
        _setter("user", user)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if path is not None:
            _setter("path", path)
        if period is not None:
            _setter("period", period)
        if placement is not None:
            _setter("placement", placement)
        if public_key is not None:
            _setter("public_key", public_key)
        if region is not None:
            _setter("region", region)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your Cloud File account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 region: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The API key from your Datadog account
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        :param str response_condition: The name of the condition to apply.
        """
        ServiceVclLoggingDatadog._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            format=format,
            format_version=format_version,
            placement=placement,
            region=region,
            response_condition=response_condition,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             placement: Optional[str] = None,
             region: Optional[str] = None,
             response_condition: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']

        _setter("name", name)
        _setter("token", token)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if placement is not None:
            _setter("placement", placement)
        if region is not None:
            _setter("region", region)
        if response_condition is not None:
            _setter("response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The API key from your Datadog account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingDigitalocean(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingDigitalocean. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingDigitalocean.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingDigitalocean.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 secret_key: str,
                 compression_codec: Optional[str] = None,
                 domain: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your DigitalOcean Spaces account access key
        :param str bucket_name: The name of the DigitalOcean Space
        :param str name: The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str secret_key: Your DigitalOcean Spaces account secret key
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str domain: The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str path: The path to upload logs to
        :param int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceVclLoggingDigitalocean._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_key=access_key,
            bucket_name=bucket_name,
            name=name,
            secret_key=secret_key,
            compression_codec=compression_codec,
            domain=domain,
            format=format,
            format_version=format_version,
            gzip_level=gzip_level,
            message_type=message_type,
            path=path,
            period=period,
            placement=placement,
            public_key=public_key,
            response_condition=response_condition,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_key: Optional[str] = None,
             bucket_name: Optional[str] = None,
             name: Optional[str] = None,
             secret_key: Optional[str] = None,
             compression_codec: Optional[str] = None,
             domain: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             path: Optional[str] = None,
             period: Optional[int] = None,
             placement: Optional[str] = None,
             public_key: Optional[str] = None,
             response_condition: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if access_key is None and 'accessKey' in kwargs:
            access_key = kwargs['accessKey']
        if access_key is None:
            raise TypeError("Missing 'access_key' argument")
        if bucket_name is None and 'bucketName' in kwargs:
            bucket_name = kwargs['bucketName']
        if bucket_name is None:
            raise TypeError("Missing 'bucket_name' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if secret_key is None and 'secretKey' in kwargs:
            secret_key = kwargs['secretKey']
        if secret_key is None:
            raise TypeError("Missing 'secret_key' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("access_key", access_key)
        _setter("bucket_name", bucket_name)
        _setter("name", name)
        _setter("secret_key", secret_key)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if domain is not None:
            _setter("domain", domain)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if path is not None:
            _setter("path", path)
        if period is not None:
            _setter("period", period)
        if placement is not None:
            _setter("placement", placement)
        if public_key is not None:
            _setter("public_key", public_key)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your DigitalOcean Spaces account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the DigitalOcean Space
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your DigitalOcean Spaces account secret key
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingElasticsearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingElasticsearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingElasticsearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingElasticsearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index: str,
                 name: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 password: Optional[str] = None,
                 pipeline: Optional[str] = None,
                 placement: Optional[str] = None,
                 request_max_bytes: Optional[int] = None,
                 request_max_entries: Optional[int] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str index: The name of the Elasticsearch index to send documents (logs) to
        :param str name: The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: The Elasticsearch URL to stream logs to
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param str password: BasicAuth password for Elasticsearch
        :param str pipeline: The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param int request_max_bytes: The maximum number of logs sent in one request. Defaults to `0` for unbounded
        :param int request_max_entries: The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        :param str response_condition: The name of the condition to apply
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        :param str user: BasicAuth username for Elasticsearch
        """
        ServiceVclLoggingElasticsearch._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            index=index,
            name=name,
            url=url,
            format=format,
            format_version=format_version,
            password=password,
            pipeline=pipeline,
            placement=placement,
            request_max_bytes=request_max_bytes,
            request_max_entries=request_max_entries,
            response_condition=response_condition,
            tls_ca_cert=tls_ca_cert,
            tls_client_cert=tls_client_cert,
            tls_client_key=tls_client_key,
            tls_hostname=tls_hostname,
            user=user,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             index: Optional[str] = None,
             name: Optional[str] = None,
             url: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             password: Optional[str] = None,
             pipeline: Optional[str] = None,
             placement: Optional[str] = None,
             request_max_bytes: Optional[int] = None,
             request_max_entries: Optional[int] = None,
             response_condition: Optional[str] = None,
             tls_ca_cert: Optional[str] = None,
             tls_client_cert: Optional[str] = None,
             tls_client_key: Optional[str] = None,
             tls_hostname: Optional[str] = None,
             user: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if index is None:
            raise TypeError("Missing 'index' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if request_max_bytes is None and 'requestMaxBytes' in kwargs:
            request_max_bytes = kwargs['requestMaxBytes']
        if request_max_entries is None and 'requestMaxEntries' in kwargs:
            request_max_entries = kwargs['requestMaxEntries']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if tls_ca_cert is None and 'tlsCaCert' in kwargs:
            tls_ca_cert = kwargs['tlsCaCert']
        if tls_client_cert is None and 'tlsClientCert' in kwargs:
            tls_client_cert = kwargs['tlsClientCert']
        if tls_client_key is None and 'tlsClientKey' in kwargs:
            tls_client_key = kwargs['tlsClientKey']
        if tls_hostname is None and 'tlsHostname' in kwargs:
            tls_hostname = kwargs['tlsHostname']

        _setter("index", index)
        _setter("name", name)
        _setter("url", url)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if password is not None:
            _setter("password", password)
        if pipeline is not None:
            _setter("pipeline", pipeline)
        if placement is not None:
            _setter("placement", placement)
        if request_max_bytes is not None:
            _setter("request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            _setter("request_max_entries", request_max_entries)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if tls_ca_cert is not None:
            _setter("tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            _setter("tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            _setter("tls_client_key", tls_client_key)
        if tls_hostname is not None:
            _setter("tls_hostname", tls_hostname)
        if user is not None:
            _setter("user", user)

    @property
    @pulumi.getter
    def index(self) -> str:
        """
        The name of the Elasticsearch index to send documents (logs) to
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The Elasticsearch URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        BasicAuth password for Elasticsearch
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[str]:
        """
        The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[int]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[int]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        BasicAuth username for Elasticsearch
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceVclLoggingFtp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingFtp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingFtp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingFtp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 password: str,
                 path: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 port: Optional[int] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str address: The FTP address to stream logs to
        :param str name: The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str password: The password for the server (for anonymous use an email address)
        :param str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param str user: The username for the server (can be `anonymous`)
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param int period: How frequently the logs should be transferred, in seconds (Default `3600`)
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param int port: The port number. Default: `21`
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str response_condition: The name of the condition to apply.
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceVclLoggingFtp._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            name=name,
            password=password,
            path=path,
            user=user,
            compression_codec=compression_codec,
            format=format,
            format_version=format_version,
            gzip_level=gzip_level,
            message_type=message_type,
            period=period,
            placement=placement,
            port=port,
            public_key=public_key,
            response_condition=response_condition,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             name: Optional[str] = None,
             password: Optional[str] = None,
             path: Optional[str] = None,
             user: Optional[str] = None,
             compression_codec: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             period: Optional[int] = None,
             placement: Optional[str] = None,
             port: Optional[int] = None,
             public_key: Optional[str] = None,
             response_condition: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if address is None:
            raise TypeError("Missing 'address' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if password is None:
            raise TypeError("Missing 'password' argument")
        if path is None:
            raise TypeError("Missing 'path' argument")
        if user is None:
            raise TypeError("Missing 'user' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("address", address)
        _setter("name", name)
        _setter("password", password)
        _setter("path", path)
        _setter("user", user)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if period is not None:
            _setter("period", period)
        if placement is not None:
            _setter("placement", placement)
        if port is not None:
            _setter("port", port)
        if public_key is not None:
            _setter("public_key", public_key)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The FTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for the server (for anonymous use an email address)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for the server (can be `anonymous`)
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds (Default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number. Default: `21`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingGc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingGc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingGc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingGc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 name: str,
                 account_name: Optional[str] = None,
                 compression_codec: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 project_id: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str bucket_name: The name of the bucket in which to store the logs
        :param str name: A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str format: Apache-style string or VCL variables to use for log formatting
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param int period: How frequently the logs should be transferred, in seconds (Default 3600)
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str project_id: The ID of your Google Cloud Platform project
        :param str response_condition: Name of a condition to apply this logging.
        :param str secret_key: The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        :param str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        ServiceVclLoggingGc._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket_name=bucket_name,
            name=name,
            account_name=account_name,
            compression_codec=compression_codec,
            format=format,
            format_version=format_version,
            gzip_level=gzip_level,
            message_type=message_type,
            path=path,
            period=period,
            placement=placement,
            project_id=project_id,
            response_condition=response_condition,
            secret_key=secret_key,
            timestamp_format=timestamp_format,
            user=user,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket_name: Optional[str] = None,
             name: Optional[str] = None,
             account_name: Optional[str] = None,
             compression_codec: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             path: Optional[str] = None,
             period: Optional[int] = None,
             placement: Optional[str] = None,
             project_id: Optional[str] = None,
             response_condition: Optional[str] = None,
             secret_key: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             user: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if bucket_name is None and 'bucketName' in kwargs:
            bucket_name = kwargs['bucketName']
        if bucket_name is None:
            raise TypeError("Missing 'bucket_name' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if account_name is None and 'accountName' in kwargs:
            account_name = kwargs['accountName']
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if project_id is None and 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if secret_key is None and 'secretKey' in kwargs:
            secret_key = kwargs['secretKey']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("bucket_name", bucket_name)
        _setter("name", name)
        if account_name is not None:
            _setter("account_name", account_name)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if path is not None:
            _setter("path", path)
        if period is not None:
            _setter("period", period)
        if placement is not None:
            _setter("placement", placement)
        if project_id is not None:
            _setter("project_id", project_id)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if secret_key is not None:
            _setter("secret_key", secret_key)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)
        if user is not None:
            _setter("user", user)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds (Default 3600)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of a condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GCS_EMAIL`.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceVclLoggingGooglepubsub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingGooglepubsub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingGooglepubsub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingGooglepubsub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 project_id: str,
                 secret_key: str,
                 topic: str,
                 user: str,
                 account_name: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str project_id: The ID of your Google Cloud Platform project
        :param str secret_key: Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        :param str topic: The Google Cloud Pub/Sub topic to which logs will be published
        :param str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        :param str account_name: The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        ServiceVclLoggingGooglepubsub._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            project_id=project_id,
            secret_key=secret_key,
            topic=topic,
            user=user,
            account_name=account_name,
            format=format,
            format_version=format_version,
            placement=placement,
            response_condition=response_condition,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             project_id: Optional[str] = None,
             secret_key: Optional[str] = None,
             topic: Optional[str] = None,
             user: Optional[str] = None,
             account_name: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             placement: Optional[str] = None,
             response_condition: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if project_id is None and 'projectId' in kwargs:
            project_id = kwargs['projectId']
        if project_id is None:
            raise TypeError("Missing 'project_id' argument")
        if secret_key is None and 'secretKey' in kwargs:
            secret_key = kwargs['secretKey']
        if secret_key is None:
            raise TypeError("Missing 'secret_key' argument")
        if topic is None:
            raise TypeError("Missing 'topic' argument")
        if user is None:
            raise TypeError("Missing 'user' argument")
        if account_name is None and 'accountName' in kwargs:
            account_name = kwargs['accountName']
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']

        _setter("name", name)
        _setter("project_id", project_id)
        _setter("secret_key", secret_key)
        _setter("topic", topic)
        _setter("user", user)
        if account_name is not None:
            _setter("account_name", account_name)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if placement is not None:
            _setter("placement", placement)
        if response_condition is not None:
            _setter("response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Google Cloud Pub/Sub topic to which logs will be published
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The google account name used to obtain temporary credentials (default none). You may optionally provide this via an environment variable, `FASTLY_GCS_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingHerokus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingHerokus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingHerokus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingHerokus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        :param str url: The URL to stream logs to
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        ServiceVclLoggingHerokus._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            url=url,
            format=format,
            format_version=format_version,
            placement=placement,
            response_condition=response_condition,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             url: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             placement: Optional[str] = None,
             response_condition: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']

        _setter("name", name)
        _setter("token", token)
        _setter("url", url)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if placement is not None:
            _setter("placement", placement)
        if response_condition is not None:
            _setter("response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingHoneycomb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingHoneycomb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingHoneycomb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingHoneycomb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: str,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str dataset: The Honeycomb Dataset you want to log to
        :param str name: The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The Write Key from the Account page of your Honeycomb account
        :param str format: Apache style log formatting. Your log must produce valid JSON that Honeycomb can ingest.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        ServiceVclLoggingHoneycomb._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            dataset=dataset,
            name=name,
            token=token,
            format=format,
            format_version=format_version,
            placement=placement,
            response_condition=response_condition,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             dataset: Optional[str] = None,
             name: Optional[str] = None,
             token: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             placement: Optional[str] = None,
             response_condition: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if dataset is None:
            raise TypeError("Missing 'dataset' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']

        _setter("dataset", dataset)
        _setter("name", name)
        _setter("token", token)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if placement is not None:
            _setter("placement", placement)
        if response_condition is not None:
            _setter("response_condition", response_condition)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The Honeycomb Dataset you want to log to
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Write Key from the Account page of your Honeycomb account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting. Your log must produce valid JSON that Honeycomb can ingest.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"
        elif key == "jsonFormat":
            suggest = "json_format"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 url: str,
                 content_type: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 header_name: Optional[str] = None,
                 header_value: Optional[str] = None,
                 json_format: Optional[str] = None,
                 message_type: Optional[str] = None,
                 method: Optional[str] = None,
                 placement: Optional[str] = None,
                 request_max_bytes: Optional[int] = None,
                 request_max_entries: Optional[int] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None):
        """
        :param str name: The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: URL that log data will be sent to. Must use the https protocol
        :param str content_type: Value of the `Content-Type` header sent with the request
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param str header_name: Custom header sent with the request
        :param str header_value: Value of the custom header sent with the request
        :param str json_format: Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        :param str placement: Where in the generated VCL the logging call should be placed
        :param int request_max_bytes: The maximum number of bytes sent in one request
        :param int request_max_entries: The maximum number of logs sent in one request
        :param str response_condition: The name of the condition to apply
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param str tls_hostname: Used during the TLS handshake to validate the certificate
        """
        ServiceVclLoggingHttp._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            url=url,
            content_type=content_type,
            format=format,
            format_version=format_version,
            header_name=header_name,
            header_value=header_value,
            json_format=json_format,
            message_type=message_type,
            method=method,
            placement=placement,
            request_max_bytes=request_max_bytes,
            request_max_entries=request_max_entries,
            response_condition=response_condition,
            tls_ca_cert=tls_ca_cert,
            tls_client_cert=tls_client_cert,
            tls_client_key=tls_client_key,
            tls_hostname=tls_hostname,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             url: Optional[str] = None,
             content_type: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             header_name: Optional[str] = None,
             header_value: Optional[str] = None,
             json_format: Optional[str] = None,
             message_type: Optional[str] = None,
             method: Optional[str] = None,
             placement: Optional[str] = None,
             request_max_bytes: Optional[int] = None,
             request_max_entries: Optional[int] = None,
             response_condition: Optional[str] = None,
             tls_ca_cert: Optional[str] = None,
             tls_client_cert: Optional[str] = None,
             tls_client_key: Optional[str] = None,
             tls_hostname: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")
        if content_type is None and 'contentType' in kwargs:
            content_type = kwargs['contentType']
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if header_name is None and 'headerName' in kwargs:
            header_name = kwargs['headerName']
        if header_value is None and 'headerValue' in kwargs:
            header_value = kwargs['headerValue']
        if json_format is None and 'jsonFormat' in kwargs:
            json_format = kwargs['jsonFormat']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if request_max_bytes is None and 'requestMaxBytes' in kwargs:
            request_max_bytes = kwargs['requestMaxBytes']
        if request_max_entries is None and 'requestMaxEntries' in kwargs:
            request_max_entries = kwargs['requestMaxEntries']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if tls_ca_cert is None and 'tlsCaCert' in kwargs:
            tls_ca_cert = kwargs['tlsCaCert']
        if tls_client_cert is None and 'tlsClientCert' in kwargs:
            tls_client_cert = kwargs['tlsClientCert']
        if tls_client_key is None and 'tlsClientKey' in kwargs:
            tls_client_key = kwargs['tlsClientKey']
        if tls_hostname is None and 'tlsHostname' in kwargs:
            tls_hostname = kwargs['tlsHostname']

        _setter("name", name)
        _setter("url", url)
        if content_type is not None:
            _setter("content_type", content_type)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if header_name is not None:
            _setter("header_name", header_name)
        if header_value is not None:
            _setter("header_value", header_value)
        if json_format is not None:
            _setter("json_format", json_format)
        if message_type is not None:
            _setter("message_type", message_type)
        if method is not None:
            _setter("method", method)
        if placement is not None:
            _setter("placement", placement)
        if request_max_bytes is not None:
            _setter("request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            _setter("request_max_entries", request_max_entries)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if tls_ca_cert is not None:
            _setter("tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            _setter("tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            _setter("tls_client_key", tls_client_key)
        if tls_hostname is not None:
            _setter("tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL that log data will be sent to. Must use the https protocol
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        Value of the `Content-Type` header sent with the request
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[str]:
        """
        Custom header sent with the request
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[str]:
        """
        Value of the custom header sent with the request
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter(name="jsonFormat")
    def json_format(self) -> Optional[str]:
        """
        Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        """
        return pulumi.get(self, "json_format")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[int]:
        """
        The maximum number of bytes sent in one request
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[int]:
        """
        The maximum number of logs sent in one request
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")


@pulumi.output_type
class ServiceVclLoggingKafka(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMethod":
            suggest = "auth_method"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "parseLogKeyvals":
            suggest = "parse_log_keyvals"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requiredAcks":
            suggest = "required_acks"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingKafka. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingKafka.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingKafka.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 brokers: str,
                 name: str,
                 topic: str,
                 auth_method: Optional[str] = None,
                 compression_codec: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 parse_log_keyvals: Optional[bool] = None,
                 password: Optional[str] = None,
                 placement: Optional[str] = None,
                 request_max_bytes: Optional[int] = None,
                 required_acks: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 use_tls: Optional[bool] = None,
                 user: Optional[str] = None):
        """
        :param str brokers: A comma-separated list of IP addresses or hostnames of Kafka brokers
        :param str name: The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str topic: The Kafka topic to send logs to
        :param str auth_method: SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        :param str compression_codec: The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param bool parse_log_keyvals: Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        :param str password: SASL Pass
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param int request_max_bytes: Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        :param str required_acks: The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1` Wait for all in-sync replicas to respond
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param bool use_tls: Whether to use TLS for secure logging. Can be either `true` or `false`
        :param str user: SASL User
        """
        ServiceVclLoggingKafka._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            brokers=brokers,
            name=name,
            topic=topic,
            auth_method=auth_method,
            compression_codec=compression_codec,
            format=format,
            format_version=format_version,
            parse_log_keyvals=parse_log_keyvals,
            password=password,
            placement=placement,
            request_max_bytes=request_max_bytes,
            required_acks=required_acks,
            response_condition=response_condition,
            tls_ca_cert=tls_ca_cert,
            tls_client_cert=tls_client_cert,
            tls_client_key=tls_client_key,
            tls_hostname=tls_hostname,
            use_tls=use_tls,
            user=user,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             brokers: Optional[str] = None,
             name: Optional[str] = None,
             topic: Optional[str] = None,
             auth_method: Optional[str] = None,
             compression_codec: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             parse_log_keyvals: Optional[bool] = None,
             password: Optional[str] = None,
             placement: Optional[str] = None,
             request_max_bytes: Optional[int] = None,
             required_acks: Optional[str] = None,
             response_condition: Optional[str] = None,
             tls_ca_cert: Optional[str] = None,
             tls_client_cert: Optional[str] = None,
             tls_client_key: Optional[str] = None,
             tls_hostname: Optional[str] = None,
             use_tls: Optional[bool] = None,
             user: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if brokers is None:
            raise TypeError("Missing 'brokers' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if topic is None:
            raise TypeError("Missing 'topic' argument")
        if auth_method is None and 'authMethod' in kwargs:
            auth_method = kwargs['authMethod']
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if parse_log_keyvals is None and 'parseLogKeyvals' in kwargs:
            parse_log_keyvals = kwargs['parseLogKeyvals']
        if request_max_bytes is None and 'requestMaxBytes' in kwargs:
            request_max_bytes = kwargs['requestMaxBytes']
        if required_acks is None and 'requiredAcks' in kwargs:
            required_acks = kwargs['requiredAcks']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if tls_ca_cert is None and 'tlsCaCert' in kwargs:
            tls_ca_cert = kwargs['tlsCaCert']
        if tls_client_cert is None and 'tlsClientCert' in kwargs:
            tls_client_cert = kwargs['tlsClientCert']
        if tls_client_key is None and 'tlsClientKey' in kwargs:
            tls_client_key = kwargs['tlsClientKey']
        if tls_hostname is None and 'tlsHostname' in kwargs:
            tls_hostname = kwargs['tlsHostname']
        if use_tls is None and 'useTls' in kwargs:
            use_tls = kwargs['useTls']

        _setter("brokers", brokers)
        _setter("name", name)
        _setter("topic", topic)
        if auth_method is not None:
            _setter("auth_method", auth_method)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if parse_log_keyvals is not None:
            _setter("parse_log_keyvals", parse_log_keyvals)
        if password is not None:
            _setter("password", password)
        if placement is not None:
            _setter("placement", placement)
        if request_max_bytes is not None:
            _setter("request_max_bytes", request_max_bytes)
        if required_acks is not None:
            _setter("required_acks", required_acks)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if tls_ca_cert is not None:
            _setter("tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            _setter("tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            _setter("tls_client_key", tls_client_key)
        if tls_hostname is not None:
            _setter("tls_hostname", tls_hostname)
        if use_tls is not None:
            _setter("use_tls", use_tls)
        if user is not None:
            _setter("user", user)

    @property
    @pulumi.getter
    def brokers(self) -> str:
        """
        A comma-separated list of IP addresses or hostnames of Kafka brokers
        """
        return pulumi.get(self, "brokers")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Kafka topic to send logs to
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[str]:
        """
        SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        """
        return pulumi.get(self, "auth_method")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="parseLogKeyvals")
    def parse_log_keyvals(self) -> Optional[bool]:
        """
        Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        """
        return pulumi.get(self, "parse_log_keyvals")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        SASL Pass
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[int]:
        """
        Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requiredAcks")
    def required_acks(self) -> Optional[str]:
        """
        The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1` Wait for all in-sync replicas to respond
        """
        return pulumi.get(self, "required_acks")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Can be either `true` or `false`
        """
        return pulumi.get(self, "use_tls")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        SASL User
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceVclLoggingKinese(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "iamRole":
            suggest = "iam_role"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingKinese. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingKinese.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingKinese.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 topic: str,
                 access_key: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 iam_role: Optional[str] = None,
                 placement: Optional[str] = None,
                 region: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 secret_key: Optional[str] = None):
        """
        :param str name: The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str topic: The Kinesis stream name
        :param str access_key: The AWS access key to be used to write to the stream
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str region: The AWS region the stream resides in. (Default: `us-east-1`)
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str secret_key: The AWS secret access key to authenticate with
        """
        ServiceVclLoggingKinese._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            topic=topic,
            access_key=access_key,
            format=format,
            format_version=format_version,
            iam_role=iam_role,
            placement=placement,
            region=region,
            response_condition=response_condition,
            secret_key=secret_key,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             topic: Optional[str] = None,
             access_key: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             iam_role: Optional[str] = None,
             placement: Optional[str] = None,
             region: Optional[str] = None,
             response_condition: Optional[str] = None,
             secret_key: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if topic is None:
            raise TypeError("Missing 'topic' argument")
        if access_key is None and 'accessKey' in kwargs:
            access_key = kwargs['accessKey']
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if iam_role is None and 'iamRole' in kwargs:
            iam_role = kwargs['iamRole']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if secret_key is None and 'secretKey' in kwargs:
            secret_key = kwargs['secretKey']

        _setter("name", name)
        _setter("topic", topic)
        if access_key is not None:
            _setter("access_key", access_key)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if iam_role is not None:
            _setter("iam_role", iam_role)
        if placement is not None:
            _setter("placement", placement)
        if region is not None:
            _setter("region", region)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if secret_key is not None:
            _setter("secret_key", secret_key)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Kinesis stream name
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[str]:
        """
        The AWS access key to be used to write to the stream
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        """
        return pulumi.get(self, "iam_role")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The AWS region the stream resides in. (Default: `us-east-1`)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The AWS secret access key to authenticate with
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class ServiceVclLoggingLogentry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingLogentry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingLogentry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingLogentry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 port: Optional[int] = None,
                 response_condition: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str name: The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: Use token based authentication (https://logentries.com/doc/input-token/)
        :param str format: Apache-style string or VCL variables to use for log formatting
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param int port: The port number configured in Logentries
        :param str response_condition: Name of blockAttributes condition to apply this logging.
        :param bool use_tls: Whether to use TLS for secure logging
        """
        ServiceVclLoggingLogentry._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            format=format,
            format_version=format_version,
            placement=placement,
            port=port,
            response_condition=response_condition,
            use_tls=use_tls,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             placement: Optional[str] = None,
             port: Optional[int] = None,
             response_condition: Optional[str] = None,
             use_tls: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if use_tls is None and 'useTls' in kwargs:
            use_tls = kwargs['useTls']

        _setter("name", name)
        _setter("token", token)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if placement is not None:
            _setter("placement", placement)
        if port is not None:
            _setter("port", port)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if use_tls is not None:
            _setter("use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Use token based authentication (https://logentries.com/doc/input-token/)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number configured in Logentries
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceVclLoggingLoggly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingLoggly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingLoggly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingLoggly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        ServiceVclLoggingLoggly._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            format=format,
            format_version=format_version,
            placement=placement,
            response_condition=response_condition,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             placement: Optional[str] = None,
             response_condition: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']

        _setter("name", name)
        _setter("token", token)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if placement is not None:
            _setter("placement", placement)
        if response_condition is not None:
            _setter("response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingLogshuttle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingLogshuttle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingLogshuttle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingLogshuttle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The data authentication token associated with this endpoint
        :param str url: Your Log Shuttle endpoint URL
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        ServiceVclLoggingLogshuttle._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            url=url,
            format=format,
            format_version=format_version,
            placement=placement,
            response_condition=response_condition,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             url: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             placement: Optional[str] = None,
             response_condition: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']

        _setter("name", name)
        _setter("token", token)
        _setter("url", url)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if placement is not None:
            _setter("placement", placement)
        if response_condition is not None:
            _setter("response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your Log Shuttle endpoint URL
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingNewrelic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingNewrelic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingNewrelic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingNewrelic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 region: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The Insert API key from the Account page of your New Relic account
        :param str format: Apache style log formatting. Your log must produce valid JSON that New Relic Logs can ingest.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str region: The region that log data will be sent to. Default: `US`
        :param str response_condition: The name of the condition to apply.
        """
        ServiceVclLoggingNewrelic._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            format=format,
            format_version=format_version,
            placement=placement,
            region=region,
            response_condition=response_condition,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             placement: Optional[str] = None,
             region: Optional[str] = None,
             response_condition: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']

        _setter("name", name)
        _setter("token", token)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if placement is not None:
            _setter("placement", placement)
        if region is not None:
            _setter("region", region)
        if response_condition is not None:
            _setter("response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Insert API key from the Account page of your New Relic account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting. Your log must produce valid JSON that New Relic Logs can ingest.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region that log data will be sent to. Default: `US`
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingOpenstack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingOpenstack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingOpenstack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingOpenstack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 url: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your OpenStack account access key
        :param str bucket_name: The name of your OpenStack container
        :param str name: The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: Your OpenStack auth url
        :param str user: The username for your OpenStack account
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceVclLoggingOpenstack._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_key=access_key,
            bucket_name=bucket_name,
            name=name,
            url=url,
            user=user,
            compression_codec=compression_codec,
            format=format,
            format_version=format_version,
            gzip_level=gzip_level,
            message_type=message_type,
            path=path,
            period=period,
            placement=placement,
            public_key=public_key,
            response_condition=response_condition,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_key: Optional[str] = None,
             bucket_name: Optional[str] = None,
             name: Optional[str] = None,
             url: Optional[str] = None,
             user: Optional[str] = None,
             compression_codec: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             path: Optional[str] = None,
             period: Optional[int] = None,
             placement: Optional[str] = None,
             public_key: Optional[str] = None,
             response_condition: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if access_key is None and 'accessKey' in kwargs:
            access_key = kwargs['accessKey']
        if access_key is None:
            raise TypeError("Missing 'access_key' argument")
        if bucket_name is None and 'bucketName' in kwargs:
            bucket_name = kwargs['bucketName']
        if bucket_name is None:
            raise TypeError("Missing 'bucket_name' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")
        if user is None:
            raise TypeError("Missing 'user' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("access_key", access_key)
        _setter("bucket_name", bucket_name)
        _setter("name", name)
        _setter("url", url)
        _setter("user", user)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if path is not None:
            _setter("path", path)
        if period is not None:
            _setter("period", period)
        if placement is not None:
            _setter("placement", placement)
        if public_key is not None:
            _setter("public_key", public_key)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your OpenStack account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your OpenStack container
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your OpenStack account
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingPapertrail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingPapertrail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingPapertrail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingPapertrail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 port: int,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str address: The address of the Papertrail endpoint
        :param str name: A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param int port: The port associated with the address where the Papertrail endpoint can be accessed
        :param str format: A Fastly [log format string](https://docs.fastly.com/en/guides/custom-log-formats)
        :param int format_version: The version of the custom logging format used for the configured endpoint. The logging call gets placed by default in `vcl_log` if `format_version` is set to `2` and in `vcl_deliver` if `format_version` is set to `1`
        :param str placement: Where in the generated VCL the logging call should be placed. If not set, endpoints with `format_version` of 2 are placed in `vcl_log` and those with `format_version` of 1 are placed in `vcl_deliver`
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute
        """
        ServiceVclLoggingPapertrail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            name=name,
            port=port,
            format=format,
            format_version=format_version,
            placement=placement,
            response_condition=response_condition,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             name: Optional[str] = None,
             port: Optional[int] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             placement: Optional[str] = None,
             response_condition: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if address is None:
            raise TypeError("Missing 'address' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if port is None:
            raise TypeError("Missing 'port' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']

        _setter("address", address)
        _setter("name", name)
        _setter("port", port)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if placement is not None:
            _setter("placement", placement)
        if response_condition is not None:
            _setter("response_condition", response_condition)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The address of the Papertrail endpoint
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port associated with the address where the Papertrail endpoint can be accessed
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        A Fastly [log format string](https://docs.fastly.com/en/guides/custom-log-formats)
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. The logging call gets placed by default in `vcl_log` if `format_version` is set to `2` and in `vcl_deliver` if `format_version` is set to `1`
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. If not set, endpoints with `format_version` of 2 are placed in `vcl_log` and those with `format_version` of 1 are placed in `vcl_deliver`
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "s3AccessKey":
            suggest = "s3_access_key"
        elif key == "s3IamRole":
            suggest = "s3_iam_role"
        elif key == "s3SecretKey":
            suggest = "s3_secret_key"
        elif key == "serverSideEncryption":
            suggest = "server_side_encryption"
        elif key == "serverSideEncryptionKmsKeyId":
            suggest = "server_side_encryption_kms_key_id"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 name: str,
                 acl: Optional[str] = None,
                 compression_codec: Optional[str] = None,
                 domain: Optional[str] = None,
                 file_max_bytes: Optional[int] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 redundancy: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 s3_access_key: Optional[str] = None,
                 s3_iam_role: Optional[str] = None,
                 s3_secret_key: Optional[str] = None,
                 server_side_encryption: Optional[str] = None,
                 server_side_encryption_kms_key_id: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str bucket_name: The name of the bucket in which to store the logs
        :param str name: The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str acl: The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str domain: If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        :param int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2).
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str redundancy: The S3 storage class (redundancy level). Should be one of: `standard`, `intelligent_tiering`, `standard_ia`, `onezone_ia`, `glacier`, `glacier_ir`, `deep_archive`, or `reduced_redundancy`
        :param str response_condition: Name of blockAttributes condition to apply this logging.
        :param str s3_access_key: AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        :param str s3_iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        :param str s3_secret_key: AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        :param str server_side_encryption: Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        :param str server_side_encryption_kms_key_id: Optional server-side KMS Key Id. Must be set if server*side*encryption is set to `aws:kms`
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceVclLoggingS3._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket_name=bucket_name,
            name=name,
            acl=acl,
            compression_codec=compression_codec,
            domain=domain,
            file_max_bytes=file_max_bytes,
            format=format,
            format_version=format_version,
            gzip_level=gzip_level,
            message_type=message_type,
            path=path,
            period=period,
            placement=placement,
            public_key=public_key,
            redundancy=redundancy,
            response_condition=response_condition,
            s3_access_key=s3_access_key,
            s3_iam_role=s3_iam_role,
            s3_secret_key=s3_secret_key,
            server_side_encryption=server_side_encryption,
            server_side_encryption_kms_key_id=server_side_encryption_kms_key_id,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket_name: Optional[str] = None,
             name: Optional[str] = None,
             acl: Optional[str] = None,
             compression_codec: Optional[str] = None,
             domain: Optional[str] = None,
             file_max_bytes: Optional[int] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             path: Optional[str] = None,
             period: Optional[int] = None,
             placement: Optional[str] = None,
             public_key: Optional[str] = None,
             redundancy: Optional[str] = None,
             response_condition: Optional[str] = None,
             s3_access_key: Optional[str] = None,
             s3_iam_role: Optional[str] = None,
             s3_secret_key: Optional[str] = None,
             server_side_encryption: Optional[str] = None,
             server_side_encryption_kms_key_id: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if bucket_name is None and 'bucketName' in kwargs:
            bucket_name = kwargs['bucketName']
        if bucket_name is None:
            raise TypeError("Missing 'bucket_name' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if file_max_bytes is None and 'fileMaxBytes' in kwargs:
            file_max_bytes = kwargs['fileMaxBytes']
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if s3_access_key is None and 's3AccessKey' in kwargs:
            s3_access_key = kwargs['s3AccessKey']
        if s3_iam_role is None and 's3IamRole' in kwargs:
            s3_iam_role = kwargs['s3IamRole']
        if s3_secret_key is None and 's3SecretKey' in kwargs:
            s3_secret_key = kwargs['s3SecretKey']
        if server_side_encryption is None and 'serverSideEncryption' in kwargs:
            server_side_encryption = kwargs['serverSideEncryption']
        if server_side_encryption_kms_key_id is None and 'serverSideEncryptionKmsKeyId' in kwargs:
            server_side_encryption_kms_key_id = kwargs['serverSideEncryptionKmsKeyId']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("bucket_name", bucket_name)
        _setter("name", name)
        if acl is not None:
            _setter("acl", acl)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if domain is not None:
            _setter("domain", domain)
        if file_max_bytes is not None:
            _setter("file_max_bytes", file_max_bytes)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if path is not None:
            _setter("path", path)
        if period is not None:
            _setter("period", period)
        if placement is not None:
            _setter("placement", placement)
        if public_key is not None:
            _setter("public_key", public_key)
        if redundancy is not None:
            _setter("redundancy", redundancy)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if s3_access_key is not None:
            _setter("s3_access_key", s3_access_key)
        if s3_iam_role is not None:
            _setter("s3_iam_role", s3_iam_role)
        if s3_secret_key is not None:
            _setter("s3_secret_key", s3_secret_key)
        if server_side_encryption is not None:
            _setter("server_side_encryption", server_side_encryption)
        if server_side_encryption_kms_key_id is not None:
            _setter("server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def acl(self) -> Optional[str]:
        """
        The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def redundancy(self) -> Optional[str]:
        """
        The S3 storage class (redundancy level). Should be one of: `standard`, `intelligent_tiering`, `standard_ia`, `onezone_ia`, `glacier`, `glacier_ir`, `deep_archive`, or `reduced_redundancy`
        """
        return pulumi.get(self, "redundancy")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> Optional[str]:
        """
        AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        """
        return pulumi.get(self, "s3_access_key")

    @property
    @pulumi.getter(name="s3IamRole")
    def s3_iam_role(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        """
        return pulumi.get(self, "s3_iam_role")

    @property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> Optional[str]:
        """
        AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        """
        return pulumi.get(self, "s3_secret_key")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[str]:
        """
        Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[str]:
        """
        Optional server-side KMS Key Id. Must be set if server*side*encryption is set to `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingScalyr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingScalyr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingScalyr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingScalyr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 region: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The token to use for authentication (https://www.scalyr.com/keys)
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        ServiceVclLoggingScalyr._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            format=format,
            format_version=format_version,
            placement=placement,
            region=region,
            response_condition=response_condition,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             placement: Optional[str] = None,
             region: Optional[str] = None,
             response_condition: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']

        _setter("name", name)
        _setter("token", token)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if placement is not None:
            _setter("placement", placement)
        if region is not None:
            _setter("region", region)
        if response_condition is not None:
            _setter("response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to use for authentication (https://www.scalyr.com/keys)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingSftp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKnownHosts":
            suggest = "ssh_known_hosts"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingSftp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingSftp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingSftp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 path: str,
                 ssh_known_hosts: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 password: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 port: Optional[int] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str address: The SFTP address to stream logs to
        :param str name: The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param str ssh_known_hosts: A list of host keys for all hosts we can connect to over SFTP
        :param str user: The username for the server
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param int port: The port the SFTP service listens on. (Default: `22`)
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str response_condition: The name of the condition to apply.
        :param str secret_key: The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        ServiceVclLoggingSftp._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            name=name,
            path=path,
            ssh_known_hosts=ssh_known_hosts,
            user=user,
            compression_codec=compression_codec,
            format=format,
            format_version=format_version,
            gzip_level=gzip_level,
            message_type=message_type,
            password=password,
            period=period,
            placement=placement,
            port=port,
            public_key=public_key,
            response_condition=response_condition,
            secret_key=secret_key,
            timestamp_format=timestamp_format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             name: Optional[str] = None,
             path: Optional[str] = None,
             ssh_known_hosts: Optional[str] = None,
             user: Optional[str] = None,
             compression_codec: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             gzip_level: Optional[int] = None,
             message_type: Optional[str] = None,
             password: Optional[str] = None,
             period: Optional[int] = None,
             placement: Optional[str] = None,
             port: Optional[int] = None,
             public_key: Optional[str] = None,
             response_condition: Optional[str] = None,
             secret_key: Optional[str] = None,
             timestamp_format: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if address is None:
            raise TypeError("Missing 'address' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if path is None:
            raise TypeError("Missing 'path' argument")
        if ssh_known_hosts is None and 'sshKnownHosts' in kwargs:
            ssh_known_hosts = kwargs['sshKnownHosts']
        if ssh_known_hosts is None:
            raise TypeError("Missing 'ssh_known_hosts' argument")
        if user is None:
            raise TypeError("Missing 'user' argument")
        if compression_codec is None and 'compressionCodec' in kwargs:
            compression_codec = kwargs['compressionCodec']
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if gzip_level is None and 'gzipLevel' in kwargs:
            gzip_level = kwargs['gzipLevel']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if public_key is None and 'publicKey' in kwargs:
            public_key = kwargs['publicKey']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if secret_key is None and 'secretKey' in kwargs:
            secret_key = kwargs['secretKey']
        if timestamp_format is None and 'timestampFormat' in kwargs:
            timestamp_format = kwargs['timestampFormat']

        _setter("address", address)
        _setter("name", name)
        _setter("path", path)
        _setter("ssh_known_hosts", ssh_known_hosts)
        _setter("user", user)
        if compression_codec is not None:
            _setter("compression_codec", compression_codec)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if gzip_level is not None:
            _setter("gzip_level", gzip_level)
        if message_type is not None:
            _setter("message_type", message_type)
        if password is not None:
            _setter("password", password)
        if period is not None:
            _setter("period", period)
        if placement is not None:
            _setter("placement", placement)
        if port is not None:
            _setter("port", port)
        if public_key is not None:
            _setter("public_key", public_key)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if secret_key is not None:
            _setter("secret_key", secret_key)
        if timestamp_format is not None:
            _setter("timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> str:
        """
        A list of host keys for all hosts we can connect to over SFTP
        """
        return pulumi.get(self, "ssh_known_hosts")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for the server
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port the SFTP service listens on. (Default: `22`)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceVclLoggingSplunk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingSplunk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingSplunk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingSplunk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str name: A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The Splunk token to be used for authentication
        :param str url: The Splunk URL to stream logs to
        :param str format: Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param str placement: Where in the generated VCL the logging call should be placed
        :param str response_condition: The name of the condition to apply
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param bool use_tls: Whether to use TLS for secure logging. Default: `false`
        """
        ServiceVclLoggingSplunk._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            token=token,
            url=url,
            format=format,
            format_version=format_version,
            placement=placement,
            response_condition=response_condition,
            tls_ca_cert=tls_ca_cert,
            tls_client_cert=tls_client_cert,
            tls_client_key=tls_client_key,
            tls_hostname=tls_hostname,
            use_tls=use_tls,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             token: Optional[str] = None,
             url: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             placement: Optional[str] = None,
             response_condition: Optional[str] = None,
             tls_ca_cert: Optional[str] = None,
             tls_client_cert: Optional[str] = None,
             tls_client_key: Optional[str] = None,
             tls_hostname: Optional[str] = None,
             use_tls: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if token is None:
            raise TypeError("Missing 'token' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if tls_ca_cert is None and 'tlsCaCert' in kwargs:
            tls_ca_cert = kwargs['tlsCaCert']
        if tls_client_cert is None and 'tlsClientCert' in kwargs:
            tls_client_cert = kwargs['tlsClientCert']
        if tls_client_key is None and 'tlsClientKey' in kwargs:
            tls_client_key = kwargs['tlsClientKey']
        if tls_hostname is None and 'tlsHostname' in kwargs:
            tls_hostname = kwargs['tlsHostname']
        if use_tls is None and 'useTls' in kwargs:
            use_tls = kwargs['useTls']

        _setter("name", name)
        _setter("token", token)
        _setter("url", url)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if placement is not None:
            _setter("placement", placement)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if tls_ca_cert is not None:
            _setter("tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            _setter("tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            _setter("tls_client_key", tls_client_key)
        if tls_hostname is not None:
            _setter("tls_hostname", tls_hostname)
        if use_tls is not None:
            _setter("use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Splunk token to be used for authentication
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The Splunk URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Default: `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceVclLoggingSumologic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingSumologic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingSumologic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingSumologic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 message_type: Optional[str] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: The URL to Sumologic collector endpoint
        :param str format: Apache-style string or VCL variables to use for log formatting
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str response_condition: Name of blockAttributes condition to apply this logging.
        """
        ServiceVclLoggingSumologic._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            url=url,
            format=format,
            format_version=format_version,
            message_type=message_type,
            placement=placement,
            response_condition=response_condition,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             url: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             message_type: Optional[str] = None,
             placement: Optional[str] = None,
             response_condition: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if url is None:
            raise TypeError("Missing 'url' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']

        _setter("name", name)
        _setter("url", url)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if message_type is not None:
            _setter("message_type", message_type)
        if placement is not None:
            _setter("placement", placement)
        if response_condition is not None:
            _setter("response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL to Sumologic collector endpoint
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class ServiceVclLoggingSyslog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclLoggingSyslog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclLoggingSyslog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclLoggingSyslog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 message_type: Optional[str] = None,
                 placement: Optional[str] = None,
                 port: Optional[int] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 token: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str address: A hostname or IPv4 address of the Syslog endpoint
        :param str name: A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str format: Apache-style string or VCL variables to use for log formatting
        :param int format_version: The version of the custom logging format. Can be either 1 or 2. (Default: 2)
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param int port: The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        :param str response_condition: Name of blockAttributes condition to apply this logging.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        :param str tls_hostname: Used during the TLS handshake to validate the certificate
        :param str token: Whether to prepend each message with a specific token
        :param bool use_tls: Whether to use TLS for secure logging. Default `false`
        """
        ServiceVclLoggingSyslog._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            address=address,
            name=name,
            format=format,
            format_version=format_version,
            message_type=message_type,
            placement=placement,
            port=port,
            response_condition=response_condition,
            tls_ca_cert=tls_ca_cert,
            tls_client_cert=tls_client_cert,
            tls_client_key=tls_client_key,
            tls_hostname=tls_hostname,
            token=token,
            use_tls=use_tls,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             address: Optional[str] = None,
             name: Optional[str] = None,
             format: Optional[str] = None,
             format_version: Optional[int] = None,
             message_type: Optional[str] = None,
             placement: Optional[str] = None,
             port: Optional[int] = None,
             response_condition: Optional[str] = None,
             tls_ca_cert: Optional[str] = None,
             tls_client_cert: Optional[str] = None,
             tls_client_key: Optional[str] = None,
             tls_hostname: Optional[str] = None,
             token: Optional[str] = None,
             use_tls: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if address is None:
            raise TypeError("Missing 'address' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if format_version is None and 'formatVersion' in kwargs:
            format_version = kwargs['formatVersion']
        if message_type is None and 'messageType' in kwargs:
            message_type = kwargs['messageType']
        if response_condition is None and 'responseCondition' in kwargs:
            response_condition = kwargs['responseCondition']
        if tls_ca_cert is None and 'tlsCaCert' in kwargs:
            tls_ca_cert = kwargs['tlsCaCert']
        if tls_client_cert is None and 'tlsClientCert' in kwargs:
            tls_client_cert = kwargs['tlsClientCert']
        if tls_client_key is None and 'tlsClientKey' in kwargs:
            tls_client_key = kwargs['tlsClientKey']
        if tls_hostname is None and 'tlsHostname' in kwargs:
            tls_hostname = kwargs['tlsHostname']
        if use_tls is None and 'useTls' in kwargs:
            use_tls = kwargs['useTls']

        _setter("address", address)
        _setter("name", name)
        if format is not None:
            _setter("format", format)
        if format_version is not None:
            _setter("format_version", format_version)
        if message_type is not None:
            _setter("message_type", message_type)
        if placement is not None:
            _setter("placement", placement)
        if port is not None:
            _setter("port", port)
        if response_condition is not None:
            _setter("response_condition", response_condition)
        if tls_ca_cert is not None:
            _setter("tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            _setter("tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            _setter("tls_client_key", tls_client_key)
        if tls_hostname is not None:
            _setter("tls_hostname", tls_hostname)
        if token is not None:
            _setter("token", token)
        if use_tls is not None:
            _setter("use_tls", use_tls)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        A hostname or IPv4 address of the Syslog endpoint
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format. Can be either 1 or 2. (Default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default is `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        Whether to prepend each message with a specific token
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Default `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceVclProductEnablement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "brotliCompression":
            suggest = "brotli_compression"
        elif key == "domainInspector":
            suggest = "domain_inspector"
        elif key == "imageOptimizer":
            suggest = "image_optimizer"
        elif key == "originInspector":
            suggest = "origin_inspector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclProductEnablement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclProductEnablement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclProductEnablement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 brotli_compression: Optional[bool] = None,
                 domain_inspector: Optional[bool] = None,
                 image_optimizer: Optional[bool] = None,
                 name: Optional[str] = None,
                 origin_inspector: Optional[bool] = None,
                 websockets: Optional[bool] = None):
        """
        :param bool brotli_compression: Enable Brotli Compression support
        :param bool domain_inspector: Enable Domain Inspector support
        :param bool image_optimizer: Enable Image Optimizer support (requires at least one backend with a `shield` attribute)
        :param str name: Used by the provider to identify modified settings (changing this value will force the entire block to be deleted, then recreated)
        :param bool origin_inspector: Enable Origin Inspector support
        :param bool websockets: Enable WebSockets support
        """
        ServiceVclProductEnablement._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            brotli_compression=brotli_compression,
            domain_inspector=domain_inspector,
            image_optimizer=image_optimizer,
            name=name,
            origin_inspector=origin_inspector,
            websockets=websockets,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             brotli_compression: Optional[bool] = None,
             domain_inspector: Optional[bool] = None,
             image_optimizer: Optional[bool] = None,
             name: Optional[str] = None,
             origin_inspector: Optional[bool] = None,
             websockets: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if brotli_compression is None and 'brotliCompression' in kwargs:
            brotli_compression = kwargs['brotliCompression']
        if domain_inspector is None and 'domainInspector' in kwargs:
            domain_inspector = kwargs['domainInspector']
        if image_optimizer is None and 'imageOptimizer' in kwargs:
            image_optimizer = kwargs['imageOptimizer']
        if origin_inspector is None and 'originInspector' in kwargs:
            origin_inspector = kwargs['originInspector']

        if brotli_compression is not None:
            _setter("brotli_compression", brotli_compression)
        if domain_inspector is not None:
            _setter("domain_inspector", domain_inspector)
        if image_optimizer is not None:
            _setter("image_optimizer", image_optimizer)
        if name is not None:
            _setter("name", name)
        if origin_inspector is not None:
            _setter("origin_inspector", origin_inspector)
        if websockets is not None:
            _setter("websockets", websockets)

    @property
    @pulumi.getter(name="brotliCompression")
    def brotli_compression(self) -> Optional[bool]:
        """
        Enable Brotli Compression support
        """
        return pulumi.get(self, "brotli_compression")

    @property
    @pulumi.getter(name="domainInspector")
    def domain_inspector(self) -> Optional[bool]:
        """
        Enable Domain Inspector support
        """
        return pulumi.get(self, "domain_inspector")

    @property
    @pulumi.getter(name="imageOptimizer")
    def image_optimizer(self) -> Optional[bool]:
        """
        Enable Image Optimizer support (requires at least one backend with a `shield` attribute)
        """
        return pulumi.get(self, "image_optimizer")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Used by the provider to identify modified settings (changing this value will force the entire block to be deleted, then recreated)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="originInspector")
    def origin_inspector(self) -> Optional[bool]:
        """
        Enable Origin Inspector support
        """
        return pulumi.get(self, "origin_inspector")

    @property
    @pulumi.getter
    def websockets(self) -> Optional[bool]:
        """
        Enable WebSockets support
        """
        return pulumi.get(self, "websockets")


@pulumi.output_type
class ServiceVclRateLimiter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientKey":
            suggest = "client_key"
        elif key == "httpMethods":
            suggest = "http_methods"
        elif key == "penaltyBoxDuration":
            suggest = "penalty_box_duration"
        elif key == "rpsLimit":
            suggest = "rps_limit"
        elif key == "windowSize":
            suggest = "window_size"
        elif key == "featureRevision":
            suggest = "feature_revision"
        elif key == "loggerType":
            suggest = "logger_type"
        elif key == "ratelimiterId":
            suggest = "ratelimiter_id"
        elif key == "responseObjectName":
            suggest = "response_object_name"
        elif key == "uriDictionaryName":
            suggest = "uri_dictionary_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclRateLimiter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclRateLimiter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclRateLimiter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 client_key: str,
                 http_methods: str,
                 name: str,
                 penalty_box_duration: int,
                 rps_limit: int,
                 window_size: int,
                 feature_revision: Optional[int] = None,
                 logger_type: Optional[str] = None,
                 ratelimiter_id: Optional[str] = None,
                 response: Optional['outputs.ServiceVclRateLimiterResponse'] = None,
                 response_object_name: Optional[str] = None,
                 uri_dictionary_name: Optional[str] = None):
        """
        :param str action: The action to take when a rate limiter violation is detected (one of: log*only, response, response*object)
        :param str client_key: Comma-separated list of VCL variables used to generate a counter key to identify a client
        :param str http_methods: Comma-separated list of HTTP methods to apply rate limiting to
        :param str name: A unique human readable name for the rate limiting rule
        :param int penalty_box_duration: Length of time in minutes that the rate limiter is in effect after the initial violation is detected
        :param int rps_limit: Upper limit of requests per second allowed by the rate limiter
        :param int window_size: Number of seconds during which the RPS limit must be exceeded in order to trigger a violation (one of: 1, 10, 60)
        :param int feature_revision: Revision number of the rate limiting feature implementation
        :param str logger_type: Name of the type of logging endpoint to be used when action is log_only (one of: azureblob, bigquery, cloudfiles, datadog, digitalocean, elasticsearch, ftp, gcs, googleanalytics, heroku, honeycomb, http, https, kafka, kinesis, logentries, loggly, logshuttle, newrelic, openstack, papertrail, pubsub, s3, scalyr, sftp, splunk, stackdriver, sumologic, syslog)
        :param str ratelimiter_id: Alphanumeric string identifying the rate limiter
        :param 'ServiceVclRateLimiterResponseArgs' response: Custom response to be sent when the rate limit is exceeded. Required if action is response
        :param str response_object_name: Name of existing response object. Required if action is response_object
        :param str uri_dictionary_name: The name of an Edge Dictionary containing URIs as keys. If not defined or null, all origin URIs will be rate limited
        """
        ServiceVclRateLimiter._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            client_key=client_key,
            http_methods=http_methods,
            name=name,
            penalty_box_duration=penalty_box_duration,
            rps_limit=rps_limit,
            window_size=window_size,
            feature_revision=feature_revision,
            logger_type=logger_type,
            ratelimiter_id=ratelimiter_id,
            response=response,
            response_object_name=response_object_name,
            uri_dictionary_name=uri_dictionary_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: Optional[str] = None,
             client_key: Optional[str] = None,
             http_methods: Optional[str] = None,
             name: Optional[str] = None,
             penalty_box_duration: Optional[int] = None,
             rps_limit: Optional[int] = None,
             window_size: Optional[int] = None,
             feature_revision: Optional[int] = None,
             logger_type: Optional[str] = None,
             ratelimiter_id: Optional[str] = None,
             response: Optional['outputs.ServiceVclRateLimiterResponse'] = None,
             response_object_name: Optional[str] = None,
             uri_dictionary_name: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if action is None:
            raise TypeError("Missing 'action' argument")
        if client_key is None and 'clientKey' in kwargs:
            client_key = kwargs['clientKey']
        if client_key is None:
            raise TypeError("Missing 'client_key' argument")
        if http_methods is None and 'httpMethods' in kwargs:
            http_methods = kwargs['httpMethods']
        if http_methods is None:
            raise TypeError("Missing 'http_methods' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if penalty_box_duration is None and 'penaltyBoxDuration' in kwargs:
            penalty_box_duration = kwargs['penaltyBoxDuration']
        if penalty_box_duration is None:
            raise TypeError("Missing 'penalty_box_duration' argument")
        if rps_limit is None and 'rpsLimit' in kwargs:
            rps_limit = kwargs['rpsLimit']
        if rps_limit is None:
            raise TypeError("Missing 'rps_limit' argument")
        if window_size is None and 'windowSize' in kwargs:
            window_size = kwargs['windowSize']
        if window_size is None:
            raise TypeError("Missing 'window_size' argument")
        if feature_revision is None and 'featureRevision' in kwargs:
            feature_revision = kwargs['featureRevision']
        if logger_type is None and 'loggerType' in kwargs:
            logger_type = kwargs['loggerType']
        if ratelimiter_id is None and 'ratelimiterId' in kwargs:
            ratelimiter_id = kwargs['ratelimiterId']
        if response_object_name is None and 'responseObjectName' in kwargs:
            response_object_name = kwargs['responseObjectName']
        if uri_dictionary_name is None and 'uriDictionaryName' in kwargs:
            uri_dictionary_name = kwargs['uriDictionaryName']

        _setter("action", action)
        _setter("client_key", client_key)
        _setter("http_methods", http_methods)
        _setter("name", name)
        _setter("penalty_box_duration", penalty_box_duration)
        _setter("rps_limit", rps_limit)
        _setter("window_size", window_size)
        if feature_revision is not None:
            _setter("feature_revision", feature_revision)
        if logger_type is not None:
            _setter("logger_type", logger_type)
        if ratelimiter_id is not None:
            _setter("ratelimiter_id", ratelimiter_id)
        if response is not None:
            _setter("response", response)
        if response_object_name is not None:
            _setter("response_object_name", response_object_name)
        if uri_dictionary_name is not None:
            _setter("uri_dictionary_name", uri_dictionary_name)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action to take when a rate limiter violation is detected (one of: log*only, response, response*object)
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        Comma-separated list of VCL variables used to generate a counter key to identify a client
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="httpMethods")
    def http_methods(self) -> str:
        """
        Comma-separated list of HTTP methods to apply rate limiting to
        """
        return pulumi.get(self, "http_methods")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique human readable name for the rate limiting rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="penaltyBoxDuration")
    def penalty_box_duration(self) -> int:
        """
        Length of time in minutes that the rate limiter is in effect after the initial violation is detected
        """
        return pulumi.get(self, "penalty_box_duration")

    @property
    @pulumi.getter(name="rpsLimit")
    def rps_limit(self) -> int:
        """
        Upper limit of requests per second allowed by the rate limiter
        """
        return pulumi.get(self, "rps_limit")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> int:
        """
        Number of seconds during which the RPS limit must be exceeded in order to trigger a violation (one of: 1, 10, 60)
        """
        return pulumi.get(self, "window_size")

    @property
    @pulumi.getter(name="featureRevision")
    def feature_revision(self) -> Optional[int]:
        """
        Revision number of the rate limiting feature implementation
        """
        return pulumi.get(self, "feature_revision")

    @property
    @pulumi.getter(name="loggerType")
    def logger_type(self) -> Optional[str]:
        """
        Name of the type of logging endpoint to be used when action is log_only (one of: azureblob, bigquery, cloudfiles, datadog, digitalocean, elasticsearch, ftp, gcs, googleanalytics, heroku, honeycomb, http, https, kafka, kinesis, logentries, loggly, logshuttle, newrelic, openstack, papertrail, pubsub, s3, scalyr, sftp, splunk, stackdriver, sumologic, syslog)
        """
        return pulumi.get(self, "logger_type")

    @property
    @pulumi.getter(name="ratelimiterId")
    def ratelimiter_id(self) -> Optional[str]:
        """
        Alphanumeric string identifying the rate limiter
        """
        return pulumi.get(self, "ratelimiter_id")

    @property
    @pulumi.getter
    def response(self) -> Optional['outputs.ServiceVclRateLimiterResponse']:
        """
        Custom response to be sent when the rate limit is exceeded. Required if action is response
        """
        return pulumi.get(self, "response")

    @property
    @pulumi.getter(name="responseObjectName")
    def response_object_name(self) -> Optional[str]:
        """
        Name of existing response object. Required if action is response_object
        """
        return pulumi.get(self, "response_object_name")

    @property
    @pulumi.getter(name="uriDictionaryName")
    def uri_dictionary_name(self) -> Optional[str]:
        """
        The name of an Edge Dictionary containing URIs as keys. If not defined or null, all origin URIs will be rate limited
        """
        return pulumi.get(self, "uri_dictionary_name")


@pulumi.output_type
class ServiceVclRateLimiterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclRateLimiterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclRateLimiterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclRateLimiterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 status: int):
        """
        :param str content: The VCL code that specifies exactly what the snippet does
        :param str content_type: Value of the `Content-Type` header sent with the request
        :param int status: HTTP response status code (e.g. 429)
        """
        ServiceVclRateLimiterResponse._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            content_type=content_type,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: Optional[str] = None,
             content_type: Optional[str] = None,
             status: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if content is None:
            raise TypeError("Missing 'content' argument")
        if content_type is None and 'contentType' in kwargs:
            content_type = kwargs['contentType']
        if content_type is None:
            raise TypeError("Missing 'content_type' argument")
        if status is None:
            raise TypeError("Missing 'status' argument")

        _setter("content", content)
        _setter("content_type", content_type)
        _setter("status", status)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Value of the `Content-Type` header sent with the request
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def status(self) -> int:
        """
        HTTP response status code (e.g. 429)
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServiceVclRequestSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bypassBusyWait":
            suggest = "bypass_busy_wait"
        elif key == "defaultHost":
            suggest = "default_host"
        elif key == "forceMiss":
            suggest = "force_miss"
        elif key == "forceSsl":
            suggest = "force_ssl"
        elif key == "geoHeaders":
            suggest = "geo_headers"
        elif key == "hashKeys":
            suggest = "hash_keys"
        elif key == "maxStaleAge":
            suggest = "max_stale_age"
        elif key == "requestCondition":
            suggest = "request_condition"
        elif key == "timerSupport":
            suggest = "timer_support"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclRequestSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclRequestSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclRequestSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 action: Optional[str] = None,
                 bypass_busy_wait: Optional[bool] = None,
                 default_host: Optional[str] = None,
                 force_miss: Optional[bool] = None,
                 force_ssl: Optional[bool] = None,
                 geo_headers: Optional[bool] = None,
                 hash_keys: Optional[str] = None,
                 max_stale_age: Optional[int] = None,
                 request_condition: Optional[str] = None,
                 timer_support: Optional[bool] = None,
                 xff: Optional[str] = None):
        """
        :param str name: Unique name to refer to this Request Setting. It is important to note that changing this attribute will delete and recreate the resource
        :param str action: Allows you to terminate request handling and immediately perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely)
        :param bool bypass_busy_wait: Disable collapsed forwarding, so you don't wait for other objects to origin
        :param str default_host: Sets the host header
        :param bool force_miss: Force a cache miss for the request. If specified, can be `true` or `false`
        :param bool force_ssl: Forces the request to use SSL (Redirects a non-SSL request to SSL)
        :param bool geo_headers: Injects Fastly-Geo-Country, Fastly-Geo-City, and Fastly-Geo-Region into the request headers
        :param str hash_keys: Comma separated list of varnish request object fields that should be in the hash key
        :param int max_stale_age: How old an object is allowed to be to serve `stale-if-error` or `stale-while-revalidate`, in seconds
        :param str request_condition: Name of already defined `condition` to determine if this request setting should be applied (should be unique across multiple instances of `request_setting`)
        :param bool timer_support: Injects the X-Timer info into the request for viewing origin fetch durations
        :param str xff: X-Forwarded-For, should be `clear`, `leave`, `append`, `append_all`, or `overwrite`. Default `append`
        """
        ServiceVclRequestSetting._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            action=action,
            bypass_busy_wait=bypass_busy_wait,
            default_host=default_host,
            force_miss=force_miss,
            force_ssl=force_ssl,
            geo_headers=geo_headers,
            hash_keys=hash_keys,
            max_stale_age=max_stale_age,
            request_condition=request_condition,
            timer_support=timer_support,
            xff=xff,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             action: Optional[str] = None,
             bypass_busy_wait: Optional[bool] = None,
             default_host: Optional[str] = None,
             force_miss: Optional[bool] = None,
             force_ssl: Optional[bool] = None,
             geo_headers: Optional[bool] = None,
             hash_keys: Optional[str] = None,
             max_stale_age: Optional[int] = None,
             request_condition: Optional[str] = None,
             timer_support: Optional[bool] = None,
             xff: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if bypass_busy_wait is None and 'bypassBusyWait' in kwargs:
            bypass_busy_wait = kwargs['bypassBusyWait']
        if default_host is None and 'defaultHost' in kwargs:
            default_host = kwargs['defaultHost']
        if force_miss is None and 'forceMiss' in kwargs:
            force_miss = kwargs['forceMiss']
        if force_ssl is None and 'forceSsl' in kwargs:
            force_ssl = kwargs['forceSsl']
        if geo_headers is None and 'geoHeaders' in kwargs:
            geo_headers = kwargs['geoHeaders']
        if hash_keys is None and 'hashKeys' in kwargs:
            hash_keys = kwargs['hashKeys']
        if max_stale_age is None and 'maxStaleAge' in kwargs:
            max_stale_age = kwargs['maxStaleAge']
        if request_condition is None and 'requestCondition' in kwargs:
            request_condition = kwargs['requestCondition']
        if timer_support is None and 'timerSupport' in kwargs:
            timer_support = kwargs['timerSupport']

        _setter("name", name)
        if action is not None:
            _setter("action", action)
        if bypass_busy_wait is not None:
            _setter("bypass_busy_wait", bypass_busy_wait)
        if default_host is not None:
            _setter("default_host", default_host)
        if force_miss is not None:
            _setter("force_miss", force_miss)
        if force_ssl is not None:
            _setter("force_ssl", force_ssl)
        if geo_headers is not None:
            _setter("geo_headers", geo_headers)
        if hash_keys is not None:
            _setter("hash_keys", hash_keys)
        if max_stale_age is not None:
            _setter("max_stale_age", max_stale_age)
        if request_condition is not None:
            _setter("request_condition", request_condition)
        if timer_support is not None:
            _setter("timer_support", timer_support)
        if xff is not None:
            _setter("xff", xff)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name to refer to this Request Setting. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Allows you to terminate request handling and immediately perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely)
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="bypassBusyWait")
    def bypass_busy_wait(self) -> Optional[bool]:
        """
        Disable collapsed forwarding, so you don't wait for other objects to origin
        """
        return pulumi.get(self, "bypass_busy_wait")

    @property
    @pulumi.getter(name="defaultHost")
    def default_host(self) -> Optional[str]:
        """
        Sets the host header
        """
        return pulumi.get(self, "default_host")

    @property
    @pulumi.getter(name="forceMiss")
    def force_miss(self) -> Optional[bool]:
        """
        Force a cache miss for the request. If specified, can be `true` or `false`
        """
        return pulumi.get(self, "force_miss")

    @property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[bool]:
        """
        Forces the request to use SSL (Redirects a non-SSL request to SSL)
        """
        return pulumi.get(self, "force_ssl")

    @property
    @pulumi.getter(name="geoHeaders")
    def geo_headers(self) -> Optional[bool]:
        """
        Injects Fastly-Geo-Country, Fastly-Geo-City, and Fastly-Geo-Region into the request headers
        """
        warnings.warn("""'geo_headers' attribute has been deprecated and will be removed in the next major version release""", DeprecationWarning)
        pulumi.log.warn("""geo_headers is deprecated: 'geo_headers' attribute has been deprecated and will be removed in the next major version release""")

        return pulumi.get(self, "geo_headers")

    @property
    @pulumi.getter(name="hashKeys")
    def hash_keys(self) -> Optional[str]:
        """
        Comma separated list of varnish request object fields that should be in the hash key
        """
        return pulumi.get(self, "hash_keys")

    @property
    @pulumi.getter(name="maxStaleAge")
    def max_stale_age(self) -> Optional[int]:
        """
        How old an object is allowed to be to serve `stale-if-error` or `stale-while-revalidate`, in seconds
        """
        return pulumi.get(self, "max_stale_age")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to determine if this request setting should be applied (should be unique across multiple instances of `request_setting`)
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter(name="timerSupport")
    def timer_support(self) -> Optional[bool]:
        """
        Injects the X-Timer info into the request for viewing origin fetch durations
        """
        return pulumi.get(self, "timer_support")

    @property
    @pulumi.getter
    def xff(self) -> Optional[str]:
        """
        X-Forwarded-For, should be `clear`, `leave`, `append`, `append_all`, or `overwrite`. Default `append`
        """
        return pulumi.get(self, "xff")


@pulumi.output_type
class ServiceVclResponseObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "requestCondition":
            suggest = "request_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclResponseObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclResponseObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclResponseObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 cache_condition: Optional[str] = None,
                 content: Optional[str] = None,
                 content_type: Optional[str] = None,
                 request_condition: Optional[str] = None,
                 response: Optional[str] = None,
                 status: Optional[int] = None):
        """
        :param str name: A unique name to identify this Response Object. It is important to note that changing this attribute will delete and recreate the resource
        :param str cache_condition: Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param str content: The content to deliver for the response object
        :param str content_type: The MIME type of the content
        :param str request_condition: Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`
        :param str response: The HTTP Response. Default `OK`
        :param int status: The HTTP Status Code. Default `200`
        """
        ServiceVclResponseObject._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            cache_condition=cache_condition,
            content=content,
            content_type=content_type,
            request_condition=request_condition,
            response=response,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             cache_condition: Optional[str] = None,
             content: Optional[str] = None,
             content_type: Optional[str] = None,
             request_condition: Optional[str] = None,
             response: Optional[str] = None,
             status: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if name is None:
            raise TypeError("Missing 'name' argument")
        if cache_condition is None and 'cacheCondition' in kwargs:
            cache_condition = kwargs['cacheCondition']
        if content_type is None and 'contentType' in kwargs:
            content_type = kwargs['contentType']
        if request_condition is None and 'requestCondition' in kwargs:
            request_condition = kwargs['requestCondition']

        _setter("name", name)
        if cache_condition is not None:
            _setter("cache_condition", cache_condition)
        if content is not None:
            _setter("content", content)
        if content_type is not None:
            _setter("content_type", content_type)
        if request_condition is not None:
            _setter("request_condition", request_condition)
        if response is not None:
            _setter("response", response)
        if status is not None:
            _setter("status", status)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Response Object. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        The content to deliver for the response object
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        The MIME type of the content
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter
    def response(self) -> Optional[str]:
        """
        The HTTP Response. Default `OK`
        """
        return pulumi.get(self, "response")

    @property
    @pulumi.getter
    def status(self) -> Optional[int]:
        """
        The HTTP Status Code. Default `200`
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServiceVclSnippet(dict):
    def __init__(__self__, *,
                 content: str,
                 name: str,
                 type: str,
                 priority: Optional[int] = None):
        """
        :param str content: The VCL code that specifies exactly what the snippet does
        :param str name: A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        :param str type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        :param int priority: Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        ServiceVclSnippet._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            name=name,
            type=type,
            priority=priority,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: Optional[str] = None,
             name: Optional[str] = None,
             type: Optional[str] = None,
             priority: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if content is None:
            raise TypeError("Missing 'content' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if type is None:
            raise TypeError("Missing 'type' argument")

        _setter("content", content)
        _setter("name", name)
        _setter("type", type)
        if priority is not None:
            _setter("priority", priority)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hash`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class ServiceVclVcl(dict):
    def __init__(__self__, *,
                 content: str,
                 name: str,
                 main: Optional[bool] = None):
        """
        :param str content: The custom VCL code to upload
        :param str name: A unique name for this configuration block. It is important to note that changing this attribute will delete and recreate the resource
        :param bool main: If `true`, use this block as the main configuration. If `false`, use this block as an includable library. Only a single VCL block can be marked as the main block. Default is `false`
        """
        ServiceVclVcl._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            name=name,
            main=main,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: Optional[str] = None,
             name: Optional[str] = None,
             main: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if content is None:
            raise TypeError("Missing 'content' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")

        _setter("content", content)
        _setter("name", name)
        if main is not None:
            _setter("main", main)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The custom VCL code to upload
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name for this configuration block. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def main(self) -> Optional[bool]:
        """
        If `true`, use this block as the main configuration. If `false`, use this block as an includable library. Only a single VCL block can be marked as the main block. Default is `false`
        """
        return pulumi.get(self, "main")


@pulumi.output_type
class ServiceVclWaf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "responseObject":
            suggest = "response_object"
        elif key == "prefetchCondition":
            suggest = "prefetch_condition"
        elif key == "wafId":
            suggest = "waf_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVclWaf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVclWaf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVclWaf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 response_object: str,
                 disabled: Optional[bool] = None,
                 prefetch_condition: Optional[str] = None,
                 waf_id: Optional[str] = None):
        """
        :param str response_object: The name of the response object used by the Web Application Firewall
        :param bool disabled: A flag used to completely disable a Web Application Firewall. This is intended to only be used in an emergency
        :param str prefetch_condition: The `condition` to determine which requests will be run past your Fastly WAF. This `condition` must be of type `PREFETCH`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param str waf_id: The ID of the WAF
        """
        ServiceVclWaf._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            response_object=response_object,
            disabled=disabled,
            prefetch_condition=prefetch_condition,
            waf_id=waf_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             response_object: Optional[str] = None,
             disabled: Optional[bool] = None,
             prefetch_condition: Optional[str] = None,
             waf_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if response_object is None and 'responseObject' in kwargs:
            response_object = kwargs['responseObject']
        if response_object is None:
            raise TypeError("Missing 'response_object' argument")
        if prefetch_condition is None and 'prefetchCondition' in kwargs:
            prefetch_condition = kwargs['prefetchCondition']
        if waf_id is None and 'wafId' in kwargs:
            waf_id = kwargs['wafId']

        _setter("response_object", response_object)
        if disabled is not None:
            _setter("disabled", disabled)
        if prefetch_condition is not None:
            _setter("prefetch_condition", prefetch_condition)
        if waf_id is not None:
            _setter("waf_id", waf_id)

    @property
    @pulumi.getter(name="responseObject")
    def response_object(self) -> str:
        """
        The name of the response object used by the Web Application Firewall
        """
        return pulumi.get(self, "response_object")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        A flag used to completely disable a Web Application Firewall. This is intended to only be used in an emergency
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="prefetchCondition")
    def prefetch_condition(self) -> Optional[str]:
        """
        The `condition` to determine which requests will be run past your Fastly WAF. This `condition` must be of type `PREFETCH`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "prefetch_condition")

    @property
    @pulumi.getter(name="wafId")
    def waf_id(self) -> Optional[str]:
        """
        The ID of the WAF
        """
        return pulumi.get(self, "waf_id")


@pulumi.output_type
class ServiceWafConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modsecRuleId":
            suggest = "modsec_rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceWafConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceWafConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceWafConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 modsec_rule_id: int,
                 status: str,
                 revision: Optional[int] = None):
        """
        :param int modsec_rule_id: The Web Application Firewall rule's modsecurity ID
        :param str status: The Web Application Firewall rule's status. Allowed values are (`log`, `block` and `score`)
        :param int revision: The Web Application Firewall rule's revision. The latest revision will be used if this is not provided
        """
        ServiceWafConfigurationRule._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            modsec_rule_id=modsec_rule_id,
            status=status,
            revision=revision,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             modsec_rule_id: Optional[int] = None,
             status: Optional[str] = None,
             revision: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if modsec_rule_id is None and 'modsecRuleId' in kwargs:
            modsec_rule_id = kwargs['modsecRuleId']
        if modsec_rule_id is None:
            raise TypeError("Missing 'modsec_rule_id' argument")
        if status is None:
            raise TypeError("Missing 'status' argument")

        _setter("modsec_rule_id", modsec_rule_id)
        _setter("status", status)
        if revision is not None:
            _setter("revision", revision)

    @property
    @pulumi.getter(name="modsecRuleId")
    def modsec_rule_id(self) -> int:
        """
        The Web Application Firewall rule's modsecurity ID
        """
        return pulumi.get(self, "modsec_rule_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The Web Application Firewall rule's status. Allowed values are (`log`, `block` and `score`)
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def revision(self) -> Optional[int]:
        """
        The Web Application Firewall rule's revision. The latest revision will be used if this is not provided
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class ServiceWafConfigurationRuleExclusion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusionType":
            suggest = "exclusion_type"
        elif key == "modsecRuleIds":
            suggest = "modsec_rule_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceWafConfigurationRuleExclusion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceWafConfigurationRuleExclusion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceWafConfigurationRuleExclusion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: str,
                 exclusion_type: str,
                 name: str,
                 modsec_rule_ids: Optional[Sequence[int]] = None,
                 number: Optional[int] = None):
        """
        :param str condition: A conditional expression in VCL used to determine if the condition is met
        :param str exclusion_type: The type of rule exclusion. Values are `rule` to exclude the specified rule(s), or `waf` to disable the Web Application Firewall
        :param str name: The name of rule exclusion
        :param Sequence[int] modsec_rule_ids: Set of modsecurity IDs to be excluded. No rules should be provided when `exclusion_type` is `waf`. The rules need to be configured on the Web Application Firewall to be excluded
        :param int number: The numeric ID assigned to the WAF Rule Exclusion
        """
        ServiceWafConfigurationRuleExclusion._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            condition=condition,
            exclusion_type=exclusion_type,
            name=name,
            modsec_rule_ids=modsec_rule_ids,
            number=number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             condition: Optional[str] = None,
             exclusion_type: Optional[str] = None,
             name: Optional[str] = None,
             modsec_rule_ids: Optional[Sequence[int]] = None,
             number: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if condition is None:
            raise TypeError("Missing 'condition' argument")
        if exclusion_type is None and 'exclusionType' in kwargs:
            exclusion_type = kwargs['exclusionType']
        if exclusion_type is None:
            raise TypeError("Missing 'exclusion_type' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if modsec_rule_ids is None and 'modsecRuleIds' in kwargs:
            modsec_rule_ids = kwargs['modsecRuleIds']

        _setter("condition", condition)
        _setter("exclusion_type", exclusion_type)
        _setter("name", name)
        if modsec_rule_ids is not None:
            _setter("modsec_rule_ids", modsec_rule_ids)
        if number is not None:
            _setter("number", number)

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        A conditional expression in VCL used to determine if the condition is met
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="exclusionType")
    def exclusion_type(self) -> str:
        """
        The type of rule exclusion. Values are `rule` to exclude the specified rule(s), or `waf` to disable the Web Application Firewall
        """
        return pulumi.get(self, "exclusion_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of rule exclusion
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="modsecRuleIds")
    def modsec_rule_ids(self) -> Optional[Sequence[int]]:
        """
        Set of modsecurity IDs to be excluded. No rules should be provided when `exclusion_type` is `waf`. The rules need to be configured on the Web Application Firewall to be excluded
        """
        return pulumi.get(self, "modsec_rule_ids")

    @property
    @pulumi.getter
    def number(self) -> Optional[int]:
        """
        The numeric ID assigned to the WAF Rule Exclusion
        """
        return pulumi.get(self, "number")


@pulumi.output_type
class TlsSubscriptionManagedDnsChallenge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordName":
            suggest = "record_name"
        elif key == "recordType":
            suggest = "record_type"
        elif key == "recordValue":
            suggest = "record_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsSubscriptionManagedDnsChallenge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsSubscriptionManagedDnsChallenge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsSubscriptionManagedDnsChallenge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_name: Optional[str] = None,
                 record_type: Optional[str] = None,
                 record_value: Optional[str] = None):
        TlsSubscriptionManagedDnsChallenge._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            record_name=record_name,
            record_type=record_type,
            record_value=record_value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             record_name: Optional[str] = None,
             record_type: Optional[str] = None,
             record_value: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if record_name is None and 'recordName' in kwargs:
            record_name = kwargs['recordName']
        if record_type is None and 'recordType' in kwargs:
            record_type = kwargs['recordType']
        if record_value is None and 'recordValue' in kwargs:
            record_value = kwargs['recordValue']

        if record_name is not None:
            _setter("record_name", record_name)
        if record_type is not None:
            _setter("record_type", record_type)
        if record_value is not None:
            _setter("record_value", record_value)

    @property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[str]:
        return pulumi.get(self, "record_name")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[str]:
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="recordValue")
    def record_value(self) -> Optional[str]:
        return pulumi.get(self, "record_value")


@pulumi.output_type
class TlsSubscriptionManagedHttpChallenge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordName":
            suggest = "record_name"
        elif key == "recordType":
            suggest = "record_type"
        elif key == "recordValues":
            suggest = "record_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsSubscriptionManagedHttpChallenge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsSubscriptionManagedHttpChallenge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsSubscriptionManagedHttpChallenge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_name: Optional[str] = None,
                 record_type: Optional[str] = None,
                 record_values: Optional[Sequence[str]] = None):
        TlsSubscriptionManagedHttpChallenge._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            record_name=record_name,
            record_type=record_type,
            record_values=record_values,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             record_name: Optional[str] = None,
             record_type: Optional[str] = None,
             record_values: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if record_name is None and 'recordName' in kwargs:
            record_name = kwargs['recordName']
        if record_type is None and 'recordType' in kwargs:
            record_type = kwargs['recordType']
        if record_values is None and 'recordValues' in kwargs:
            record_values = kwargs['recordValues']

        if record_name is not None:
            _setter("record_name", record_name)
        if record_type is not None:
            _setter("record_type", record_type)
        if record_values is not None:
            _setter("record_values", record_values)

    @property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[str]:
        return pulumi.get(self, "record_name")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[str]:
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="recordValues")
    def record_values(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "record_values")


@pulumi.output_type
class GetConfigstoresStoreResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str):
        GetConfigstoresStoreResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            id=id,
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             id: Optional[str] = None,
             name: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if id is None:
            raise TypeError("Missing 'id' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")

        _setter("id", id)
        _setter("name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDatacentersPopResult(dict):
    def __init__(__self__, *,
                 code: str,
                 group: str,
                 name: str,
                 shield: str):
        GetDatacentersPopResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            code=code,
            group=group,
            name=name,
            shield=shield,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             code: Optional[str] = None,
             group: Optional[str] = None,
             name: Optional[str] = None,
             shield: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if code is None:
            raise TypeError("Missing 'code' argument")
        if group is None:
            raise TypeError("Missing 'group' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if shield is None:
            raise TypeError("Missing 'shield' argument")

        _setter("code", code)
        _setter("group", group)
        _setter("name", name)
        _setter("shield", shield)

    @property
    @pulumi.getter
    def code(self) -> str:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def group(self) -> str:
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def shield(self) -> str:
        return pulumi.get(self, "shield")


@pulumi.output_type
class GetDictionariesDictionaryResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 write_only: bool):
        GetDictionariesDictionaryResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            id=id,
            name=name,
            write_only=write_only,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             id: Optional[str] = None,
             name: Optional[str] = None,
             write_only: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if id is None:
            raise TypeError("Missing 'id' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if write_only is None and 'writeOnly' in kwargs:
            write_only = kwargs['writeOnly']
        if write_only is None:
            raise TypeError("Missing 'write_only' argument")

        _setter("id", id)
        _setter("name", name)
        _setter("write_only", write_only)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> bool:
        return pulumi.get(self, "write_only")


@pulumi.output_type
class GetKvstoresStoreResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str):
        GetKvstoresStoreResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            id=id,
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             id: Optional[str] = None,
             name: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if id is None:
            raise TypeError("Missing 'id' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")

        _setter("id", id)
        _setter("name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSecretstoresStoreResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str):
        GetSecretstoresStoreResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            id=id,
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             id: Optional[str] = None,
             name: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if id is None:
            raise TypeError("Missing 'id' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")

        _setter("id", id)
        _setter("name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServicesDetailResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 created_at: str,
                 customer_id: str,
                 id: str,
                 name: str,
                 type: str,
                 updated_at: str,
                 version: int):
        GetServicesDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            comment=comment,
            created_at=created_at,
            customer_id=customer_id,
            id=id,
            name=name,
            type=type,
            updated_at=updated_at,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             comment: Optional[str] = None,
             created_at: Optional[str] = None,
             customer_id: Optional[str] = None,
             id: Optional[str] = None,
             name: Optional[str] = None,
             type: Optional[str] = None,
             updated_at: Optional[str] = None,
             version: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if comment is None:
            raise TypeError("Missing 'comment' argument")
        if created_at is None and 'createdAt' in kwargs:
            created_at = kwargs['createdAt']
        if created_at is None:
            raise TypeError("Missing 'created_at' argument")
        if customer_id is None and 'customerId' in kwargs:
            customer_id = kwargs['customerId']
        if customer_id is None:
            raise TypeError("Missing 'customer_id' argument")
        if id is None:
            raise TypeError("Missing 'id' argument")
        if name is None:
            raise TypeError("Missing 'name' argument")
        if type is None:
            raise TypeError("Missing 'type' argument")
        if updated_at is None and 'updatedAt' in kwargs:
            updated_at = kwargs['updatedAt']
        if updated_at is None:
            raise TypeError("Missing 'updated_at' argument")
        if version is None:
            raise TypeError("Missing 'version' argument")

        _setter("comment", comment)
        _setter("created_at", created_at)
        _setter("customer_id", customer_id)
        _setter("id", id)
        _setter("name", name)
        _setter("type", type)
        _setter("updated_at", updated_at)
        _setter("version", version)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> str:
        return pulumi.get(self, "customer_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def version(self) -> int:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetTlsConfigurationDnsRecordResult(dict):
    def __init__(__self__, *,
                 record_type: str,
                 record_value: str,
                 region: str):
        GetTlsConfigurationDnsRecordResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            record_type=record_type,
            record_value=record_value,
            region=region,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             record_type: Optional[str] = None,
             record_value: Optional[str] = None,
             region: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if record_type is None and 'recordType' in kwargs:
            record_type = kwargs['recordType']
        if record_type is None:
            raise TypeError("Missing 'record_type' argument")
        if record_value is None and 'recordValue' in kwargs:
            record_value = kwargs['recordValue']
        if record_value is None:
            raise TypeError("Missing 'record_value' argument")
        if region is None:
            raise TypeError("Missing 'region' argument")

        _setter("record_type", record_type)
        _setter("record_value", record_value)
        _setter("region", region)

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> str:
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="recordValue")
    def record_value(self) -> str:
        return pulumi.get(self, "record_value")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


@pulumi.output_type
class GetWafRulesRuleResult(dict):
    def __init__(__self__, *,
                 latest_revision_number: int,
                 modsec_rule_id: int,
                 type: str):
        GetWafRulesRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            latest_revision_number=latest_revision_number,
            modsec_rule_id=modsec_rule_id,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             latest_revision_number: Optional[int] = None,
             modsec_rule_id: Optional[int] = None,
             type: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if latest_revision_number is None and 'latestRevisionNumber' in kwargs:
            latest_revision_number = kwargs['latestRevisionNumber']
        if latest_revision_number is None:
            raise TypeError("Missing 'latest_revision_number' argument")
        if modsec_rule_id is None and 'modsecRuleId' in kwargs:
            modsec_rule_id = kwargs['modsecRuleId']
        if modsec_rule_id is None:
            raise TypeError("Missing 'modsec_rule_id' argument")
        if type is None:
            raise TypeError("Missing 'type' argument")

        _setter("latest_revision_number", latest_revision_number)
        _setter("modsec_rule_id", modsec_rule_id)
        _setter("type", type)

    @property
    @pulumi.getter(name="latestRevisionNumber")
    def latest_revision_number(self) -> int:
        return pulumi.get(self, "latest_revision_number")

    @property
    @pulumi.getter(name="modsecRuleId")
    def modsec_rule_id(self) -> int:
        return pulumi.get(self, "modsec_rule_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


