# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 force_http2: Optional[pulumi.Input[bool]] = None,
                 no_auth: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] api_key: Fastly API Key from https://app.fastly.com/#account
        :param pulumi.Input[str] base_url: Fastly API URL
        :param pulumi.Input[bool] force_http2: Set this to `true` to disable HTTP/1.x fallback mechanism that the underlying Go library will attempt upon connection to
               `api.fastly.com:443` by default. This may slightly improve the provider's performance and reduce unnecessary TLS
               handshakes. Default: `false`
        :param pulumi.Input[bool] no_auth: Set to `true` if your configuration only consumes data sources that do not require authentication, such as
               `fastly_ip_ranges`
        """
        ProviderArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            api_key=api_key,
            base_url=base_url,
            force_http2=force_http2,
            no_auth=no_auth,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             api_key: Optional[pulumi.Input[str]] = None,
             base_url: Optional[pulumi.Input[str]] = None,
             force_http2: Optional[pulumi.Input[bool]] = None,
             no_auth: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions] = None,
             **kwargs):
        if api_key is None and 'apiKey' in kwargs:
            api_key = kwargs['apiKey']
        if base_url is None and 'baseUrl' in kwargs:
            base_url = kwargs['baseUrl']
        if force_http2 is None and 'forceHttp2' in kwargs:
            force_http2 = kwargs['forceHttp2']
        if no_auth is None and 'noAuth' in kwargs:
            no_auth = kwargs['noAuth']

        if api_key is not None:
            _setter("api_key", api_key)
        if base_url is not None:
            _setter("base_url", base_url)
        if force_http2 is not None:
            _setter("force_http2", force_http2)
        if no_auth is not None:
            _setter("no_auth", no_auth)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        Fastly API Key from https://app.fastly.com/#account
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[str]]:
        """
        Fastly API URL
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter(name="forceHttp2")
    def force_http2(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this to `true` to disable HTTP/1.x fallback mechanism that the underlying Go library will attempt upon connection to
        `api.fastly.com:443` by default. This may slightly improve the provider's performance and reduce unnecessary TLS
        handshakes. Default: `false`
        """
        return pulumi.get(self, "force_http2")

    @force_http2.setter
    def force_http2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_http2", value)

    @property
    @pulumi.getter(name="noAuth")
    def no_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` if your configuration only consumes data sources that do not require authentication, such as
        `fastly_ip_ranges`
        """
        return pulumi.get(self, "no_auth")

    @no_auth.setter
    def no_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_auth", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 force_http2: Optional[pulumi.Input[bool]] = None,
                 no_auth: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        The provider type for the fastly package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_key: Fastly API Key from https://app.fastly.com/#account
        :param pulumi.Input[str] base_url: Fastly API URL
        :param pulumi.Input[bool] force_http2: Set this to `true` to disable HTTP/1.x fallback mechanism that the underlying Go library will attempt upon connection to
               `api.fastly.com:443` by default. This may slightly improve the provider's performance and reduce unnecessary TLS
               handshakes. Default: `false`
        :param pulumi.Input[bool] no_auth: Set to `true` if your configuration only consumes data sources that do not require authentication, such as
               `fastly_ip_ranges`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the fastly package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ProviderArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 force_http2: Optional[pulumi.Input[bool]] = None,
                 no_auth: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["api_key"] = api_key
            __props__.__dict__["base_url"] = base_url
            __props__.__dict__["force_http2"] = pulumi.Output.from_input(force_http2).apply(pulumi.runtime.to_json) if force_http2 is not None else None
            __props__.__dict__["no_auth"] = pulumi.Output.from_input(no_auth).apply(pulumi.runtime.to_json) if no_auth is not None else None
        super(Provider, __self__).__init__(
            'fastly',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[str]]:
        """
        Fastly API Key from https://app.fastly.com/#account
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Output[Optional[str]]:
        """
        Fastly API URL
        """
        return pulumi.get(self, "base_url")

