import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeSystemGenerateScimAccessTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/system_generate_scim_access_token#id DataSnowflakeSystemGenerateScimAccessToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * SCIM Integration Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/system_generate_scim_access_token#integration_name DataSnowflakeSystemGenerateScimAccessToken#integration_name}
    */
    readonly integrationName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/system_generate_scim_access_token snowflake_system_generate_scim_access_token}
*/
export declare class DataSnowflakeSystemGenerateScimAccessToken extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_system_generate_scim_access_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/system_generate_scim_access_token snowflake_system_generate_scim_access_token} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeSystemGenerateScimAccessTokenConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeSystemGenerateScimAccessTokenConfig);
    get accessToken(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integrationName?;
    get integrationName(): string;
    set integrationName(value: string);
    get integrationNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-snowflake-system-generate-scim-access-token.d.ts.map