import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FileFormatConfig extends cdktf.TerraformMetaArguments {
    /**
    * Boolean that specifies to allow duplicate object field names (only the last one will be preserved).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#allow_duplicate FileFormat#allow_duplicate}
    */
    readonly allowDuplicate?: boolean | cdktf.IResolvable;
    /**
    * Boolean that specifies whether to interpret columns with no defined logical data type as UTF-8 text.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#binary_as_text FileFormat#binary_as_text}
    */
    readonly binaryAsText?: boolean | cdktf.IResolvable;
    /**
    * Defines the encoding format for binary input or output.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#binary_format FileFormat#binary_format}
    */
    readonly binaryFormat?: string;
    /**
    * Specifies a comment for the file format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#comment FileFormat#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the current compression algorithm for the data file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#compression FileFormat#compression}
    */
    readonly compression?: string;
    /**
    * The database in which to create the file format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#database FileFormat#database}
    */
    readonly database: string;
    /**
    * Defines the format of date values in the data files (data loading) or table (data unloading).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#date_format FileFormat#date_format}
    */
    readonly dateFormat?: string;
    /**
    * Boolean that specifies whether the XML parser disables automatic conversion of numeric and Boolean values from text to native representation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#disable_auto_convert FileFormat#disable_auto_convert}
    */
    readonly disableAutoConvert?: boolean | cdktf.IResolvable;
    /**
    * Boolean that specifies whether the XML parser disables recognition of Snowflake semi-structured data tags.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#disable_snowflake_data FileFormat#disable_snowflake_data}
    */
    readonly disableSnowflakeData?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether to insert SQL NULL for empty fields in an input file, which are represented by two successive delimiters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#empty_field_as_null FileFormat#empty_field_as_null}
    */
    readonly emptyFieldAsNull?: boolean | cdktf.IResolvable;
    /**
    * Boolean that enables parsing of octal numbers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#enable_octal FileFormat#enable_octal}
    */
    readonly enableOctal?: boolean | cdktf.IResolvable;
    /**
    * String (constant) that specifies the character set of the source data when loading data into a table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#encoding FileFormat#encoding}
    */
    readonly encoding?: string;
    /**
    * Boolean that specifies whether to generate a parsing error if the number of delimited columns (i.e. fields) in an input file does not match the number of columns in the corresponding table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#error_on_column_count_mismatch FileFormat#error_on_column_count_mismatch}
    */
    readonly errorOnColumnCountMismatch?: boolean | cdktf.IResolvable;
    /**
    * Single character string used as the escape character for field values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#escape FileFormat#escape}
    */
    readonly escape?: string;
    /**
    * Single character string used as the escape character for unenclosed field values only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#escape_unenclosed_field FileFormat#escape_unenclosed_field}
    */
    readonly escapeUnenclosedField?: string;
    /**
    * Specifies one or more singlebyte or multibyte characters that separate fields in an input file (data loading) or unloaded file (data unloading).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#field_delimiter FileFormat#field_delimiter}
    */
    readonly fieldDelimiter?: string;
    /**
    * Character used to enclose strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#field_optionally_enclosed_by FileFormat#field_optionally_enclosed_by}
    */
    readonly fieldOptionallyEnclosedBy?: string;
    /**
    * Specifies the extension for files unloaded to a stage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#file_extension FileFormat#file_extension}
    */
    readonly fileExtension?: string;
    /**
    * Specifies the format of the input files (for data loading) or output files (for data unloading).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#format_type FileFormat#format_type}
    */
    readonly formatType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#id FileFormat#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Boolean that specifies whether UTF-8 encoding errors produce error conditions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#ignore_utf8_errors FileFormat#ignore_utf8_errors}
    */
    readonly ignoreUtf8Errors?: boolean | cdktf.IResolvable;
    /**
    * Specifies the identifier for the file format; must be unique for the database and schema in which the file format is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#name FileFormat#name}
    */
    readonly name: string;
    /**
    * String used to convert to and from SQL NULL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#null_if FileFormat#null_if}
    */
    readonly nullIf?: string[];
    /**
    * Boolean that specifies whether the XML parser preserves leading and trailing spaces in element content.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#preserve_space FileFormat#preserve_space}
    */
    readonly preserveSpace?: boolean | cdktf.IResolvable;
    /**
    * Specifies one or more singlebyte or multibyte characters that separate records in an input file (data loading) or unloaded file (data unloading).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#record_delimiter FileFormat#record_delimiter}
    */
    readonly recordDelimiter?: string;
    /**
    * Boolean that specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#replace_invalid_characters FileFormat#replace_invalid_characters}
    */
    readonly replaceInvalidCharacters?: boolean | cdktf.IResolvable;
    /**
    * The schema in which to create the file format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#schema FileFormat#schema}
    */
    readonly schema: string;
    /**
    * Boolean that specifies to skip any blank lines encountered in the data files.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#skip_blank_lines FileFormat#skip_blank_lines}
    */
    readonly skipBlankLines?: boolean | cdktf.IResolvable;
    /**
    * Boolean that specifies whether to skip the BOM (byte order mark), if present in a data file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#skip_byte_order_mark FileFormat#skip_byte_order_mark}
    */
    readonly skipByteOrderMark?: boolean | cdktf.IResolvable;
    /**
    * Number of lines at the start of the file to skip.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#skip_header FileFormat#skip_header}
    */
    readonly skipHeader?: number;
    /**
    * Boolean that instructs the JSON parser to remove object fields or array elements containing null values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#strip_null_values FileFormat#strip_null_values}
    */
    readonly stripNullValues?: boolean | cdktf.IResolvable;
    /**
    * Boolean that instructs the JSON parser to remove outer brackets.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#strip_outer_array FileFormat#strip_outer_array}
    */
    readonly stripOuterArray?: boolean | cdktf.IResolvable;
    /**
    * Boolean that specifies whether the XML parser strips out the outer XML element, exposing 2nd level elements as separate documents.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#strip_outer_element FileFormat#strip_outer_element}
    */
    readonly stripOuterElement?: boolean | cdktf.IResolvable;
    /**
    * Defines the format of time values in the data files (data loading) or table (data unloading).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#time_format FileFormat#time_format}
    */
    readonly timeFormat?: string;
    /**
    * Defines the format of timestamp values in the data files (data loading) or table (data unloading).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#timestamp_format FileFormat#timestamp_format}
    */
    readonly timestampFormat?: string;
    /**
    * Boolean that specifies whether to remove white space from fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#trim_space FileFormat#trim_space}
    */
    readonly trimSpace?: boolean | cdktf.IResolvable;
    /**
    * Boolean that specifies whether to validate UTF-8 character encoding in string column data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/file_format#validate_utf8 FileFormat#validate_utf8}
    */
    readonly validateUtf8?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/file_format snowflake_file_format}
*/
export declare class FileFormat extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_file_format";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/file_format snowflake_file_format} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FileFormatConfig
    */
    constructor(scope: Construct, id: string, config: FileFormatConfig);
    private _allowDuplicate?;
    get allowDuplicate(): boolean | cdktf.IResolvable;
    set allowDuplicate(value: boolean | cdktf.IResolvable);
    resetAllowDuplicate(): void;
    get allowDuplicateInput(): boolean | cdktf.IResolvable | undefined;
    private _binaryAsText?;
    get binaryAsText(): boolean | cdktf.IResolvable;
    set binaryAsText(value: boolean | cdktf.IResolvable);
    resetBinaryAsText(): void;
    get binaryAsTextInput(): boolean | cdktf.IResolvable | undefined;
    private _binaryFormat?;
    get binaryFormat(): string;
    set binaryFormat(value: string);
    resetBinaryFormat(): void;
    get binaryFormatInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _compression?;
    get compression(): string;
    set compression(value: string);
    resetCompression(): void;
    get compressionInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _dateFormat?;
    get dateFormat(): string;
    set dateFormat(value: string);
    resetDateFormat(): void;
    get dateFormatInput(): string | undefined;
    private _disableAutoConvert?;
    get disableAutoConvert(): boolean | cdktf.IResolvable;
    set disableAutoConvert(value: boolean | cdktf.IResolvable);
    resetDisableAutoConvert(): void;
    get disableAutoConvertInput(): boolean | cdktf.IResolvable | undefined;
    private _disableSnowflakeData?;
    get disableSnowflakeData(): boolean | cdktf.IResolvable;
    set disableSnowflakeData(value: boolean | cdktf.IResolvable);
    resetDisableSnowflakeData(): void;
    get disableSnowflakeDataInput(): boolean | cdktf.IResolvable | undefined;
    private _emptyFieldAsNull?;
    get emptyFieldAsNull(): boolean | cdktf.IResolvable;
    set emptyFieldAsNull(value: boolean | cdktf.IResolvable);
    resetEmptyFieldAsNull(): void;
    get emptyFieldAsNullInput(): boolean | cdktf.IResolvable | undefined;
    private _enableOctal?;
    get enableOctal(): boolean | cdktf.IResolvable;
    set enableOctal(value: boolean | cdktf.IResolvable);
    resetEnableOctal(): void;
    get enableOctalInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _errorOnColumnCountMismatch?;
    get errorOnColumnCountMismatch(): boolean | cdktf.IResolvable;
    set errorOnColumnCountMismatch(value: boolean | cdktf.IResolvable);
    resetErrorOnColumnCountMismatch(): void;
    get errorOnColumnCountMismatchInput(): boolean | cdktf.IResolvable | undefined;
    private _escape?;
    get escape(): string;
    set escape(value: string);
    resetEscape(): void;
    get escapeInput(): string | undefined;
    private _escapeUnenclosedField?;
    get escapeUnenclosedField(): string;
    set escapeUnenclosedField(value: string);
    resetEscapeUnenclosedField(): void;
    get escapeUnenclosedFieldInput(): string | undefined;
    private _fieldDelimiter?;
    get fieldDelimiter(): string;
    set fieldDelimiter(value: string);
    resetFieldDelimiter(): void;
    get fieldDelimiterInput(): string | undefined;
    private _fieldOptionallyEnclosedBy?;
    get fieldOptionallyEnclosedBy(): string;
    set fieldOptionallyEnclosedBy(value: string);
    resetFieldOptionallyEnclosedBy(): void;
    get fieldOptionallyEnclosedByInput(): string | undefined;
    private _fileExtension?;
    get fileExtension(): string;
    set fileExtension(value: string);
    resetFileExtension(): void;
    get fileExtensionInput(): string | undefined;
    private _formatType?;
    get formatType(): string;
    set formatType(value: string);
    get formatTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreUtf8Errors?;
    get ignoreUtf8Errors(): boolean | cdktf.IResolvable;
    set ignoreUtf8Errors(value: boolean | cdktf.IResolvable);
    resetIgnoreUtf8Errors(): void;
    get ignoreUtf8ErrorsInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullIf?;
    get nullIf(): string[];
    set nullIf(value: string[]);
    resetNullIf(): void;
    get nullIfInput(): string[] | undefined;
    private _preserveSpace?;
    get preserveSpace(): boolean | cdktf.IResolvable;
    set preserveSpace(value: boolean | cdktf.IResolvable);
    resetPreserveSpace(): void;
    get preserveSpaceInput(): boolean | cdktf.IResolvable | undefined;
    private _recordDelimiter?;
    get recordDelimiter(): string;
    set recordDelimiter(value: string);
    resetRecordDelimiter(): void;
    get recordDelimiterInput(): string | undefined;
    private _replaceInvalidCharacters?;
    get replaceInvalidCharacters(): boolean | cdktf.IResolvable;
    set replaceInvalidCharacters(value: boolean | cdktf.IResolvable);
    resetReplaceInvalidCharacters(): void;
    get replaceInvalidCharactersInput(): boolean | cdktf.IResolvable | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _skipBlankLines?;
    get skipBlankLines(): boolean | cdktf.IResolvable;
    set skipBlankLines(value: boolean | cdktf.IResolvable);
    resetSkipBlankLines(): void;
    get skipBlankLinesInput(): boolean | cdktf.IResolvable | undefined;
    private _skipByteOrderMark?;
    get skipByteOrderMark(): boolean | cdktf.IResolvable;
    set skipByteOrderMark(value: boolean | cdktf.IResolvable);
    resetSkipByteOrderMark(): void;
    get skipByteOrderMarkInput(): boolean | cdktf.IResolvable | undefined;
    private _skipHeader?;
    get skipHeader(): number;
    set skipHeader(value: number);
    resetSkipHeader(): void;
    get skipHeaderInput(): number | undefined;
    private _stripNullValues?;
    get stripNullValues(): boolean | cdktf.IResolvable;
    set stripNullValues(value: boolean | cdktf.IResolvable);
    resetStripNullValues(): void;
    get stripNullValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _stripOuterArray?;
    get stripOuterArray(): boolean | cdktf.IResolvable;
    set stripOuterArray(value: boolean | cdktf.IResolvable);
    resetStripOuterArray(): void;
    get stripOuterArrayInput(): boolean | cdktf.IResolvable | undefined;
    private _stripOuterElement?;
    get stripOuterElement(): boolean | cdktf.IResolvable;
    set stripOuterElement(value: boolean | cdktf.IResolvable);
    resetStripOuterElement(): void;
    get stripOuterElementInput(): boolean | cdktf.IResolvable | undefined;
    private _timeFormat?;
    get timeFormat(): string;
    set timeFormat(value: string);
    resetTimeFormat(): void;
    get timeFormatInput(): string | undefined;
    private _timestampFormat?;
    get timestampFormat(): string;
    set timestampFormat(value: string);
    resetTimestampFormat(): void;
    get timestampFormatInput(): string | undefined;
    private _trimSpace?;
    get trimSpace(): boolean | cdktf.IResolvable;
    set trimSpace(value: boolean | cdktf.IResolvable);
    resetTrimSpace(): void;
    get trimSpaceInput(): boolean | cdktf.IResolvable | undefined;
    private _validateUtf8?;
    get validateUtf8(): boolean | cdktf.IResolvable;
    set validateUtf8(value: boolean | cdktf.IResolvable);
    resetValidateUtf8(): void;
    get validateUtf8Input(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=file-format.d.ts.map