import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SequenceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the sequence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/sequence#comment Sequence#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the sequence. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/sequence#database Sequence#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/sequence#id Sequence#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The amount the sequence will increase by each time it is used
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/sequence#increment Sequence#increment}
    */
    readonly increment?: number;
    /**
    * Specifies the name for the sequence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/sequence#name Sequence#name}
    */
    readonly name: string;
    /**
    * The schema in which to create the sequence. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/sequence#schema Sequence#schema}
    */
    readonly schema: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/sequence snowflake_sequence}
*/
export declare class Sequence extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_sequence";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/sequence snowflake_sequence} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SequenceConfig
    */
    constructor(scope: Construct, id: string, config: SequenceConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _increment?;
    get increment(): number;
    set increment(value: number);
    resetIncrement(): void;
    get incrementInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nextValue(): number;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=sequence.d.ts.map