"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_parameter_1 = require("../cfn-parameter");
const construct_compat_1 = require("../construct-compat");
class FileAssetParameters extends construct_compat_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        // add parameters for s3 bucket and s3 key. those will be set by
        // the toolkit or by CI/CD when the stack is deployed and will include
        // the name of the bucket and the S3 key where the code lives.
        this.bucketNameParameter = new cfn_parameter_1.CfnParameter(this, 'S3Bucket', {
            type: 'String',
            description: `S3 bucket for asset "${id}"`,
        });
        this.objectKeyParameter = new cfn_parameter_1.CfnParameter(this, 'S3VersionKey', {
            type: 'String',
            description: `S3 key for asset version "${id}"`
        });
        this.artifactHashParameter = new cfn_parameter_1.CfnParameter(this, 'ArtifactHash', {
            description: `Artifact hash for asset "${id}"`,
            type: 'String',
        });
    }
}
exports.FileAssetParameters = FileAssetParameters;
//# sourceMappingURL=data:application/json;base64,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