/*!
  * Copyright 2016,  Digital Reasoning
  *
  * Licensed under the Apache License, Version 2.0 (the "License");
  * you may not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  *     http://www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
*/

define(["jquery","knockout","bootbox","utils/utils","select2"],function(e,r,t,a){"use strict";return function(){var o=this;o.breadcrumbs=[{active:!1,title:"Cloud Accounts",href:"/accounts/"},{active:!0,title:"New"}],o.providerSelector=e("#accountProvider"),o.regionSelector=e("#accountRegion"),o.vpcSelector=e("#accountVpcId"),o.sgSelector=e("#accountSecurityGroups"),o.newsgSelector=e("#accountSecurityGroupsNew"),o.providerSelector.select2({ajax:{url:"/api/cloud/providers/",dataType:"json",delay:100,data:function(e){return{name:e.term}},processResults:function(e){return e.results.forEach(function(e){e.text=e.name,e.id=e.name}),e},cache:!0},theme:"bootstrap",placeholder:"Select a provider...",templateResult:function(e){return e.loading?e.text:e.name},minimumInputLength:0}),o.regionSelector.select2({data:[],theme:"bootstrap",placeholder:"Select a region...",disabled:!0}),o.providerSelector.on("select2:select",function(e){var r=e.params.data;o.provider(r),o.regionSelector.select2({ajax:{url:r.regions,dataType:"json",delay:100,data:function(e){return{title:e.term}},processResults:function(e){return e.results.forEach(function(e){e.text=e.title,e.id=e.title}),e},cache:!0},theme:"bootstrap",disabled:!1,placeholder:"Select a region...",templateResult:function(e){return e.loading?e.text:e.title},minimumInputLength:0})}),o.regionSelector.on("select2:select",function(e){var r=e.params.data;o.region(r.title)}),o.sgSelector.select2({data:[],theme:"bootstrap",placeholder:"Select a security group...",disabled:!0}),o.newsgSelector.select2({data:[],theme:"bootstrap",disabled:!0}),o.wizard=e("#accountWizard"),o.wizard.on("actionclicked.fu.wizard",function(t,c){if("next"===c.direction){o.removeErrors(o.keys);var i=!1;switch(c.step){case 1:o.provider()||(a.addError("#provider",["May not be blank"]),i=!0),o.title()||(a.addError("#title",["May not be blank"]),i=!0),o.vpcEnabled()&&!o.vpcId()&&(a.addError("#vpc_id",["May not be blank"]),i=!0),o.region()||(a.addError("#region",["May not be blank"]),i=!0),i||o.previousProvider===o.provider().name||(o.previousProvider=o.provider().name,e.ajax({method:"GET",url:o.provider().required_fields}).done(function(e){var t=[];e.results.forEach(function(e){if("private_key"!==e){var a={apiName:e,displayName:o.extrasMap[e],fieldValue:r.observable()};"secret_access_key"===e?a.type="password":a.type="text",t.push(a)}}),o.extraFields(t)}));break;case 2:o.createCloudAccount().done(function(e){o.selectedAccount=e,o.makeSGSelector(e)}).done(function(){o.wizard.wizard("selectedItem",{step:3})}).fail(function(e){try{var r=JSON.parse(e.responseText),t=!1;o.keys.forEach(function(e){r.hasOwnProperty(e)&&(t=!0)}),t?o.wizard.wizard("selectedItem",{step:1}):o.wizard.wizard("selectedItem",{step:2})}catch(a){o.wizard.wizard("selectedItem",{step:1})}}),t.preventDefault();break;case 3:var s=o.sgSelector.select2("data"),n=o.newsgSelector.select2("data");console.log(s),console.log(n);var l=[];s.forEach(function(r){l.push(e.ajax({method:"POST",url:o.selectedAccount.security_groups,data:JSON.stringify({group_id:r.group_id,"default":!0})}))}),n.forEach(function(r){l.push(e.ajax({method:"POST",url:o.selectedAccount.security_groups,data:JSON.stringify({name:r.text,"default":!0})}))}),e.when.apply(this,l).done(function(){window.location="/accounts/"}).fail(function(e){a.alertError(e,"Error saving permissions")})}i&&t.preventDefault()}}),o.keys=["provider","title","description","create_security_groups","vpc_id","region"],o.extrasMap={account_id:"Account ID",access_key_id:"Access Key ID",secret_access_key:"Secret Access Key",keypair:"Keypair Name",private_key:"Private Key",route53_domain:"Route 53 Domain"},o.previousProvider=null,o.provider=r.observable(),o.title=r.observable(),o.description=r.observable(),o.vpcEnabled=r.observable(),o.vpcId=r.observable(),o.region=r.observable(),o.createSecurityGroups=r.observable(),o.privateKey=r.observable(),o.extraFields=r.observableArray([]),o.securityGroups=r.observableArray([]),o.selectedAccount=null,o.sgSubscription=null,o.vpcSubscription=null,o.makeSGSelector=function(e){o.sgSelector.select2({ajax:{url:e.all_security_groups,dataType:"json",delay:100,data:function(e){return{name:e.term}},processResults:function(e){var r=[];return e.results.forEach(function(e){e.text=e.name,e.id=e.name,r.push(e)}),{results:r}},cache:!0},theme:"bootstrap",disabled:!1,placeholder:"Select a security group...",minimumInputLength:0}),o.newsgSelector.select2({theme:"bootstrap",tags:!0,tokenSeparators:[","]})},o.reset=function(){o.sgSubscription&&o.sgSubscription.dispose(),o.vpcSubscription&&o.vpcSubscription.dispose();var r=e("#sg-checkbox");o.sgSubscription=o.createSecurityGroups.subscribe(function(e){e?r.checkbox("check"):r.checkbox("uncheck")});var t=e("#vpc-checkbox");o.vpcSubscription=o.vpcEnabled.subscribe(function(e){e?t.checkbox("check"):t.checkbox("uncheck")}),o.provider(null),o.title(""),o.description(""),o.vpcEnabled(!0),o.createSecurityGroups(!0),o.vpcId(""),o.region(null),o.extraFields([]),o.securityGroups([])},o.removeErrors=function(r){r.forEach(function(r){var t=e("#"+r);t.removeClass("has-error");var a=t.find(".help-block");a.remove()})},o.createCloudAccount=function(){var r=o.keys.slice(),a={provider:o.provider().name,title:o.title(),description:o.description(),create_security_groups:o.createSecurityGroups(),private_key:o.privateKey(),region:o.region()};return o.vpcEnabled()?a.vpc_id=o.vpcId():a.vpc_id="",o.extraFields().forEach(function(e){a[e.apiName]=e.fieldValue(),r.push(e.apiName)}),o.removeErrors(r),e.ajax({method:"POST",url:"/api/cloud/accounts/",data:JSON.stringify(a)}).fail(function(a){var o="";try{var c=JSON.parse(a.responseText);for(var i in c)if(c.hasOwnProperty(i))if(r.indexOf(i)>=0){var s=e("#"+i);s.addClass("has-error"),c[i].forEach(function(e){s.append('<span class="help-block">'+e+"</span>")})}else if("non_field_errors"===i)c[i].forEach(function(r){if(r.indexOf("title")>=0){var t=e("#title");t.addClass("has-error"),t.append('<span class="help-block">An account with this title already exists.</span>')}});else{var n=i.replace("_"," ");c[i].forEach(function(e){o+="<dt>"+n+"</dt><dd>"+e+"</dd>"})}o&&(o='<dl class="dl-horizontal">'+o+"</dl>")}catch(l){o="Oops... there was a server error.  This has been reported to your administrators."}o&&t.alert({title:"Error creating account",message:o})})},o.reset()}});