(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     83699,       2019]
NotebookOptionsPosition[     82394,       1977]
NotebookOutlinePosition[     82759,       1993]
CellTagsIndexPosition[     82716,       1990]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"CloseKernels", "[", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"LaunchKernels", "[", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{
     RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
     "\"\<\\\\linear_mathematica\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cylinder", "=", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"calculatek0", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"calculatek0edges", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"calculatekG0", "=", "True"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "boundary", " ", "conditions", " ", "for", " ", "the", " ", "elastic", " ",
     "edges"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kBot", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"kuBot", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", "            ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "kvBot", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", "            ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "kwBot", ",", "0", ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", "            ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "kphixBot", ",", "0"}], "}"}], 
      ",", "\[IndentingNewLine]", "            ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "kphitBot"}], "}"}]}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kTop", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"kuTop", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", "           ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "kvTop", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", "           ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "kwTop", ",", "0", ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", "           ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "kphixTop", ",", "0"}], "}"}], 
      ",", "\[IndentingNewLine]", "           ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "kphitTop"}], "}"}]}], 
     "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "Numbers", " ", "are", " ", "used", " ", "to", " ", "identify", " ", 
      "the", " ", "sub"}], "-", 
     RowBox[{"matrices", " ", "as", " ", 
      RowBox[{
      "follows", ":", "\[IndentingNewLine]", "1", ":", " ", "00"}]}]}], ",", 
    " ", 
    RowBox[{"2", ":", " ", "01"}], ",", " ", 
    RowBox[{"3", ":", " ", "02"}], ",", " ", 
    RowBox[{"4", ":", " ", "11"}], ",", " ", 
    RowBox[{"5", ":", " ", "12"}], ",", " ", 
    RowBox[{"6", ":", " ", "22"}]}], "\[IndentingNewLine]", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"firstmatrix", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lastmatrix", "=", "6"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"debug", "=", "False"}], ";"}], " ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"sina", ",", "cosa", ",", "xa", ",", "xb", ",", "ta", ",", "tb"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"cylinder", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sina", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"cosa", "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"xa", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"xb", "=", "L"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ta", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"tb", "=", 
       RowBox[{"2", "*", "Pi"}]}], ";"}], "\[IndentingNewLine]", ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"xa", "=", "xa"}], ";", "\[IndentingNewLine]", 
      RowBox[{"xb", "=", "xb"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ta", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"tb", "=", 
       RowBox[{"2", "*", "Pi"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"order", "=", "0"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{
    "A11", ",", "A12", ",", "A16", ",", "A22", ",", "A26", ",", "A66", ",", 
     "B11", ",", "B12", ",", "B16", ",", "B22", ",", "B26", ",", "B66", ",", 
     "D11", ",", "D12", ",", "D16", ",", "D22", ",", "D26", ",", "D66", ",", 
     "E11", ",", "nu", ",", "G12"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"isotropic", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"G12", "=", 
       RowBox[{"E11", "/", 
        RowBox[{"(", 
         RowBox[{"2", 
          RowBox[{"(", 
           RowBox[{"1", "+", "nu"}], ")"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"A11", "=", 
       RowBox[{"E11", "*", 
        RowBox[{"h", "/", 
         RowBox[{"(", 
          RowBox[{"1", " ", "-", 
           RowBox[{"nu", "^", "2"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"A12", "=", 
       RowBox[{"nu", "*", "E11", "*", 
        RowBox[{"h", "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"nu", "^", "2"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"A16", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"A22", "=", 
       RowBox[{"E11", "*", 
        RowBox[{"h", "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"nu", "^", "2"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"A26", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"A66", "=", 
       RowBox[{"G12", "*", "h"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"B11", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"B12", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"B16", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"B22", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"B26", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"B66", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"D11", "=", 
       RowBox[{"E11", "*", 
        RowBox[{
         RowBox[{"h", "^", "3"}], "/", 
         RowBox[{"(", 
          RowBox[{"12", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"nu", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"D12", "=", 
       RowBox[{"nu", "*", "E11", "*", 
        RowBox[{
         RowBox[{"h", "^", "3"}], "/", 
         RowBox[{"(", 
          RowBox[{"12", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"nu", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"D16", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"D22", "=", 
       RowBox[{"E11", "*", 
        RowBox[{
         RowBox[{"h", "^", "3"}], "/", 
         RowBox[{"(", 
          RowBox[{"12", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"nu", "^", "2"}]}], ")"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"D26", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"D66", "=", 
       RowBox[{"G12", "*", 
        RowBox[{
         RowBox[{"h", "^", "3"}], "/", "12"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Exit", "[", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"F", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "A11", ",", "A12", ",", "A16", ",", "B11", ",", "B12", ",", "B16", ",",
         "     ", "0", ",", "     ", "0"}], "}"}], ",", "\[IndentingNewLine]",
       "  ", 
      RowBox[{"{", 
       RowBox[{
       "A12", ",", "A22", ",", "A26", ",", "B12", ",", "B22", ",", "B26", ",",
         "     ", "0", ",", "     ", "0"}], "}"}], ",", "\[IndentingNewLine]",
       "  ", 
      RowBox[{"{", 
       RowBox[{
       "A16", ",", "A26", ",", "A66", ",", "B16", ",", "B26", ",", "B66", ",",
         "     ", "0", ",", "     ", "0"}], "}"}], ",", "\[IndentingNewLine]",
       "  ", 
      RowBox[{"{", 
       RowBox[{
       "B11", ",", "B12", ",", "B16", ",", "D11", ",", "D12", ",", "D16", ",",
         "      ", "0", ",", "     ", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", "  ", 
      RowBox[{"{", 
       RowBox[{
       "B12", ",", "B22", ",", "B26", ",", "D12", ",", "D22", ",", "D26", ",",
         "      ", "0", ",", "     ", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", "  ", 
      RowBox[{"{", 
       RowBox[{
       "B16", ",", "B26", ",", "B66", ",", "D16", ",", "D26", ",", "D66", ",",
         "      ", "0", ",", "     ", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", "  ", 
      RowBox[{"{", "     ", 
       RowBox[{
       "0", ",", "     ", "0", ",", "      ", "0", ",", "     ", "0", ",", 
        "     ", "0", ",", "      ", "0", ",", "A44", ",", "A45"}], "}"}], 
      ",", "\[IndentingNewLine]", "  ", 
      RowBox[{"{", "     ", 
       RowBox[{
       "0", ",", "     ", "0", ",", "      ", "0", ",", "     ", "0", ",", 
        "     ", "0", ",", "      ", "0", ",", "A45", ",", "A55"}], "}"}]}], 
     "}"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c0num", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c1num", " ", "=", " ", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"c2num", " ", "=", " ", "10"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g0", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", "5", "}"}], ",", 
     RowBox[{"{", "c0num", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1Left", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", "5", "}"}], ",", 
     RowBox[{"{", "c1num", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1Right", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", "5", "}"}], ",", 
     RowBox[{"{", "c1num", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2Left", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", "5", "}"}], ",", 
     RowBox[{"{", "c2num", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2Right", "=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", 
      RowBox[{"{", "5", "}"}], ",", 
      RowBox[{"{", "c2num", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g0", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"L", "-", "x"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"L", "*", "cosa"}], ")"}]}]}], ";", 
  RowBox[{"(*", " ", 
   RowBox[{"to", " ", "allow", " ", "axial", " ", "compression"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"g0", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"L", "-", "x"}], ")"}], 
    RowBox[{"r2", "/", "L"}]}]}], ";", 
  RowBox[{"(*", " ", 
   RowBox[{"to", " ", "allow", " ", "torsion"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"g0", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"L", "-", "x"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"L", "*", "cosa"}], ")"}]}], "*", 
    RowBox[{"Cos", "[", 
     RowBox[{"t", "-", "tLA"}], "]"}]}]}], ";", 
  RowBox[{"(*", " ", 
   RowBox[{"to", " ", "allow", " ", "load", " ", "asymmetry"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"g1Left", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"Sin", "[", 
    RowBox[{"i1", "*", "Pi", "*", 
     RowBox[{"x", "/", "L"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g1Left", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"Sin", "[", 
    RowBox[{"i1", "*", "Pi", "*", 
     RowBox[{"x", "/", "L"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g1Left", "[", 
    RowBox[{"[", 
     RowBox[{"3", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{"Sin", "[", 
    RowBox[{"i1", "*", "Pi", "*", 
     RowBox[{"x", "/", "L"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g1Left", "[", 
    RowBox[{"[", 
     RowBox[{"4", ",", "4"}], "]"}], "]"}], "=", 
   RowBox[{"Cos", "[", 
    RowBox[{"i1", "*", "Pi", "*", 
     RowBox[{"x", "/", "L"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g1Left", "[", 
     RowBox[{"[", 
      RowBox[{"5", ",", "5"}], "]"}], "]"}], "=", 
    RowBox[{"Sin", "[", 
     RowBox[{"i1", "*", "Pi", "*", 
      RowBox[{"x", "/", "L"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g1Right", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"Sin", "[", 
    RowBox[{"k1", "*", "Pi", "*", 
     RowBox[{"x", "/", "L"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g1Right", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"Sin", "[", 
    RowBox[{"k1", "*", "Pi", "*", 
     RowBox[{"x", "/", "L"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g1Right", "[", 
    RowBox[{"[", 
     RowBox[{"3", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{"Sin", "[", 
    RowBox[{"k1", "*", "Pi", "*", 
     RowBox[{"x", "/", "L"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g1Right", "[", 
    RowBox[{"[", 
     RowBox[{"4", ",", "4"}], "]"}], "]"}], "=", 
   RowBox[{"Cos", "[", 
    RowBox[{"k1", "*", "Pi", "*", 
     RowBox[{"x", "/", "L"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g1Right", "[", 
     RowBox[{"[", 
      RowBox[{"5", ",", "5"}], "]"}], "]"}], "=", 
    RowBox[{"Sin", "[", 
     RowBox[{"k1", "*", "Pi", "*", 
      RowBox[{"x", "/", "L"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2Left", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"i2", "*", "Pi", "*", 
      RowBox[{"x", "/", "L"}]}], "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"j2", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g2Left", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"i2", "*", "Pi", "*", 
       RowBox[{"x", "/", "L"}]}], "]"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"j2", "*", "t"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2Left", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"i2", "*", "Pi", "*", 
      RowBox[{"x", "/", "L"}]}], "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"j2", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g2Left", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"i2", "*", "Pi", "*", 
       RowBox[{"x", "/", "L"}]}], "]"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"j2", "*", "t"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2Left", "[", 
    RowBox[{"[", 
     RowBox[{"3", ",", "5"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"i2", "*", "Pi", "*", 
      RowBox[{"x", "/", "L"}]}], "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"j2", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g2Left", "[", 
     RowBox[{"[", 
      RowBox[{"3", ",", "6"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i2", "*", "Pi", "*", 
       RowBox[{"x", "/", "L"}]}], "]"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"j2", "*", "t"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2Left", "[", 
    RowBox[{"[", 
     RowBox[{"4", ",", "7"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"i2", "*", "Pi", "*", 
      RowBox[{"x", "/", "L"}]}], "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"j2", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g2Left", "[", 
     RowBox[{"[", 
      RowBox[{"4", ",", "8"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"i2", "*", "Pi", "*", 
       RowBox[{"x", "/", "L"}]}], "]"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"j2", "*", "t"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2Left", "[", 
    RowBox[{"[", 
     RowBox[{"5", ",", "9"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"i2", "*", "Pi", "*", 
      RowBox[{"x", "/", "L"}]}], "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"j2", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g2Left", "[", 
     RowBox[{"[", 
      RowBox[{"5", ",", "10"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"i2", "*", "Pi", "*", 
       RowBox[{"x", "/", "L"}]}], "]"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"j2", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2Right", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"k2", "*", "Pi", "*", 
      RowBox[{"x", "/", "L"}]}], "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"l2", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g2Right", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"k2", "*", "Pi", "*", 
       RowBox[{"x", "/", "L"}]}], "]"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"l2", "*", "t"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2Right", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"k2", "*", "Pi", "*", 
      RowBox[{"x", "/", "L"}]}], "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"l2", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g2Right", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "4"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"k2", "*", "Pi", "*", 
       RowBox[{"x", "/", "L"}]}], "]"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"l2", "*", "t"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2Right", "[", 
    RowBox[{"[", 
     RowBox[{"3", ",", "5"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"k2", "*", "Pi", "*", 
      RowBox[{"x", "/", "L"}]}], "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"l2", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g2Right", "[", 
     RowBox[{"[", 
      RowBox[{"3", ",", "6"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"k2", "*", "Pi", "*", 
       RowBox[{"x", "/", "L"}]}], "]"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"l2", "*", "t"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2Right", "[", 
    RowBox[{"[", 
     RowBox[{"4", ",", "7"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"k2", "*", "Pi", "*", 
      RowBox[{"x", "/", "L"}]}], "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"l2", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g2Right", "[", 
     RowBox[{"[", 
      RowBox[{"4", ",", "8"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"k2", "*", "Pi", "*", 
       RowBox[{"x", "/", "L"}]}], "]"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"l2", "*", "t"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2Right", "[", 
    RowBox[{"[", 
     RowBox[{"5", ",", "9"}], "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"k2", "*", "Pi", "*", 
      RowBox[{"x", "/", "L"}]}], "]"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"l2", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g2Right", "[", 
     RowBox[{"[", 
      RowBox[{"5", ",", "10"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"k2", "*", "Pi", "*", 
       RowBox[{"x", "/", "L"}]}], "]"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"l2", "*", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gsLeft", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"g0", ",", "g1Left", ",", "g2Left"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gsRight", "=", 
    RowBox[{"{", 
     RowBox[{"g0", ",", "g1Right", ",", "g2Right"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"indicesLeft", "  ", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "2", ",", "2", ",", "3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"indicesRight", "=", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "2", ",", "3", ",", "3"}], "}"}]}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"expressions", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "firstmatrix"}], ",", 
     RowBox[{"i", "\[LessEqual]", "lastmatrix"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"index1", "=", 
       RowBox[{"indicesLeft", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"index2", "=", 
       RowBox[{"indicesRight", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"gLeft", "=", 
       RowBox[{"gsLeft", "[", 
        RowBox[{"[", "index1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"gu", " ", "=", " ", 
       RowBox[{"gLeft", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "All"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gv", " ", "=", " ", 
       RowBox[{"gLeft", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "All"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gw", " ", "=", " ", 
       RowBox[{"gLeft", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "All"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gphix", "=", 
       RowBox[{"gLeft", "[", 
        RowBox[{"[", 
         RowBox[{"4", ",", "All"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gphit", "=", 
       RowBox[{"gLeft", "[", 
        RowBox[{"[", 
         RowBox[{"5", ",", "All"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"GLeft", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"gw", ",", "x"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{"1", "/", "r"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{"gw", ",", "t"}], "]"}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"B0Left", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"gu", ",", "x"}], "]"}], ",", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", "sina", "*", "gu"}], " ", "+", " ", 
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{"gv", ",", "t"}], "]"}]}], " ", "+", " ", 
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", "cosa", "*", "gw"}]}], ",", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{"gu", ",", "t"}], "]"}]}], "+", " ", 
          RowBox[{"D", "[", 
           RowBox[{"gv", ",", "x"}], "]"}], "-", 
          RowBox[{"sina", "*", 
           RowBox[{"1", "/", "r"}], "*", "gv"}]}], ",", "\[IndentingNewLine]",
          "      ", 
         RowBox[{"D", "[", 
          RowBox[{"gphix", ",", "x"}], "]"}], ",", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", "sina", "*", "gphix"}], "+", 
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{"gphit", ",", "t"}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{"gphix", ",", "t"}], "]"}]}], " ", "+", " ", 
          RowBox[{"D", "[", 
           RowBox[{"gphit", ",", "x"}], "]"}], "-", 
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", "sina", "*", "gphit"}]}], ",", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "r"}], "*", "cosa", "*", "gv"}], " ", 
          "+", " ", 
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{"gw", ",", "t"}], "]"}]}], " ", "+", " ", "gphit"}], ",", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"gw", ",", "x"}], "]"}], " ", "+", " ", "gphix"}]}], 
        "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"gRight", "=", 
       RowBox[{"gsRight", "[", 
        RowBox[{"[", "index2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"gu", " ", "=", " ", 
       RowBox[{"gRight", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "All"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gv", " ", "=", " ", 
       RowBox[{"gRight", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "All"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gw", " ", "=", " ", 
       RowBox[{"gRight", "[", 
        RowBox[{"[", 
         RowBox[{"3", ",", "All"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gphix", "=", 
       RowBox[{"gRight", "[", 
        RowBox[{"[", 
         RowBox[{"4", ",", "All"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gphit", "=", 
       RowBox[{"gRight", "[", 
        RowBox[{"[", 
         RowBox[{"5", ",", "All"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"GRight", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"gw", ",", "x"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{"1", "/", "r"}], "*", 
          RowBox[{"D", "[", 
           RowBox[{"gw", ",", "t"}], "]"}]}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"B0Right", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"gu", ",", "x"}], "]"}], ",", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", "sina", "*", "gu"}], " ", "+", " ", 
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{"gv", ",", "t"}], "]"}]}], " ", "+", " ", 
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", "cosa", "*", "gw"}]}], ",", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{"gu", ",", "t"}], "]"}]}], "+", " ", 
          RowBox[{"D", "[", 
           RowBox[{"gv", ",", "x"}], "]"}], "-", 
          RowBox[{"sina", "*", 
           RowBox[{"1", "/", "r"}], "*", "gv"}]}], ",", "\[IndentingNewLine]",
          "      ", 
         RowBox[{"D", "[", 
          RowBox[{"gphix", ",", "x"}], "]"}], ",", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", "sina", "*", "gphix"}], "+", 
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{"gphit", ",", "t"}], "]"}]}]}], ",", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{"gphix", ",", "t"}], "]"}]}], " ", "+", " ", 
          RowBox[{"D", "[", 
           RowBox[{"gphit", ",", "x"}], "]"}], "-", 
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", "sina", "*", "gphit"}]}], ",", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "r"}], "*", "cosa", "*", "gv"}], " ", 
          "+", " ", 
          RowBox[{
           RowBox[{"1", "/", "r"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{"gw", ",", "t"}], "]"}]}], " ", "+", " ", "gphit"}], ",", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"gw", ",", "x"}], "]"}], " ", "+", " ", "gphix"}]}], 
        "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"k0", " ", "=", " ", 
       RowBox[{"r", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Transpose", "[", "B0Left", "]"}], ".", "F", ".", 
          "B0Right"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"gLeftBot", " ", "=", " ", 
       RowBox[{"ReplaceAll", "[", 
        RowBox[{"gLeft", ",", 
         RowBox[{"{", 
          RowBox[{"x", "\[Rule]", " ", "L"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gLeftTop", " ", "=", " ", 
       RowBox[{"ReplaceAll", "[", 
        RowBox[{"gLeft", ",", 
         RowBox[{"{", 
          RowBox[{"x", "\[Rule]", " ", "0"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gRightBot", " ", "=", " ", 
       RowBox[{"ReplaceAll", "[", 
        RowBox[{"gRight", ",", 
         RowBox[{"{", 
          RowBox[{"x", "\[Rule]", " ", "L"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"gRightTop", " ", "=", " ", 
       RowBox[{"ReplaceAll", "[", 
        RowBox[{"gRight", ",", 
         RowBox[{"{", 
          RowBox[{"x", "\[Rule]", " ", "0"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"k0edges", " ", "=", " ", 
       RowBox[{
        RowBox[{"r1", "*", 
         RowBox[{
          RowBox[{"Transpose", "[", "gLeftBot", "]"}], ".", "kBot", ".", 
          "gRightBot"}]}], "\[IndentingNewLine]", "                ", "+", 
        RowBox[{"r2", "*", 
         RowBox[{
          RowBox[{"Transpose", "[", "gLeftTop", "]"}], ".", "kTop", ".", 
          "gRightTop"}]}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Nxx", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"Fc", "+", 
            RowBox[{"2", 
             RowBox[{"(", 
              RowBox[{"MLA", "/", "r"}], ")"}], 
             RowBox[{"Cos", "[", 
              RowBox[{"t", "-", "tLA"}], "]"}]}]}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "Pi", "*", "r", "*", "cosa"}], ")"}]}], "+", 
        RowBox[{"P", " ", 
         RowBox[{"r", "/", 
          RowBox[{"(", 
           RowBox[{"2", " ", "cosa"}], ")"}]}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Ntt", "=", 
       RowBox[{"P", " ", 
        RowBox[{"r", " ", "/", "cosa"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Nxt", "=", 
       RowBox[{
        RowBox[{"-", "T"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "Pi", "*", "r", "*", "r"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Nmat", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Nxx", ",", " ", "Nxt"}], "}"}], ",", "\[IndentingNewLine]",
          "             ", 
         RowBox[{"{", 
          RowBox[{"Nxt", ",", " ", "Ntt"}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"kG0", " ", "=", " ", 
       RowBox[{"r", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Transpose", "[", "GLeft", "]"}], ".", "Nmat", ".", 
          "GRight"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
         "\"\<i\>\"", " ", "value", " ", "used", " ", "to", " ", "identify", 
          " ", "the", " ", "sub"}], "-", 
         RowBox[{"matrices", " ", "as", " ", 
          RowBox[{
          "follows", ":", "\[IndentingNewLine]", "1", ":", " ", "00"}]}]}], 
        ",", " ", 
        RowBox[{"2", ":", " ", "01"}], ",", " ", 
        RowBox[{"3", ":", " ", "02"}], ",", " ", 
        RowBox[{"4", ":", " ", "11"}], ",", " ", 
        RowBox[{"5", ":", " ", "12"}], ",", " ", 
        RowBox[{"6", ":", " ", "22"}]}], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"cond", "=", "1"}], ",", 
        RowBox[{"cond", "\[LessEqual]", "5"}], ",", 
        RowBox[{"cond", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"skip", " ", "=", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"i", "==", "1"}], ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{"cond", ">", "1"}], ")"}]}], ")"}], "||", 
           "\[IndentingNewLine]", "             ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"i", "==", "2"}], ")"}], "&&", 
              RowBox[{"(", 
               RowBox[{"cond", ">", "1"}], ")"}]}], ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{"cond", "\[NotEqual]", "5"}], ")"}]}], "||", 
           "\[IndentingNewLine]", "             ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"i", "==", "3"}], ")"}], "&&", 
              RowBox[{"(", 
               RowBox[{"cond", ">", "1"}], ")"}]}], ")"}], "&&", 
            RowBox[{"(", 
             RowBox[{"cond", "\[NotEqual]", "5"}], ")"}]}], "||", 
           "\[IndentingNewLine]", "             ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"i", "==", "4"}], ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{"cond", ">", "2"}], ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{"cond", "\[NotEqual]", "5"}], ")"}]}], ")"}], "||", 
           "\[IndentingNewLine]", "             ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"i", "==", " ", "5"}], ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{"cond", "\[NotEqual]", "3"}], ")"}], "&&", 
             RowBox[{"(", 
              RowBox[{"cond", "\[NotEqual]", "5"}], ")"}]}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<i \>\"", ",", "i", ",", "\"\< cond \>\"", ",", "cond"}], "]"}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"skip", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Continue", "[", "]"}], ";"}]}], "\[IndentingNewLine]", 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<passed i \>\"", ",", "i", ",", "\"\< cond \>\"", ",", "cond"}],
           "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"Which", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"cond", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"map", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"k1", "\[Rule]", "i1"}], ",", 
               RowBox[{"k2", "\[Rule]", "i2"}], ",", 
               RowBox[{"l2", "\[Rule]", "j2"}]}], "}"}]}], ";"}], 
           "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
           RowBox[{"cond", "\[Equal]", "2"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"map", "=", 
             RowBox[{"{", 
              RowBox[{"l2", "\[Rule]", "j2"}], " ", "}"}]}], ";"}], 
           "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
           RowBox[{"cond", "\[Equal]", "3"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"map", "=", 
             RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", ",", 
           "\[IndentingNewLine]", 
           RowBox[{"cond", "\[Equal]", "4"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"map", "=", 
             RowBox[{"{", 
              RowBox[{"k2", "\[Rule]", "i2"}], "}"}]}], ";"}], 
           "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
           RowBox[{"cond", "\[Equal]", "5"}], ",", "\[IndentingNewLine]", 
           RowBox[{"map", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"k1", "\[Rule]", "0"}], ",", 
              RowBox[{"i1", "\[Rule]", "0"}], ",", 
              RowBox[{"k2", "\[Rule]", "0"}], ",", 
              RowBox[{"i2", "\[Rule]", "0"}], ",", 
              RowBox[{"l2", "\[Rule]", "j2"}]}], "}"}]}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"k0tmp", "=", 
          RowBox[{"ReplaceAll", "[", 
           RowBox[{"k0", ",", "map"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"k0edgestmp", " ", "=", " ", 
          RowBox[{"ReplaceAll", "[", 
           RowBox[{"k0edges", ",", " ", "map"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"kG0tmp", "=", 
          RowBox[{"ReplaceAll", "[", 
           RowBox[{"kG0", ",", "map"}], "]"}]}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"sufix", "=", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{"index1", "-", "1"}], "]"}], "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{"index2", "-", "1"}], "]"}], "<>", "\"\<_cond\>\"", "<>", 
           RowBox[{"ToString", "[", "cond", "]"}]}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"debug", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"sufix", "=", 
             RowBox[{"sufix", "<>", "\"\<_debug.txt\>\""}]}], ";"}], 
           "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"sufix", "=", 
             RowBox[{"sufix", "<>", "\"\<.txt\>\""}]}], ";"}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"prefixISO", "=", "\"\<\>\""}], " ", ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"isotropic", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"prefixISO", "=", "\"\<iso_\>\""}], ";"}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"cylinder", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"namek0", "=", 
             RowBox[{
             "prefixISO", "<>", "\"\<cylinder_k0_\>\"", " ", "<>", " ", 
              "sufix"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"namek0edges", " ", "=", " ", 
             RowBox[{
             "prefixISO", "<>", "\"\<cylinder_k0edges_\>\"", "<>", 
              "sufix"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"namekG0", "=", 
             RowBox[{
             "prefixISO", "<>", "\"\<cylinder_kG0_\>\"", " ", "<>", " ", 
              "sufix"}]}], ";"}], "\[IndentingNewLine]", ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"namek0", "=", 
             RowBox[{
             "prefixISO", "<>", "\"\<cone_k0_\>\"", " ", "<>", " ", 
              "sufix"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"namek0edges", " ", "=", " ", 
             RowBox[{
             "prefixISO", "<>", "\"\<cone_k0edges_\>\"", "<>", "sufix"}]}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"namekG0", "=", 
             RowBox[{
             "prefixISO", "<>", "\"\<cone_kG0_\>\"", " ", "<>", " ", 
              "sufix"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"k0dim", "=", 
          RowBox[{"Dimensions", "[", "k0tmp", "]"}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"calculatek0", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"For", "[", 
             RowBox[{
              RowBox[{"mi", "=", "1"}], ",", 
              RowBox[{"mi", "\[LessEqual]", 
               RowBox[{"k0dim", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{"mi", "++"}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"For", "[", 
                RowBox[{
                 RowBox[{"mj", "=", "1"}], ",", 
                 RowBox[{"mj", "\[LessEqual]", " ", 
                  RowBox[{"k0dim", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                 RowBox[{"mj", "++"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"order", "+=", "1"}], ";", "\[IndentingNewLine]", 
                  RowBox[{"AppendTo", "[", 
                   RowBox[{"expressions", ",", 
                    RowBox[{"{", 
                    RowBox[{"order", ",", " ", 
                    RowBox[{"k0tmp", "[", 
                    RowBox[{"[", 
                    RowBox[{"mi", ",", "mj"}], "]"}], "]"}], ",", "namek0", 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"mi", ",", "mj"}], "}"}], ",", "k0dim"}], "}"}]}],
                    "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
             "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"calculatek0edges", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"i", "\[GreaterEqual]", "4"}], ",", 
              RowBox[{"(*", " ", 
               RowBox[{
                RowBox[{
                "the", " ", "stiffnesses", " ", "at", " ", "the", " ", 
                 "edges", " ", "are", " ", "non"}], "-", 
                RowBox[{
                "zero", " ", "only", " ", "for", " ", "g1", " ", "and", " ", 
                 "g2"}]}], " ", "*)"}], "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"For", "[", 
                RowBox[{
                 RowBox[{"mi", "=", "1"}], ",", 
                 RowBox[{"mi", "\[LessEqual]", 
                  RowBox[{"k0dim", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                 RowBox[{"mi", "++"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"For", "[", 
                   RowBox[{
                    RowBox[{"mj", "=", "1"}], ",", 
                    RowBox[{"mj", "\[LessEqual]", " ", 
                    RowBox[{"k0dim", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{"mj", "++"}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"order", "+=", "1"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"expressions", ",", 
                    RowBox[{"{", 
                    RowBox[{"order", ",", " ", 
                    RowBox[{"k0edgestmp", "[", 
                    RowBox[{"[", 
                    RowBox[{"mi", ",", "mj"}], "]"}], "]"}], ",", 
                    "namek0edges", ",", 
                    RowBox[{"{", 
                    RowBox[{"mi", ",", "mj"}], "}"}], ",", "k0dim"}], "}"}]}],
                     "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
                "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
             "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"calculatekG0", ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"For", "[", 
             RowBox[{
              RowBox[{"mi", "=", "1"}], ",", 
              RowBox[{"mi", "\[LessEqual]", 
               RowBox[{"k0dim", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{"mi", "++"}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"For", "[", 
                RowBox[{
                 RowBox[{"mj", "=", "1"}], ",", 
                 RowBox[{"mj", "\[LessEqual]", " ", 
                  RowBox[{"k0dim", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                 RowBox[{"mj", "++"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                  RowBox[{"order", "+=", "1"}], ";", "\[IndentingNewLine]", 
                  RowBox[{"AppendTo", "[", 
                   RowBox[{"expressions", ",", 
                    RowBox[{"{", 
                    RowBox[{"order", ",", " ", 
                    RowBox[{"kG0tmp", "[", 
                    RowBox[{"[", 
                    RowBox[{"mi", ",", "mj"}], "]"}], "]"}], ",", "namekG0", 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"mi", ",", "mj"}], "}"}], ",", "k0dim"}], "}"}]}],
                    "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
             "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
          "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"indices", "=", 
   RowBox[{"{", 
    RowBox[{"i1", ",", "k1", ",", "i2", ",", "j2", ",", "k2", ",", "l2"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"myIntegrate", "[", "entry_", "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ans", "=", "entry"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"expr", "=", 
        RowBox[{"ans", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"name", "=", 
        RowBox[{"ans", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"evaluate", "=", "True"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"evaluate", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"StringCount", "[", 
              RowBox[{"name", ",", "\"\<k0edges\>\""}], "]"}], ">", "0"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"expr", "=", 
              RowBox[{"Integrate", "[", 
               RowBox[{"expr", ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", "ta", ",", "tb"}], "}"}], ",", 
                RowBox[{"Assumptions", "\[Rule]", 
                 RowBox[{"indices", "\[Element]", "Integers"}]}]}], "]"}]}], 
             ";"}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"expr", "=", 
              RowBox[{"Integrate", "[", 
               RowBox[{"expr", ",", 
                RowBox[{"{", 
                 RowBox[{"x", ",", "xa", ",", "xb"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", "ta", ",", "tb"}], "}"}], ",", 
                RowBox[{"Assumptions", "\[Rule]", 
                 RowBox[{"indices", "\[Element]", "Integers"}]}]}], "]"}]}], 
             ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"expr", "=", 
           RowBox[{"Refine", "[", 
            RowBox[{"expr", ",", 
             RowBox[{"Assumptions", "\[Rule]", 
              RowBox[{"indices", "\[Element]", "Integers"}]}]}], "]"}]}], ";",
           "\[IndentingNewLine]", 
          RowBox[{"expr", "=", " ", 
           RowBox[{"FullSimplify", "[", 
            RowBox[{"expr", ",", 
             RowBox[{"Assumptions", "\[Rule]", 
              RowBox[{"indices", "\[Element]", "Integers"}]}]}], "]"}]}], 
          ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ans", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "=", "expr"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<finished expr \>\"", ",", 
           RowBox[{"ans", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", "ans"}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expressions", "=", 
   RowBox[{"RandomSample", "[", "expressions", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"expressions", "=", 
   RowBox[{"ParallelMap", "[", 
    RowBox[{"myIntegrate", ",", "expressions"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"expressions", "=", 
    RowBox[{"Sort", "[", 
     RowBox[{"expressions", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"#1", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", 
        RowBox[{"#2", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "<=", 
      RowBox[{"Length", "[", "expressions", "]"}]}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"name", "=", 
       RowBox[{"expressions", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"pos", "=", 
       RowBox[{"expressions", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "4"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dim", "=", 
       RowBox[{"expressions", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "5"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"pos", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "1"}], "&&", 
         RowBox[{
          RowBox[{"pos", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "1"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"matrix", "=", 
          RowBox[{"Table", "[", 
           RowBox[{"0", ",", 
            RowBox[{"{", 
             RowBox[{"dim", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"dim", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "}"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"matrix", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"pos", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"pos", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], "=", 
       RowBox[{"expressions", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"pos", "[", 
           RowBox[{"[", "     ", "1", "]"}], "]"}], "\[Equal]", 
          RowBox[{"dim", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "&&", 
         RowBox[{
          RowBox[{"pos", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", 
          RowBox[{"dim", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"s", " ", "=", " ", 
          RowBox[{"OpenWrite", "[", 
           RowBox[{"\"\<fortran_\>\"", "<>", "name"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Write", "[", 
          RowBox[{"s", ",", 
           RowBox[{"FortranForm", "[", "matrix", "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Close", "[", "s", "]"}], ";", "\[IndentingNewLine]", 
         "\t\t\t  ", "\[IndentingNewLine]", 
         RowBox[{"s", " ", "=", " ", 
          RowBox[{"OpenWrite", "[", "name", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Write", "[", 
          RowBox[{"s", ",", "matrix"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Close", "[", "s", "]"}], ";"}]}], "\[IndentingNewLine]", 
       "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CloseKernels", "[", "]"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5988751343024645`*^9, 3.598875149345325*^9}, {
   3.5988753108685637`*^9, 3.5988754321825027`*^9}, {3.598875479589214*^9, 
   3.5988755888094606`*^9}, 3.598875669691087*^9, {3.5988757097403774`*^9, 
   3.598875714802667*^9}, {3.598876419867995*^9, 3.598876470219875*^9}, {
   3.5988765343775444`*^9, 3.5988765453261704`*^9}, {3.5988765959400654`*^9, 
   3.598876606698681*^9}, {3.5988766473450055`*^9, 3.598876648712084*^9}, {
   3.598876704392268*^9, 3.5988767609205017`*^9}, {3.5988768236120872`*^9, 
   3.5988768269512787`*^9}, {3.5988768811743803`*^9, 3.598876910409052*^9}, {
   3.5988775028619385`*^9, 3.5988776175945005`*^9}, {3.5988776677223682`*^9, 
   3.5988776704695253`*^9}, {3.598877707026616*^9, 3.5988777811488557`*^9}, {
   3.5988778368220396`*^9, 3.5988778370500526`*^9}, {3.598877962448225*^9, 
   3.5988782071672225`*^9}, {3.5988784095227966`*^9, 3.59887864298915*^9}, {
   3.5988786775651274`*^9, 3.5988788208083205`*^9}, {3.598878884983991*^9, 
   3.5988789131836042`*^9}, {3.598878959114231*^9, 3.5988790727597313`*^9}, {
   3.598879133614212*^9, 3.5988792102165937`*^9}, {3.5988793276843123`*^9, 
   3.598879329754431*^9}, {3.59887957364038*^9, 3.5988796752711935`*^9}, {
   3.5988799419774475`*^9, 3.5988799476387715`*^9}, {3.598880004988052*^9, 
   3.5988800058301*^9}, {3.5988800420891743`*^9, 3.598880179809051*^9}, {
   3.5988802970207553`*^9, 3.5988803020230412`*^9}, 3.5988803406492505`*^9, 
   3.5988803958574085`*^9, 3.5988843138085203`*^9, {3.5988845886632404`*^9, 
   3.598884661836426*^9}, {3.598884945999679*^9, 3.598884981487709*^9}, {
   3.5988851178425083`*^9, 3.598885129732188*^9}, {3.5988851623350525`*^9, 
   3.598885167740362*^9}, {3.598889756412819*^9, 3.59888976919855*^9}, {
   3.598890243568183*^9, 3.5988902788182325`*^9}, {3.598890998621744*^9, 
   3.5988910004678497`*^9}, {3.598891399075649*^9, 3.598891643710641*^9}, {
   3.5988916877631607`*^9, 3.598891950161169*^9}, {3.5988921837895317`*^9, 
   3.5988926061946917`*^9}, {3.598892658503684*^9, 3.5988927533031063`*^9}, {
   3.5988928209009724`*^9, 3.598892850346657*^9}, {3.598892962158052*^9, 
   3.5988929865724487`*^9}, {3.598893040179515*^9, 3.598893317650385*^9}, {
   3.598893349510207*^9, 3.598893414857945*^9}, {3.5988934532411404`*^9, 
   3.598893456407322*^9}, {3.598893567842695*^9, 3.5988936027056894`*^9}, 
   3.5988937334091654`*^9, {3.5988937690862055`*^9, 3.5988938136977572`*^9}, {
   3.598893855144128*^9, 3.5988938768413687`*^9}, {3.5989008394098825`*^9, 
   3.5989009329788465`*^9}, {3.598901001556567*^9, 3.598901247506599*^9}, {
   3.5989015148677177`*^9, 3.598901541459239*^9}, {3.598901597638452*^9, 
   3.598901619842722*^9}, {3.59890169218886*^9, 3.5989017065556817`*^9}, {
   3.598901820250185*^9, 3.598901859666439*^9}, {3.5989019027429028`*^9, 
   3.5989021657859483`*^9}, {3.598902264550597*^9, 3.598902266162689*^9}, {
   3.598902380233214*^9, 3.5989023862195563`*^9}, {3.5989024342673044`*^9, 
   3.59890249066153*^9}, 3.59890252213433*^9, {3.5989283180587726`*^9, 
   3.5989283229130507`*^9}, {3.5989307440843363`*^9, 
   3.5989307484055443`*^9}, {3.5989308871769876`*^9, 
   3.5989309123554325`*^9}, {3.5989309979527826`*^9, 3.598931174591893*^9}, {
   3.598931234464798*^9, 3.5989312421088114`*^9}, {3.5989312797516775`*^9, 
   3.5989313035417194`*^9}, {3.598931447842772*^9, 3.5989314986520615`*^9}, {
   3.598931558868167*^9, 3.5989315800530043`*^9}, {3.5989317911681747`*^9, 
   3.5989318004501915`*^9}, {3.5989324456732283`*^9, 
   3.5989324464862747`*^9}, {3.5989328893606057`*^9, 
   3.5989330227812366`*^9}, {3.5989330749782224`*^9, 3.598933096754468*^9}, 
   3.598933207745816*^9, {3.598933315349971*^9, 3.5989334576691113`*^9}, {
   3.5989335193266373`*^9, 3.5989336409245925`*^9}, {3.5989337123766794`*^9, 
   3.5989337571212387`*^9}, {3.5989338200608387`*^9, 3.59893382253598*^9}, {
   3.598933872032811*^9, 3.598933872445835*^9}, {3.598933921258627*^9, 
   3.5989343830810413`*^9}, {3.598934471816117*^9, 3.598934477057417*^9}, {
   3.5989346025635953`*^9, 3.598934607990906*^9}, 3.5989357722394967`*^9, {
   3.598937289850994*^9, 3.5989372905217953`*^9}, {3.59893737290554*^9, 
   3.5989373892331686`*^9}, {3.5989378698544126`*^9, 3.598937965544981*^9}, {
   3.5989403021974573`*^9, 3.598940325923815*^9}, {3.5989404292897267`*^9, 
   3.598940429753753*^9}, {3.598940484633892*^9, 3.5989405463884244`*^9}, {
   3.5989406255849543`*^9, 3.5989406583168263`*^9}, {3.598940744685766*^9, 
   3.598940744871777*^9}, {3.59894082342627*^9, 3.5989409081201143`*^9}, 
   3.5989409741928935`*^9, {3.598941080525975*^9, 3.5989410951618123`*^9}, {
   3.5989411763134537`*^9, 3.598941199996809*^9}, {3.598941323328863*^9, 
   3.5989413410518765`*^9}, {3.5989413838193226`*^9, 3.598941418107284*^9}, {
   3.59894147765969*^9, 3.5989414853631306`*^9}, {3.5989415196480913`*^9, 
   3.5989415598783927`*^9}, {3.5989416249101124`*^9, 3.598941653385741*^9}, {
   3.598941813269886*^9, 3.5989418141589365`*^9}, {3.598941928595482*^9, 
   3.5989419505697393`*^9}, {3.5989420387787848`*^9, 
   3.5989420423249874`*^9}, {3.5989420735267715`*^9, 
   3.5989420995952625`*^9}, {3.598942162502861*^9, 3.598942197037836*^9}, {
   3.598942360156166*^9, 3.5989423615652466`*^9}, {3.5989424551666*^9, 
   3.598942521280382*^9}, {3.598942604497142*^9, 3.598942611254528*^9}, 
   3.5989426559970875`*^9, {3.598942697467459*^9, 3.5989428328192005`*^9}, {
   3.598942894615735*^9, 3.5989429033772364`*^9}, {3.598942950413927*^9, 
   3.5989429588694105`*^9}, {3.5989429960965395`*^9, 
   3.5989432881182423`*^9}, {3.5989463865184608`*^9, 
   3.5989463938128777`*^9}, {3.598946427188787*^9, 3.5989464309310007`*^9}, {
   3.5989464879652634`*^9, 3.5989464890233235`*^9}, {3.5989465415773296`*^9, 
   3.5989465948033743`*^9}, {3.598946657336951*^9, 3.5989467237547493`*^9}, {
   3.5989467912236085`*^9, 3.5989467919186487`*^9}, {3.5989468286947517`*^9, 
   3.598947002239678*^9}, {3.598947046580214*^9, 3.598947050161419*^9}, {
   3.5989471369873853`*^9, 3.598947176511646*^9}, {3.598947226504505*^9, 
   3.598947283849785*^9}, {3.5989473191518044`*^9, 3.598947320110859*^9}, {
   3.598947396647237*^9, 3.5989475024302874`*^9}, {3.598947556425376*^9, 
   3.598947605616189*^9}, {3.5989476817575445`*^9, 3.598947940226328*^9}, {
   3.5989479843508515`*^9, 3.5989479966745567`*^9}, {3.5989480925050373`*^9, 
   3.598948099923462*^9}, {3.5989481859433823`*^9, 3.5989482942445765`*^9}, {
   3.598948342116315*^9, 3.598948342665346*^9}, {3.598948381092544*^9, 
   3.598948398915563*^9}, 3.598948429952338*^9, 3.598948465970399*^9, {
   3.5989485131270957`*^9, 3.59894851529622*^9}, {3.59894854886514*^9, 
   3.59894859868499*^9}, {3.5989492197195106`*^9, 3.598949227157936*^9}, {
   3.5989492661921687`*^9, 3.5989492687833166`*^9}, {3.5989494288864746`*^9, 
   3.598949442571257*^9}, {3.5989494873338175`*^9, 3.598949519864678*^9}, {
   3.598949568399454*^9, 3.5989495694755154`*^9}, 3.5989496158311667`*^9, {
   3.598949727408549*^9, 3.5989497637656283`*^9}, {3.598949827415269*^9, 
   3.598949827889296*^9}, {3.5989500902032995`*^9, 3.5989500956716123`*^9}, 
   3.5989507114158306`*^9, {3.598952980884637*^9, 3.5989529973055763`*^9}, {
   3.598957466597205*^9, 3.598957483430168*^9}, {3.598957555606296*^9, 
   3.598957590505292*^9}, {3.5989576659356065`*^9, 3.5989577327594285`*^9}, {
   3.598957849311095*^9, 3.598957860429731*^9}, {3.598957937391133*^9, 
   3.598957944207523*^9}, {3.5989580490555196`*^9, 3.5989580801012955`*^9}, {
   3.5989581170834107`*^9, 3.5989581606899047`*^9}, {3.598958760223196*^9, 
   3.598958788981841*^9}, {3.598958818984557*^9, 3.598958819660596*^9}, {
   3.59895885015434*^9, 3.598959041927309*^9}, {3.598959664781934*^9, 
   3.598959836280743*^9}, {3.5989599195805073`*^9, 3.5989600401544037`*^9}, {
   3.5989601035640306`*^9, 3.598960104128063*^9}, {3.5989601554439983`*^9, 
   3.5989601566070647`*^9}, 3.598960193784191*^9, 3.598960309731823*^9, {
   3.5989621763145857`*^9, 3.598962183858017*^9}, {3.5989624612098804`*^9, 
   3.598962475481697*^9}, {3.5989625181551375`*^9, 3.598962533497015*^9}, 
   3.5990380589814873`*^9, {3.599039065738877*^9, 3.5990391194269476`*^9}, {
   3.599039680189021*^9, 3.5990397056494775`*^9}, {3.599040616635583*^9, 
   3.5990406172746196`*^9}, {3.599041429305065*^9, 3.5990414297000875`*^9}, 
   3.5990415101156874`*^9, {3.5990416092203555`*^9, 3.5990416223561068`*^9}, {
   3.5990417281541586`*^9, 3.599041757649845*^9}, {3.599041958725346*^9, 
   3.59904197452125*^9}, {3.5990421625350037`*^9, 3.5990421632540445`*^9}, {
   3.5991910375335283`*^9, 3.599191086860815*^9}, {3.5991911684645586`*^9, 
   3.599191182114582*^9}, {3.59919133416885*^9, 3.599191387739344*^9}, {
   3.5991923725646772`*^9, 3.5991923804738913`*^9}, 3.59919242541757*^9, {
   3.599547303663577*^9, 3.5995474528081074`*^9}, {3.599547556025011*^9, 
   3.599547813222722*^9}, {3.59954794780942*^9, 3.5995480687243357`*^9}, {
   3.599548126367633*^9, 3.599548193469471*^9}, 3.5995507096043854`*^9, {
   3.599550861245059*^9, 3.5995508919968176`*^9}, {3.599550968578198*^9, 
   3.5995510382031803`*^9}, {3.599551076213354*^9, 3.5995511047639875`*^9}, 
   3.5995512284830637`*^9, {3.599551261296941*^9, 3.5995512624100046`*^9}, {
   3.5995513174951553`*^9, 3.599551335259171*^9}, {3.599555382517661*^9, 
   3.5995553905711217`*^9}, {3.5995554906778474`*^9, 
   3.5995555130101247`*^9}, {3.599558329900242*^9, 3.5995583489363303`*^9}, {
   3.5995584073126693`*^9, 3.5995584079257045`*^9}, 3.599561217520404*^9, {
   3.599561277803852*^9, 3.5995612783418827`*^9}, {3.601054837836965*^9, 
   3.6010548545819225`*^9}, 3.6010550310190144`*^9, {3.601055062097792*^9, 
   3.601055092218515*^9}, {3.6010578042656355`*^9, 3.601057804644657*^9}, {
   3.6010934147001796`*^9, 3.601093452577046*^9}, {3.601093513900754*^9, 
   3.601093587408083*^9}, {3.6010936308541594`*^9, 3.601093639262574*^9}, {
   3.6010942107361393`*^9, 3.601094255835819*^9}, 3.60109431332192*^9, {
   3.6010949780822067`*^9, 3.6010949928554325`*^9}, {3.601095104848029*^9, 
   3.6010951052536297`*^9}, {3.601095627230361*^9, 3.601095650068801*^9}, {
   3.601095725741334*^9, 3.6010957297349405`*^9}, {3.6010973259793453`*^9, 
   3.601097414696701*^9}, {3.6010975148800774`*^9, 3.6010975154884777`*^9}, {
   3.6010985531116076`*^9, 3.6010985936872787`*^9}, {3.6010986458537703`*^9, 
   3.6010986464933715`*^9}, {3.601099027830043*^9, 3.601099053585688*^9}, 
   3.6011805374775176`*^9, {3.601208683718072*^9, 3.601208701722101*^9}, {
   3.6012087400332923`*^9, 3.6012087408183374`*^9}, {3.6012088574933186`*^9, 
   3.6012088580373497`*^9}, {3.6012303878174653`*^9, 
   3.6012304190532517`*^9}, {3.6012305073062997`*^9, 3.601230507738324*^9}, 
   3.601231286825886*^9, {3.6012314158592663`*^9, 3.6012314169193263`*^9}, {
   3.601272568083086*^9, 3.601272568546113*^9}, {3.601272743561123*^9, 
   3.6012727440401506`*^9}, {3.6012729040032997`*^9, 3.601272931484872*^9}, {
   3.6012742326072917`*^9, 3.60127423328333*^9}, 3.6012742708864813`*^9, {
   3.6012743224734316`*^9, 3.6012743463958*^9}, {3.601274432020697*^9, 
   3.6012744325637283`*^9}, {3.601274486423809*^9, 3.6012744904960423`*^9}, {
   3.601274746667694*^9, 3.601274748624806*^9}, {3.601274824524147*^9, 
   3.601274824955172*^9}, {3.6012748779612036`*^9, 3.601274889714876*^9}, {
   3.6012785497712193`*^9, 3.60127856219993*^9}, {3.6012790546820984`*^9, 
   3.6012790552161293`*^9}, 3.6012795345495453`*^9, {3.602230055587788*^9, 
   3.6022300559309883`*^9}, {3.602230278220981*^9, 3.602230282729389*^9}, {
   3.602230331697875*^9, 3.602230338889488*^9}, {3.6022305255282154`*^9, 
   3.602230615711974*^9}, {3.6022308282787485`*^9, 3.602230864845213*^9}, {
   3.6022309319565306`*^9, 3.602231035181912*^9}, {3.602231081408395*^9, 
   3.6022311160716553`*^9}, {3.602231297796375*^9, 3.6022313993057528`*^9}, 
   3.6022314452322335`*^9, {3.602231653711*^9, 3.6022317338951406`*^9}, {
   3.602231812269678*^9, 3.6022318608481636`*^9}, {3.6022320331348667`*^9, 
   3.60223204639489*^9}, {3.6022320961745768`*^9, 3.602232119013017*^9}, {
   3.602232156063082*^9, 3.6022323054957447`*^9}, {3.602232498078083*^9, 
   3.6022324984056835`*^9}, {3.6022326092438784`*^9, 3.602232614719488*^9}, {
   3.6022326613635693`*^9, 3.60223266690158*^9}, {3.602232705355647*^9, 
   3.6022327114552574`*^9}, {3.602232741875311*^9, 3.6022327427021127`*^9}, {
   3.602232777848974*^9, 3.602232934407649*^9}, {3.6022348241873817`*^9, 
   3.602234865168654*^9}, {3.602235164080779*^9, 3.602235340002288*^9}, {
   3.6022353759135513`*^9, 3.602235416177222*^9}, {3.6022365862618723`*^9, 
   3.6022365869339113`*^9}, {3.602237893054617*^9, 3.6022378959527826`*^9}, {
   3.6022397910231743`*^9, 3.6022397917932186`*^9}, {3.6029084404850254`*^9, 
   3.602908682117846*^9}, {3.6029087286475077`*^9, 3.602908807173999*^9}, {
   3.6029088640432515`*^9, 3.6029089016134005`*^9}, {3.6029089334492216`*^9, 
   3.6029089651490345`*^9}, {3.602910036533314*^9, 3.6029102010657253`*^9}, {
   3.602910826170479*^9, 3.602910826434494*^9}, {3.6029109769591036`*^9, 
   3.6029111854150267`*^9}, {3.6029112176178684`*^9, 
   3.6029112182049017`*^9}, {3.6029117974100304`*^9, 3.602911853151219*^9}, {
   3.602912102576485*^9, 3.602912134672321*^9}, {3.6029152101922307`*^9, 
   3.6029152361587157`*^9}, {3.602922690167061*^9, 3.602922699683605*^9}, {
   3.6029274883304996`*^9, 3.6029274900185966`*^9}, {3.6029438906910295`*^9, 
   3.602943937070682*^9}, {3.602995542225423*^9, 3.6029955660617867`*^9}, 
   3.602995886335105*^9, {3.6029960314424047`*^9, 3.602996036674704*^9}, {
   3.6031191735046606`*^9, 3.603119190549636*^9}, {3.603440459458683*^9, 
   3.6034404907367373`*^9}, {3.603440528364004*^9, 3.6034405287852044`*^9}, {
   3.6034407355777507`*^9, 3.6034407370285535`*^9}, {3.603443002860837*^9, 
   3.603443050569566*^9}, {3.603443588539336*^9, 3.6034435890323644`*^9}, {
   3.6034501924330573`*^9, 3.603450194145155*^9}, {3.6034719048144736`*^9, 
   3.6034719120428867`*^9}, {3.603471995613667*^9, 3.60347203972519*^9}, {
   3.603473730170878*^9, 3.6034737332930565`*^9}, {3.603512698513817*^9, 
   3.603512713550677*^9}, {3.603513409864504*^9, 3.6035134102475257`*^9}, {
   3.603517063016452*^9, 3.6035170635834846`*^9}, {3.6036450133879566`*^9, 
   3.6036452135544057`*^9}, {3.6036452488764257`*^9, 3.60364539615885*^9}, {
   3.6036487653275557`*^9, 3.603648765990594*^9}, {3.603949277276176*^9, 
   3.603949327281036*^9}, {3.6039493671393156`*^9, 3.6039494127119226`*^9}, {
   3.603956750826638*^9, 3.6039567517016883`*^9}, {3.604029595735668*^9, 
   3.604029619282015*^9}, {3.604029658591264*^9, 3.604029659415311*^9}, 
   3.6040299568353224`*^9, {3.604030424454067*^9, 3.604030484685773*^9}, {
   3.6040305299414525`*^9, 3.604030586101551*^9}, {3.6040306449136543`*^9, 
   3.6040306456000557`*^9}, {3.60403084829982*^9, 3.6040308484870205`*^9}, {
   3.604033990502967*^9, 3.6040339954779744`*^9}, {3.604459770064294*^9, 
   3.6044597784415083`*^9}, {3.6054925970571127`*^9, 3.605492598819916*^9}, {
   3.60549263560478*^9, 3.6054926999080935`*^9}, {3.6054927843042417`*^9, 
   3.6054928379995356`*^9}, {3.6054929392905135`*^9, 
   3.6054929398053145`*^9}, {3.6054945992178297`*^9, 3.605494599904231*^9}, {
   3.6054948488650684`*^9, 3.605494896273552*^9}, {3.605494980251336*^9, 
   3.605494980966337*^9}, {3.6054953695323343`*^9, 3.6054953702031355`*^9}, {
   3.6054955571286726`*^9, 3.605495571808298*^9}, {3.605495639387617*^9, 
   3.605495672553275*^9}, {3.6054957165297527`*^9, 3.6054957170601535`*^9}, {
   3.605498402269271*^9, 3.6054984316909227`*^9}, {3.60549847014499*^9, 
   3.605498478569005*^9}, {3.605498531749498*^9, 3.605498532357899*^9}, {
   3.6054987566258154`*^9, 3.60549875722585*^9}, {3.6055159491171703`*^9, 
   3.605515983169118*^9}, {3.60551606975807*^9, 3.6055160727502413`*^9}, {
   3.6055167901882763`*^9, 3.605516796777653*^9}, {3.6055169669863887`*^9, 
   3.6055169914027853`*^9}, {3.605517094172663*^9, 3.60551710162909*^9}, 
   3.605517328441063*^9, {3.6055825599490957`*^9, 3.6055825603291173`*^9}, {
   3.6098272225908337`*^9, 3.6098272247229557`*^9}, {3.612768321879773*^9, 
   3.6127683331741934`*^9}, {3.612768403608317*^9, 3.6127684042947183`*^9}, 
   3.6127684384953966`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["i ", 1, " cond ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"passed i \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["passed i ", 1, " cond ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["i ", 1, " cond ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["i ", 1, " cond ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["i ", 1, " cond ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["i ", 1, " cond ", 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["i ", 2, " cond ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"passed i \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["passed i ", 2, " cond ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["i ", 2, " cond ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["i ", 2, " cond ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["i ", 2, " cond ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["i ", 2, " cond ", 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"passed i \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["passed i ", 2, " cond ", 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078671246`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["i ", 3, " cond ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078827243`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"passed i \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["passed i ", 3, " cond ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078827243`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["i ", 3, " cond ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078827243`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["i ", 3, " cond ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078827243`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["i ", 3, " cond ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078827243`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"i \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["i ", 3, " cond ", 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078827243`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"passed i \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" cond \"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm["passed i ", 3, " cond ", 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.605498557148343*^9, 3.6054987603680296`*^9, 
  3.605580342889287*^9, 3.605582564244341*^9, 3.6127683357637978`*^9, 
  3.6127684078827243`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"LinkObject", "::", "linkd"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Unable to communicate with closed link \
\[NoBreak]\\!\\(LinkObject[\\(\\(\\\"\\\\\\\"C:\\\\\\\\Program \
Files\\\\\\\\Wolfram Research\\\\\\\\Mathematica\\\\\\\\9.0\\\\\\\\MathKernel\
\\\\\\\" -subkernel -noinit -mathlink -noicon\\\", 3974, \
6\\)\\)]\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/LinkObject/linkd\\\", ButtonNote -> \
\\\"LinkObject::linkd\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6127685741688347`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"KernelObject", "::", "rdead"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Subkernel connected through \
\[NoBreak]\\!\\(KernelObject[\\(\\(24, \\\"local\\\"\\)\\)]\\)\[NoBreak] \
appears dead. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/KernelObject\\\", ButtonNote -> \
\\\"KernelObject::rdead\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6127685742312355`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Parallel`Developer`QueueRun", "::", "req"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requeueing evaluations \[NoBreak]\\!\\({84}\\)\[NoBreak] \
assigned to \[NoBreak]\\!\\(KernelObject[\\(\\(24, \\\"local\\\", \
\\\"<defunct>\\\"\\)\\)]\\)\[NoBreak].\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6127685743248353`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"LaunchKernels", "::", "clone"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Kernel \[NoBreak]\\!\\(KernelObject[\\(\\(24, \
\\\"local\\\", \\\"<defunct>\\\"\\)\\)]\\)\[NoBreak] resurrected as \
\[NoBreak]\\!\\(KernelObject[\\(\\(24, \\\"local\\\"\\)\\)]\\)\[NoBreak]. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/LaunchKernels\\\", ButtonNote \
-> \\\"LaunchKernels::clone\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.612768574714836*^9}]
}, Open  ]]
},
WindowSize->{944, 907},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
CellContext->Notebook,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 71785, 1698, 7132, "Input"],
Cell[CellGroupData[{
Cell[72389, 1724, 386, 8, 23, "Print"],
Cell[72778, 1734, 400, 8, 23, "Print"],
Cell[73181, 1744, 386, 8, 23, "Print"],
Cell[73570, 1754, 386, 8, 23, "Print"],
Cell[73959, 1764, 386, 8, 23, "Print"],
Cell[74348, 1774, 386, 8, 23, "Print"],
Cell[74737, 1784, 386, 8, 23, "Print"],
Cell[75126, 1794, 400, 8, 23, "Print"],
Cell[75529, 1804, 386, 8, 23, "Print"],
Cell[75918, 1814, 386, 8, 23, "Print"],
Cell[76307, 1824, 386, 8, 23, "Print"],
Cell[76696, 1834, 386, 8, 23, "Print"],
Cell[77085, 1844, 400, 8, 23, "Print"],
Cell[77488, 1854, 386, 8, 23, "Print"],
Cell[77877, 1864, 400, 8, 23, "Print"],
Cell[78280, 1874, 386, 8, 23, "Print"],
Cell[78669, 1884, 386, 8, 23, "Print"],
Cell[79058, 1894, 386, 8, 23, "Print"],
Cell[79447, 1904, 386, 8, 23, "Print"],
Cell[79836, 1914, 400, 8, 23, "Print"]
}, Open  ]],
Cell[80251, 1925, 660, 13, 39, "Message"],
Cell[80914, 1940, 504, 11, 21, "Message"],
Cell[81421, 1953, 376, 8, 21, "Message"],
Cell[81800, 1963, 578, 11, 21, "Message"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
